/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.validation.impl;

import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReasonCode;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.sys.context.SpringContext;

public class BudgetConstructionAppointmentFundingReasonCodeRule
extends MaintenanceDocumentRuleBase {
    protected static final Logger LOG = Logger.getLogger(BudgetConstructionAppointmentFundingReasonCodeRule.class);
    protected BudgetConstructionAppointmentFundingReasonCode oldBudgetConstructionAppointmentFundingReasonCode;
    protected BudgetConstructionAppointmentFundingReasonCode newBudgetConstructionAppointmentFundingReasonCode;
    protected SalarySettingService salarySettingService;

    public BudgetConstructionAppointmentFundingReasonCodeRule() {
        this.setSalarySettingService((SalarySettingService)SpringContext.getBean(SalarySettingService.class));
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info((Object)"processCustomRouteDocumentBusinessRules called");
        boolean success = true;
        if (document.isEdit()) {
            success &= this.checkInactivateReason(document);
        }
        return success;
    }

    protected boolean checkInactivateReason(MaintenanceDocument document) {
        LOG.info((Object)"checkInactivateReason called");
        boolean success = true;
        if (!this.oldBudgetConstructionAppointmentFundingReasonCode.isActive() || this.newBudgetConstructionAppointmentFundingReasonCode.isActive()) {
            return true;
        }
        if (this.salarySettingService.hasExistingFundingReason(this.newBudgetConstructionAppointmentFundingReasonCode)) {
            this.putGlobalError("error.budget.reasonMaintenance.inactivate.reasonExist");
            success &= false;
        }
        return success;
    }

    public void setupConvenienceObjects() {
        this.oldBudgetConstructionAppointmentFundingReasonCode = (BudgetConstructionAppointmentFundingReasonCode)((Object)super.getOldBo());
        this.newBudgetConstructionAppointmentFundingReasonCode = (BudgetConstructionAppointmentFundingReasonCode)((Object)super.getNewBo());
    }

    public void setSalarySettingService(SalarySettingService salarySettingService) {
        this.salarySettingService = salarySettingService;
    }
}

