/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.validation.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import org.kuali.kfs.coa.document.validation.impl.MaintenancePreRulesBase;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;

public class BudgetConstructionPositionPreRules
extends MaintenancePreRulesBase {
    protected BudgetConstructionPosition newBudgetConstructionPosition;
    protected BudgetConstructionPosition copyBudgetConstructionPosition;

    protected boolean doCustomPreRules(MaintenanceDocument document) {
        this.setupConvenienceObjects(document);
        this.computeFTE();
        return true;
    }

    protected void computeFTE() {
        BigDecimal newPositionStandardHoursDefault = this.newBudgetConstructionPosition.getPositionStandardHoursDefault();
        Integer newIuNormalWorkMonths = this.newBudgetConstructionPosition.getIuNormalWorkMonths();
        Integer newIuPayMonths = this.newBudgetConstructionPosition.getIuPayMonths();
        if (ObjectUtils.isNotNull((Object)newPositionStandardHoursDefault) && ObjectUtils.isNotNull((Object)newPositionStandardHoursDefault) && ObjectUtils.isNotNull((Object)newPositionStandardHoursDefault)) {
            BigDecimal result = BudgetConstructionPosition.getCalculatedBCPositionFTE(newPositionStandardHoursDefault, newIuNormalWorkMonths, newIuPayMonths);
            this.newBudgetConstructionPosition.setPositionFullTimeEquivalency(result);
        } else {
            BigDecimal result = new BigDecimal(0);
        }
    }

    protected void setupConvenienceObjects(MaintenanceDocument document) {
        this.newBudgetConstructionPosition = (BudgetConstructionPosition)document.getNewMaintainableObject().getBusinessObject();
        this.copyBudgetConstructionPosition = (BudgetConstructionPosition)((Object)ObjectUtils.deepCopy((Serializable)((Object)this.newBudgetConstructionPosition)));
        this.copyBudgetConstructionPosition.refreshNonUpdateableReferences();
    }
}

