/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrganizationReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.KeyValue;

public class OrganizationSelectionTreeForm
extends BudgetExpansionForm {
    private static final Logger LOG = Logger.getLogger(OrganizationSelectionTreeForm.class);
    private BudgetConstructionOrganizationReports pointOfViewOrg;
    private List<BudgetConstructionPullup> selectionSubTreeOrgs;
    private List<BudgetConstructionPullup> previousBranchOrgs;
    private boolean hideDetails = false;
    private String operatingModeTitle;
    private String operatingModePullFlagLabel;
    private String currentPointOfViewKeyCode;
    private String previousPointOfViewKeyCode;
    private List<KeyValue> pullFlagKeyLabels;
    private String operatingMode;
    private boolean accountSummaryConsolidation;
    private boolean accountObjectDetailConsolidation;
    private boolean monthObjectSummaryConsolidation;
    private String reportMode;
    private boolean noResetOnReturn = false;

    public OrganizationSelectionTreeForm() {
        this.setPointOfViewOrg(new BudgetConstructionOrganizationReports());
        this.setSelectionSubTreeOrgs(new ArrayList<BudgetConstructionPullup>());
        this.setPreviousBranchOrgs(new ArrayList<BudgetConstructionPullup>());
        this.setPullFlagKeyLabels(new ArrayList<KeyValue>());
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        this.populatePreviousBranchOrgs();
        this.populateSelectionSubTreeOrgs();
    }

    public void populateSelectionSubTreeOrgs() {
        for (BudgetConstructionPullup selectionOrg : this.getSelectionSubTreeOrgs()) {
            List<String> REFRESH_FIELDS = Collections.unmodifiableList(Arrays.asList("organization"));
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)selectionOrg, REFRESH_FIELDS);
        }
    }

    public void populatePreviousBranchOrgs() {
        for (BudgetConstructionPullup previousBranchOrg : this.getPreviousBranchOrgs()) {
            List<String> REFRESH_FIELDS = Collections.unmodifiableList(Arrays.asList("organization"));
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveReferenceObjects((Object)previousBranchOrg, REFRESH_FIELDS);
        }
    }

    public BudgetConstructionOrganizationReports getPointOfViewOrg() {
        return this.pointOfViewOrg;
    }

    public void setPointOfViewOrg(BudgetConstructionOrganizationReports pointOfViewOrg) {
        this.pointOfViewOrg = pointOfViewOrg;
    }

    public boolean isHideDetails() {
        return this.hideDetails;
    }

    public void setHideDetails(boolean hideDetails) {
        this.hideDetails = hideDetails;
    }

    public String getOperatingMode() {
        return this.operatingMode;
    }

    public void setOperatingMode(String operatingMode) {
        this.operatingMode = operatingMode;
    }

    public String getOperatingModeTitle() {
        return this.operatingModeTitle;
    }

    public void setOperatingModeTitle(String operatingModeTitle) {
        this.operatingModeTitle = operatingModeTitle;
    }

    public String getCurrentPointOfViewKeyCode() {
        return this.currentPointOfViewKeyCode;
    }

    public void setCurrentPointOfViewKeyCode(String currentPointOfViewKeyCode) {
        this.currentPointOfViewKeyCode = currentPointOfViewKeyCode;
    }

    public String getPreviousPointOfViewKeyCode() {
        return this.previousPointOfViewKeyCode;
    }

    public void setPreviousPointOfViewKeyCode(String previousPointOfViewKeyCode) {
        this.previousPointOfViewKeyCode = previousPointOfViewKeyCode;
    }

    public List<BudgetConstructionPullup> getSelectionSubTreeOrgs() {
        return this.selectionSubTreeOrgs;
    }

    public void setSelectionSubTreeOrgs(List<BudgetConstructionPullup> selectionSubTree) {
        this.selectionSubTreeOrgs = selectionSubTree;
    }

    public List<BudgetConstructionPullup> getPreviousBranchOrgs() {
        return this.previousBranchOrgs;
    }

    public void setPreviousBranchOrgs(List<BudgetConstructionPullup> previousBranchOrgs) {
        this.previousBranchOrgs = previousBranchOrgs;
    }

    public List<KeyValue> getPullFlagKeyLabels() {
        return this.pullFlagKeyLabels;
    }

    public void setPullFlagKeyLabels(List<KeyValue> pullFlagKeyLabels) {
        this.pullFlagKeyLabels = pullFlagKeyLabels;
    }

    public String getOperatingModePullFlagLabel() {
        return this.operatingModePullFlagLabel;
    }

    public void setOperatingModePullFlagLabel(String operatingModePullFlagLabel) {
        this.operatingModePullFlagLabel = operatingModePullFlagLabel;
    }

    public boolean isAccountSummaryConsolidation() {
        return this.accountSummaryConsolidation;
    }

    public void setAccountSummaryConsolidation(boolean accountSummaryConsolidation) {
        this.accountSummaryConsolidation = accountSummaryConsolidation;
    }

    public String getReportMode() {
        return this.reportMode;
    }

    public void setReportMode(String reportMode) {
        this.reportMode = reportMode;
    }

    public boolean isAccountObjectDetailConsolidation() {
        return this.accountObjectDetailConsolidation;
    }

    public void setAccountObjectDetailConsolidation(boolean accountObjectDetailConsolidation) {
        this.accountObjectDetailConsolidation = accountObjectDetailConsolidation;
    }

    public boolean isMonthObjectSummaryConsolidation() {
        return this.monthObjectSummaryConsolidation;
    }

    public void setMonthObjectSummaryConsolidation(boolean monthObjectSummaryConsolidation) {
        this.monthObjectSummaryConsolidation = monthObjectSummaryConsolidation;
    }

    public boolean shouldMethodToCallParameterBeUsed(String methodToCallParameterName, String methodToCallParameterValue, HttpServletRequest request) {
        if (methodToCallParameterValue.equalsIgnoreCase("performBuildPointOfView")) {
            return true;
        }
        return super.shouldMethodToCallParameterBeUsed(methodToCallParameterName, methodToCallParameterValue, request);
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        if (this.isNoResetOnReturn()) {
            this.setNoResetOnReturn(false);
        } else {
            super.reset(mapping, request);
            for (BudgetConstructionPullup selectionSubTreeOrg : this.selectionSubTreeOrgs) {
                selectionSubTreeOrg.setPullFlag(0);
            }
            this.setAccountSummaryConsolidation(false);
            this.setAccountObjectDetailConsolidation(false);
            this.setMonthObjectSummaryConsolidation(false);
        }
        this.getMessages().clear();
    }

    public boolean isNoResetOnReturn() {
        return this.noResetOnReturn;
    }

    public void setNoResetOnReturn(boolean noResetOnReturn) {
        this.noResetOnReturn = noResetOnReturn;
    }
}

