/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReason;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFundingAware;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.sys.context.SpringContext;

public class SalarySettingExpansion
extends PendingBudgetConstructionGeneralLedger
implements PendingBudgetConstructionAppointmentFundingAware {
    private List<PendingBudgetConstructionAppointmentFunding> pendingBudgetConstructionAppointmentFunding = new ArrayList<PendingBudgetConstructionAppointmentFunding>();

    @Override
    public List<PendingBudgetConstructionAppointmentFunding> getPendingBudgetConstructionAppointmentFunding() {
        return this.pendingBudgetConstructionAppointmentFunding;
    }

    @Deprecated
    public void setPendingBudgetConstructionAppointmentFunding(List<PendingBudgetConstructionAppointmentFunding> pendingBudgetConstructionAppointmentFunding) {
        this.pendingBudgetConstructionAppointmentFunding = pendingBudgetConstructionAppointmentFunding;
    }

    public boolean isHourlyPaid() {
        Integer fiscalYear = this.getUniversityFiscalYear();
        String chartOfAccountsCode = this.getChartOfAccountsCode();
        String objectCode = this.getFinancialObjectCode();
        return ((SalarySettingService)SpringContext.getBean(SalarySettingService.class)).isHourlyPaidObject(fiscalYear, chartOfAccountsCode, objectCode);
    }

    public String getSalarySettingExpansionString() {
        String pattern = "{0};{1};{2};{3};{4}";
        return MessageFormat.format(pattern, this.getChartOfAccountsCode(), this.getAccountNumber(), this.getSubAccountNumber(), this.getFinancialObjectCode(), this.getFinancialSubObjectCode());
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getPendingBudgetConstructionAppointmentFunding());
        ArrayList<BudgetConstructionAppointmentFundingReason> appointmentFundingReasons = new ArrayList<BudgetConstructionAppointmentFundingReason>();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : this.getPendingBudgetConstructionAppointmentFunding()) {
            appointmentFundingReasons.addAll(appointmentFunding.getBudgetConstructionAppointmentFundingReason());
        }
        managedLists.add(appointmentFundingReasons);
        return managedLists;
    }
}

