/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.krad.bo.BusinessObject;

public class BudgetConstructionReportHelper {
    public static BigDecimal setDecimalDigit(BigDecimal number, int digit, boolean setNullIndicator) {
        BigDecimal returnNum = BigDecimal.ZERO;
        if (number != null) {
            if (number.compareTo(BigDecimal.ZERO) == 0 && setNullIndicator) {
                return null;
            }
            returnNum = number.setScale(digit, 4);
        }
        return returnNum;
    }

    public static BigDecimal calculatePercent(BigDecimal numerator, BigDecimal denominator) {
        BigDecimal result = BigDecimal.ZERO;
        if (numerator != null && denominator != null && denominator.compareTo(BigDecimal.ZERO) != 0) {
            result = numerator.divide(denominator, 3, 4).movePointRight(2);
        }
        return result;
    }

    public static BigDecimal calculatePercent(Integer numerator, Integer denominator) {
        BigDecimal result = BigDecimal.ZERO;
        if (numerator != null && denominator != null) {
            return BudgetConstructionReportHelper.calculatePercent(new BigDecimal(numerator), new BigDecimal(denominator));
        }
        return result;
    }

    public static BigDecimal calculatePercent(KualiInteger numerator, KualiInteger denominator) {
        BigDecimal result = BigDecimal.ZERO;
        if (numerator != null && denominator != null) {
            return BudgetConstructionReportHelper.calculatePercent(new BigDecimal(numerator.bigIntegerValue()), new BigDecimal(denominator.bigIntegerValue()));
        }
        return result;
    }

    public static BigDecimal calculateDivide(BigDecimal numerator, BigDecimal denominator) {
        BigDecimal result = BigDecimal.ZERO;
        if (denominator.compareTo(BigDecimal.ZERO) != 0) {
            result = numerator.divide(denominator, 3, 4);
        }
        return result;
    }

    public static Integer convertKualiInteger(KualiInteger num) {
        Integer returnNum = null;
        returnNum = num != null ? new Integer(num.intValue()) : new Integer(0);
        return returnNum;
    }

    public static List deleteDuplicated(List<BusinessObject> list, List<String> fields) {
        ArrayList<BusinessObject> returnList = new ArrayList<BusinessObject>();
        ArrayList<String> foundObjects = new ArrayList<String>();
        for (BusinessObject businessObject : list) {
            String valueString = "";
            for (String fieldName : fields) {
                Object fieldValue = ObjectUtils.getPropertyValue((Object)businessObject, (String)fieldName);
                valueString = valueString + fieldValue.toString();
            }
            if (foundObjects.contains(valueString)) continue;
            returnList.add(businessObject);
            foundObjects.add(valueString);
        }
        return returnList;
    }

    public static boolean isSameEntry(BusinessObject firstObject, BusinessObject secondObject, List<String> fields) {
        String firstValueString = "";
        String secondValueString = "";
        for (String fieldName : fields) {
            Object firstFieldValue = ObjectUtils.getPropertyValue((Object)firstObject, (String)fieldName);
            Object secondFieldValue = ObjectUtils.getPropertyValue((Object)secondObject, (String)fieldName);
            firstValueString = firstValueString + firstFieldValue.toString();
            secondValueString = secondValueString + secondFieldValue.toString();
        }
        return firstValueString.equals(secondValueString);
    }
}

