/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.BudgetConstructionReportMode;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountSelect;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbentSelect;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrganizationReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPositionSelect;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionProcessorService;
import org.kuali.kfs.module.bc.document.service.BudgetOrganizationTreeService;
import org.kuali.kfs.module.bc.document.service.BudgetPushPullService;
import org.kuali.kfs.module.bc.document.service.OrganizationBCDocumentSearchService;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionAction;
import org.kuali.kfs.module.bc.document.web.struts.OrganizationSelectionTreeForm;
import org.kuali.kfs.module.bc.report.ReportControlListBuildHelper;
import org.kuali.kfs.module.bc.util.BudgetUrlUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.identity.Person;

public class OrganizationSelectionTreeAction
extends BudgetExpansionAction {
    private static final Logger LOG = Logger.getLogger(OrganizationSelectionTreeAction.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        OrganizationSelectionTreeForm orgSelTreeForm = (OrganizationSelectionTreeForm)form;
        if (orgSelTreeForm.getMethodToCall().equals("refresh") && "session".equals(mapping.getScope())) {
            HttpSession sess = request.getSession(Boolean.FALSE.booleanValue());
            String formName = mapping.getAttribute();
            sess.setAttribute(formName, (Object)orgSelTreeForm);
        }
        if (orgSelTreeForm.getPullFlagKeyLabels().isEmpty() && orgSelTreeForm.getOperatingMode() != null) {
            BCConstants.OrgSelOpMode opMode = BCConstants.OrgSelOpMode.valueOf(orgSelTreeForm.getOperatingMode());
            switch (opMode) {
                case SALSET: {
                    orgSelTreeForm.setOperatingModeTitle("Budget Salary Setting Organization Selection");
                    orgSelTreeForm.setOperatingModePullFlagLabel("Selected");
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.NO.getKey().toString(), BCConstants.OrgSelControlOption.NO.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.YES.getKey().toString(), BCConstants.OrgSelControlOption.YES.getLabel()));
                    break;
                }
                case REPORTS: {
                    orgSelTreeForm.setOperatingModeTitle("BC Reports Organization Selection");
                    orgSelTreeForm.setOperatingModePullFlagLabel("Selected");
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.NO.getKey().toString(), BCConstants.OrgSelControlOption.NO.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.YES.getKey().toString(), BCConstants.OrgSelControlOption.YES.getLabel()));
                    break;
                }
                case PULLUP: {
                    orgSelTreeForm.setOperatingModeTitle("BC Pull Up Organization Selection");
                    orgSelTreeForm.setOperatingModePullFlagLabel("Pull Up Type");
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.NOTSEL.getKey().toString(), BCConstants.OrgSelControlOption.NOTSEL.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.BOTH.getKey().toString(), BCConstants.OrgSelControlOption.BOTH.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.ORG.getKey().toString(), BCConstants.OrgSelControlOption.ORG.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.SUBORG.getKey().toString(), BCConstants.OrgSelControlOption.SUBORG.getLabel()));
                    break;
                }
                case PUSHDOWN: {
                    orgSelTreeForm.setOperatingModeTitle("BC Push Down Organization Selection");
                    orgSelTreeForm.setOperatingModePullFlagLabel("Push Down Type");
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.NOTSEL.getKey().toString(), BCConstants.OrgSelControlOption.NOTSEL.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.ORGLEV.getKey().toString(), BCConstants.OrgSelControlOption.ORGLEV.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.MGRLEV.getKey().toString(), BCConstants.OrgSelControlOption.MGRLEV.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.ORGMGRLEV.getKey().toString(), BCConstants.OrgSelControlOption.ORGMGRLEV.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.LEVONE.getKey().toString(), BCConstants.OrgSelControlOption.LEVONE.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.LEVZERO.getKey().toString(), BCConstants.OrgSelControlOption.LEVZERO.getLabel()));
                    break;
                }
                default: {
                    orgSelTreeForm.setOperatingModeTitle("Budgeted Account List Search Organization Selection");
                    orgSelTreeForm.setOperatingModePullFlagLabel("Selected");
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.NO.getKey().toString(), BCConstants.OrgSelControlOption.NO.getLabel()));
                    orgSelTreeForm.getPullFlagKeyLabels().add((KeyValue)new ConcreteKeyValue(BCConstants.OrgSelControlOption.YES.getKey().toString(), BCConstants.OrgSelControlOption.YES.getLabel()));
                }
            }
        }
        return actionForward;
    }

    public ActionForward loadExpansionScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm orgSelTreeForm = (OrganizationSelectionTreeForm)form;
        Person person = GlobalVariables.getUserSession().getPerson();
        List<Organization> pointOfViewOrgs = ((BudgetConstructionProcessorService)SpringContext.getBean(BudgetConstructionProcessorService.class)).getProcessorOrgs(person);
        if (pointOfViewOrgs != null && pointOfViewOrgs.size() == 1) {
            orgSelTreeForm.setCurrentPointOfViewKeyCode(pointOfViewOrgs.get(0).getChartOfAccountsCode() + "-" + pointOfViewOrgs.get(0).getOrganizationCode());
            return this.performBuildPointOfView(mapping, form, request, response);
        }
        if (pointOfViewOrgs.isEmpty()) {
            GlobalVariables.getMessageMap().putError("pointOfViewOrg", "error.budget.userNotOrgApprover", new String[0]);
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward returnToCaller(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String principalName = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        ((BudgetOrganizationTreeService)SpringContext.getBean(BudgetOrganizationTreeService.class)).cleanPullup(principalName);
        return super.returnToCaller(mapping, form, request, response);
    }

    public ActionForward performBuildPointOfView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        if (organizationSelectionTreeForm.getCurrentPointOfViewKeyCode() != null) {
            if (organizationSelectionTreeForm.getPreviousPointOfViewKeyCode() == null || !organizationSelectionTreeForm.getPreviousPointOfViewKeyCode().equalsIgnoreCase(organizationSelectionTreeForm.getCurrentPointOfViewKeyCode())) {
                String[] flds = organizationSelectionTreeForm.getCurrentPointOfViewKeyCode().split("[-]");
                organizationSelectionTreeForm.setPreviousPointOfViewKeyCode(organizationSelectionTreeForm.getCurrentPointOfViewKeyCode());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("chartOfAccountsCode", flds[0]);
                map.put("organizationCode", flds[1]);
                organizationSelectionTreeForm.setPointOfViewOrg((BudgetConstructionOrganizationReports)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BudgetConstructionOrganizationReports.class, map));
                String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
                ((BudgetOrganizationTreeService)SpringContext.getBean(BudgetOrganizationTreeService.class)).buildPullupSql(principalId, flds[0], flds[1]);
                map.put("principalId", principalId);
                organizationSelectionTreeForm.setSelectionSubTreeOrgs((List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(BudgetConstructionPullup.class, map));
                organizationSelectionTreeForm.populateSelectionSubTreeOrgs();
                organizationSelectionTreeForm.setPreviousBranchOrgs(new ArrayList<BudgetConstructionPullup>());
            }
        } else {
            organizationSelectionTreeForm.setPreviousPointOfViewKeyCode(organizationSelectionTreeForm.getCurrentPointOfViewKeyCode());
            organizationSelectionTreeForm.setPointOfViewOrg(new BudgetConstructionOrganizationReports());
            organizationSelectionTreeForm.setSelectionSubTreeOrgs(new ArrayList<BudgetConstructionPullup>());
            organizationSelectionTreeForm.setPreviousBranchOrgs(new ArrayList<BudgetConstructionPullup>());
        }
        return mapping.findForward("basic");
    }

    public ActionForward navigateDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        ((BudgetOrganizationTreeService)SpringContext.getBean(BudgetOrganizationTreeService.class)).resetPullFlag(principalId);
        organizationSelectionTreeForm.getPreviousBranchOrgs().add(organizationSelectionTreeForm.getSelectionSubTreeOrgs().get(this.getSelectedLine(request)));
        String chartOfAccountsCode = organizationSelectionTreeForm.getSelectionSubTreeOrgs().get(this.getSelectedLine(request)).getChartOfAccountsCode();
        String organizationCode = organizationSelectionTreeForm.getSelectionSubTreeOrgs().get(this.getSelectedLine(request)).getOrganizationCode();
        organizationSelectionTreeForm.setSelectionSubTreeOrgs(((BudgetOrganizationTreeService)SpringContext.getBean(BudgetOrganizationTreeService.class)).getPullupChildOrgs(principalId, chartOfAccountsCode, organizationCode));
        organizationSelectionTreeForm.populateSelectionSubTreeOrgs();
        return mapping.findForward("basic");
    }

    public ActionForward navigateUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        ((BudgetOrganizationTreeService)SpringContext.getBean(BudgetOrganizationTreeService.class)).resetPullFlag(principalId);
        int popIdx = this.getSelectedLine(request);
        BudgetConstructionPullup previousBranchOrg = organizationSelectionTreeForm.getPreviousBranchOrgs().remove(popIdx);
        if (popIdx == 0) {
            organizationSelectionTreeForm.setPreviousBranchOrgs(new ArrayList<BudgetConstructionPullup>());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("chartOfAccountsCode", previousBranchOrg.getChartOfAccountsCode());
            map.put("organizationCode", previousBranchOrg.getOrganizationCode());
            map.put("principalId", principalId);
            organizationSelectionTreeForm.setSelectionSubTreeOrgs((List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(BudgetConstructionPullup.class, map));
            organizationSelectionTreeForm.populateSelectionSubTreeOrgs();
        } else {
            organizationSelectionTreeForm.setPreviousBranchOrgs(organizationSelectionTreeForm.getPreviousBranchOrgs().subList(0, popIdx));
            String chartOfAccountsCode = previousBranchOrg.getReportsToChartOfAccountsCode();
            String organizationCode = previousBranchOrg.getReportsToOrganizationCode();
            organizationSelectionTreeForm.setSelectionSubTreeOrgs(((BudgetOrganizationTreeService)SpringContext.getBean(BudgetOrganizationTreeService.class)).getPullupChildOrgs(principalId, chartOfAccountsCode, organizationCode));
            organizationSelectionTreeForm.populateSelectionSubTreeOrgs();
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.YES.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward clearAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.NO.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward selectPullOrgAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.ORG.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward selectPullSubOrgAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.SUBORG.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward selectPullBothAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.BOTH.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward selectPushOrgLevAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.ORGLEV.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward selectPushMgrLevAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.MGRLEV.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward selectPushOrgMgrLevAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.ORGMGRLEV.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward selectPushLevOneAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.LEVONE.getKey());
        return mapping.findForward("basic");
    }

    public ActionForward selectPushLevZeroAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        this.setPullFlag(organizationSelectionTreeForm.getSelectionSubTreeOrgs(), BCConstants.OrgSelControlOption.LEVZERO.getKey());
        return mapping.findForward("basic");
    }

    protected void setPullFlag(List<BudgetConstructionPullup> selOrgs, Integer pullFlagValue) {
        for (int i = 0; i < selOrgs.size(); ++i) {
            selOrgs.get(i).setPullFlag(pullFlagValue);
        }
    }

    protected boolean storedSelectedOrgs(List<BudgetConstructionPullup> selectionSubTreeOrgs) {
        boolean foundSelected = false;
        for (BudgetConstructionPullup budgetConstructionPullup : selectionSubTreeOrgs) {
            if (budgetConstructionPullup.getPullFlag() <= 0) continue;
            foundSelected = true;
            break;
        }
        if (foundSelected) {
            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save(selectionSubTreeOrgs);
        } else {
            GlobalVariables.getMessageMap().putError("selectionSubTreeOrgs", "error.budget.orgNotSelected", new String[0]);
        }
        return foundSelected;
    }

    public ActionForward performPositionPick(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        if (!this.storedSelectedOrgs(organizationSelectionTreeForm.getSelectionSubTreeOrgs())) {
            return mapping.findForward("basic");
        }
        organizationSelectionTreeForm.setNoResetOnReturn(true);
        String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, organizationSelectionTreeForm, 2, BudgetConstructionPositionSelect.class.getName(), null);
        return new ActionForward(url, true);
    }

    public ActionForward performIncumbentPick(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        if (!this.storedSelectedOrgs(organizationSelectionTreeForm.getSelectionSubTreeOrgs())) {
            return mapping.findForward("basic");
        }
        organizationSelectionTreeForm.setNoResetOnReturn(true);
        String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, organizationSelectionTreeForm, 1, BudgetConstructionIntendedIncumbentSelect.class.getName(), null);
        return new ActionForward(url, true);
    }

    public ActionForward performShowBudgetDocs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        if (!this.storedSelectedOrgs(organizationSelectionTreeForm.getSelectionSubTreeOrgs())) {
            return mapping.findForward("basic");
        }
        int rowCount = ((OrganizationBCDocumentSearchService)SpringContext.getBean(OrganizationBCDocumentSearchService.class)).buildAccountSelectPullList(GlobalVariables.getUserSession().getPerson().getPrincipalId(), organizationSelectionTreeForm.getUniversityFiscalYear());
        if (rowCount == 0) {
            KNSGlobalVariables.getMessageList().add("error.inquiry", new String[0]);
            return mapping.findForward("basic");
        }
        organizationSelectionTreeForm.setNoResetOnReturn(true);
        String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, organizationSelectionTreeForm, 4, BudgetConstructionAccountSelect.class.getName(), null);
        return new ActionForward(url, true);
    }

    public ActionForward performPullUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        if (!this.storedSelectedOrgs(organizationSelectionTreeForm.getSelectionSubTreeOrgs())) {
            return mapping.findForward("basic");
        }
        String pointOfViewCharOfAccountsCode = organizationSelectionTreeForm.getPointOfViewOrg().getChartOfAccountsCode();
        String pointOfViewOrganizationCode = organizationSelectionTreeForm.getPointOfViewOrg().getOrganizationCode();
        Integer bcFiscalYear = organizationSelectionTreeForm.getUniversityFiscalYear();
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        ((BudgetPushPullService)SpringContext.getBean(BudgetPushPullService.class)).pullupSelectedOrganizationDocuments(principalId, bcFiscalYear, pointOfViewCharOfAccountsCode, pointOfViewOrganizationCode);
        int rowCount = ((BudgetPushPullService)SpringContext.getBean(BudgetPushPullService.class)).buildPullUpBudgetedDocuments(principalId, bcFiscalYear, pointOfViewCharOfAccountsCode, pointOfViewOrganizationCode);
        if (rowCount != 0) {
            organizationSelectionTreeForm.setNoResetOnReturn(true);
            String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, organizationSelectionTreeForm, 7, BudgetConstructionAccountSelect.class.getName(), null);
            return new ActionForward(url, true);
        }
        KNSGlobalVariables.getMessageList().add("message.budget.orgPullUpSuccessful", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward performShowPullUpBudgetDocs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        if (!this.storedSelectedOrgs(organizationSelectionTreeForm.getSelectionSubTreeOrgs())) {
            return mapping.findForward("basic");
        }
        String pointOfViewCharOfAccountsCode = organizationSelectionTreeForm.getPointOfViewOrg().getChartOfAccountsCode();
        String pointOfViewOrganizationCode = organizationSelectionTreeForm.getPointOfViewOrg().getOrganizationCode();
        Integer bcFiscalYear = organizationSelectionTreeForm.getUniversityFiscalYear();
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        int rowCount = ((BudgetPushPullService)SpringContext.getBean(BudgetPushPullService.class)).buildPullUpBudgetedDocuments(principalId, bcFiscalYear, pointOfViewCharOfAccountsCode, pointOfViewOrganizationCode);
        if (rowCount == 0) {
            String message = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("error.budget.noAccountsPullUp");
            message = MessageFormat.format(message, pointOfViewCharOfAccountsCode, pointOfViewOrganizationCode);
            organizationSelectionTreeForm.addMessage(message);
            return mapping.findForward("basic");
        }
        organizationSelectionTreeForm.setNoResetOnReturn(true);
        String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, organizationSelectionTreeForm, 7, BudgetConstructionAccountSelect.class.getName(), null);
        return new ActionForward(url, true);
    }

    public ActionForward performPushDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        if (!this.storedSelectedOrgs(organizationSelectionTreeForm.getSelectionSubTreeOrgs())) {
            return mapping.findForward("basic");
        }
        String pointOfViewCharOfAccountsCode = organizationSelectionTreeForm.getPointOfViewOrg().getChartOfAccountsCode();
        String pointOfViewOrganizationCode = organizationSelectionTreeForm.getPointOfViewOrg().getOrganizationCode();
        Integer bcFiscalYear = organizationSelectionTreeForm.getUniversityFiscalYear();
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        ((BudgetPushPullService)SpringContext.getBean(BudgetPushPullService.class)).pushdownSelectedOrganizationDocuments(principalId, bcFiscalYear, pointOfViewCharOfAccountsCode, pointOfViewOrganizationCode);
        int rowCount = ((BudgetPushPullService)SpringContext.getBean(BudgetPushPullService.class)).buildPushDownBudgetedDocuments(principalId, bcFiscalYear, pointOfViewCharOfAccountsCode, pointOfViewOrganizationCode);
        if (rowCount != 0) {
            organizationSelectionTreeForm.setNoResetOnReturn(true);
            String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, organizationSelectionTreeForm, 8, BudgetConstructionAccountSelect.class.getName(), null);
            return new ActionForward(url, true);
        }
        KNSGlobalVariables.getMessageList().add("message.budget.orgPushDownSuccessful", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward performShowPushDownBudgetDocs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        if (!this.storedSelectedOrgs(organizationSelectionTreeForm.getSelectionSubTreeOrgs())) {
            return mapping.findForward("basic");
        }
        String pointOfViewCharOfAccountsCode = organizationSelectionTreeForm.getPointOfViewOrg().getChartOfAccountsCode();
        String pointOfViewOrganizationCode = organizationSelectionTreeForm.getPointOfViewOrg().getOrganizationCode();
        Integer bcFiscalYear = organizationSelectionTreeForm.getUniversityFiscalYear();
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        int rowCount = ((BudgetPushPullService)SpringContext.getBean(BudgetPushPullService.class)).buildPushDownBudgetedDocuments(principalId, bcFiscalYear, pointOfViewCharOfAccountsCode, pointOfViewOrganizationCode);
        if (rowCount == 0) {
            String message = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("error.budget.noAccountsPushDown");
            message = MessageFormat.format(message, pointOfViewCharOfAccountsCode, pointOfViewOrganizationCode);
            organizationSelectionTreeForm.addMessage(message);
            return mapping.findForward("basic");
        }
        organizationSelectionTreeForm.setNoResetOnReturn(true);
        String url = BudgetUrlUtil.buildTempListLookupUrl(mapping, organizationSelectionTreeForm, 8, BudgetConstructionAccountSelect.class.getName(), null);
        return new ActionForward(url, true);
    }

    public ActionForward performReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationSelectionTreeForm organizationSelectionTreeForm = (OrganizationSelectionTreeForm)form;
        List<BudgetConstructionPullup> selectionSubTreeOrgs = organizationSelectionTreeForm.getSelectionSubTreeOrgs();
        if (!this.storedSelectedOrgs(selectionSubTreeOrgs)) {
            return mapping.findForward("basic");
        }
        ReportControlListBuildHelper buildHelper = (ReportControlListBuildHelper)GlobalVariables.getUserSession().retrieveObject("controlBuildHelper");
        if (buildHelper == null) {
            buildHelper = new ReportControlListBuildHelper();
        }
        BudgetConstructionReportMode reportMode = this.setupReportMode(request, organizationSelectionTreeForm);
        buildHelper.addBuildRequest(organizationSelectionTreeForm.getCurrentPointOfViewKeyCode(), this.removeUnselectedSubTreeOrgs(selectionSubTreeOrgs), reportMode.reportBuildMode);
        GlobalVariables.getUserSession().addObject("controlBuildHelper", (Object)buildHelper);
        String[] pointOfViewFields = organizationSelectionTreeForm.getCurrentPointOfViewKeyCode().split("[-]");
        int rowCount = ((OrganizationBCDocumentSearchService)SpringContext.getBean(OrganizationBCDocumentSearchService.class)).buildBudgetedAccountsAbovePointsOfView(GlobalVariables.getUserSession().getPerson().getPrincipalId(), organizationSelectionTreeForm.getUniversityFiscalYear(), pointOfViewFields[0], pointOfViewFields[1]);
        boolean forceToAccountListScreen = false;
        String reportModeName = organizationSelectionTreeForm.getReportMode();
        if (reportModeName.equals(BudgetConstructionReportMode.TWOPLG_LIST_REPORT.reportModeName) || reportModeName.equals(BudgetConstructionReportMode.SYNCHRONIZATION_PROBLEMS_REPORT.reportModeName)) {
            forceToAccountListScreen = true;
        }
        organizationSelectionTreeForm.setNoResetOnReturn(true);
        String forwardURL = "";
        forwardURL = rowCount != 0 || forceToAccountListScreen ? this.buildAccountListForwardURL(organizationSelectionTreeForm, mapping, forceToAccountListScreen) : this.buildReportSelectForwardURL(organizationSelectionTreeForm, mapping);
        return new ActionForward(forwardURL, true);
    }

    public List<BudgetConstructionPullup> removeUnselectedSubTreeOrgs(List<BudgetConstructionPullup> selectionSubTreeOrgs) {
        ArrayList<BudgetConstructionPullup> returnList = new ArrayList<BudgetConstructionPullup>();
        for (BudgetConstructionPullup pullUp : selectionSubTreeOrgs) {
            if (pullUp.getPullFlag() <= 0) continue;
            returnList.add(pullUp);
        }
        return returnList;
    }

    private BudgetConstructionReportMode setupReportMode(HttpServletRequest request, OrganizationSelectionTreeForm organizationSelectionTreeForm) {
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String reportName = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        organizationSelectionTreeForm.setReportMode(reportName);
        return BudgetConstructionReportMode.getBudgetConstructionReportModeByName(organizationSelectionTreeForm.getReportMode());
    }

    private String buildAccountListForwardURL(OrganizationSelectionTreeForm organizationSelectionTreeForm, ActionMapping mapping, boolean forceToAccountListScreen) {
        HashMap<String, String> urlParms = new HashMap<String, String>();
        urlParms.put("reportMode", organizationSelectionTreeForm.getReportMode());
        urlParms.put("currentPointOfViewKeyCode", organizationSelectionTreeForm.getCurrentPointOfViewKeyCode());
        if (forceToAccountListScreen) {
            urlParms.put("forceToAccountListScreen", "true");
        } else {
            urlParms.put("forceToAccountListScreen", "false");
        }
        if (organizationSelectionTreeForm.getReportMode().equals(BudgetConstructionReportMode.ACCOUNT_SUMMARY_REPORT.reportModeName) && organizationSelectionTreeForm.isAccountSummaryConsolidation() || organizationSelectionTreeForm.getReportMode().equals(BudgetConstructionReportMode.ACCOUNT_OBJECT_DETAIL_REPORT.reportModeName) && organizationSelectionTreeForm.isAccountObjectDetailConsolidation() || organizationSelectionTreeForm.getReportMode().equals(BudgetConstructionReportMode.MONTH_SUMMARY_REPORT.reportModeName) && organizationSelectionTreeForm.isMonthObjectSummaryConsolidation()) {
            urlParms.put("reportConsolidation", "true");
        }
        return BudgetUrlUtil.buildTempListLookupUrl(mapping, organizationSelectionTreeForm, 3, BudgetConstructionAccountSelect.class.getName(), urlParms);
    }

    private String buildReportSelectForwardURL(OrganizationSelectionTreeForm organizationSelectionTreeForm, ActionMapping mapping) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("reportMode", organizationSelectionTreeForm.getReportMode());
        parameters.put("currentPointOfViewKeyCode", organizationSelectionTreeForm.getCurrentPointOfViewKeyCode());
        if (organizationSelectionTreeForm.getReportMode().equals(BudgetConstructionReportMode.ACCOUNT_SUMMARY_REPORT.reportModeName) && organizationSelectionTreeForm.isAccountSummaryConsolidation() || organizationSelectionTreeForm.getReportMode().equals(BudgetConstructionReportMode.ACCOUNT_OBJECT_DETAIL_REPORT.reportModeName) && organizationSelectionTreeForm.isAccountObjectDetailConsolidation() || organizationSelectionTreeForm.getReportMode().equals(BudgetConstructionReportMode.MONTH_SUMMARY_REPORT.reportModeName) && organizationSelectionTreeForm.isMonthObjectSummaryConsolidation()) {
            parameters.put("reportConsolidation", "true");
        }
        return BudgetUrlUtil.buildBudgetUrl(mapping, organizationSelectionTreeForm, "budgetOrganizationReportSelection.do", parameters);
    }
}

