/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.kns.lookup.Lookupable;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.action.KualiLookupAction;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionLockSummary;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.document.service.OrganizationBCDocumentSearchService;
import org.kuali.kfs.module.bc.document.service.OrganizationSalarySettingSearchService;
import org.kuali.kfs.module.bc.document.web.struts.TempListLookupForm;
import org.kuali.kfs.module.bc.exception.BudgetIncumbentAlreadyExistsException;
import org.kuali.kfs.module.bc.exception.BudgetPositionAlreadyExistsException;
import org.kuali.kfs.module.bc.exception.IncumbentNotFoundException;
import org.kuali.kfs.module.bc.exception.PositionNotFoundException;
import org.kuali.kfs.module.bc.service.BudgetConstructionIntendedIncumbentService;
import org.kuali.kfs.module.bc.service.BudgetConstructionPositionService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.services.IdentityManagementService;

public class TempListLookupAction
extends KualiLookupAction {
    private static final Logger LOG = Logger.getLogger(TempListLookupAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        return super.execute(mapping, form, request, response);
    }

    protected void supressActionsIfNeeded(ActionForm form) throws ClassNotFoundException {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        if (tempListLookupForm.getTempListLookupMode() == 10 || tempListLookupForm.getTempListLookupMode() == 11) {
            tempListLookupForm.setSuppressActions(false);
        } else if (tempListLookupForm.getTempListLookupMode() == 5) {
            String[] rootOrg = ((OrganizationService)SpringContext.getBean(OrganizationService.class)).getRootOrganizationCode();
            HashMap<String, String> qualification = new HashMap<String, String>();
            qualification.put("organizationChartOfAccountsCode", rootOrg[0]);
            qualification.put("organizationCode", rootOrg[1]);
            boolean canUnlock = ((IdentityManagementService)SpringContext.getBean(IdentityManagementService.class)).isAuthorized(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "KFS-BC", "Unlock", qualification);
            tempListLookupForm.setSuppressActions(!canUnlock);
            tempListLookupForm.setSupplementalActionsEnabled(canUnlock);
        } else {
            super.supressActionsIfNeeded(form);
        }
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        switch (tempListLookupForm.getTempListLookupMode()) {
            case 1: {
                ((OrganizationSalarySettingSearchService)SpringContext.getBean(OrganizationSalarySettingSearchService.class)).buildIntendedIncumbentSelect(tempListLookupForm.getPrincipalId(), tempListLookupForm.getUniversityFiscalYear());
                break;
            }
            case 2: {
                ((OrganizationSalarySettingSearchService)SpringContext.getBean(OrganizationSalarySettingSearchService.class)).buildPositionSelect(tempListLookupForm.getPrincipalId(), tempListLookupForm.getUniversityFiscalYear());
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                KNSGlobalVariables.getMessageList().add("message.budget.accountList", new String[0]);
                break;
            }
            case 7: {
                KNSGlobalVariables.getMessageList().add("message.budget.accountPullupList", new String[0]);
                break;
            }
            case 8: {
                KNSGlobalVariables.getMessageList().add("message.budget.accountPushdownList", new String[0]);
                break;
            }
            case 9: {
                KNSGlobalVariables.getMessageList().add("message.budget.accountManagerDelegateList", new String[0]);
            }
        }
        ActionForward forward = super.start(mapping, form, request, response);
        if (tempListLookupForm.isShowInitialResults()) {
            forward = this.search(mapping, form, request, response);
        }
        if (tempListLookupForm.getTempListLookupMode() == 3) {
            if (tempListLookupForm.isForceToAccountListScreen()) {
                ArrayList resultTable = (ArrayList)request.getAttribute("reqSearchResults");
                int resultSize = resultTable.size();
                if (resultSize == 0) {
                    KNSGlobalVariables.getMessageList().add("message.budget.report.emptyAccountList", new String[0]);
                } else {
                    KNSGlobalVariables.getMessageList().add("message.budget.report.accountList", new String[0]);
                }
            } else {
                KNSGlobalVariables.getMessageList().add("message.budget.report.accountList", new String[0]);
            }
        }
        return forward;
    }

    public ActionForward clearValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable kualiLookupable = lookupForm.getLookupable();
        if (kualiLookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        for (Row row : kualiLookupable.getRows()) {
            for (Field field : row.getFields()) {
                if (field.getFieldType().equals("radio") || field.getFieldType().equals("hidden")) continue;
                field.setPropertyValue(field.getDefaultValue());
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        switch (tempListLookupForm.getTempListLookupMode()) {
            case 1: {
                ((OrganizationSalarySettingSearchService)SpringContext.getBean(OrganizationSalarySettingSearchService.class)).cleanIntendedIncumbentSelect(tempListLookupForm.getPrincipalId());
                break;
            }
            case 2: {
                ((OrganizationSalarySettingSearchService)SpringContext.getBean(OrganizationSalarySettingSearchService.class)).cleanPositionSelect(tempListLookupForm.getPrincipalId());
                break;
            }
            default: {
                ((OrganizationBCDocumentSearchService)SpringContext.getBean(OrganizationBCDocumentSearchService.class)).cleanAccountSelectPullList(tempListLookupForm.getPrincipalId(), tempListLookupForm.getUniversityFiscalYear());
            }
        }
        if (tempListLookupForm.getDocNum() == null) {
            tempListLookupForm.setDocNum("");
        }
        return super.cancel(mapping, form, request, response);
    }

    public ActionForward performExtendedPositionSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        tempListLookupForm.setMethodToCall("refresh");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        parameters.put("backLocation", basePath + mapping.getPath() + ".do");
        parameters.put("universityFiscalYear", tempListLookupForm.getUniversityFiscalYear().toString());
        parameters.put("principalId", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        parameters.put("docFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        parameters.put("businessObjectClassName", BudgetConstructionPosition.class.getName());
        parameters.put("hideReturnLink", "true");
        parameters.put("suppressActions", "false");
        parameters.put("showInitialResults", "true");
        parameters.put("tempListLookupMode", Integer.toString(10));
        Map fieldValues = tempListLookupForm.getFieldsForLookup();
        parameters.put("positionNumber", fieldValues.get("positionNumber"));
        parameters.put("positionDepartmentIdentifier", fieldValues.get("positionDepartmentIdentifier"));
        parameters.put("iuPositionType", fieldValues.get("iuPositionType"));
        parameters.put("positionSalaryPlanDefault", fieldValues.get("salaryAdministrationPlan"));
        parameters.put("positionGradeDefault", fieldValues.get("grade"));
        parameters.put("showSalaryByPositionAction", "true");
        parameters.put("addLine", "false");
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + "budgetTempListLookup.do"), (Properties)parameters);
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward getNewPosition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        if (!tempListLookupForm.isGetNewPositionEnabled()) {
            LOG.error((Object)"get new position not enabled.");
            throw new RuntimeException("get new position not enabled");
        }
        String positionNumber = (String)tempListLookupForm.getFieldsForLookup().get("positionNumber");
        if (StringUtils.isBlank((String)positionNumber)) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.requiredGetNewPosition", new String[0]);
            return mapping.findForward("basic");
        }
        try {
            ((BudgetConstructionPositionService)SpringContext.getBean(BudgetConstructionPositionService.class)).pullNewPositionFromExternal(tempListLookupForm.getUniversityFiscalYear(), positionNumber);
        }
        catch (PositionNotFoundException e) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", e.getMessageKey(), e.getMessageParameters());
        }
        catch (BudgetPositionAlreadyExistsException e1) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", e1.getMessageKey(), e1.getMessageParameters());
        }
        return this.search(mapping, form, request, response);
    }

    public ActionForward performExtendedIncumbentSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        tempListLookupForm.setMethodToCall("refresh");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        parameters.put("backLocation", basePath + mapping.getPath() + ".do");
        parameters.put("universityFiscalYear", tempListLookupForm.getUniversityFiscalYear().toString());
        parameters.put("principalId", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        parameters.put("docFormKey", GlobalVariables.getUserSession().addObjectWithGeneratedKey((Serializable)form, "BcDoc"));
        parameters.put("businessObjectClassName", BudgetConstructionIntendedIncumbent.class.getName());
        parameters.put("hideReturnLink", "true");
        parameters.put("suppressActions", "false");
        parameters.put("showInitialResults", "true");
        parameters.put("tempListLookupMode", Integer.toString(11));
        Map fieldValues = tempListLookupForm.getFieldsForLookup();
        parameters.put("emplid", fieldValues.get("emplid"));
        parameters.put("name", fieldValues.get("name"));
        parameters.put("showSalaryByIncumbentAction", "true");
        parameters.put("addLine", "false");
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + "budgetTempListLookup.do"), (Properties)parameters);
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward getNewIncumbent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        if (!tempListLookupForm.isGetNewIncumbentEnabled()) {
            LOG.error((Object)"get new incumbent not enabled.");
            throw new RuntimeException("get new incumbent not enabled");
        }
        String emplid = (String)tempListLookupForm.getFieldsForLookup().get("emplid");
        if (StringUtils.isBlank((String)emplid)) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.requiredGetNewIncumbent", new String[0]);
            return mapping.findForward("basic");
        }
        try {
            ((BudgetConstructionIntendedIncumbentService)SpringContext.getBean(BudgetConstructionIntendedIncumbentService.class)).pullNewIncumbentFromExternal(emplid);
        }
        catch (IncumbentNotFoundException e) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", e.getMessageKey(), e.getMessageParameters());
        }
        catch (BudgetIncumbentAlreadyExistsException e1) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", e1.getMessageKey(), e1.getMessageParameters());
        }
        return this.search(mapping, form, request, response);
    }

    public ActionForward submitReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("returnFormKey", tempListLookupForm.getFormKey());
        parameters.put("backLocation", basePath + "/" + "budgetOrganizationSelectionTree.do");
        if (tempListLookupForm.isReportConsolidation()) {
            parameters.put("reportConsolidation", "true");
        }
        parameters.put("universityFiscalYear", tempListLookupForm.getUniversityFiscalYear().toString());
        parameters.put("principalId", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        parameters.put("reportMode", tempListLookupForm.getReportMode());
        parameters.put("currentPointOfViewKeyCode", tempListLookupForm.getCurrentPointOfViewKeyCode());
        String lookupUrl = UrlFactory.parameterizeUrl((String)(basePath + "/" + "budgetOrganizationReportSelection.do"), (Properties)parameters);
        return new ActionForward(lookupUrl, true);
    }

    public ActionForward unlock(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        String unlockKeyString = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isBlank((String)unlockKeyString)) {
            unlockKeyString = request.getParameter("methodToCallPath");
        }
        BudgetConstructionLockSummary lockSummary = this.populateLockSummary(unlockKeyString);
        String lockKeyMessage = this.buildLockKeyMessage(lockSummary.getLockType(), lockSummary.getLockUserId(), lockSummary.getChartOfAccountsCode(), lockSummary.getAccountNumber(), lockSummary.getSubAccountNumber(), lockSummary.getUniversityFiscalYear(), lockSummary.getPositionNumber());
        ActionForward forward = this.doUnlockConfirmation(mapping, form, request, response, lockSummary.getLockType(), lockKeyMessage);
        if (forward != null) {
            return forward;
        }
        boolean lockExists = ((LockService)SpringContext.getBean(LockService.class)).checkLockExists(lockSummary);
        if (!lockExists) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "message.budget.lock.lockNotExist", new String[]{lockSummary.getLockType(), lockKeyMessage});
        } else {
            BCConstants.LockStatus lockStatus = ((LockService)SpringContext.getBean(LockService.class)).doUnlock(lockSummary);
            if (BCConstants.LockStatus.SUCCESS.equals((Object)lockStatus)) {
                String successMessage = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("message.budget.lock.unlockSuccessful");
                tempListLookupForm.addMessage(MessageFormat.format(successMessage, lockSummary.getLockType(), lockKeyMessage));
            } else {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "message.budget.lock.unlockNotSuccessful", new String[]{lockSummary.getLockType(), lockKeyMessage});
            }
        }
        return this.search(mapping, form, request, response);
    }

    public ActionForward doUnlockConfirmation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String lockType, String lockKeyMessage) throws Exception {
        TempListLookupForm lookupForm = (TempListLookupForm)form;
        String question = request.getParameter("questionIndex");
        if (question == null) {
            String message = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("message.budget.lock.unlockConfirmation");
            message = MessageFormat.format(message, lockType, lockKeyMessage);
            return this.performQuestionWithoutInput(mapping, form, request, response, "UnlockConfirmationQuestion", message, "cf.confirmationQuestion", "unlock", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("UnlockConfirmationQuestion".equals(question) && "0".equals(buttonClicked)) {
            return null;
        }
        return this.search(mapping, form, request, response);
    }

    protected BudgetConstructionLockSummary populateLockSummary(String methodToCallString) {
        BudgetConstructionLockSummary lockSummary = new BudgetConstructionLockSummary();
        String lockType = StringUtils.substringBetween((String)methodToCallString, (String)"(((", (String)")))");
        String lockFieldsString = StringUtils.substringBetween((String)methodToCallString, (String)"((~", (String)"~))");
        String lockUser = StringUtils.substringBetween((String)methodToCallString, (String)"((<", (String)">))");
        lockSummary.setLockType(StringUtils.replace((String)lockType, (String)"_", (String)" "));
        lockSummary.setLockUserId(lockUser);
        StrTokenizer strTokenizer = new StrTokenizer(lockFieldsString, "!");
        strTokenizer.setIgnoreEmptyTokens(false);
        String fiscalYear = strTokenizer.nextToken();
        if (fiscalYear != null) {
            lockSummary.setUniversityFiscalYear(Integer.parseInt(fiscalYear));
        }
        lockSummary.setChartOfAccountsCode(strTokenizer.nextToken());
        lockSummary.setAccountNumber(strTokenizer.nextToken());
        lockSummary.setSubAccountNumber(strTokenizer.nextToken());
        lockSummary.setPositionNumber(strTokenizer.nextToken());
        return lockSummary;
    }

    protected String buildLockKeyMessage(String lockType, String lockUserId, String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear, String positionNumber) {
        ConfigurationService kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        String lockKeyMessage = "";
        if ("position lock".equals(lockType)) {
            lockKeyMessage = kualiConfigurationService.getPropertyValueAsString("message.budget.lock.positionKey");
            lockKeyMessage = MessageFormat.format(lockKeyMessage, lockUserId, fiscalYear.toString(), positionNumber);
        } else if ("position/funding lock".equals(lockType)) {
            lockKeyMessage = kualiConfigurationService.getPropertyValueAsString("message.budget.lock.positionFundingKey");
            lockKeyMessage = MessageFormat.format(lockKeyMessage, lockUserId, fiscalYear.toString(), positionNumber, chartOfAccountsCode, accountNumber, subAccountNumber);
        } else {
            lockKeyMessage = kualiConfigurationService.getPropertyValueAsString("message.budget.lock.accountKey");
            lockKeyMessage = MessageFormat.format(lockKeyMessage, lockUserId, fiscalYear.toString(), chartOfAccountsCode, accountNumber, subAccountNumber);
        }
        return lockKeyMessage;
    }

    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TempListLookupForm tempListLookupForm = (TempListLookupForm)form;
        tempListLookupForm.setMethodToCall("refresh");
        return super.performLookup(mapping, form, request, response);
    }
}

