/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionRuleHelperService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.rice.krad.bo.BusinessObject;

public class BudgetConstructionRuleHelperServiceImpl
implements BudgetConstructionRuleHelperService {
    private static final Logger LOG = Logger.getLogger(BudgetConstructionRuleHelperServiceImpl.class);
    protected DictionaryValidationService dictionaryValidationService;
    protected LaborModuleService laborModuleService;
    protected BudgetDocumentService budgetDocumentService;

    @Override
    public boolean hasDetailPositionRequiredObjectCode(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String objectCode = appointmentFunding.getFinancialObjectCode();
        ObjectCode financialObject = appointmentFunding.getFinancialObject();
        return this.isDetailPositionRequiredObjectCode(financialObject, objectCode, errorMap, "financialObject");
    }

    @Override
    public boolean hasValidAccount(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String accountNumber = appointmentFunding.getAccountNumber();
        Account account = appointmentFunding.getAccount();
        return this.isValidAccount(account, accountNumber, errorMap, "accountNumber");
    }

    @Override
    public boolean hasValidChart(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String chartOfAccountsCode = appointmentFunding.getChartOfAccountsCode();
        Chart chart = appointmentFunding.getChartOfAccounts();
        return this.isValidChart(chart, chartOfAccountsCode, errorMap, "chartOfAccountsCode");
    }

    @Override
    public boolean hasValidIncumbent(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String emplid = appointmentFunding.getEmplid();
        if ("VACANT".equalsIgnoreCase(emplid)) {
            return true;
        }
        BudgetConstructionIntendedIncumbent intendedIncumbent = appointmentFunding.getBudgetConstructionIntendedIncumbent();
        return this.isValidIncumbent(intendedIncumbent, emplid, errorMap, "emplid");
    }

    @Override
    public boolean hasValidIncumbentQuickSalarySetting(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        return this.hasValidIncumbent(appointmentFunding, errorMap);
    }

    @Override
    public boolean hasValidObjectCode(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String objectCode = appointmentFunding.getFinancialObjectCode();
        ObjectCode financialObject = appointmentFunding.getFinancialObject();
        return this.isValidObjectCode(financialObject, objectCode, errorMap, "financialObjectCode");
    }

    @Override
    public boolean hasValidPosition(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String positionNumber = appointmentFunding.getPositionNumber();
        BudgetConstructionPosition position = appointmentFunding.getBudgetConstructionPosition();
        return this.isValidPosition(position, positionNumber, errorMap, "positionNumber");
    }

    @Override
    public boolean hasValidSubAccount(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String subAccountNumber = appointmentFunding.getSubAccountNumber();
        if (KFSConstants.getDashSubAccountNumber().equals(subAccountNumber)) {
            return true;
        }
        SubAccount subAccount = appointmentFunding.getSubAccount();
        return this.isValidSubAccount(subAccount, subAccountNumber, errorMap, "subAccountName");
    }

    @Override
    public boolean hasValidSubObjectCode(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        String subObjectCode = appointmentFunding.getFinancialSubObjectCode();
        if (KFSConstants.getDashFinancialSubObjectCode().equals(subObjectCode)) {
            return true;
        }
        SubObjectCode subObject = appointmentFunding.getFinancialSubObject();
        return this.isValidSubObjectCode(subObject, subObjectCode, errorMap, "financialSubObjectCode");
    }

    @Override
    public boolean isAssociatedWithValidDocument(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap, String errorPropertyName) {
        BudgetConstructionDocument budgetConstructionDocument = this.budgetDocumentService.getBudgetConstructionDocument(appointmentFunding);
        if (ObjectUtils.isNull((Object)((Object)budgetConstructionDocument))) {
            errorMap.putError(errorPropertyName, "error.existence", new String[0]);
            return false;
        }
        return this.isBudgetableDocument(budgetConstructionDocument, errorMap, errorPropertyName);
    }

    @Override
    public boolean isBudgetableDocument(BudgetConstructionDocument budgetConstructionDocument, MessageMap errorMap, String errorPropertyName) {
        boolean isBudgetAllowed = this.budgetDocumentService.isBudgetableDocument(budgetConstructionDocument);
        if (!isBudgetAllowed) {
            errorMap.putError(errorPropertyName, "error.budget.documentNotBudgetable", new String[]{budgetConstructionDocument.getAccountNumber() + ";" + budgetConstructionDocument.getSubAccountNumber()});
        }
        return isBudgetAllowed;
    }

    @Override
    public boolean isDetailPositionRequiredObjectCode(ObjectCode financialObject, String currentValue, MessageMap errorMap, String errorPropertyName) {
        if (ObjectUtils.isNull((Object)financialObject)) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(ObjectCode.class, (String)"financialObjectCode", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.existence", new String[]{errorMessage});
            return false;
        }
        LaborLedgerObject laborObject = this.laborModuleService.retrieveLaborLedgerObject(financialObject);
        if (laborObject == null || !laborObject.isDetailPositionRequiredIndicator()) {
            errorMap.putError(errorPropertyName, "error.budget.detailPositionNotRequired", new String[]{currentValue});
            return false;
        }
        return true;
    }

    @Override
    public boolean isFieldFormatValid(PendingBudgetConstructionAppointmentFunding appointmentFunding, MessageMap errorMap) {
        return this.dictionaryValidationService.isBusinessObjectValid((BusinessObject)appointmentFunding);
    }

    @Override
    public boolean isValidAccount(Account account, String currentValue, MessageMap errorMap, String errorPropertyName) {
        if (ObjectUtils.isNull((Object)account)) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(Account.class, (String)"accountName", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.existence", new String[]{errorMessage});
            return false;
        }
        if (!account.isActive()) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(Account.class, (String)"accountName", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.inactive", new String[]{errorMessage});
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidChart(Chart chart, String currentValue, MessageMap errorMap, String errorPropertyName) {
        if (ObjectUtils.isNull((Object)chart)) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(Chart.class, (String)"chartOfAccountsCode", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.existence", new String[]{errorMessage});
            return false;
        }
        if (!chart.isActive()) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(Chart.class, (String)"chartOfAccountsCode", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.inactive", new String[]{errorMessage});
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidIncumbent(BudgetConstructionIntendedIncumbent intendedIncumbent, String currentValue, MessageMap errorMap, String errorPropertyName) {
        if (ObjectUtils.isNull((Object)intendedIncumbent)) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(BudgetConstructionIntendedIncumbent.class, (String)"emplid", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.existence", new String[]{errorMessage});
            return false;
        }
        if (!intendedIncumbent.isActive()) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(BudgetConstructionIntendedIncumbent.class, (String)"emplid", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.inactive", new String[]{errorMessage});
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidObjectCode(ObjectCode objectCode, String currentValue, MessageMap errorMap, String errorPropertyName) {
        if (ObjectUtils.isNull((Object)objectCode)) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(ObjectCode.class, (String)"financialObjectCode", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.existence", new String[]{errorMessage});
            return false;
        }
        if (!objectCode.isActive()) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(ObjectCode.class, (String)"financialObjectCode", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.inactive", new String[]{errorMessage});
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidPosition(BudgetConstructionPosition position, String currentValue, MessageMap errorMap, String errorPropertyName) {
        if (ObjectUtils.isNull((Object)position)) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(BudgetConstructionPosition.class, (String)"positionNumber", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.existence", new String[]{errorMessage});
            return false;
        }
        if (!position.isEffective()) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(BudgetConstructionPosition.class, (String)"positionNumber", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.inactive", new String[]{errorMessage});
            return false;
        }
        if (!position.isBudgetedPosition()) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(BudgetConstructionPosition.class, (String)"positionNumber", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.inactive", new String[]{errorMessage});
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidSubAccount(SubAccount subAccount, String currentValue, MessageMap errorMap, String errorPropertyName) {
        if (ObjectUtils.isNull((Object)subAccount)) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(SubAccount.class, (String)"subAccountNumber", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.existence", new String[]{errorMessage});
            return false;
        }
        if (!subAccount.isActive()) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(SubAccount.class, (String)"subAccountNumber", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.document.subAccountInactive", new String[]{errorMessage});
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidSubObjectCode(SubObjectCode subObjectCode, String currentValue, MessageMap errorMap, String errorPropertyName) {
        if (ObjectUtils.isNull((Object)subObjectCode)) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(SubObjectCode.class, (String)"financialSubObjectCode", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.existence", new String[]{errorMessage});
            return false;
        }
        if (!subObjectCode.isActive()) {
            String errorMessage = MessageBuilder.buildErrorMessageWithDataDictionary(SubObjectCode.class, (String)"financialSubObjectCode", (String)currentValue);
            errorMap.putError(errorPropertyName, "error.inactive", new String[]{errorMessage});
            return false;
        }
        return true;
    }

    public void setBudgetDocumentService(BudgetDocumentService budgetDocumentService) {
        this.budgetDocumentService = budgetDocumentService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public void setLaborModuleService(LaborModuleService laborModuleService) {
        this.laborModuleService = laborModuleService;
    }
}

