/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.BudgetConstructionReportMode;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionObjectPick;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionReasonCodePick;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionReportThresholdSettings;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionSubFundPick;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionAccountFundingDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionAccountObjectDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionAccountSummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionLevelSummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionList2PLGReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionMonthSummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionObjectSummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionPositionFundingDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReasonStatisticsReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReasonSummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionSalaryStatisticsReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionSalarySummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionSubFundSummaryReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionSynchronizationProblemsReportService;
import org.kuali.kfs.module.bc.document.service.BudgetReportsControlListService;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionAction;
import org.kuali.kfs.module.bc.document.web.struts.OrganizationReportSelectionForm;
import org.kuali.kfs.module.bc.report.ReportControlListBuildHelper;
import org.kuali.kfs.module.bc.util.BudgetUrlUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.ReportGenerationService;

public class OrganizationReportSelectionAction
extends BudgetExpansionAction {
    private static final Logger LOG = Logger.getLogger(OrganizationReportSelectionAction.class);

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationReportSelectionForm organizationReportSelectionForm = (OrganizationReportSelectionForm)form;
        String principalName = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        BudgetConstructionReportMode reportMode = BudgetConstructionReportMode.getBudgetConstructionReportModeByName(organizationReportSelectionForm.getReportMode());
        if (reportMode == null) {
            LOG.error((Object)("Invalid report mode passed to report select action: " + organizationReportSelectionForm.getReportMode()));
            throw new RuntimeException("Invalid report mode passed to report select action: " + organizationReportSelectionForm.getReportMode());
        }
        ReportControlListBuildHelper buildHelper = (ReportControlListBuildHelper)GlobalVariables.getUserSession().retrieveObject("controlBuildHelper");
        if (buildHelper == null) {
            buildHelper = new ReportControlListBuildHelper();
            Collection<BudgetConstructionPullup> selectedOrganizations = ((BudgetReportsControlListService)SpringContext.getBean(BudgetReportsControlListService.class)).retrieveSelectedOrganziations(principalName);
            buildHelper.addBuildRequest(organizationReportSelectionForm.getCurrentPointOfViewKeyCode(), selectedOrganizations, reportMode.reportBuildMode);
            GlobalVariables.getUserSession().addObject("controlBuildHelper", (Object)buildHelper);
        }
        this.buildControlLists(principalName, organizationReportSelectionForm.getUniversityFiscalYear(), buildHelper, reportMode.reportSelectMode);
        if (BCConstants.Report.ReportSelectMode.ACCOUNT.equals((Object)reportMode.reportSelectMode)) {
            organizationReportSelectionForm.setOperatingModeTitle("");
            return this.performReport(mapping, form, request, response);
        }
        if (BCConstants.Report.ReportSelectMode.SUBFUND.equals((Object)reportMode.reportSelectMode)) {
            organizationReportSelectionForm.setSubFundPickList((List)((BudgetReportsControlListService)SpringContext.getBean(BudgetReportsControlListService.class)).retrieveSubFundList(principalName));
            organizationReportSelectionForm.setOperatingModeTitle("Sub-Fund List Selection");
        } else if (BCConstants.Report.ReportSelectMode.OBJECT_CODE.equals((Object)reportMode.reportSelectMode) || BCConstants.Report.ReportSelectMode.REASON.equals((Object)reportMode.reportSelectMode)) {
            organizationReportSelectionForm.setObjectCodePickList((List)((BudgetReportsControlListService)SpringContext.getBean(BudgetReportsControlListService.class)).retrieveObjectCodeList(principalName));
            organizationReportSelectionForm.setOperatingModeTitle("Salary Object List Selection");
            organizationReportSelectionForm.getBudgetConstructionReportThresholdSettings().setLockThreshold(reportMode.lockThreshold);
        }
        return mapping.findForward("basic");
    }

    protected void buildControlLists(String principalName, Integer universityFiscalYear, ReportControlListBuildHelper buildHelper, BCConstants.Report.ReportSelectMode reportSelectMode) {
        BudgetReportsControlListService budgetReportsControlListService = (BudgetReportsControlListService)SpringContext.getBean(BudgetReportsControlListService.class);
        if (buildHelper.isBuildNeeded()) {
            String[] pointOfViewFields = buildHelper.getRequestedState().getPointOfView().split("[-]");
            budgetReportsControlListService.updateReportsControlList(principalName, universityFiscalYear, pointOfViewFields[0], pointOfViewFields[1], buildHelper.getRequestedState().getBuildMode());
            if (BCConstants.Report.ReportSelectMode.SUBFUND.equals((Object)reportSelectMode)) {
                budgetReportsControlListService.updateReportSubFundGroupSelectList(principalName);
            } else if (BCConstants.Report.ReportSelectMode.OBJECT_CODE.equals((Object)reportSelectMode) || BCConstants.Report.ReportSelectMode.REASON.equals((Object)reportSelectMode)) {
                budgetReportsControlListService.updateReportObjectCodeSelectList(principalName);
            }
            buildHelper.requestBuildComplete();
            GlobalVariables.getUserSession().addObject("controlBuildHelper", (Object)buildHelper);
        }
    }

    public ActionForward performReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationReportSelectionForm organizationReportSelectionForm = (OrganizationReportSelectionForm)form;
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        BudgetConstructionReportMode reportMode = BudgetConstructionReportMode.getBudgetConstructionReportModeByName(organizationReportSelectionForm.getReportMode());
        if (!this.storeCodeSelections(organizationReportSelectionForm, reportMode, principalId)) {
            return mapping.findForward("basic");
        }
        if (!(reportMode != BudgetConstructionReportMode.REASON_STATISTICS_REPORT && reportMode != BudgetConstructionReportMode.REASON_SUMMARY_REPORT && reportMode != BudgetConstructionReportMode.SALARY_SUMMARY_REPORT || this.validThresholdSettings(organizationReportSelectionForm.getBudgetConstructionReportThresholdSettings()))) {
            return mapping.findForward("basic");
        }
        if (reportMode.export) {
            String exportUrl = this.buildReportExportForwardURL(organizationReportSelectionForm, mapping);
            return new ActionForward(exportUrl, true);
        }
        Collection reportSet = this.buildReportData(reportMode, organizationReportSelectionForm.getUniversityFiscalYear(), principalId, organizationReportSelectionForm.isReportConsolidation(), organizationReportSelectionForm.getBudgetConstructionReportThresholdSettings());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (reportSet.isEmpty()) {
            ArrayList<String> messageList = new ArrayList<String>();
            messageList.add("No data found.");
            ((BudgetConstructionReportsServiceHelper)SpringContext.getBean(BudgetConstructionReportsServiceHelper.class)).generatePdf(messageList, baos);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)(reportMode.jasperFileName + ".pdf"));
        } else {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org/kuali/kfs/module/bc/report/BudgetOrgReport", Locale.getDefault());
            HashMap<String, ResourceBundle> reportData = new HashMap<String, ResourceBundle>();
            reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
            ((ReportGenerationService)SpringContext.getBean(ReportGenerationService.class)).generateReportToOutputStream(reportData, (Object)reportSet, "org/kuali/kfs/module/bc/report/" + reportMode.jasperFileName, (OutputStream)baos);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)(reportMode.jasperFileName + ".pdf"));
        }
        return null;
    }

    protected boolean storeCodeSelections(OrganizationReportSelectionForm organizationReportSelectionForm, BudgetConstructionReportMode reportMode, String principalName) {
        boolean codeSelected = true;
        if (BCConstants.Report.ReportSelectMode.SUBFUND.equals((Object)reportMode.reportSelectMode)) {
            if (!this.storedSelectedSubFunds(organizationReportSelectionForm.getSubFundPickList())) {
                codeSelected = false;
            }
        } else if (organizationReportSelectionForm.getOperatingModeTitle().equals("Salary Object List Selection")) {
            if (!this.storedSelectedObjectCodes(organizationReportSelectionForm.getObjectCodePickList())) {
                codeSelected = false;
            }
            if (BCConstants.Report.ReportSelectMode.REASON.equals((Object)reportMode.reportSelectMode) && !organizationReportSelectionForm.getBudgetConstructionReportThresholdSettings().isUseThreshold()) {
                BudgetReportsControlListService budgetReportsControlListService = (BudgetReportsControlListService)SpringContext.getBean(BudgetReportsControlListService.class);
                budgetReportsControlListService.updateReportReasonCodeSelectList(principalName);
                organizationReportSelectionForm.setReasonCodePickList((List)budgetReportsControlListService.retrieveReasonCodeList(principalName));
                organizationReportSelectionForm.setOperatingModeTitle("Reason Code Selection");
                codeSelected = false;
            }
        } else if (organizationReportSelectionForm.getOperatingModeTitle().equals("Reason Code Selection") && !this.storedSelectedReasonCodes(organizationReportSelectionForm.getReasonCodePickList())) {
            codeSelected = false;
        }
        return codeSelected;
    }

    protected Collection buildReportData(BudgetConstructionReportMode reportMode, Integer universityFiscalYear, String principalId, boolean runConsolidated, BudgetConstructionReportThresholdSettings budgetConstructionReportThresholdSettings) {
        Collection<Object> reportData = new ArrayList();
        switch (reportMode) {
            case ACCOUNT_SUMMARY_REPORT: {
                ((BudgetConstructionAccountSummaryReportService)SpringContext.getBean(BudgetConstructionAccountSummaryReportService.class)).updateReportsAccountSummaryTable(principalId, runConsolidated);
                reportData = ((BudgetConstructionAccountSummaryReportService)SpringContext.getBean(BudgetConstructionAccountSummaryReportService.class)).buildReports(universityFiscalYear, principalId, runConsolidated);
                break;
            }
            case SUBFUND_SUMMARY_REPORT: {
                ((BudgetConstructionSubFundSummaryReportService)SpringContext.getBean(BudgetConstructionSubFundSummaryReportService.class)).updateSubFundSummaryReport(principalId);
                reportData = ((BudgetConstructionSubFundSummaryReportService)SpringContext.getBean(BudgetConstructionSubFundSummaryReportService.class)).buildReports(universityFiscalYear, principalId);
                break;
            }
            case LEVEL_SUMMARY_REPORT: {
                ((BudgetConstructionLevelSummaryReportService)SpringContext.getBean(BudgetConstructionLevelSummaryReportService.class)).updateLevelSummaryReport(principalId);
                reportData = ((BudgetConstructionLevelSummaryReportService)SpringContext.getBean(BudgetConstructionLevelSummaryReportService.class)).buildReports(universityFiscalYear, principalId);
                break;
            }
            case OBJECT_SUMMARY_REPORT: {
                ((BudgetConstructionObjectSummaryReportService)SpringContext.getBean(BudgetConstructionObjectSummaryReportService.class)).updateObjectSummaryReport(principalId);
                reportData = ((BudgetConstructionObjectSummaryReportService)SpringContext.getBean(BudgetConstructionObjectSummaryReportService.class)).buildReports(universityFiscalYear, principalId);
                break;
            }
            case ACCOUNT_OBJECT_DETAIL_REPORT: {
                ((BudgetConstructionAccountObjectDetailReportService)SpringContext.getBean(BudgetConstructionAccountObjectDetailReportService.class)).updateAccountObjectDetailReport(principalId, runConsolidated);
                reportData = ((BudgetConstructionAccountObjectDetailReportService)SpringContext.getBean(BudgetConstructionAccountObjectDetailReportService.class)).buildReports(universityFiscalYear, principalId, runConsolidated);
                break;
            }
            case ACCOUNT_FUNDING_DETAIL_REPORT: {
                ((BudgetConstructionAccountFundingDetailReportService)SpringContext.getBean(BudgetConstructionAccountFundingDetailReportService.class)).updateAccountFundingDetailTable(principalId);
                reportData = ((BudgetConstructionAccountFundingDetailReportService)SpringContext.getBean(BudgetConstructionAccountFundingDetailReportService.class)).buildReports(universityFiscalYear, principalId);
                break;
            }
            case MONTH_SUMMARY_REPORT: {
                ((BudgetConstructionMonthSummaryReportService)SpringContext.getBean(BudgetConstructionMonthSummaryReportService.class)).updateMonthSummaryReport(principalId, runConsolidated);
                reportData = ((BudgetConstructionMonthSummaryReportService)SpringContext.getBean(BudgetConstructionMonthSummaryReportService.class)).buildReports(universityFiscalYear, principalId, runConsolidated);
                break;
            }
            case POSITION_FUNDING_DETAIL_REPORT: {
                ((BudgetConstructionPositionFundingDetailReportService)SpringContext.getBean(BudgetConstructionPositionFundingDetailReportService.class)).updatePositionFundingDetailReport(principalId, budgetConstructionReportThresholdSettings);
                reportData = ((BudgetConstructionPositionFundingDetailReportService)SpringContext.getBean(BudgetConstructionPositionFundingDetailReportService.class)).buildReports(universityFiscalYear, principalId);
                break;
            }
            case SALARY_SUMMARY_REPORT: {
                ((BudgetConstructionSalarySummaryReportService)SpringContext.getBean(BudgetConstructionSalarySummaryReportService.class)).updateSalarySummaryReport(principalId, universityFiscalYear, budgetConstructionReportThresholdSettings);
                reportData = ((BudgetConstructionSalarySummaryReportService)SpringContext.getBean(BudgetConstructionSalarySummaryReportService.class)).buildReports(universityFiscalYear, principalId, budgetConstructionReportThresholdSettings);
                break;
            }
            case SALARY_STATISTICS_REPORT: {
                ((BudgetConstructionSalaryStatisticsReportService)SpringContext.getBean(BudgetConstructionSalaryStatisticsReportService.class)).updateSalaryStatisticsReport(principalId, universityFiscalYear);
                reportData = ((BudgetConstructionSalaryStatisticsReportService)SpringContext.getBean(BudgetConstructionSalaryStatisticsReportService.class)).buildReports(universityFiscalYear, principalId);
                break;
            }
            case REASON_SUMMARY_REPORT: {
                ((BudgetConstructionReasonSummaryReportService)SpringContext.getBean(BudgetConstructionReasonSummaryReportService.class)).updateReasonSummaryReport(principalId, universityFiscalYear, budgetConstructionReportThresholdSettings);
                reportData = ((BudgetConstructionReasonSummaryReportService)SpringContext.getBean(BudgetConstructionReasonSummaryReportService.class)).buildReports(universityFiscalYear, principalId, budgetConstructionReportThresholdSettings);
                break;
            }
            case REASON_STATISTICS_REPORT: {
                ((BudgetConstructionReasonStatisticsReportService)SpringContext.getBean(BudgetConstructionReasonStatisticsReportService.class)).updateReasonStatisticsReport(principalId, universityFiscalYear, budgetConstructionReportThresholdSettings);
                reportData = ((BudgetConstructionReasonStatisticsReportService)SpringContext.getBean(BudgetConstructionReasonStatisticsReportService.class)).buildReports(universityFiscalYear, principalId, budgetConstructionReportThresholdSettings);
                break;
            }
            case TWOPLG_LIST_REPORT: {
                ((BudgetConstructionList2PLGReportService)SpringContext.getBean(BudgetConstructionList2PLGReportService.class)).updateList2PLGReport(principalId, universityFiscalYear);
                reportData = ((BudgetConstructionList2PLGReportService)SpringContext.getBean(BudgetConstructionList2PLGReportService.class)).buildReports(universityFiscalYear, principalId);
                break;
            }
            case SYNCHRONIZATION_PROBLEMS_REPORT: {
                ((BudgetConstructionSynchronizationProblemsReportService)SpringContext.getBean(BudgetConstructionSynchronizationProblemsReportService.class)).updateSynchronizationProblemsReport(principalId);
                reportData = ((BudgetConstructionSynchronizationProblemsReportService)SpringContext.getBean(BudgetConstructionSynchronizationProblemsReportService.class)).buildReports(universityFiscalYear, principalId);
            }
        }
        return reportData;
    }

    protected String buildReportExportForwardURL(OrganizationReportSelectionForm organizationReportSelectionForm, ActionMapping mapping) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("reportMode", organizationReportSelectionForm.getReportMode());
        parameters.put("orgReport", "true");
        return BudgetUrlUtil.buildBudgetUrl(mapping, organizationReportSelectionForm, "budgetReportExport.do", parameters);
    }

    public ActionForward selectAllSubFunds(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationReportSelectionForm organizationReportSelectionForm = (OrganizationReportSelectionForm)form;
        for (BudgetConstructionSubFundPick budgetConstructionSubFundPick : organizationReportSelectionForm.getSubFundPickList()) {
            budgetConstructionSubFundPick.setReportFlag(new Integer(1));
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectAllObjectCodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationReportSelectionForm organizationReportSelectionForm = (OrganizationReportSelectionForm)form;
        for (BudgetConstructionObjectPick budgetConstructionObjectPick : organizationReportSelectionForm.getObjectCodePickList()) {
            budgetConstructionObjectPick.setSelectFlag(new Integer(1));
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectAllReasonCodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationReportSelectionForm organizationReportSelectionForm = (OrganizationReportSelectionForm)form;
        for (BudgetConstructionReasonCodePick budgetConstructionReasonCodePick : organizationReportSelectionForm.getReasonCodePickList()) {
            budgetConstructionReasonCodePick.setSelectFlag(new Integer(1));
        }
        return mapping.findForward("basic");
    }

    public ActionForward unselectAllSubFunds(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationReportSelectionForm organizationReportSelectionForm = (OrganizationReportSelectionForm)form;
        for (BudgetConstructionSubFundPick budgetConstructionSubFundPick : organizationReportSelectionForm.getSubFundPickList()) {
            budgetConstructionSubFundPick.setReportFlag(new Integer(0));
        }
        return mapping.findForward("basic");
    }

    public ActionForward unselectAllObjectCodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationReportSelectionForm organizationReportSelectionForm = (OrganizationReportSelectionForm)form;
        for (BudgetConstructionObjectPick budgetConstructionObjectPick : organizationReportSelectionForm.getObjectCodePickList()) {
            budgetConstructionObjectPick.setSelectFlag(new Integer(0));
        }
        return mapping.findForward("basic");
    }

    public ActionForward unselectAllReasonCodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrganizationReportSelectionForm organizationReportSelectionForm = (OrganizationReportSelectionForm)form;
        for (BudgetConstructionReasonCodePick budgetConstructionReasonCodePick : organizationReportSelectionForm.getReasonCodePickList()) {
            budgetConstructionReasonCodePick.setSelectFlag(new Integer(0));
        }
        return mapping.findForward("basic");
    }

    protected boolean storedSelectedSubFunds(List<BudgetConstructionSubFundPick> subFundPickList) {
        boolean foundSelected = false;
        for (BudgetConstructionSubFundPick budgetConstructionSubFundPick : subFundPickList) {
            if (budgetConstructionSubFundPick.getReportFlag() <= 0) continue;
            foundSelected = true;
        }
        if (foundSelected) {
            ((BudgetReportsControlListService)SpringContext.getBean(BudgetReportsControlListService.class)).updateSubFundSelectFlags(subFundPickList);
        } else {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.subFundNotSelected", new String[0]);
        }
        return foundSelected;
    }

    protected boolean storedSelectedObjectCodes(List<BudgetConstructionObjectPick> objectCodePickList) {
        boolean foundSelected = false;
        for (BudgetConstructionObjectPick budgetConstructionObjectPick : objectCodePickList) {
            if (budgetConstructionObjectPick.getSelectFlag() <= 0) continue;
            foundSelected = true;
        }
        if (foundSelected) {
            ((BudgetReportsControlListService)SpringContext.getBean(BudgetReportsControlListService.class)).updateObjectCodeSelectFlags(objectCodePickList);
        } else {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.objectCodeNotSelected", new String[0]);
        }
        return foundSelected;
    }

    protected boolean storedSelectedReasonCodes(List<BudgetConstructionReasonCodePick> reasonCodePickList) {
        boolean foundSelected = false;
        for (BudgetConstructionReasonCodePick budgetConstructionReasonCodePick : reasonCodePickList) {
            if (budgetConstructionReasonCodePick.getSelectFlag() <= 0) continue;
            foundSelected = true;
        }
        if (foundSelected) {
            ((BudgetReportsControlListService)SpringContext.getBean(BudgetReportsControlListService.class)).updateReasonCodeSelectFlags(reasonCodePickList);
        } else {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.reasonCodeNotSelected", new String[0]);
        }
        return foundSelected;
    }

    protected boolean validThresholdSettings(BudgetConstructionReportThresholdSettings thresholdSettings) {
        Boolean thresholdSettingsValid = true;
        if (thresholdSettings.isUseThreshold() && thresholdSettings.getThresholdPercent() == null) {
            thresholdSettingsValid = false;
            GlobalVariables.getMessageMap().putError("budgetConstructionReportThresholdSettings.thresholdPercent", "error.budget.thresholdPercentNeeded", new String[0]);
        }
        return thresholdSettingsValid;
    }
}

