/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.authorization;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.LedgerPostingDocument;
import org.kuali.kfs.sys.document.authorization.FinancialSystemMaintenanceDocumentPresentationControllerBase;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetRetirementPresentationController
extends FinancialSystemMaintenanceDocumentPresentationControllerBase {
    protected static final Map<String, String[]> NON_VIEWABLE_SECTION_MAP = new HashMap<String, String[]>();

    public Set<String> getConditionallyHiddenPropertyNames(BusinessObject businessObject) {
        Set fields = super.getConditionallyHiddenPropertyNames(businessObject);
        MaintenanceDocument document = (MaintenanceDocument)businessObject;
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getNewMaintainableObject().getBusinessObject();
        if (!((AssetRetirementService)SpringContext.getBean(AssetRetirementService.class)).isAssetRetiredByMerged(assetRetirementGlobal)) {
            fields.add("mergedTargetCapitalAssetNumber");
            fields.add("mergedTargetCapitalAssetDescription");
        }
        this.conditionallyHideAssetCollectionEditing(document);
        fields.add("add.assetRetirementGlobalDetails.asset.organizationOwnerChartOfAccountsCode");
        fields.add("add.assetRetirementGlobalDetails.asset.organizationOwnerAccountNumber");
        fields.add("add.assetRetirementGlobalDetails.asset.organizationOwnerAccount.organizationCode");
        fields.add("add.assetRetirementGlobalDetails.asset.acquisitionTypeCode");
        fields.add("add.assetRetirementGlobalDetails.asset.inventoryStatusCode");
        fields.add("add.assetRetirementGlobalDetails.asset.conditionCode");
        fields.add("add.assetRetirementGlobalDetails.asset.capitalAssetDescription");
        fields.add("add.assetRetirementGlobalDetails.asset.capitalAssetTypeCode");
        fields.add("add.assetRetirementGlobalDetails.asset.vendorName");
        fields.add("add.assetRetirementGlobalDetails.asset.manufacturerModelNumber");
        fields.add("add.assetRetirementGlobalDetails.asset.serialNumber");
        fields.add("add.assetRetirementGlobalDetails.asset.campusTagNumber");
        fields.add("add.assetRetirementGlobalDetails.asset.governmentTagNumber");
        fields.add("add.assetRetirementGlobalDetails.asset.lastInventoryDate");
        fields.add("add.assetRetirementGlobalDetails.asset.createDate");
        fields.add("add.assetRetirementGlobalDetails.asset.capitalAssetInServiceDate");
        fields.add("add.assetRetirementGlobalDetails.asset.depreciationDate");
        fields.add("add.assetRetirementGlobalDetails.asset.totalCostAmount");
        fields.add("add.assetRetirementGlobalDetails.asset.accumulatedDepreciation");
        fields.add("add.assetRetirementGlobalDetails.asset.bookValue");
        fields.add("add.assetRetirementGlobalDetails.asset.federalContribution");
        fields.add("add.assetRetirementGlobalDetails.asset.assetOrganization.organizationText");
        return fields;
    }

    protected void conditionallyHideAssetCollectionEditing(MaintenanceDocument document) {
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getNewMaintainableObject().getBusinessObject();
        MaintainableCollectionDefinition maintCollDef = ((MaintenanceDocumentDictionaryService)SpringContext.getBean(MaintenanceDocumentDictionaryService.class)).getMaintainableCollection("ARG", "assetRetirementGlobalDetails");
        if (((AssetService)SpringContext.getBean(AssetService.class)).isDocumentEnrouting((Document)document)) {
            maintCollDef.setIncludeAddLine(false);
            maintCollDef.setIncludeMultipleLookupLine(false);
            for (AssetRetirementGlobalDetail assetDetail : assetRetirementGlobal.getAssetRetirementGlobalDetails()) {
                assetDetail.setNewCollectionRecord(false);
            }
        } else {
            maintCollDef.setIncludeAddLine(true);
            maintCollDef.setIncludeMultipleLookupLine(true);
        }
    }

    public Set<String> getConditionallyHiddenSectionIds(BusinessObject businessObject) {
        String[] nonViewableSections;
        Set fields = super.getConditionallyHiddenSectionIds(businessObject);
        MaintenanceDocument document = (MaintenanceDocument)businessObject;
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getNewMaintainableObject().getBusinessObject();
        String docType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        ParameterEvaluator evaluator = this.getParameterEvaluatorService().getParameterEvaluator("KFS-SYS", "Document", "FISCAL_PERIOD_SELECTION_DOCUMENT_TYPES", docType);
        if (!evaluator.evaluationSucceeds()) {
            fields.add("Accounting Period");
        }
        if ((nonViewableSections = NON_VIEWABLE_SECTION_MAP.get(assetRetirementGlobal.getRetirementReasonCode())) == null) {
            fields.add("AuctionOrSold");
            fields.add("ExternalTransferOrGift");
            fields.add("Theft");
        } else {
            fields.addAll(Arrays.asList(nonViewableSections));
        }
        if (!((AssetRetirementService)SpringContext.getBean(AssetRetirementService.class)).isAssetRetiredByMerged(assetRetirementGlobal)) {
            fields.add("Retirement Target Information");
        }
        return fields;
    }

    public boolean canEdit(Document document) {
        Set<String> nodeNames;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isEnroute() && ((nodeNames = ((AssetService)SpringContext.getBean(AssetService.class)).getCurrentRouteLevels(workflowDocument)).contains("ExternalTransfer") || nodeNames.contains("Purchasing"))) {
            return false;
        }
        return super.canEdit(document);
    }

    public Set<String> getDocumentActions(Document document) {
        Set documentActions = super.getDocumentActions(document);
        if (document instanceof LedgerPostingDocument) {
            String docType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
            ParameterEvaluatorService parameterEvaluatorService = (ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class);
            ParameterEvaluator evaluator = parameterEvaluatorService.getParameterEvaluator("KFS-SYS", "Document", "FISCAL_PERIOD_SELECTION_DOCUMENT_TYPES", docType);
            if (evaluator.evaluationSucceeds()) {
                documentActions.add("AccountingPeriodViewAction");
            }
        }
        return documentActions;
    }

    static {
        NON_VIEWABLE_SECTION_MAP.put("9", new String[]{"AuctionOrSold", "Theft"});
        NON_VIEWABLE_SECTION_MAP.put("6", new String[]{"AuctionOrSold", "Theft"});
        NON_VIEWABLE_SECTION_MAP.put("1", new String[]{"ExternalTransferOrGift", "Theft"});
        NON_VIEWABLE_SECTION_MAP.put("A", new String[]{"ExternalTransferOrGift", "Theft"});
        NON_VIEWABLE_SECTION_MAP.put("7", new String[]{"AuctionOrSold", "ExternalTransferOrGift"});
    }
}

