/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class AssetPaymentDocumentPreRules
extends PromptBeforeValidationBase {
    protected static final Logger LOG = Logger.getLogger(AssetPaymentDocumentPreRules.class);

    public boolean doPrompts(Document document) {
        if (this.hasDifferentObjectSubTypes((AssetPaymentDocument)document) && !this.isOkHavingDifferentObjectSubTypes()) {
            this.event.setActionForwardName("basic");
            return false;
        }
        return true;
    }

    public boolean hasDifferentObjectSubTypes(AssetPaymentDocument document) {
        if (!document.getDocumentHeader().getWorkflowDocument().isSaved() && !document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            return false;
        }
        ArrayList subTypes = new ArrayList();
        subTypes = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(Asset.class, "OBJECT_SUB_TYPE_GROUPS"));
        List assetPaymentDetails = document.getSourceAccountingLines();
        List<Object> validObjectSubTypes = new ArrayList<String>();
        Object objectSubTypeCode = null;
        ArrayList<String> objectSubTypeList = new ArrayList<String>();
        for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
            assetPaymentDetail.refreshReferenceObject("objectCode");
            if (ObjectUtils.isNull((Object)assetPaymentDetail.getObjectCode())) {
                return false;
            }
            objectSubTypeList.add(assetPaymentDetail.getObjectCode().getFinancialObjectSubTypeCode());
        }
        if (!this.getAssetService().isObjectSubTypeCompatible(objectSubTypeList)) {
            return true;
        }
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = document.getAssetPaymentAssetDetail();
        for (AssetPaymentAssetDetail assetPaymentAssetDetail : assetPaymentAssetDetails) {
            assetPaymentAssetDetail.getAsset().refreshReferenceObject("assetPayments");
            List<AssetPayment> assetPayments = assetPaymentAssetDetail.getAsset().getAssetPayments();
            if (assetPayments.isEmpty()) continue;
            for (AssetPayment assetPayment : assetPayments) {
                String subType;
                String paymentSubObjectType = assetPayment.getFinancialObject().getFinancialObjectSubTypeCode();
                validObjectSubTypes = new ArrayList();
                Iterator iterator = subTypes.iterator();
                while (iterator.hasNext() && !(validObjectSubTypes = Arrays.asList(StringUtils.split((String)(subType = (String)iterator.next()), (String)","))).contains(paymentSubObjectType)) {
                    validObjectSubTypes = new ArrayList();
                }
                if (validObjectSubTypes.isEmpty()) {
                    validObjectSubTypes.add(paymentSubObjectType);
                }
                for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
                    if (validObjectSubTypes.contains(assetPaymentDetail.getObjectCode().getFinancialObjectSubTypeCode())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isOkHavingDifferentObjectSubTypes() {
        String parameterDetail = "(module:" + KRADServiceLocatorWeb.getKualiModuleService().getNamespaceCode(AssetGlobal.class) + "/component:" + AssetGlobal.class.getSimpleName() + ")";
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        String continueQuestion = kualiConfiguration.getPropertyValueAsString("document.question.continue.text");
        String warningMessage = kualiConfiguration.getPropertyValueAsString("warning.payment.object.subtype.not_the_same") + " " + "OBJECT_SUB_TYPE_GROUPS" + " " + parameterDetail + ". " + continueQuestion;
        return super.askOrAnalyzeYesNoQuestion("AssetPaymentDifferentObjectSubTypeQuestion", warningMessage);
    }

    protected AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }
}

