/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.location.framework.country.CountryEbo;
import org.kuali.rice.location.framework.postalcode.PostalCodeEbo;
import org.kuali.rice.location.framework.state.StateEbo;

public class EquipmentLoanOrReturnDocument
extends FinancialSystemTransactionalDocumentBase {
    protected static Logger LOG = Logger.getLogger(EquipmentLoanOrReturnDocument.class);
    protected String hiddenFieldForError;
    protected String documentNumber;
    protected Date loanDate;
    protected Date expectedReturnDate;
    protected Date loanReturnDate;
    protected String borrowerUniversalIdentifier;
    protected String borrowerAddress;
    protected String borrowerCityName;
    protected String borrowerStateCode;
    protected String borrowerZipCode;
    protected String borrowerCountryCode;
    protected String borrowerPhoneNumber;
    protected String borrowerStorageAddress;
    protected String borrowerStorageCityName;
    protected String borrowerStorageStateCode;
    protected String borrowerStorageZipCode;
    protected String borrowerStorageCountryCode;
    protected String borrowerStoragePhoneNumber;
    protected Long capitalAssetNumber;
    protected StateEbo borrowerState;
    protected StateEbo borrowerStorageState;
    protected CountryEbo borrowerCountry;
    protected CountryEbo borrowerStorageCountry;
    protected Person borrowerPerson;
    protected Asset asset;
    protected PostalCodeEbo borrowerPostalZipCode;
    protected PostalCodeEbo borrowerStoragePostalZipCode;
    protected boolean newLoan;
    protected boolean returnLoan;

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public CountryEbo getBorrowerCountry() {
        if (StringUtils.isBlank((String)this.borrowerCountryCode)) {
            this.borrowerCountry = null;
        } else if (this.borrowerCountry == null || !StringUtils.equals((String)this.borrowerCountry.getCode(), (String)this.borrowerCountryCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(CountryEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(1);
                keys.put("code", this.borrowerCountryCode);
                this.borrowerCountry = (CountryEbo)moduleService.getExternalizableBusinessObject(CountryEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.borrowerCountry;
    }

    public void setBorrowerCountry(CountryEbo borrowerCountry) {
        this.borrowerCountry = borrowerCountry;
    }

    public StateEbo getBorrowerState() {
        if (StringUtils.isBlank((String)"US") || StringUtils.isBlank((String)this.borrowerStateCode)) {
            this.borrowerState = null;
        } else if (this.borrowerState == null || !StringUtils.equals((String)this.borrowerState.getCode(), (String)this.borrowerStateCode) || !StringUtils.equals((String)this.borrowerState.getCountryCode(), (String)"US")) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(StateEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", this.borrowerCountryCode);
                keys.put("code", this.borrowerStateCode);
                this.borrowerState = (StateEbo)moduleService.getExternalizableBusinessObject(StateEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.borrowerState;
    }

    public void setBorrowerState(StateEbo borrowerState) {
        this.borrowerState = borrowerState;
    }

    public CountryEbo getBorrowerStorageCountry() {
        if (StringUtils.isBlank((String)this.borrowerStorageCountryCode)) {
            this.borrowerStorageCountry = null;
        } else if (this.borrowerStorageCountry == null || !StringUtils.equals((String)this.borrowerStorageCountry.getCode(), (String)this.borrowerStorageCountryCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(CountryEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(1);
                keys.put("code", this.borrowerStorageCountryCode);
                this.borrowerStorageCountry = (CountryEbo)moduleService.getExternalizableBusinessObject(CountryEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.borrowerStorageCountry;
    }

    public void setBorrowerStorageCountry(CountryEbo borrowerStorageCountry) {
        this.borrowerStorageCountry = borrowerStorageCountry;
    }

    public StateEbo getBorrowerStorageState() {
        if (StringUtils.isBlank((String)"US") || StringUtils.isBlank((String)this.borrowerStorageStateCode)) {
            this.borrowerStorageState = null;
        } else if (this.borrowerStorageState == null || !StringUtils.equals((String)this.borrowerStorageState.getCountryCode(), (String)this.borrowerStorageCountryCode) || !StringUtils.equals((String)this.borrowerStorageState.getCode(), (String)this.borrowerStorageStateCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(StateEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", this.borrowerStorageCountryCode);
                keys.put("code", this.borrowerStorageStateCode);
                this.borrowerStorageState = (StateEbo)moduleService.getExternalizableBusinessObject(StateEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.borrowerStorageState;
    }

    public void setBorrowerStorageState(StateEbo borrowerStorageState) {
        this.borrowerStorageState = borrowerStorageState;
    }

    public Person getBorrowerPerson() {
        this.borrowerPerson = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.borrowerUniversalIdentifier, this.borrowerPerson);
        return this.borrowerPerson;
    }

    public void setBorrowerPerson(Person borrowerPerson) {
        this.borrowerPerson = borrowerPerson;
    }

    public String getBorrowerAddress() {
        return this.borrowerAddress;
    }

    public void setBorrowerAddress(String borrowerAddress) {
        this.borrowerAddress = borrowerAddress;
    }

    public String getBorrowerCityName() {
        return this.borrowerCityName;
    }

    public void setBorrowerCityName(String borrowerCityName) {
        this.borrowerCityName = borrowerCityName;
    }

    public String getBorrowerCountryCode() {
        return this.borrowerCountryCode;
    }

    public void setBorrowerCountryCode(String borrowerCountryCode) {
        this.borrowerCountryCode = borrowerCountryCode;
    }

    public String getBorrowerPhoneNumber() {
        return this.borrowerPhoneNumber;
    }

    public void setBorrowerPhoneNumber(String borrowerPhoneNumber) {
        this.borrowerPhoneNumber = borrowerPhoneNumber;
    }

    public String getBorrowerStateCode() {
        return this.borrowerStateCode;
    }

    public void setBorrowerStateCode(String borrowerStateCode) {
        this.borrowerStateCode = borrowerStateCode;
    }

    public String getBorrowerStorageAddress() {
        return this.borrowerStorageAddress;
    }

    public void setBorrowerStorageAddress(String borrowerStorageAddress) {
        this.borrowerStorageAddress = borrowerStorageAddress;
    }

    public String getBorrowerStorageCityName() {
        return this.borrowerStorageCityName;
    }

    public void setBorrowerStorageCityName(String borrowerStorageCityName) {
        this.borrowerStorageCityName = borrowerStorageCityName;
    }

    public String getBorrowerStorageCountryCode() {
        return this.borrowerStorageCountryCode;
    }

    public void setBorrowerStorageCountryCode(String borrowerStorageCountryCode) {
        this.borrowerStorageCountryCode = borrowerStorageCountryCode;
    }

    public String getBorrowerStoragePhoneNumber() {
        return this.borrowerStoragePhoneNumber;
    }

    public void setBorrowerStoragePhoneNumber(String borrowerStoragePhoneNumber) {
        this.borrowerStoragePhoneNumber = borrowerStoragePhoneNumber;
    }

    public String getBorrowerStorageStateCode() {
        return this.borrowerStorageStateCode;
    }

    public void setBorrowerStorageStateCode(String borrowerStorageStateCode) {
        this.borrowerStorageStateCode = borrowerStorageStateCode;
    }

    public String getBorrowerStorageZipCode() {
        return this.borrowerStorageZipCode;
    }

    public void setBorrowerStorageZipCode(String borrowerStorageZipCode) {
        this.borrowerStorageZipCode = borrowerStorageZipCode;
    }

    public PostalCodeEbo getBorrowerPostalZipCode() {
        if (StringUtils.isBlank((String)"US") || StringUtils.isBlank((String)this.borrowerZipCode)) {
            this.borrowerPostalZipCode = null;
        } else if (this.borrowerPostalZipCode == null || !StringUtils.equals((String)this.borrowerPostalZipCode.getCountryCode(), (String)this.borrowerCountryCode) || !StringUtils.equals((String)this.borrowerPostalZipCode.getCode(), (String)this.borrowerZipCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(PostalCodeEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", this.borrowerCountryCode);
                keys.put("code", this.borrowerZipCode);
                this.borrowerPostalZipCode = (PostalCodeEbo)moduleService.getExternalizableBusinessObject(PostalCodeEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.borrowerPostalZipCode;
    }

    public void setBorrowerPostalZipCode(PostalCodeEbo borrowerPostalZipCode) {
        this.borrowerPostalZipCode = borrowerPostalZipCode;
    }

    public PostalCodeEbo getBorrowerStoragePostalZipCode() {
        if (StringUtils.isBlank((String)"US") || StringUtils.isBlank((String)this.borrowerStorageZipCode)) {
            this.borrowerStoragePostalZipCode = null;
        } else if (this.borrowerStoragePostalZipCode == null || !StringUtils.equals((String)this.borrowerStoragePostalZipCode.getCountryCode(), (String)this.borrowerStorageCountryCode) || !StringUtils.equals((String)this.borrowerStoragePostalZipCode.getCode(), (String)this.borrowerStorageZipCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(PostalCodeEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", this.borrowerStorageCountryCode);
                keys.put("code", this.borrowerStorageZipCode);
                this.borrowerStoragePostalZipCode = (PostalCodeEbo)moduleService.getExternalizableBusinessObject(PostalCodeEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.borrowerStoragePostalZipCode;
    }

    public void setborrowerStoragePostalZipCode(PostalCodeEbo borrowerStoragePostalZipCode) {
        this.borrowerStoragePostalZipCode = borrowerStoragePostalZipCode;
    }

    public String getBorrowerUniversalIdentifier() {
        return this.borrowerUniversalIdentifier;
    }

    public void setBorrowerUniversalIdentifier(String borrowerUniversalIdentifier) {
        this.borrowerUniversalIdentifier = borrowerUniversalIdentifier;
    }

    public String getBorrowerZipCode() {
        return this.borrowerZipCode;
    }

    public void setBorrowerZipCode(String borrowerZipCode) {
        this.borrowerZipCode = borrowerZipCode;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Date getExpectedReturnDate() {
        return this.expectedReturnDate;
    }

    public void setExpectedReturnDate(Date expectedReturnDate) {
        this.expectedReturnDate = expectedReturnDate;
    }

    public Date getLoanDate() {
        if (this.loanDate != null) {
            return this.loanDate;
        }
        return ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
    }

    public void setLoanDate(Date loanDate) {
        this.loanDate = loanDate;
    }

    public Date getLoanReturnDate() {
        return this.loanReturnDate;
    }

    public void setLoanReturnDate(Date loanReturnDate) {
        this.loanReturnDate = loanReturnDate;
    }

    public void postProcessSave(KualiDocumentEvent event) {
        super.postProcessSave(event);
        if (!(event instanceof SaveDocumentEvent)) {
            ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
            if (this.getCapitalAssetNumber() != null) {
                capitalAssetNumbers.add(this.getCapitalAssetNumber());
            }
            if (!this.getCapitalAssetManagementModuleService().storeAssetLocks(capitalAssetNumbers, this.getDocumentNumber(), "ELR", null)) {
                throw new ValidationException("Asset " + capitalAssetNumbers.toString() + " is being locked by other documents.");
            }
        }
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isProcessed()) {
            ((EquipmentLoanOrReturnService)SpringContext.getBean(EquipmentLoanOrReturnService.class)).processApprovedEquipmentLoanOrReturn(this);
        }
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isProcessed()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.documentNumber);
        return m;
    }

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public boolean isNewLoan() {
        return this.newLoan;
    }

    public void setNewLoan(boolean newLoan) {
        this.newLoan = newLoan;
    }

    public boolean isReturnLoan() {
        return this.returnLoan;
    }

    public void setReturnLoan(boolean returnLoan) {
        this.returnLoan = returnLoan;
    }

    public String getHiddenFieldForError() {
        return this.hiddenFieldForError;
    }

    public void setHiddenFieldForError(String hiddenFieldForError) {
        this.hiddenFieldForError = hiddenFieldForError;
    }
}

