/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.batch;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.gl.businessobject.Entry;

public class ExtractProcessLog {
    private Timestamp startTime;
    private Timestamp finishTime;
    private Timestamp lastExtractTime;
    private List<Entry> ignoredGLEntries;
    private List<Entry> duplicateGLEntries;
    private List<Entry> mismatchedGLEntries;
    private String errorMessage;
    private boolean success = true;
    private Integer totalGlCount = 0;
    private Integer nonPurApGlCount = 0;
    private Integer purApGlCount = 0;
    private String statusMessage;

    public List<Entry> getIgnoredGLEntries() {
        return this.ignoredGLEntries;
    }

    public void setIgnoredGLEntries(List<Entry> ignoredGLEntries) {
        this.ignoredGLEntries = ignoredGLEntries;
    }

    public List<Entry> getDuplicateGLEntries() {
        return this.duplicateGLEntries;
    }

    public void setDuplicateGLEntries(List<Entry> duplicateGLEntries) {
        this.duplicateGLEntries = duplicateGLEntries;
    }

    public List<Entry> getMismatchedGLEntries() {
        return this.mismatchedGLEntries;
    }

    public void setMismatchedGLEntries(List<Entry> mismatchedGLEntries) {
        this.mismatchedGLEntries = mismatchedGLEntries;
    }

    public void addIgnoredGLEntries(Collection<Entry> add) {
        if (this.ignoredGLEntries == null) {
            this.ignoredGLEntries = new ArrayList<Entry>();
        }
        this.ignoredGLEntries.addAll(add);
    }

    public void addDuplicateGLEntries(Collection<Entry> add) {
        if (this.duplicateGLEntries == null) {
            this.duplicateGLEntries = new ArrayList<Entry>();
        }
        this.duplicateGLEntries.addAll(add);
    }

    public void addMismatchedGLEntries(Collection<Entry> add) {
        if (this.mismatchedGLEntries == null) {
            this.mismatchedGLEntries = new ArrayList<Entry>();
        }
        this.mismatchedGLEntries.addAll(add);
    }

    public void addIgnoredGLEntry(Entry add) {
        if (this.ignoredGLEntries == null) {
            this.ignoredGLEntries = new ArrayList<Entry>();
        }
        this.ignoredGLEntries.add(add);
    }

    public void addDuplicateGLEntry(Entry add) {
        if (this.duplicateGLEntries == null) {
            this.duplicateGLEntries = new ArrayList<Entry>();
        }
        this.duplicateGLEntries.add(add);
    }

    public void addMismatchedGLEntry(Entry add) {
        if (this.mismatchedGLEntries == null) {
            this.mismatchedGLEntries = new ArrayList<Entry>();
        }
        this.mismatchedGLEntries.add(add);
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getLastExtractTime() {
        return this.lastExtractTime;
    }

    public void setLastExtractTime(Timestamp lastExtractTime) {
        this.lastExtractTime = lastExtractTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Timestamp getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Timestamp finishTime) {
        this.finishTime = finishTime;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Integer getTotalGlCount() {
        return this.totalGlCount;
    }

    public void setTotalGlCount(Integer totalGlCount) {
        this.totalGlCount = totalGlCount;
    }

    public Integer getNonPurApGlCount() {
        return this.nonPurApGlCount;
    }

    public void setNonPurApGlCount(Integer nonPurApGlCount) {
        this.nonPurApGlCount = nonPurApGlCount;
    }

    public Integer getPurApGlCount() {
        return this.purApGlCount;
    }

    public void setPurApGlCount(Integer purApGlCount) {
        this.purApGlCount = purApGlCount;
    }

    public String getStatusMessage() {
        if (this.statusMessage == null) {
            return this.success ? "Success" : (this.errorMessage == null ? "" : this.errorMessage);
        }
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }
}

