/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.GlobalBusinessObjectDetail;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementReason;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.location.framework.country.CountryEbo;
import org.kuali.rice.location.framework.postalcode.PostalCodeEbo;
import org.kuali.rice.location.framework.state.StateEbo;

public class AssetRetirementGlobal
extends PersistableBusinessObjectBase
implements GlobalBusinessObject {
    protected String documentNumber;
    protected Long mergedTargetCapitalAssetNumber;
    protected String mergedTargetCapitalAssetDescription;
    protected String retirementReasonCode;
    protected String retirementChartOfAccountsCode;
    protected String retirementAccountNumber;
    protected String retirementContactName;
    protected String retirementInstitutionName;
    protected String retirementStreetAddress;
    protected String retirementCityName;
    protected String retirementStateCode;
    protected String retirementZipCode;
    protected String retirementCountryCode;
    protected String retirementPhoneNumber;
    protected KualiDecimal estimatedSellingPrice;
    protected KualiDecimal salePrice;
    protected String cashReceiptFinancialDocumentNumber;
    protected KualiDecimal handlingFeeAmount;
    protected KualiDecimal preventiveMaintenanceAmount;
    protected String buyerDescription;
    protected String paidCaseNumber;
    protected Date retirementDate;
    protected Asset mergedTargetCapitalAsset;
    protected AssetRetirementReason retirementReason;
    protected FinancialSystemDocumentHeader documentHeader;
    protected List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = new ArrayList<AssetRetirementGlobalDetail>();
    protected Account retirementAccount;
    protected Chart retirementChartOfAccounts;
    protected DocumentHeader cashReceiptFinancialDocument;
    protected StateEbo retirementState;
    protected CountryEbo retirementCountry;
    protected PostalCodeEbo postalZipCode;
    protected List<GeneralLedgerPendingEntry> generalLedgerPendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
    protected Integer postingYear;
    protected String postingPeriodCode;
    protected AccountingPeriod accountingPeriod;
    protected static transient AccountingPeriodService accountingPeriodService;
    protected KualiDecimal calculatedTotal;

    public List<PersistableBusinessObject> generateDeactivationsToPersist() {
        return null;
    }

    public List<PersistableBusinessObject> generateGlobalChangesToPersist() {
        AssetRetirementService retirementService = (AssetRetirementService)SpringContext.getBean(AssetRetirementService.class);
        ArrayList<PersistableBusinessObject> persistables = new ArrayList<PersistableBusinessObject>();
        if (retirementService.isAssetRetiredByMerged(this) && this.mergedTargetCapitalAsset != null) {
            this.setMergeObjectsForPersist(persistables, retirementService);
        }
        for (AssetRetirementGlobalDetail detail : this.assetRetirementGlobalDetails) {
            this.setAssetForPersist(detail.getAsset(), persistables, retirementService);
        }
        return persistables;
    }

    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        List managedList = super.buildListOfDeletionAwareLists();
        managedList.add(new ArrayList<AssetRetirementGlobalDetail>(this.getAssetRetirementGlobalDetails()));
        return managedList;
    }

    protected void setAssetForPersist(Asset asset, List<PersistableBusinessObject> persistables, AssetRetirementService retirementService) {
        UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        asset.setInventoryStatusCode("R");
        asset.setRetirementReasonCode(this.retirementReasonCode);
        UniversityDate currentUniversityDate = universityDateService.getCurrentUniversityDate();
        if (ObjectUtils.isNotNull((Object)currentUniversityDate)) {
            asset.setRetirementFiscalYear(universityDateService.getCurrentUniversityDate().getUniversityFiscalYear());
            asset.setRetirementPeriodCode(universityDateService.getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
        }
        if (retirementService.isAssetRetiredByTheft(this) && StringUtils.isNotBlank((String)this.getPaidCaseNumber())) {
            asset.setCampusPoliceDepartmentCaseNumber(this.getPaidCaseNumber());
        } else if (retirementService.isAssetRetiredBySold(this) || retirementService.isAssetRetiredByAuction(this)) {
            asset.setRetirementChartOfAccountsCode(this.getRetirementChartOfAccountsCode());
            asset.setRetirementAccountNumber(this.getRetirementAccountNumber());
            asset.setCashReceiptFinancialDocumentNumber(this.getCashReceiptFinancialDocumentNumber());
            asset.setSalePrice(this.getSalePrice());
            asset.setEstimatedSellingPrice(this.getEstimatedSellingPrice());
        } else if (retirementService.isAssetRetiredByMerged(this)) {
            asset.setTotalCostAmount(KualiDecimal.ZERO);
            asset.setSalvageAmount(KualiDecimal.ZERO);
        } else if (retirementService.isAssetRetiredByExternalTransferOrGift(this)) {
            persistables.add((PersistableBusinessObject)this.setOffCampusLocationObjectsForPersist(asset));
        }
        asset.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
        persistables.add((PersistableBusinessObject)asset);
    }

    protected AssetLocation setOffCampusLocationObjectsForPersist(Asset asset) {
        AssetLocation offCampusLocation = new AssetLocation();
        offCampusLocation.setCapitalAssetNumber(asset.getCapitalAssetNumber());
        offCampusLocation.setAssetLocationTypeCode("R");
        offCampusLocation = (AssetLocation)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).retrieve((PersistableBusinessObject)offCampusLocation);
        if (offCampusLocation == null) {
            offCampusLocation = new AssetLocation();
            offCampusLocation.setCapitalAssetNumber(asset.getCapitalAssetNumber());
            offCampusLocation.setAssetLocationTypeCode("R");
            asset.getAssetLocations().add(offCampusLocation);
        }
        offCampusLocation.setAssetLocationContactName(this.getRetirementContactName());
        offCampusLocation.setAssetLocationInstitutionName(this.getRetirementInstitutionName());
        offCampusLocation.setAssetLocationPhoneNumber(this.getRetirementPhoneNumber());
        offCampusLocation.setAssetLocationStreetAddress(this.getRetirementStreetAddress());
        offCampusLocation.setAssetLocationCityName(this.getRetirementCityName());
        offCampusLocation.setAssetLocationStateCode(this.getRetirementStateCode());
        offCampusLocation.setAssetLocationCountryCode(this.getRetirementCountryCode());
        offCampusLocation.setAssetLocationZipCode(this.getRetirementZipCode());
        return offCampusLocation;
    }

    protected void setMergeObjectsForPersist(List<PersistableBusinessObject> persistables, AssetRetirementService retirementService) {
        PaymentSummaryService paymentSummaryService = (PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class);
        AssetPaymentService assetPaymentService = (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
        Integer maxTargetSequenceNo = assetPaymentService.getMaxSequenceNumber(this.mergedTargetCapitalAssetNumber);
        KualiDecimal salvageAmount = KualiDecimal.ZERO;
        KualiDecimal totalCostAmount = KualiDecimal.ZERO;
        for (AssetRetirementGlobalDetail detail : this.getAssetRetirementGlobalDetails()) {
            detail.refreshReferenceObject("asset");
            Asset sourceAsset = detail.getAsset();
            totalCostAmount = (KualiDecimal)totalCostAmount.add((AbstractKualiDecimal)paymentSummaryService.calculatePaymentTotalCost(sourceAsset));
            salvageAmount = (KualiDecimal)salvageAmount.add((AbstractKualiDecimal)sourceAsset.getSalvageAmount());
            retirementService.generateOffsetPaymentsForEachSource(sourceAsset, persistables, detail.getDocumentNumber());
            maxTargetSequenceNo = retirementService.generateNewPaymentForTarget(this.mergedTargetCapitalAsset, sourceAsset, persistables, maxTargetSequenceNo, detail.getDocumentNumber());
        }
        KualiDecimal mergedTargetSalvageAmount = this.mergedTargetCapitalAsset.getSalvageAmount() != null ? this.mergedTargetCapitalAsset.getSalvageAmount() : KualiDecimal.ZERO;
        this.mergedTargetCapitalAsset.setTotalCostAmount((KualiDecimal)totalCostAmount.add((AbstractKualiDecimal)paymentSummaryService.calculatePaymentTotalCost(this.mergedTargetCapitalAsset)));
        this.mergedTargetCapitalAsset.setSalvageAmount((KualiDecimal)salvageAmount.add((AbstractKualiDecimal)mergedTargetSalvageAmount));
        this.mergedTargetCapitalAsset.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
        this.mergedTargetCapitalAsset.setCapitalAssetDescription(this.getMergedTargetCapitalAssetDescription());
        persistables.add((PersistableBusinessObject)this.mergedTargetCapitalAsset);
    }

    public List<? extends GlobalBusinessObjectDetail> getAllDetailObjects() {
        return this.getAssetRetirementGlobalDetails();
    }

    public boolean isPersistable() {
        return true;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getMergedTargetCapitalAssetNumber() {
        return this.mergedTargetCapitalAssetNumber;
    }

    public void setMergedTargetCapitalAssetNumber(Long mergedTargetCapitalAssetNumber) {
        this.mergedTargetCapitalAssetNumber = mergedTargetCapitalAssetNumber;
    }

    public String getRetirementReasonCode() {
        return this.retirementReasonCode;
    }

    public void setRetirementReasonCode(String retirementReasonCode) {
        this.retirementReasonCode = retirementReasonCode;
    }

    public Date getRetirementDate() {
        return this.retirementDate;
    }

    public void setRetirementDate(Date remeretirementDatentDate) {
        this.retirementDate = remeretirementDatentDate;
    }

    public Asset getMergedTargetCapitalAsset() {
        return this.mergedTargetCapitalAsset;
    }

    public void setMergedTargetCapitalAsset(Asset mergedTargetCapitalAsset) {
        this.mergedTargetCapitalAsset = mergedTargetCapitalAsset;
    }

    public AssetRetirementReason getRetirementReason() {
        return this.retirementReason;
    }

    public void setRetirementReason(AssetRetirementReason retirementReason) {
        this.retirementReason = retirementReason;
    }

    public FinancialSystemDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void setDocumentHeader(FinancialSystemDocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public List<AssetRetirementGlobalDetail> getAssetRetirementGlobalDetails() {
        return this.assetRetirementGlobalDetails;
    }

    public void setAssetRetirementGlobalDetails(List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails) {
        this.assetRetirementGlobalDetails = assetRetirementGlobalDetails;
    }

    public List<GeneralLedgerPendingEntry> getGeneralLedgerPendingEntries() {
        return this.generalLedgerPendingEntries;
    }

    public void setGeneralLedgerPendingEntries(List<GeneralLedgerPendingEntry> glPendingEntries) {
        this.generalLedgerPendingEntries = glPendingEntries;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.documentNumber);
        return m;
    }

    public String getMergedTargetCapitalAssetDescription() {
        return this.mergedTargetCapitalAssetDescription;
    }

    public void setMergedTargetCapitalAssetDescription(String mergedTargetCapitalAssetDescription) {
        this.mergedTargetCapitalAssetDescription = mergedTargetCapitalAssetDescription;
    }

    public String getRetirementChartOfAccountsCode() {
        return this.retirementChartOfAccountsCode;
    }

    public void setRetirementChartOfAccountsCode(String retirementChartOfAccountsCode) {
        this.retirementChartOfAccountsCode = retirementChartOfAccountsCode;
    }

    public String getRetirementAccountNumber() {
        return this.retirementAccountNumber;
    }

    public void setRetirementAccountNumber(String retirementAccountNumber) {
        this.retirementAccountNumber = retirementAccountNumber;
    }

    public String getRetirementContactName() {
        return this.retirementContactName;
    }

    public void setRetirementContactName(String retirementContactName) {
        this.retirementContactName = retirementContactName;
    }

    public String getRetirementInstitutionName() {
        return this.retirementInstitutionName;
    }

    public void setRetirementInstitutionName(String retirementInstitutionName) {
        this.retirementInstitutionName = retirementInstitutionName;
    }

    public String getRetirementStreetAddress() {
        return this.retirementStreetAddress;
    }

    public void setRetirementStreetAddress(String retirementStreetAddress) {
        this.retirementStreetAddress = retirementStreetAddress;
    }

    public String getRetirementCityName() {
        return this.retirementCityName;
    }

    public void setRetirementCityName(String retirementCityName) {
        this.retirementCityName = retirementCityName;
    }

    public String getRetirementStateCode() {
        return this.retirementStateCode;
    }

    public void setRetirementStateCode(String retirementStateCode) {
        this.retirementStateCode = retirementStateCode;
    }

    public String getRetirementZipCode() {
        return this.retirementZipCode;
    }

    public void setRetirementZipCode(String retirementZipCode) {
        this.retirementZipCode = retirementZipCode;
    }

    public PostalCodeEbo getPostalZipCode() {
        if (StringUtils.isBlank((String)this.retirementCountryCode) || StringUtils.isBlank((String)this.retirementZipCode)) {
            this.postalZipCode = null;
        } else if (this.postalZipCode == null || !StringUtils.equals((String)this.postalZipCode.getCode(), (String)this.retirementZipCode) || !StringUtils.equals((String)this.postalZipCode.getCountyCode(), (String)"US")) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(PostalCodeEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", this.retirementCountryCode);
                keys.put("code", this.retirementZipCode);
                this.postalZipCode = (PostalCodeEbo)moduleService.getExternalizableBusinessObject(PostalCodeEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.postalZipCode;
    }

    public void setPostalZipCode(PostalCodeEbo postalZipCode) {
        this.postalZipCode = postalZipCode;
    }

    public String getRetirementCountryCode() {
        return this.retirementCountryCode;
    }

    public void setRetirementCountryCode(String retirementCountryCode) {
        this.retirementCountryCode = retirementCountryCode;
    }

    public String getRetirementPhoneNumber() {
        return this.retirementPhoneNumber;
    }

    public void setRetirementPhoneNumber(String retirementPhoneNumber) {
        this.retirementPhoneNumber = retirementPhoneNumber;
    }

    public KualiDecimal getEstimatedSellingPrice() {
        return this.estimatedSellingPrice;
    }

    public void setEstimatedSellingPrice(KualiDecimal estimatedSellingPrice) {
        this.estimatedSellingPrice = estimatedSellingPrice;
    }

    public KualiDecimal getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(KualiDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public String getCashReceiptFinancialDocumentNumber() {
        return this.cashReceiptFinancialDocumentNumber;
    }

    public void setCashReceiptFinancialDocumentNumber(String cashReceiptFinancialDocumentNumber) {
        this.cashReceiptFinancialDocumentNumber = cashReceiptFinancialDocumentNumber;
    }

    public KualiDecimal getHandlingFeeAmount() {
        return this.handlingFeeAmount;
    }

    public void setHandlingFeeAmount(KualiDecimal handlingFeeAmount) {
        this.handlingFeeAmount = handlingFeeAmount;
    }

    public KualiDecimal getPreventiveMaintenanceAmount() {
        return this.preventiveMaintenanceAmount;
    }

    public void setPreventiveMaintenanceAmount(KualiDecimal preventiveMaintenanceAmount) {
        this.preventiveMaintenanceAmount = preventiveMaintenanceAmount;
    }

    public String getBuyerDescription() {
        return this.buyerDescription;
    }

    public void setBuyerDescription(String buyerDescription) {
        this.buyerDescription = buyerDescription;
    }

    public String getPaidCaseNumber() {
        return this.paidCaseNumber;
    }

    public void setPaidCaseNumber(String paidCaseNumber) {
        this.paidCaseNumber = paidCaseNumber;
    }

    public Chart getRetirementChartOfAccounts() {
        return this.retirementChartOfAccounts;
    }

    public void setRetirementChartOfAccounts(Chart retirementChartOfAccounts) {
        this.retirementChartOfAccounts = retirementChartOfAccounts;
    }

    public Account getRetirementAccount() {
        return this.retirementAccount;
    }

    public void setRetirementAccount(Account retirementAccount) {
        this.retirementAccount = retirementAccount;
    }

    public DocumentHeader getCashReceiptFinancialDocument() {
        return this.cashReceiptFinancialDocument;
    }

    public void setCashReceiptFinancialDocument(DocumentHeader cashReceiptFinancialDocument) {
        this.cashReceiptFinancialDocument = cashReceiptFinancialDocument;
    }

    public CountryEbo getRetirementCountry() {
        if (StringUtils.isBlank((String)this.retirementCountryCode)) {
            this.retirementCountry = null;
        } else if (this.retirementCountry == null || !StringUtils.equals((String)this.retirementCountry.getCode(), (String)this.retirementCountryCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(CountryEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(1);
                keys.put("code", this.retirementCountryCode);
                this.retirementCountry = (CountryEbo)moduleService.getExternalizableBusinessObject(CountryEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.retirementCountry;
    }

    public void setRetirementCountry(CountryEbo retirementCountry) {
        this.retirementCountry = retirementCountry;
    }

    public StateEbo getRetirementState() {
        if (StringUtils.isBlank((String)this.retirementStateCode) || StringUtils.isBlank((String)"US")) {
            this.retirementState = null;
        } else if (this.retirementState == null || !StringUtils.equals((String)this.retirementState.getCode(), (String)this.retirementStateCode) || !StringUtils.equals((String)this.retirementState.getCountryCode(), (String)"US")) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(StateEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", "US");
                keys.put("code", this.retirementStateCode);
                this.retirementState = (StateEbo)moduleService.getExternalizableBusinessObject(StateEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.retirementState;
    }

    public void setRetirementState(StateEbo retirementState) {
        this.retirementState = retirementState;
    }

    public KualiDecimal getCalculatedTotal() {
        this.calculatedTotal = KualiDecimal.ZERO;
        if (this.handlingFeeAmount != null) {
            this.calculatedTotal = (KualiDecimal)this.calculatedTotal.add((AbstractKualiDecimal)this.handlingFeeAmount);
        }
        if (this.preventiveMaintenanceAmount != null) {
            this.calculatedTotal = (KualiDecimal)this.calculatedTotal.add((AbstractKualiDecimal)this.preventiveMaintenanceAmount);
        }
        if (this.salePrice != null) {
            this.calculatedTotal = (KualiDecimal)this.calculatedTotal.add((AbstractKualiDecimal)this.salePrice);
        }
        return this.calculatedTotal;
    }

    public Integer getPostingYear() {
        return this.postingYear;
    }

    public void setPostingYear(Integer postingYear) {
        this.postingYear = postingYear;
    }

    public static AccountingPeriodService getAccountingPeriodService() {
        if (accountingPeriodService == null) {
            accountingPeriodService = (AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class);
        }
        return accountingPeriodService;
    }

    public String getAccountingPeriodCompositeString() {
        if (this.postingPeriodCode == null || this.postingYear == null) {
            return "";
        }
        return this.postingPeriodCode + this.postingYear;
    }

    public void setAccountingPeriodCompositeString(String accountingPeriodString) {
        String THIRTEEN = "13";
        if (StringUtils.isNotBlank((String)accountingPeriodString) && StringUtils.left((String)accountingPeriodString, (int)2).equals(THIRTEEN)) {
            String period = StringUtils.left((String)accountingPeriodString, (int)2);
            Integer year = new Integer(StringUtils.right((String)accountingPeriodString, (int)4));
            AccountingPeriod accountingPeriod = AssetRetirementGlobal.getAccountingPeriodService().getByPeriod(period, year);
            this.setAccountingPeriod(accountingPeriod);
        }
    }

    public String getPostingPeriodCode() {
        return this.postingPeriodCode;
    }

    public void setPostingPeriodCode(String postingPeriodCode) {
        this.postingPeriodCode = postingPeriodCode;
    }

    public void setAccountingPeriod(AccountingPeriod accountingPeriod) {
        this.accountingPeriod = accountingPeriod;
        if (ObjectUtils.isNotNull((Object)accountingPeriod)) {
            this.setPostingYear(accountingPeriod.getUniversityFiscalYear());
            this.setPostingPeriodCode(accountingPeriod.getUniversityFiscalPeriodCode());
        }
    }

    public AccountingPeriod getAccountingPeriod() {
        return this.accountingPeriod;
    }
}

