/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.batch.service.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.kuali.kfs.module.cab.batch.ExtractProcessLog;
import org.kuali.kfs.module.cab.batch.service.BatchExtractReportService;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class BatchExtractReportServiceImpl
implements BatchExtractReportService {
    protected ReportGenerationService reportGenerationService;
    protected ReportInfo cabBatchStatusReportInfo;
    protected ReportInfo cabBatchMismatchReportInfo;
    protected DateTimeService dateTimeService;

    @Override
    public File generateStatusReportPDF(ExtractProcessLog extractProcessLog) {
        String reportFileName = this.cabBatchStatusReportInfo.getReportFileName();
        String reportDirectoty = this.cabBatchStatusReportInfo.getReportsDirectory();
        String reportTemplateClassPath = this.cabBatchStatusReportInfo.getReportTemplateClassPath();
        String reportTemplateName = this.cabBatchStatusReportInfo.getReportTemplateName();
        ResourceBundle resourceBundle = this.cabBatchStatusReportInfo.getResourceBundle();
        String subReportTemplateClassPath = this.cabBatchStatusReportInfo.getSubReportTemplateClassPath();
        Map subReports = this.cabBatchStatusReportInfo.getSubReports();
        HashMap<String, Object> reportData = new HashMap<String, Object>();
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.reportGenerationService.buildFullFileName(this.dateTimeService.getCurrentDate(), reportDirectoty, reportFileName, "");
        ArrayList<ExtractProcessLog> dataSource = new ArrayList<ExtractProcessLog>();
        dataSource.add(extractProcessLog);
        this.reportGenerationService.generateReportToPdfFile(reportData, dataSource, template, fullReportFileName);
        return new File(fullReportFileName + ".pdf");
    }

    @Override
    public File generateMismatchReportPDF(ExtractProcessLog extractProcessLog) {
        String reportFileName = this.cabBatchMismatchReportInfo.getReportFileName();
        String reportDirectoty = this.cabBatchMismatchReportInfo.getReportsDirectory();
        String reportTemplateClassPath = this.cabBatchMismatchReportInfo.getReportTemplateClassPath();
        String reportTemplateName = this.cabBatchMismatchReportInfo.getReportTemplateName();
        ResourceBundle resourceBundle = this.cabBatchMismatchReportInfo.getResourceBundle();
        String subReportTemplateClassPath = this.cabBatchMismatchReportInfo.getSubReportTemplateClassPath();
        Map subReports = this.cabBatchMismatchReportInfo.getSubReports();
        HashMap<String, Object> reportData = new HashMap<String, Object>();
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.reportGenerationService.buildFullFileName(this.dateTimeService.getCurrentDate(), reportDirectoty, reportFileName, "");
        ArrayList<ExtractProcessLog> dataSource = new ArrayList<ExtractProcessLog>();
        dataSource.add(extractProcessLog);
        this.reportGenerationService.generateReportToPdfFile(reportData, dataSource, template, fullReportFileName);
        return new File(fullReportFileName + ".pdf");
    }

    public ReportGenerationService getReportGenerationService() {
        return this.reportGenerationService;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ReportInfo getCabBatchStatusReportInfo() {
        return this.cabBatchStatusReportInfo;
    }

    public void setCabBatchStatusReportInfo(ReportInfo cabBatchStatusReportInfo) {
        this.cabBatchStatusReportInfo = cabBatchStatusReportInfo;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ReportInfo getCabBatchMismatchReportInfo() {
        return this.cabBatchMismatchReportInfo;
    }

    public void setCabBatchMismatchReportInfo(ReportInfo cabBatchMismatchReportInfo) {
        this.cabBatchMismatchReportInfo = cabBatchMismatchReportInfo;
    }
}

