/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.kew.api.WorkflowDocument;

public class AssetServiceImpl
implements AssetService {
    protected static Logger LOG = Logger.getLogger(AssetServiceImpl.class);
    private ParameterService parameterService;
    private PaymentSummaryService paymentSummaryService;
    private BusinessObjectService businessObjectService;

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public boolean isAssetMovableCheckByAsset(Asset asset) {
        asset.refreshReferenceObject("capitalAssetType");
        return asset.getCapitalAssetType().isMovingIndicator();
    }

    @Override
    public boolean isAssetDepreciationStarted(Asset asset) {
        if (ObjectUtils.isNotNull((Object)asset.getAccumulatedDepreciation()) && asset.getAccumulatedDepreciation().isPositive()) {
            return true;
        }
        for (AssetPayment assetPayment : asset.getAssetPayments()) {
            if (!ObjectUtils.isNotNull((Object)assetPayment.getAccumulatedPrimaryDepreciationAmount()) || !assetPayment.getAccumulatedPrimaryDepreciationAmount().isPositive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCapitalAsset(Asset asset) {
        return this.parameterService.getParameterValuesAsString(Asset.class, "CAPITAL_ASSET_STATUS_CODES").contains(asset.getInventoryStatusCode());
    }

    @Override
    public boolean isAssetRetired(Asset asset) {
        return this.parameterService.getParameterValuesAsString(Asset.class, "RETIRED_STATUS_CODES").contains(asset.getInventoryStatusCode());
    }

    @Override
    public boolean isInServiceDateChanged(Asset oldAsset, Asset newAsset) {
        return !(!ObjectUtils.isNull((Object)oldAsset.getCapitalAssetInServiceDate()) ? oldAsset.getCapitalAssetInServiceDate().equals(newAsset.getCapitalAssetInServiceDate()) : ObjectUtils.isNull((Object)newAsset.getCapitalAssetInServiceDate()));
    }

    @Override
    public boolean isAssetFabrication(MaintenanceDocument maintenanceDocument) {
        return maintenanceDocument.getNewMaintainableObject().getBusinessObject() instanceof Asset && maintenanceDocument.isNew();
    }

    @Override
    public boolean isAssetLoaned(Asset asset) {
        return ObjectUtils.isNotNull((Object)asset.getExpectedReturnDate()) && ObjectUtils.isNull((Object)asset.getLoanReturnDate());
    }

    @Override
    public boolean isAssetTaggedInPriorFiscalYear(Asset asset) {
        UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        return StringUtils.isNotBlank((String)asset.getCampusTagNumber()) && ObjectUtils.isNotNull((Object)asset.getFinancialDocumentPostingYear()) && !universityDateService.getCurrentFiscalYear().equals(asset.getFinancialDocumentPostingYear());
    }

    @Override
    public boolean isTagNumberCheckExclude(Asset asset) {
        String status = asset.getInventoryStatusCode();
        return StringUtils.equalsIgnoreCase((String)status, (String)"R") || StringUtils.equalsIgnoreCase((String)status, (String)"O") || StringUtils.equalsIgnoreCase((String)asset.getCampusTagNumber(), (String)"N");
    }

    @Override
    public boolean isOffCampusLocationEntered(Asset asset) {
        AssetLocation offCampus = asset.getOffCampusLocation();
        return StringUtils.isNotBlank((String)offCampus.getAssetLocationContactName()) || StringUtils.isNotBlank((String)offCampus.getAssetLocationStreetAddress()) || StringUtils.isNotBlank((String)offCampus.getAssetLocationCityName()) || StringUtils.isNotBlank((String)offCampus.getAssetLocationStateCode()) || StringUtils.isNotBlank((String)offCampus.getAssetLocationZipCode()) || StringUtils.isNotBlank((String)offCampus.getAssetLocationCountryCode());
    }

    @Override
    public boolean isFinancialObjectSubTypeCodeChanged(Asset oldAsset, Asset newAsset) {
        return !StringUtils.equalsIgnoreCase((String)oldAsset.getFinancialObjectSubTypeCode(), (String)newAsset.getFinancialObjectSubTypeCode());
    }

    @Override
    public boolean isAssetTypeCodeChanged(Asset oldAsset, Asset newAsset) {
        return !StringUtils.equalsIgnoreCase((String)oldAsset.getCapitalAssetTypeCode(), (String)newAsset.getCapitalAssetTypeCode());
    }

    @Override
    public boolean isAssetDepreciableLifeLimitZero(Asset asset) {
        asset.refreshReferenceObject("capitalAssetType");
        AssetType capitalAssetType = asset.getCapitalAssetType();
        if (ObjectUtils.isNotNull((Object)((Object)capitalAssetType))) {
            return Integer.valueOf(0).equals(capitalAssetType.getDepreciableLifeLimit());
        }
        return false;
    }

    @Override
    public boolean isCapitalAssetNumberDuplicate(Long capitalAssetNumber1, Long capitalAssetNumber2) {
        return capitalAssetNumber1 != null && capitalAssetNumber2 != null && capitalAssetNumber1.compareTo(capitalAssetNumber2) == 0;
    }

    @Override
    public void setAssetSummaryFields(Asset asset) {
        if (ObjectUtils.isNotNull((Object)((Object)asset))) {
            asset.setFederalContribution(this.paymentSummaryService.calculateFederalContribution(asset));
            asset.setAccumulatedDepreciation(this.paymentSummaryService.calculatePrimaryAccumulatedDepreciation(asset));
            asset.setBookValue(this.paymentSummaryService.calculatePrimaryBookValue(asset));
        }
    }

    public PaymentSummaryService getPaymentSummaryService() {
        return this.paymentSummaryService;
    }

    public void setPaymentSummaryService(PaymentSummaryService paymentSummaryService) {
        this.paymentSummaryService = paymentSummaryService;
    }

    @Override
    public boolean isAssetMovableCheckByPayment(String financialObjectSubTypeCode) {
        if (ObjectUtils.isNull((Object)financialObjectSubTypeCode)) {
            return true;
        }
        if (this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES").contains(financialObjectSubTypeCode)) {
            return true;
        }
        if (this.parameterService.getParameterValuesAsString(Asset.class, "NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES").contains(financialObjectSubTypeCode)) {
            return false;
        }
        throw new ValidationException("Could not determine movable or non-movable for this object sub-type code " + financialObjectSubTypeCode);
    }

    @Override
    public boolean isAssetMovableCheckByPayment(Asset asset) {
        String financialObjectSubTypeCode = asset.getFinancialObjectSubTypeCode();
        if (ObjectUtils.isNotNull(asset.getAssetPayments()) && !asset.getAssetPayments().isEmpty()) {
            int size = asset.getAssetPayments().size();
            AssetPayment lastAssetPayment = asset.getAssetPayments().get(size - 1);
            lastAssetPayment.refreshReferenceObject("financialObject");
            ObjectCodeService objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
            String chartCode = lastAssetPayment.getChartOfAccountsCode();
            String finObjectCode = lastAssetPayment.getFinancialObjectCode();
            ObjectCode objectCode = objectCodeService.getByPrimaryIdForCurrentYear(chartCode, finObjectCode);
            if (ObjectUtils.isNotNull((Object)objectCode)) {
                financialObjectSubTypeCode = objectCode.getFinancialObjectSubTypeCode();
            } else {
                LOG.warn((Object)("Possibly out-dated object code " + finObjectCode + " for chart " + chartCode + " for current fiscal year in payments for asset " + asset.getCapitalAssetNumber()));
            }
        }
        return this.isAssetMovableCheckByPayment(financialObjectSubTypeCode);
    }

    @Override
    public List<Asset> findActiveAssetsMatchingTagNumber(String campusTagNumber) {
        ArrayList<Asset> activeMatches = new ArrayList<Asset>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("campusTagNumber", campusTagNumber);
        Collection tagMatches = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(Asset.class, params);
        if (tagMatches != null && !tagMatches.isEmpty()) {
            for (Asset asset : tagMatches) {
                if (this.isAssetRetired(asset)) continue;
                activeMatches.add(asset);
            }
        }
        return activeMatches;
    }

    @Override
    public Collection<Asset> findAssetsMatchingTagNumber(String campusTagNumber) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("campusTagNumber", campusTagNumber);
        Collection tagMatches = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(Asset.class, params);
        return tagMatches;
    }

    @Override
    public boolean isObjectSubTypeCompatible(List<String> financialObjectSubTypeCode) {
        if (financialObjectSubTypeCode == null || financialObjectSubTypeCode.size() <= 1) {
            return true;
        }
        ArrayList subTypes = new ArrayList(this.parameterService.getParameterValuesAsString(Asset.class, "OBJECT_SUB_TYPE_GROUPS"));
        String firstObjectSubType = financialObjectSubTypeCode.get(0);
        List<Object> validObjectSubTypes = new ArrayList<String>();
        for (String subType : subTypes) {
            if (!subType.contains(firstObjectSubType)) continue;
            validObjectSubTypes = Arrays.asList(StringUtils.split((String)subType, (String)","));
            break;
        }
        if (validObjectSubTypes.isEmpty()) {
            validObjectSubTypes.add(firstObjectSubType);
        }
        for (String subTypeCode : financialObjectSubTypeCode) {
            if (validObjectSubTypes.contains(subTypeCode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSeparateHistory(Asset asset) {
        HashMap<String, String> paramsAssetGlobalDetail = new HashMap<String, String>();
        paramsAssetGlobalDetail.put(CamsPropertyConstants.AssetGlobalDetail.CAPITAL_ASSET_NUMBER, asset.getCapitalAssetNumber().toString());
        Collection assetGlobalDetails = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(AssetGlobalDetail.class, paramsAssetGlobalDetail);
        if (assetGlobalDetails.size() > 1) {
            throw new IllegalStateException("Asset #" + asset.getCapitalAssetNumber().toString() + " was created from more then one asset document.");
        }
        if (assetGlobalDetails.size() == 1) {
            HashMap<String, String> paramsAssetGlobal = new HashMap<String, String>();
            paramsAssetGlobal.put("documentNumber", ((AssetGlobalDetail)((Object)assetGlobalDetails.iterator().next())).getDocumentNumber());
            AssetGlobal assetGlobal = (AssetGlobal)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(AssetGlobal.class, paramsAssetGlobal);
            if ("A".equals(assetGlobal.getDocumentHeader().getFinancialDocumentStatusCode())) {
                asset.setSeparateHistory(assetGlobal);
            }
        }
    }

    @Override
    public List<String> getDocumentNumbersThatSeparatedThisAsset(Long capitalAssetNumber) {
        HashMap<String, String> paramsAssetGlobal = new HashMap<String, String>();
        paramsAssetGlobal.put("separateSourceCapitalAssetNumber", capitalAssetNumber.toString());
        Collection assetGlobals = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(AssetGlobal.class, paramsAssetGlobal);
        ArrayList<String> separateDocumentNumbers = new ArrayList<String>();
        for (AssetGlobal assetGlobal : assetGlobals) {
            if (!"A".equals(assetGlobal.getDocumentHeader().getFinancialDocumentStatusCode())) continue;
            separateDocumentNumbers.add(assetGlobal.getDocumentNumber());
        }
        return separateDocumentNumbers;
    }

    @Override
    public void setFiscalPeriod(Asset asset) {
        if (asset.getCreateDate() == null) {
            return;
        }
        HashMap<String, Date> primaryKeys = new HashMap<String, Date>();
        primaryKeys.put("universityDate", asset.getCreateDate());
        UniversityDate universityDate = (UniversityDate)this.businessObjectService.findByPrimaryKey(UniversityDate.class, primaryKeys);
        if (universityDate != null) {
            asset.setFinancialDocumentPostingYear(universityDate.getUniversityFiscalYear());
            asset.setFinancialDocumentPostingPeriodCode(universityDate.getUniversityFiscalAccountingPeriod());
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public Set<String> getCurrentRouteLevels(WorkflowDocument workflowDocument) {
        return workflowDocument.getCurrentNodeNames();
    }

    @Override
    public boolean isDocumentEnrouting(Document document) {
        return document.getDocumentHeader().getWorkflowDocument().isEnroute();
    }
}

