/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.web.struts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.validation.event.AssetPaymentAddAssetEvent;
import org.kuali.kfs.module.cam.document.validation.event.AssetPaymentAllocationEvent;
import org.kuali.kfs.module.cam.document.validation.event.AssetPaymentManuallyAddAccountingLineEvent;
import org.kuali.kfs.module.cam.document.validation.event.AssetPaymentPrepareRouteEvent;
import org.kuali.kfs.module.cam.document.web.struts.AssetPaymentForm;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.service.SegmentedLookupResultsService;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentActionBase;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class AssetPaymentAction
extends KualiAccountingDocumentActionBase {
    protected static final Logger LOG = Logger.getLogger(AssetPaymentAction.class);

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        ((AssetPaymentDocument)kualiDocumentFormBase.getDocument()).setAssetPaymentAllocationTypeCode("2");
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.docHandler(mapping, form, request, response);
        AssetPaymentForm assetPaymentForm = (AssetPaymentForm)form;
        String command = assetPaymentForm.getCommand();
        if ("initiate".equals(command) && assetPaymentForm.getCapitalAssetNumber() != null && !assetPaymentForm.getCapitalAssetNumber().trim().equals("")) {
            List<AssetPaymentAssetDetail> assetPaymentAssetDetails = assetPaymentForm.getAssetPaymentDocument().getAssetPaymentAssetDetail();
            AssetPaymentAssetDetail assetPaymentAssetDetail = new AssetPaymentAssetDetail();
            assetPaymentAssetDetail.setDocumentNumber(assetPaymentForm.getAssetPaymentDocument().getDocumentNumber());
            assetPaymentAssetDetail.setCapitalAssetNumber(new Long(assetPaymentForm.getCapitalAssetNumber()));
            assetPaymentAssetDetail.refreshReferenceObject("asset");
            assetPaymentAssetDetail.setPreviousTotalCostAmount(assetPaymentAssetDetail.getAsset().getTotalCostAmount());
            assetPaymentAssetDetails.add(assetPaymentAssetDetail);
            assetPaymentForm.getAssetPaymentDocument().setAssetPaymentAssetDetail(assetPaymentAssetDetails);
            assetPaymentForm.setCapitalAssetNumber("");
        }
        return actionForward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        AssetPaymentForm assetPaymentForm = (AssetPaymentForm)form;
        Collection rawValues = null;
        HashMap segmentedSelection = new HashMap();
        if (StringUtils.equals((String)"multipleValues", (String)assetPaymentForm.getRefreshCaller())) {
            String lookupResultsSequenceNumber = assetPaymentForm.getLookupResultsSequenceNumber();
            if (StringUtils.isNotBlank((String)lookupResultsSequenceNumber)) {
                Set selectedIds = ((SegmentedLookupResultsService)SpringContext.getBean(SegmentedLookupResultsService.class)).retrieveSetOfSelectedObjectIds(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
                for (String selectedId : selectedIds) {
                    String selectedObjId = StringUtils.substringBefore((String)selectedId, (String)".");
                    String selectedMonthData = StringUtils.substringAfter((String)selectedId, (String)".");
                    if (!segmentedSelection.containsKey(selectedObjId)) {
                        segmentedSelection.put(selectedObjId, new HashSet());
                    }
                    ((Set)segmentedSelection.get(selectedObjId)).add(selectedMonthData);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Asking segmentation service for object ids " + segmentedSelection.keySet()));
                }
                rawValues = ((SegmentedLookupResultsService)SpringContext.getBean(SegmentedLookupResultsService.class)).retrieveSelectedResultBOs(lookupResultsSequenceNumber, segmentedSelection.keySet(), Asset.class, GlobalVariables.getUserSession().getPerson().getPrincipalId());
            }
            List<AssetPaymentAssetDetail> assetPaymentAssetDetails = assetPaymentForm.getAssetPaymentDocument().getAssetPaymentAssetDetail();
            if (rawValues != null) {
                for (PersistableBusinessObject bo : rawValues) {
                    Asset asset = (Asset)bo;
                    boolean addIt = true;
                    for (AssetPaymentAssetDetail detail : assetPaymentAssetDetails) {
                        if (detail.getCapitalAssetNumber().compareTo(asset.getCapitalAssetNumber()) != 0) continue;
                        addIt = false;
                        break;
                    }
                    if (!addIt) continue;
                    AssetPaymentAssetDetail assetPaymentAssetDetail = new AssetPaymentAssetDetail();
                    assetPaymentAssetDetail.setDocumentNumber(assetPaymentForm.getAssetPaymentDocument().getDocumentNumber());
                    assetPaymentAssetDetail.setCapitalAssetNumber(asset.getCapitalAssetNumber());
                    assetPaymentAssetDetail.refreshReferenceObject("asset");
                    assetPaymentAssetDetail.setPreviousTotalCostAmount(assetPaymentAssetDetail.getAsset().getTotalCostAmount());
                    assetPaymentAssetDetails.add(assetPaymentAssetDetail);
                }
                assetPaymentForm.getAssetPaymentDocument().setAssetPaymentAssetDetail(assetPaymentAssetDetails);
            }
        }
        this.validateAllocations((ActionForm)assetPaymentForm);
        return mapping.findForward("basic");
    }

    protected void uploadAccountingLines(boolean isSource, ActionForm form) throws FileNotFoundException, IOException {
        AssetPaymentForm assetPaymentForm = (AssetPaymentForm)form;
        super.uploadAccountingLines(isSource, (ActionForm)assetPaymentForm);
        List assetPaymentDetails = assetPaymentForm.getAssetPaymentDocument().getSourceAccountingLines();
        for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
            this.getAssetPaymentService().extractPostedDatePeriod(assetPaymentDetail);
        }
    }

    public ActionForward insertSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssetPaymentForm assetPaymentForm = (AssetPaymentForm)form;
        SourceAccountingLine line = assetPaymentForm.getNewSourceLine();
        boolean rulePassed = true;
        if (rulePassed &= this.getRuleService().applyRules((KualiDocumentEvent)new AssetPaymentManuallyAddAccountingLineEvent("newSourceLine", assetPaymentForm.getDocument(), (AccountingLine)line))) {
            rulePassed &= this.getRuleService().applyRules((KualiDocumentEvent)new AddAccountingLineEvent("newSourceLine", assetPaymentForm.getDocument(), (AccountingLine)line));
        }
        if (rulePassed) {
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).refreshAllNonUpdatingReferences((PersistableBusinessObject)line);
            this.insertAccountingLine(true, assetPaymentForm, (AccountingLine)line);
            assetPaymentForm.setNewSourceLine(new AssetPaymentDetail());
        }
        this.validateAllocations((ActionForm)assetPaymentForm);
        return mapping.findForward("basic");
    }

    public ActionForward insertAssetPaymentAssetDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssetPaymentForm assetPaymentForm = (AssetPaymentForm)form;
        AssetPaymentDocument assetPaymentDocument = assetPaymentForm.getAssetPaymentDocument();
        List<AssetPaymentAssetDetail> assetPaymentDetails = assetPaymentForm.getAssetPaymentDocument().getAssetPaymentAssetDetail();
        AssetPaymentAssetDetail newAssetPaymentAssetDetail = new AssetPaymentAssetDetail();
        String sCapitalAssetNumber = assetPaymentForm.getCapitalAssetNumber();
        String errorPath = "capitalAssetNumber";
        Long capitalAssetNumber = null;
        try {
            capitalAssetNumber = Long.parseLong(sCapitalAssetNumber);
        }
        catch (NumberFormatException e) {
            if (ObjectUtils.isNull((Object)sCapitalAssetNumber) || StringUtils.isBlank((String)sCapitalAssetNumber)) {
                String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(AssetPaymentAssetDetail.class.getName()).getAttributeDefinition("capitalAssetNumber").getLabel();
                GlobalVariables.getMessageMap().putError(errorPath, "error.required", new String[]{label});
            } else {
                GlobalVariables.getMessageMap().putError(errorPath, "error.asset.location.invalid.capital.asset.number", new String[]{sCapitalAssetNumber});
            }
            return mapping.findForward("basic");
        }
        boolean rulePassed = true;
        newAssetPaymentAssetDetail.setDocumentNumber(assetPaymentDocument.getDocumentNumber());
        newAssetPaymentAssetDetail.setCapitalAssetNumber(capitalAssetNumber);
        newAssetPaymentAssetDetail.refreshReferenceObject("asset");
        if (rulePassed &= this.getRuleService().applyRules((KualiDocumentEvent)new AssetPaymentAddAssetEvent(errorPath, assetPaymentForm.getDocument(), newAssetPaymentAssetDetail))) {
            newAssetPaymentAssetDetail.setPreviousTotalCostAmount(newAssetPaymentAssetDetail.getAsset().getTotalCostAmount());
            assetPaymentForm.getAssetPaymentDocument().addAssetPaymentAssetDetail(newAssetPaymentAssetDetail);
            assetPaymentForm.setCapitalAssetNumber("");
        }
        this.validateAllocations((ActionForm)assetPaymentForm);
        return mapping.findForward("basic");
    }

    public ActionForward deleteAssetPaymentAssetDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssetPaymentForm assetPaymentForm = (AssetPaymentForm)form;
        int deleteIndex = this.getLineToDelete(request);
        Long capitalAssetNumber = assetPaymentForm.getAssetPaymentDocument().getAssetPaymentAssetDetail().get(deleteIndex).getCapitalAssetNumber();
        assetPaymentForm.getAssetPaymentDocument().getAssetPaymentAssetDetail().remove(deleteIndex);
        this.validateAllocations((ActionForm)assetPaymentForm);
        return mapping.findForward("basic");
    }

    public ActionForward updateAssetPaymentAssetDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.validateAllocations(form);
        return mapping.findForward("basic");
    }

    private boolean validateAllocations(ActionForm form) {
        AssetPaymentForm assetPaymentForm = (AssetPaymentForm)form;
        AssetPaymentDocument assetPaymentDocument = assetPaymentForm.getAssetPaymentDocument();
        assetPaymentDocument.getAssetPaymentDistributor().applyDistributionsToDocument();
        String errorPath = "document";
        return this.getRuleService().applyRules((KualiDocumentEvent)new AssetPaymentAllocationEvent(errorPath, assetPaymentDocument));
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssetPaymentDocument assetPaymentDocument = ((AssetPaymentForm)form).getAssetPaymentDocument();
        String errorPath = "document";
        boolean rulePassed = this.getRuleService().applyRules((KualiDocumentEvent)new AssetPaymentPrepareRouteEvent(errorPath, (Document)assetPaymentDocument));
        if (rulePassed &= this.validateAllocations(form)) {
            return super.route(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssetPaymentDocument assetPaymentDocument = ((AssetPaymentForm)form).getAssetPaymentDocument();
        String errorPath = "document";
        boolean rulePassed = this.getRuleService().applyRules((KualiDocumentEvent)new AssetPaymentPrepareRouteEvent(errorPath, (Document)assetPaymentDocument));
        if (rulePassed &= this.validateAllocations(form)) {
            return super.blanketApprove(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.validateAllocations(form);
        return super.deleteSourceLine(mapping, form, request, response);
    }

    public ActionForward selectAllocationType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssetPaymentDocument assetPaymentDocument = ((AssetPaymentForm)form).getAssetPaymentDocument();
        assetPaymentDocument.getAssetPaymentDistributor().applyDistributionsToDocument();
        return mapping.findForward("basic");
    }

    protected AssetPaymentService getAssetPaymentService() {
        return (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
    }

    protected KualiRuleService getRuleService() {
        return (KualiRuleService)SpringContext.getBean(KualiRuleService.class);
    }
}

