/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.batch.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.kuali.kfs.fp.businessobject.CapitalAssetAccountsGroupDetails;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformationDetail;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cab.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cab.document.service.GlLineService;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class GlLineServiceTest
extends KualiTestBase {
    private GlLineService glLineService;
    private BusinessObjectService businessObjectService;
    private AssetGlobalService assetGlobalService;
    private GeneralLedgerEntry primary;
    private List<GeneralLedgerEntry> entries;

    @ConfigureContext(session=UserNameFixture.bomiddle, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.glLineService = (GlLineService)SpringContext.getBean(GlLineService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.assetGlobalService = (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class);
        GeneralLedgerEntry entry = this.createCABGLEntry("1031400", 1, new KualiDecimal(5200.5));
        GeneralLedgerEntry entry2 = this.createCABGLEntry("1031400", 2, new KualiDecimal(3300.5));
        this.primary = entry;
        this.entries = new ArrayList<GeneralLedgerEntry>();
        this.entries.add(entry);
        this.entries.add(entry2);
    }

    private CapitalAssetInformationDetail createNewCapitalAssetInformationDetail() {
        CapitalAssetInformationDetail assetInformationDetail = new CapitalAssetInformationDetail();
        assetInformationDetail.setDocumentNumber("1001");
        assetInformationDetail.setCapitalAssetLineNumber(Integer.valueOf(1));
        assetInformationDetail.setItemLineNumber(Integer.valueOf(1));
        assetInformationDetail.setCampusCode("BL");
        assetInformationDetail.setBuildingCode("BL001");
        assetInformationDetail.setBuildingRoomNumber("001");
        assetInformationDetail.setBuildingSubRoomNumber("23");
        assetInformationDetail.setCapitalAssetTagNumber("TGX");
        assetInformationDetail.setCapitalAssetSerialNumber("SER");
        this.businessObjectService.save((PersistableBusinessObject)assetInformationDetail);
        return assetInformationDetail;
    }

    private CapitalAssetAccountsGroupDetails createNewCapitalAssetAcountsGroupDetails() {
        CapitalAssetAccountsGroupDetails capitalAssetAccountsGroupDetails = new CapitalAssetAccountsGroupDetails();
        capitalAssetAccountsGroupDetails.setDocumentNumber("1001");
        capitalAssetAccountsGroupDetails.setChartOfAccountsCode(this.primary.getChartOfAccountsCode());
        capitalAssetAccountsGroupDetails.setAccountNumber(this.primary.getAccountNumber());
        capitalAssetAccountsGroupDetails.setSubAccountNumber(this.primary.getSubAccountNumber());
        capitalAssetAccountsGroupDetails.setFinancialDocumentLineTypeCode("C".equals(this.primary.getTransactionDebitCreditCode()) ? "F" : "T");
        capitalAssetAccountsGroupDetails.setCapitalAssetAccountLineNumber(Integer.valueOf(1));
        capitalAssetAccountsGroupDetails.setCapitalAssetLineNumber(Integer.valueOf(1));
        capitalAssetAccountsGroupDetails.setFinancialObjectCode(this.primary.getFinancialObjectCode());
        capitalAssetAccountsGroupDetails.setFinancialSubObjectCode(this.primary.getFinancialSubObjectCode());
        capitalAssetAccountsGroupDetails.setProjectCode(this.primary.getProjectCode());
        capitalAssetAccountsGroupDetails.setOrganizationReferenceId(this.primary.getOrganizationReferenceId());
        capitalAssetAccountsGroupDetails.setSequenceNumber(Integer.valueOf(0));
        capitalAssetAccountsGroupDetails.setAmount(KualiDecimal.ZERO);
        return capitalAssetAccountsGroupDetails;
    }

    private CapitalAssetInformation createNewCapitalAssetInformation() {
        CapitalAssetInformation assetInformation = new CapitalAssetInformation();
        assetInformation.setDocumentNumber("1001");
        assetInformation.setCapitalAssetActionIndicator("C");
        assetInformation.setCapitalAssetLineAmount(new KualiDecimal(5200.5));
        assetInformation.setCapitalAssetLineNumber(Integer.valueOf(1));
        assetInformation.setVendorHeaderGeneratedIdentifier(Integer.valueOf(1000));
        assetInformation.setVendorDetailAssignedIdentifier(Integer.valueOf(0));
        assetInformation.setCapitalAssetTypeCode("07009");
        assetInformation.setCapitalAssetManufacturerName("MFR");
        assetInformation.setCapitalAssetDescription("DESC");
        assetInformation.setCapitalAssetManufacturerModelNumber("MDL");
        this.businessObjectService.save((PersistableBusinessObject)assetInformation);
        return assetInformation;
    }

    private GeneralLedgerEntry createCABGLEntry(String accountNumber, int seqNumber, KualiDecimal amount) throws ParseException {
        Entry glEntry = this.createGLEntry(accountNumber, seqNumber, amount);
        this.businessObjectService.save((PersistableBusinessObject)glEntry);
        GeneralLedgerEntry entry = new GeneralLedgerEntry(glEntry);
        return entry;
    }

    private Entry createGLEntry(String accountNumber, int seqNumber, KualiDecimal amount) throws ParseException {
        Entry entry = new Entry();
        entry.setUniversityFiscalYear(Integer.valueOf(2009));
        entry.setChartOfAccountsCode("BL");
        entry.setAccountNumber(accountNumber);
        entry.setSubAccountNumber("---");
        entry.setFinancialObjectCode("7015");
        entry.setFinancialSubObjectCode("---");
        entry.setFinancialBalanceTypeCode("AC");
        entry.setFinancialObjectTypeCode("AS");
        entry.setUniversityFiscalPeriodCode("10");
        entry.setFinancialDocumentTypeCode("INV");
        entry.setFinancialSystemOriginationCode("01");
        entry.setDocumentNumber("1001");
        entry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(seqNumber));
        entry.setTransactionLedgerEntryDescription("Test GL");
        entry.setTransactionLedgerEntryAmount(amount);
        entry.setOrganizationReferenceId(null);
        entry.setReferenceFinancialSystemOriginationCode(null);
        entry.setReferenceFinancialDocumentNumber(null);
        entry.setTransactionDebitCreditCode("D");
        entry.setOrganizationDocumentNumber(null);
        entry.setProjectCode(null);
        entry.setTransactionDate(new Date(DateUtils.parseDate((String)"04/23/2009", (String[])new String[]{"MM/dd/yyyy"}).getTime()));
        entry.setTransactionPostingDate(new Date(DateUtils.parseDate((String)"04/23/2009", (String[])new String[]{"MM/dd/yyyy"}).getTime()));
        entry.setTransactionDateTimeStamp(new Timestamp(DateUtils.parseDate((String)"04/23/2009 10:59:59", (String[])new String[]{"MM/dd/yyyy HH:mm:ss"}).getTime()));
        return entry;
    }

    public void testCreateAssetGlobalDocument_noFPData() throws Exception {
        MaintenanceDocument assetGlobalDocument = (MaintenanceDocument)this.glLineService.createAssetGlobalDocument(this.primary, Integer.valueOf(1));
        GlLineServiceTest.assertNotNull((Object)assetGlobalDocument);
        AssetGlobal assetGlobal = (AssetGlobal)assetGlobalDocument.getNewMaintainableObject().getBusinessObject();
        GlLineServiceTest.assertEquals((String)"BL", (String)assetGlobal.getOrganizationOwnerChartOfAccountsCode());
        GlLineServiceTest.assertEquals((String)"1031400", (String)assetGlobal.getOrganizationOwnerAccountNumber());
        GlLineServiceTest.assertEquals((String)this.assetGlobalService.getNewAcquisitionTypeCode(), (String)assetGlobal.getAcquisitionTypeCode());
        GlLineServiceTest.assertEquals(null, (String)assetGlobal.getInventoryStatusCode());
        GlLineServiceTest.assertEquals(null, (String)assetGlobal.getCapitalAssetTypeCode());
        GlLineServiceTest.assertEquals(null, (String)assetGlobal.getManufacturerName());
        GlLineServiceTest.assertEquals(null, (String)assetGlobal.getManufacturerModelNumber());
        GlLineServiceTest.assertEquals(null, (String)assetGlobal.getVendorName());
        GlLineServiceTest.assertEquals(null, (String)assetGlobal.getCapitalAssetDescription());
        List assetGlobalDetails = assetGlobal.getAssetSharedDetails();
        GlLineServiceTest.assertTrue((boolean)assetGlobalDetails.isEmpty());
        List assetPaymentDetails = assetGlobal.getAssetPaymentDetails();
        GlLineServiceTest.assertEquals((int)0, (int)assetPaymentDetails.size());
    }

    public void testCreateAssetGlobalDocument_FPData() throws Exception {
        CapitalAssetInformation assetInformation = this.createNewCapitalAssetInformation();
        assetInformation.getCapitalAssetInformationDetails().add(this.createNewCapitalAssetInformationDetail());
        assetInformation.getCapitalAssetAccountsGroupDetails().add(this.createNewCapitalAssetAcountsGroupDetails());
        this.businessObjectService.save((PersistableBusinessObject)assetInformation);
        assetInformation.refreshNonUpdateableReferences();
        MaintenanceDocument assetGlobalDocument = (MaintenanceDocument)this.glLineService.createAssetGlobalDocument(this.primary, Integer.valueOf(1));
        GlLineServiceTest.assertNotNull((Object)assetGlobalDocument);
        AssetGlobal assetGlobal = (AssetGlobal)assetGlobalDocument.getNewMaintainableObject().getBusinessObject();
        GlLineServiceTest.assertEquals((String)"BL", (String)assetGlobal.getOrganizationOwnerChartOfAccountsCode());
        GlLineServiceTest.assertEquals((String)"1031400", (String)assetGlobal.getOrganizationOwnerAccountNumber());
        GlLineServiceTest.assertEquals((String)this.assetGlobalService.getNewAcquisitionTypeCode(), (String)assetGlobal.getAcquisitionTypeCode());
        GlLineServiceTest.assertEquals((String)"A", (String)assetGlobal.getInventoryStatusCode());
        GlLineServiceTest.assertEquals((String)"07009", (String)assetGlobal.getCapitalAssetTypeCode());
        GlLineServiceTest.assertEquals((String)"MFR", (String)assetGlobal.getManufacturerName());
        GlLineServiceTest.assertEquals((String)"MDL", (String)assetGlobal.getManufacturerModelNumber());
        GlLineServiceTest.assertEquals((String)"DESC", (String)assetGlobal.getCapitalAssetDescription());
        GlLineServiceTest.assertEquals((String)"ABC CLEANING SERVICES", (String)assetGlobal.getVendorName());
        List assetGlobalDetails = assetGlobal.getAssetSharedDetails();
        GlLineServiceTest.assertEquals((int)1, (int)assetGlobalDetails.size());
        AssetGlobalDetail assetGlobalDetail = (AssetGlobalDetail)assetGlobalDetails.get(0);
        GlLineServiceTest.assertEquals((String)"BL", (String)assetGlobalDetail.getCampusCode());
        GlLineServiceTest.assertEquals((String)"BL001", (String)assetGlobalDetail.getBuildingCode());
        GlLineServiceTest.assertEquals((String)"001", (String)assetGlobalDetail.getBuildingRoomNumber());
        GlLineServiceTest.assertEquals((String)"23", (String)assetGlobalDetail.getBuildingSubRoomNumber());
        GlLineServiceTest.assertEquals((String)"TGX", (String)assetGlobalDetail.getCampusTagNumber());
        GlLineServiceTest.assertEquals((String)"SER", (String)assetGlobalDetail.getSerialNumber());
        List assetPaymentDetails = assetGlobal.getAssetPaymentDetails();
        GlLineServiceTest.assertEquals((int)1, (int)assetPaymentDetails.size());
        this.assertAssetPaymentDetail((Document)assetGlobalDocument, (AssetPaymentDetail)assetPaymentDetails.get(0), "1031400", new KualiDecimal(5200.5), 1);
    }

    private void assertAssetPaymentDetail(Document document, AssetPaymentDetail detail, String accountNumber, KualiDecimal amount, Integer seqNo) {
        GlLineServiceTest.assertEquals((String)document.getDocumentNumber(), (String)detail.getDocumentNumber());
        GlLineServiceTest.assertEquals((Object)seqNo, (Object)detail.getSequenceNumber());
        GlLineServiceTest.assertEquals((Object)2009, (Object)detail.getPostingYear());
        GlLineServiceTest.assertEquals((String)"10", (String)detail.getPostingPeriodCode());
        GlLineServiceTest.assertEquals((String)"BL", (String)detail.getChartOfAccountsCode());
        GlLineServiceTest.assertEquals((String)accountNumber, (String)detail.getAccountNumber());
        GlLineServiceTest.assertEquals((String)"", (String)detail.getSubAccountNumber());
        GlLineServiceTest.assertEquals((String)"7015", (String)detail.getFinancialObjectCode());
        GlLineServiceTest.assertEquals((String)"", (String)detail.getProjectCode());
        GlLineServiceTest.assertEquals((String)"", (String)detail.getOrganizationReferenceId());
        GlLineServiceTest.assertEquals((String)"01", (String)detail.getExpenditureFinancialSystemOriginationCode());
        GlLineServiceTest.assertEquals((String)"1001", (String)detail.getExpenditureFinancialDocumentNumber());
        GlLineServiceTest.assertEquals((String)"INV", (String)detail.getExpenditureFinancialDocumentTypeCode());
        GlLineServiceTest.assertEquals((String)"04/23/2009", (String)new SimpleDateFormat("MM/dd/yyyy").format(detail.getExpenditureFinancialDocumentPostedDate()));
        GlLineServiceTest.assertEquals((String)"", (String)detail.getPurchaseOrderNumber());
        GlLineServiceTest.assertEquals((boolean)false, (boolean)detail.isTransferPaymentIndicator());
    }

    public void testCreateAssetPaymentDocument_noFPData() throws Exception {
        AssetPaymentDocument document = (AssetPaymentDocument)this.glLineService.createAssetPaymentDocument(this.primary, Integer.valueOf(1));
        GlLineServiceTest.assertNotNull((Object)document);
        List assetPaymentDetails = document.getSourceAccountingLines();
        GlLineServiceTest.assertEquals((int)0, (int)assetPaymentDetails.size());
    }

    public void testCreateAssetPaymentDocument_FPData() throws Exception {
        CapitalAssetInformation assetInformation = new CapitalAssetInformation();
        assetInformation.getCapitalAssetAccountsGroupDetails().add(this.createNewCapitalAssetAcountsGroupDetails());
        assetInformation.setDocumentNumber("1001");
        assetInformation.setCapitalAssetNumber(Long.valueOf(1594L));
        assetInformation.setCapitalAssetLineAmount(new KualiDecimal(5200.5));
        assetInformation.setCapitalAssetLineNumber(Integer.valueOf(1));
        assetInformation.setCapitalAssetActionIndicator("C");
        this.businessObjectService.save((PersistableBusinessObject)assetInformation);
        AssetPaymentDocument document = (AssetPaymentDocument)this.glLineService.createAssetPaymentDocument(this.primary, Integer.valueOf(1));
        GlLineServiceTest.assertNotNull((Object)document);
        List assetPaymentDetails = document.getSourceAccountingLines();
        GlLineServiceTest.assertEquals((int)1, (int)assetPaymentDetails.size());
        this.assertAssetPaymentDetail((Document)document, (AssetPaymentDetail)assetPaymentDetails.get(0), "1031400", new KualiDecimal(5200.5), 1);
    }
}

