/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.batch.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.module.cab.batch.ExtractProcessLog;
import org.kuali.kfs.module.cab.batch.service.BatchExtractService;
import org.kuali.kfs.module.cab.batch.service.BatchTestBase;
import org.kuali.kfs.module.cab.batch.service.ReconciliationService;
import org.kuali.kfs.module.cab.businessobject.GlAccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ReconciliationServiceTest
extends BatchTestBase {
    private BatchExtractService batchExtractService;

    @Override
    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.batchExtractService = (BatchExtractService)SpringContext.getBean(BatchExtractService.class);
    }

    public void testServiceNotSingleton() throws Exception {
        ReconciliationService cabReconciliationService1 = (ReconciliationService)SpringContext.getBean(ReconciliationService.class);
        ReconciliationService cabReconciliationService2 = (ReconciliationService)SpringContext.getBean(ReconciliationService.class);
        ReconciliationServiceTest.assertFalse((boolean)cabReconciliationService1.equals(cabReconciliationService2));
    }

    public void testReconcile() throws Exception {
        ReconciliationService service = (ReconciliationService)SpringContext.getBean(ReconciliationService.class);
        Collection glEntries = this.batchExtractService.findElgibleGLEntries(new ExtractProcessLog());
        ArrayList purapLines = new ArrayList();
        this.batchExtractService.separatePOLines(new ArrayList(), purapLines, glEntries);
        Collection purapAcctEntries = this.batchExtractService.findPurapAccountRevisions();
        service.reconcile(purapLines, purapAcctEntries);
        List ignoredEntries = service.getDuplicateEntries();
        Collection mismatchedEntries = service.getMisMatchedGroups();
        Collection validEntries = service.getMatchedGroups();
        ReconciliationServiceTest.assertEquals((int)0, (int)ignoredEntries.size());
        ReconciliationServiceTest.assertEquals((int)11, (int)validEntries.size());
        ReconciliationServiceTest.assertEquals((int)0, (int)mismatchedEntries.size());
        for (GlAccountLineGroup glAccountLineGroup : validEntries) {
            KualiDecimal purapAmount = KualiDecimal.ZERO;
            List matchedPurApAcctLines = glAccountLineGroup.getMatchedPurApAcctLines();
            for (PurApAccountingLineBase purApAccountingLineBase : matchedPurApAcctLines) {
                purapAmount = (KualiDecimal)purapAmount.add((AbstractKualiDecimal)purApAccountingLineBase.getAmount());
            }
            Entry targetEntry = glAccountLineGroup.getTargetEntry();
            KualiDecimal targetAmount = targetEntry.getTransactionLedgerEntryAmount();
            if ("CM".equals(targetEntry.getFinancialDocumentTypeCode())) {
                ReconciliationServiceTest.assertTrue((boolean)glAccountLineGroup.getAmount().equals((Object)purapAmount.negated()));
            } else {
                ReconciliationServiceTest.assertTrue((boolean)glAccountLineGroup.getAmount().equals((Object)purapAmount));
            }
            if ("C".equals(targetEntry.getTransactionDebitCreditCode())) {
                targetAmount = (KualiDecimal)targetAmount.negated();
            }
            if ("CM".equals(targetEntry.getFinancialDocumentTypeCode())) {
                ReconciliationServiceTest.assertTrue((boolean)targetAmount.equals((Object)purapAmount.negated()));
            } else {
                ReconciliationServiceTest.assertTrue((boolean)targetAmount.equals((Object)purapAmount));
            }
            purapAmount = KualiDecimal.ZERO;
        }
    }
}

