/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.service.AssetDepreciationService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.dataaccess.AssetDepreciationUtilDao;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciationBatchDao;
import org.kuali.kfs.module.cam.document.dataaccess.impl.MockDepreciationBatchDao;
import org.kuali.kfs.module.cam.fixture.AssetDepreciationServiceFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.dataaccess.UniversityDateDao;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.kfs, shouldCommitTransactions=false)
public class AssetDepreciationServiceTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(AssetDepreciationServiceTest.class);
    private String ERROR_INVALID_DATE = "Invalid depreciation date";
    private String ERROR_INVALID_DATE_FORMAT = "Invalid depreciation date format";
    private String ERROR_RECORD_NUMBER_DOESNT_MATCH = "Depreciated assets collection doesn't have the same number of elements of the results we need to compare against";
    private String ERROR_INVALID_AMOUNTS = "Depreciation figures don't match those in the properties file";
    private String PARAMETER_NAME = "parameterName";
    private String PARAMETER_DETAIL_TYPE_CODE = "parameterDetailTypeCode";
    private String PARAMETER_NAMESPACE_CODE = "parameterNamespaceCode";
    private String CAPITAL_ASSETS_NAMESPACE = "KFS-CAM";
    private ConfigurationService kualiConfigurationService;
    private AssetDepreciationService camsAssetDepreciationService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private AssetDepreciationUtilDao assetDepreciationUtilDao;
    private String depreciationDateParameter;
    private UniversityDateDao universityDateDao;
    List<AssetPayment> assetPaymentsToInsert;
    List<AssetPayment> assetPayments;
    List<Asset> assets;
    private int fiscalMonth;
    private MockDepreciationBatchDao mockDepreciationBatchDao;

    public void setUp() throws Exception {
        super.setUp();
        this.camsAssetDepreciationService = (AssetDepreciationService)SpringContext.getBean(AssetDepreciationService.class);
        this.camsAssetDepreciationService.setDepreciationBatchDao((DepreciationBatchDao)this.mockDepreciationBatchDao);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        this.assetDepreciationUtilDao = (AssetDepreciationUtilDao)SpringContext.getBean(AssetDepreciationUtilDao.class);
        this.universityDateDao = (UniversityDateDao)SpringContext.getBean(UniversityDateDao.class);
    }

    public void testNothing() {
    }

    public void PATCHFIX_testRunDepreciation() throws Exception {
        this.assets = AssetDepreciationServiceFixture.DATA.getAssets();
        this.assetPaymentsToInsert = AssetDepreciationServiceFixture.DATA.getAssetPaymentsFromPropertiesFile();
        this.assetDepreciationUtilDao.deleteAssetPayment(this.assets);
        this.assetDepreciationUtilDao.deleteAssets(this.assets);
        this.assetDepreciationUtilDao.deleteGLPEs();
        this.businessObjectService.save(this.assets);
        this.businessObjectService.save(this.assetPaymentsToInsert);
        String initialDepreciationDate = AssetDepreciationServiceFixture.DATA.getDepreciationDate();
        AssetDepreciationServiceTest.assertTrue((String)this.ERROR_INVALID_DATE, (boolean)this.isValidDate(initialDepreciationDate));
        String depreciationDate = initialDepreciationDate;
        for (int nCounter = 0; nCounter < 12; ++nCounter) {
            if (nCounter > 0) {
                depreciationDate = this.getNewDepreciationDate(initialDepreciationDate, nCounter);
            }
            this.setDepreciationDate(depreciationDate);
            this.camsAssetDepreciationService.runDepreciation();
        }
        Collection<AssetPayment> depreciatedPayments = this.assetDepreciationUtilDao.getAssetPayments(this.assets);
        List<AssetPayment> resultsMustGet = AssetDepreciationServiceFixture.DATA.getResultsFromPropertiesFile();
        AssetDepreciationServiceTest.assertTrue((String)this.ERROR_RECORD_NUMBER_DOESNT_MATCH, (resultsMustGet.size() == depreciatedPayments.size() ? 1 : 0) != 0);
        AssetDepreciationServiceTest.assertTrue((String)this.ERROR_INVALID_AMOUNTS, (boolean)this.isDepreciationOk(depreciatedPayments, resultsMustGet));
    }

    public void setDepreciationDate(String depreciationDateParameter) {
        Calendar depreciationDate = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        AssetDepreciationServiceTest.assertTrue((String)"Paramater DEPRECIATION_RUN_DATE doesn't exist!", (boolean)this.parameterService.parameterExists(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, "DEPRECIATION_RUN_DATE"));
        if (depreciationDateParameter != null && !depreciationDateParameter.trim().equals("")) {
            try {
                depreciationDate.setTime(dateFormat.parse(depreciationDateParameter));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.invalidDepreciationDateFormat"));
            }
        }
        TestUtils.setSystemParameter(KfsParameterConstants.CAPITAL_ASSETS_BATCH.class, (String)"DEPRECIATION_RUN_DATE", (String)depreciationDateParameter);
    }

    public boolean isValidDate(String depreciationDateParameter) {
        boolean valid = true;
        Calendar depreciationDate = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (depreciationDateParameter != null && !depreciationDateParameter.trim().equals("")) {
            try {
                depreciationDate.setTime(dateFormat.parse(depreciationDateParameter));
            }
            catch (ParseException e) {
                valid = false;
            }
        }
        return valid;
    }

    public String getNewDepreciationDate(String depreciationDateParameter, int incrementBy) throws Exception {
        Calendar depreciationDate = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (incrementBy <= 0) {
            return depreciationDateParameter;
        }
        try {
            depreciationDate.setTime(dateFormat.parse(depreciationDateParameter));
        }
        catch (ParseException e) {
            throw new Exception(this.ERROR_INVALID_DATE_FORMAT);
        }
        depreciationDate.add(2, incrementBy);
        return dateFormat.format(depreciationDate.getTime());
    }

    public boolean isDepreciationOk(Collection<AssetPayment> depreciatedAssets, Collection<AssetPayment> resultsMustGet) {
        boolean result = true;
        try {
            Iterator<AssetPayment> resultsMustGetIterator = resultsMustGet.iterator();
            for (AssetPayment depreciatedAsset : depreciatedAssets) {
                AssetPayment resultMustGet = resultsMustGetIterator.next();
                for (int period = 1; period < 13; ++period) {
                    String getterMethodName = "getPeriod" + period + "Depreciation1Amount";
                    Method method = AssetPayment.class.getMethod(getterMethodName, new Class[0]);
                    KualiDecimal amountCalculated = new KualiDecimal(method.invoke((Object)depreciatedAsset, new Object[0]).toString());
                    KualiDecimal amountInFile = new KualiDecimal(method.invoke((Object)resultMustGet, new Object[0]).toString());
                    String stringFromFile = period + "-" + depreciatedAsset.getCapitalAssetNumber() + "-" + depreciatedAsset.getPaymentSequenceNumber() + "-" + amountInFile.bigDecimalValue();
                    if (this.mockDepreciationBatchDao.getAssetPaymentsStr().contains(stringFromFile)) continue;
                    result &= false;
                    break;
                }
                if (result) continue;
                break;
            }
        }
        catch (Exception re) {
            LOG.info((Object)re.getMessage());
        }
        return result;
    }

    public void save(List businessObjects) {
        for (PersistableBusinessObject bo : businessObjects) {
            bo.refresh();
            this.businessObjectService.save(bo);
        }
    }
}

