/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.List;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.gl.AssetRetirementGeneralLedgerPendingEntrySource;
import org.kuali.kfs.module.cam.document.gl.CamsGeneralLedgerPendingEntrySourceBase;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.fixture.AssetRetirementGlobalMaintainableFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AssetRetirementServiceTest
extends KualiTestBase {
    private AssetRetirementService assetRetirementService;
    private UniversityDateService universityDateService;

    @ConfigureContext(session=UserNameFixture.bomiddle, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.assetRetirementService = (AssetRetirementService)SpringContext.getBean(AssetRetirementService.class);
        this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
    }

    @ConfigureContext(session=UserNameFixture.bomiddle, shouldCommitTransactions=false)
    public void testCreateGLPostables_Success() throws Exception {
        MaintenanceDocument document = (MaintenanceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("ARG");
        AssetRetirementGlobal assetRetirementGlobal = AssetRetirementGlobalMaintainableFixture.RETIREMENT1.newAssetRetirement();
        AssetRetirementGeneralLedgerPendingEntrySource assetRetirementGlPoster = new AssetRetirementGeneralLedgerPendingEntrySource((FinancialSystemDocumentHeader)document.getDocumentHeader());
        this.assetRetirementService.createGLPostables(assetRetirementGlobal, (CamsGeneralLedgerPendingEntrySourceBase)assetRetirementGlPoster);
        List postables = assetRetirementGlPoster.getPostables();
        AssetRetirementServiceTest.assertFalse((boolean)postables.isEmpty());
        AssetRetirementServiceTest.assertEquals((int)10, (int)postables.size());
        int i = 0;
        for (AssetRetirementGlobalDetail detail : assetRetirementGlobal.getAssetRetirementGlobalDetails()) {
            Asset asset = detail.getAsset();
            AssetPayment payment1 = (AssetPayment)asset.getAssetPayments().get(0);
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccountChargeAmount(), "9520004", "Asset retirement cost reversal entry", "8610");
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccumulatedPrimaryDepreciationAmount(), "9520004", "Asset retirement depreciation reversal", "8910");
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), (KualiDecimal)payment1.getAccountChargeAmount().subtract((AbstractKualiDecimal)payment1.getAccumulatedPrimaryDepreciationAmount()), "9520004", "Asset retirement fund balance adjustment", "4998");
            AssetPayment payment2 = (AssetPayment)asset.getAssetPayments().get(1);
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccountChargeAmount(), "9520004", "Asset retirement cost reversal entry", "8610");
            this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)postables.get(i++), asset.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccumulatedPrimaryDepreciationAmount(), "9520004", "Asset retirement depreciation reversal", "8910");
        }
    }

    private void assertGLPostable(GeneralLedgerPendingEntrySourceDetail glPostable, String chartOfAccountsCode, KualiDecimal amount, String plantAccount, String financialLineDesc, String financialObjectCode) {
        AssetRetirementServiceTest.assertEquals((String)plantAccount, (String)glPostable.getAccountNumber());
        AssetRetirementServiceTest.assertEquals((Object)amount, (Object)glPostable.getAmount());
        AssetRetirementServiceTest.assertEquals((String)"AC", (String)glPostable.getBalanceTypeCode());
        AssetRetirementServiceTest.assertEquals((String)chartOfAccountsCode, (String)glPostable.getChartOfAccountsCode());
        AssetRetirementServiceTest.assertEquals((String)financialLineDesc, (String)glPostable.getFinancialDocumentLineDescription());
        AssetRetirementServiceTest.assertEquals((String)financialObjectCode, (String)glPostable.getFinancialObjectCode());
        AssetRetirementServiceTest.assertEquals((Object)this.universityDateService.getCurrentFiscalYear(), (Object)glPostable.getPostingYear());
        AssetRetirementServiceTest.assertNull((Object)glPostable.getOrganizationReferenceId());
        AssetRetirementServiceTest.assertNull((Object)glPostable.getProjectCode());
        AssetRetirementServiceTest.assertNull((Object)glPostable.getReferenceNumber());
        AssetRetirementServiceTest.assertNull((Object)glPostable.getReferenceOriginCode());
        AssetRetirementServiceTest.assertNull((Object)glPostable.getReferenceTypeCode());
    }
}

