/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.sql.Date;
import java.util.ArrayList;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class EquipmentLoanOrReturnServiceTest
extends KualiTestBase {
    private EquipmentLoanOrReturnService equipmentLoanOrReturnService;
    private DateTimeService dateTimeService;
    private Asset asset;

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.equipmentLoanOrReturnService = (EquipmentLoanOrReturnService)SpringContext.getBean(EquipmentLoanOrReturnService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        Date date = new Date(this.dateTimeService.getCurrentDate().getTime());
        this.asset = new Asset(){

            public void refreshReferenceObject(String referenceObjectName) {
                ArrayList<AssetLocation> assetLocations = new ArrayList<AssetLocation>();
                AssetLocation loc1 = new AssetLocation();
                loc1.setAssetLocationTypeCode("B");
                assetLocations.add(loc1);
                AssetLocation loc2 = new AssetLocation();
                loc2.setAssetLocationTypeCode("BS");
                assetLocations.add(loc2);
                this.setAssetLocations(assetLocations);
            }
        };
        this.asset.setExpectedReturnDate(date);
    }

    public void testSetEquipmentLoanInfo() throws Exception {
        this.equipmentLoanOrReturnService.setEquipmentLoanInfo(this.asset);
        EquipmentLoanOrReturnServiceTest.assertNotNull((Object)this.asset.getBorrowerLocation());
        EquipmentLoanOrReturnServiceTest.assertNotNull((Object)this.asset.getBorrowerStorageLocation());
    }

    public void testSetEquipmentLoanInfo_NoLoan() throws Exception {
        this.asset.setExpectedReturnDate(null);
        this.equipmentLoanOrReturnService.setEquipmentLoanInfo(this.asset);
        EquipmentLoanOrReturnServiceTest.assertNull((Object)this.asset.getBorrowerLocation());
        EquipmentLoanOrReturnServiceTest.assertNull((Object)this.asset.getBorrowerStorageLocation());
    }
}

