/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.coreservice.impl.parameter.ParameterServiceImpl;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.service.impl.PaymentSummaryServiceImpl;
import org.kuali.kfs.module.cam.fixture.PaymentSummaryFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.UniversityDateServiceImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentSummaryServiceTest
extends KualiTestBase {
    private Asset asset;
    private PaymentSummaryServiceImpl paymentSummaryService;

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        this.asset = PaymentSummaryFixture.ASSET.newAsset();
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        assetPayments.add(PaymentSummaryFixture.PAYMENT1.newAssetPayment());
        assetPayments.add(PaymentSummaryFixture.PAYMENT2.newAssetPayment());
        assetPayments.add(PaymentSummaryFixture.PAYMENT3.newAssetPayment());
        assetPayments.add(PaymentSummaryFixture.PAYMENT4.newAssetPayment());
        this.asset.setAssetPayments(assetPayments);
        this.paymentSummaryService = new PaymentSummaryServiceImpl();
        this.paymentSummaryService.setParameterService((ParameterService)new ParameterServiceImpl(){

            public List<String> getParameterValuesAsString(Class componentClass, String parameterName) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("BF");
                return list;
            }
        });
        UniversityDateServiceImpl universityDateService = new UniversityDateServiceImpl(){

            public UniversityDate getCurrentUniversityDate() {
                return new UniversityDate(){

                    public String getUniversityFiscalAccountingPeriod() {
                        return "5";
                    }
                };
            }
        };
        this.paymentSummaryService.setUniversityDateService((UniversityDateService)universityDateService);
    }

    public void testCalculateAndSetPaymentSummary_SL() throws Exception {
        this.paymentSummaryService.calculateAndSetPaymentSummary(this.asset);
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(50), (Object)this.asset.getFederalContribution());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(50), (Object)this.asset.getPaymentTotalCost());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(100), (Object)this.asset.getAccumulatedDepreciation());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(100.3), (Object)this.asset.getBaseAmount());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(0.3), (Object)this.asset.getBookValue());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(62), (Object)this.asset.getPrevYearDepreciation());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(160.81), (Object)this.asset.getYearToDateDepreciation());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(15), (Object)this.asset.getCurrentMonthDepreciation());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(392.38), (Object)((AssetPayment)this.asset.getAssetPayments().get(0)).getYearToDate());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(210.92), (Object)((AssetPayment)this.asset.getAssetPayments().get(1)).getYearToDate());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(-392.38), (Object)((AssetPayment)this.asset.getAssetPayments().get(2)).getYearToDate());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(-50.11), (Object)((AssetPayment)this.asset.getAssetPayments().get(3)).getYearToDate());
    }

    public void testCalculateAndSetPaymentSummary_SV() throws Exception {
        this.asset.setPrimaryDepreciationMethodCode("SV");
        this.asset.setSalvageAmount(new KualiDecimal(25));
        this.paymentSummaryService.calculateAndSetPaymentSummary(this.asset);
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(50), (Object)this.asset.getFederalContribution());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(50), (Object)this.asset.getPaymentTotalCost());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(100), (Object)this.asset.getAccumulatedDepreciation());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(100.3), (Object)this.asset.getBaseAmount());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(-24.7), (Object)this.asset.getBookValue());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(62), (Object)this.asset.getPrevYearDepreciation());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(160.81), (Object)this.asset.getYearToDateDepreciation());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(15), (Object)this.asset.getCurrentMonthDepreciation());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(392.38), (Object)((AssetPayment)this.asset.getAssetPayments().get(0)).getYearToDate());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(210.92), (Object)((AssetPayment)this.asset.getAssetPayments().get(1)).getYearToDate());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(-392.38), (Object)((AssetPayment)this.asset.getAssetPayments().get(2)).getYearToDate());
        PaymentSummaryServiceTest.assertEquals((Object)new KualiDecimal(-50.11), (Object)((AssetPayment)this.asset.getAssetPayments().get(3)).getYearToDate());
    }
}

