/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.fixture;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.fixture.CamsFixture;
import org.kuali.kfs.sys.context.SpringContext;

public enum AssetDepreciationServiceFixture {
    DATA;

    private BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    private int testDataPos;
    private static Properties properties;
    static String TEST_RECORD;
    static String ASSET;
    static String ASSET_PAYMENT;
    static String DEPRECIATION_DATE;
    static String FIELD_NAMES;
    static String NUM_OF_REC;
    static String DELIMINATOR;
    static String RESULT;

    public List<Asset> getAssets() {
        Integer numOfRecords = new Integer(properties.getProperty(ASSET + "." + NUM_OF_REC));
        ArrayList<Asset> assets = new ArrayList<Asset>();
        String deliminator = properties.getProperty(DELIMINATOR);
        String fieldNames = properties.getProperty(ASSET + "." + FIELD_NAMES);
        for (int i = 1; i <= numOfRecords; ++i) {
            String propertyKey = ASSET + "." + TEST_RECORD + i;
            Asset asset = CamsFixture.DATA_POPULATOR.buildTestDataObject(Asset.class, properties, propertyKey, fieldNames, deliminator);
            assets.add(asset);
        }
        return assets;
    }

    public String getDepreciationDate() {
        return properties.getProperty(DEPRECIATION_DATE);
    }

    public List<AssetPayment> getAssetPaymentsFromPropertiesFile() {
        Integer numOfRecords = new Integer(properties.getProperty(ASSET_PAYMENT + "." + NUM_OF_REC));
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        String deliminator = properties.getProperty(DELIMINATOR);
        String fieldNames = properties.getProperty(ASSET_PAYMENT + "." + FIELD_NAMES);
        for (int i = 1; i <= numOfRecords; ++i) {
            String propertyKey = ASSET_PAYMENT + "." + TEST_RECORD + i;
            AssetPayment assetPayment = CamsFixture.DATA_POPULATOR.buildTestDataObject(AssetPayment.class, properties, propertyKey, fieldNames, deliminator);
            assetPayments.add(assetPayment);
        }
        return assetPayments;
    }

    public List<AssetPayment> getResultsFromPropertiesFile() {
        Integer numOfRecords = new Integer(properties.getProperty(RESULT + "." + NUM_OF_REC));
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        String deliminator = properties.getProperty(DELIMINATOR);
        String fieldNames = properties.getProperty(RESULT + "." + FIELD_NAMES);
        for (int i = 1; i <= numOfRecords; ++i) {
            String propertyKey = RESULT + "." + TEST_RECORD + i;
            AssetPayment assetPayment = CamsFixture.DATA_POPULATOR.buildTestDataObject(AssetPayment.class, properties, propertyKey, fieldNames, deliminator);
            assetPayments.add(assetPayment);
        }
        return assetPayments;
    }

    static {
        String propertiesFileName = "org/kuali/kfs/module/cam/document/service/depreciation_service.properties";
        properties = new Properties();
        try {
            properties.load(ClassLoader.getSystemResourceAsStream(propertiesFileName));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        TEST_RECORD = "testRecord";
        ASSET = "asset";
        ASSET_PAYMENT = "assetPayment";
        DEPRECIATION_DATE = "depreciationDate";
        FIELD_NAMES = "fieldNames";
        NUM_OF_REC = "numOfRecords";
        DELIMINATOR = "deliminator";
        RESULT = "result";
    }
}

