/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.utils;

import org.kuali.kfs.module.cam.util.KualiDecimalUtils;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class KualiDecimalUtilsTest
extends KualiTestBase {
    public void testAllocateByQuantity() throws Exception {
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByQuantity((KualiDecimal)new KualiDecimal(10.0), (int)3);
        KualiDecimalUtilsTest.assertEquals((int)allocationResults.length, (int)3);
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[0], (Object)new KualiDecimal(3.33));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[1], (Object)new KualiDecimal(3.33));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[2], (Object)new KualiDecimal(3.34));
        allocationResults = KualiDecimalUtils.allocateByQuantity((KualiDecimal)new KualiDecimal(10.0), (int)15);
        KualiDecimalUtilsTest.assertEquals((int)allocationResults.length, (int)15);
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[0], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[1], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[2], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[3], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[4], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[5], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[6], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[7], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[8], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[9], (Object)new KualiDecimal(0.67));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[10], (Object)new KualiDecimal(0.66));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[11], (Object)new KualiDecimal(0.66));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[12], (Object)new KualiDecimal(0.66));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[13], (Object)new KualiDecimal(0.66));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[14], (Object)new KualiDecimal(0.66));
        allocationResults = KualiDecimalUtils.allocateByQuantity((KualiDecimal)new KualiDecimal(5.0), (int)7);
        KualiDecimalUtilsTest.assertEquals((int)allocationResults.length, (int)7);
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[0], (Object)new KualiDecimal(0.71));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[1], (Object)new KualiDecimal(0.71));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[2], (Object)new KualiDecimal(0.71));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[3], (Object)new KualiDecimal(0.71));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[4], (Object)new KualiDecimal(0.72));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[5], (Object)new KualiDecimal(0.72));
        KualiDecimalUtilsTest.assertEquals((Object)allocationResults[6], (Object)new KualiDecimal(0.72));
    }

    public void testAllocateByRatio() throws Exception {
        KualiDecimal[] values = KualiDecimalUtils.allocateByRatio((KualiDecimal)new KualiDecimal(13), (double[])new double[]{0.533333});
        KualiDecimalUtilsTest.assertNotNull((Object)values);
        KualiDecimalUtilsTest.assertEquals((int)1, (int)values.length);
        KualiDecimalUtilsTest.assertEquals((Object)new KualiDecimal(6.94), (Object)values[0]);
        values = KualiDecimalUtils.allocateByRatio((KualiDecimal)new KualiDecimal(13), (double[])new double[]{0.2820512821, 0.333333333, 0.384615385});
        KualiDecimalUtilsTest.assertNotNull((Object)values);
        KualiDecimalUtilsTest.assertEquals((int)3, (int)values.length);
        KualiDecimalUtilsTest.assertEquals((Object)new KualiDecimal(3.67), (Object)values[0]);
        KualiDecimalUtilsTest.assertEquals((Object)new KualiDecimal(4.33), (Object)values[1]);
        KualiDecimalUtilsTest.assertEquals((Object)new KualiDecimal(5), (Object)values[2]);
        KualiDecimalUtilsTest.assertEquals((Object)new KualiDecimal(13), (Object)((KualiDecimal)values[2].add((AbstractKualiDecimal)values[1])).add((AbstractKualiDecimal)values[0]));
    }

    public void testAllocateByQuantityExtremeCases() throws Exception {
        int i;
        String input = "2956900.56";
        KualiDecimal originalAmount = new KualiDecimal(input);
        KualiDecimal allocatedAmount = KualiDecimalUtils.allocateByQuantity((KualiDecimal)originalAmount, (int)1)[0];
        KualiDecimalUtilsTest.assertEquals((Object)originalAmount, (Object)allocatedAmount);
        KualiDecimal totalAmount = new KualiDecimal(99);
        int divisor = 10000;
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByQuantity((KualiDecimal)totalAmount, (int)divisor);
        KualiDecimal cent = new KualiDecimal(0.01);
        for (i = 0; i < divisor - 100; ++i) {
            KualiDecimalUtilsTest.assertEquals((Object)allocationResults[i], (Object)cent);
        }
        for (i = divisor - 100; i < divisor; ++i) {
            KualiDecimalUtilsTest.assertEquals((Object)allocationResults[i], (Object)KualiDecimal.ZERO);
        }
    }

    public void testAllocateByRatioExtremeCases() throws Exception {
        int i;
        String input = "2956900.56";
        KualiDecimal originalAmount = new KualiDecimal(input);
        double[] ratio = new double[]{1.0};
        KualiDecimal allocatedAmount = KualiDecimalUtils.allocateByRatio((KualiDecimal)originalAmount, (double[])ratio)[0];
        KualiDecimalUtilsTest.assertEquals((Object)originalAmount, (Object)allocatedAmount);
        KualiDecimal totalAmount = new KualiDecimal(99.0);
        double[] ratios = new double[10000];
        for (int i2 = 0; i2 < ratios.length; ++i2) {
            ratios[i2] = 1.0E-4;
        }
        KualiDecimal[] allocationResults = KualiDecimalUtils.allocateByRatio((KualiDecimal)totalAmount, (double[])ratios);
        KualiDecimal cent = new KualiDecimal(0.01);
        for (i = 0; i < ratios.length - 100; ++i) {
            KualiDecimalUtilsTest.assertEquals((Object)allocationResults[i], (Object)cent);
        }
        for (i = ratios.length - 100; i < ratios.length; ++i) {
            KualiDecimalUtilsTest.assertEquals((Object)allocationResults[i], (Object)KualiDecimal.ZERO);
        }
    }
}

