/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.util.MaintenanceUtils;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetYearEndDepreciation;
import org.kuali.kfs.module.cam.businessobject.AssetYearEndDepreciationDetail;
import org.kuali.kfs.module.cam.document.gl.AssetRetirementGeneralLedgerPendingEntrySource;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetYearEndDepreciationMaintainableImpl
extends FinancialSystemMaintainable {
    private static Logger LOG = Logger.getLogger(AssetYearEndDepreciationMaintainableImpl.class);
    public static final String DOCUMENT_ERROR_PREFIX = "document.";
    public static final String MAINTAINABLE_ERROR_PATH = "document.newMaintainableObject";
    public static final String DETAIL_ERROR_PATH = "document.newMaintainableObject.add.assetYearEndDepreciationDetail";

    public List<MaintenanceLock> generateMaintenanceLocks() {
        return new ArrayList<MaintenanceLock>();
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterEdit(document, parameters);
        AssetYearEndDepreciation assetYearEndDepreciation = (AssetYearEndDepreciation)((Object)document.getOldMaintainableObject().getDataObject());
        List<AssetYearEndDepreciationDetail> assetYearEndDepreciationDetails = assetYearEndDepreciation.getAssetYearEndDepreciationDetails();
        for (AssetYearEndDepreciationDetail assetYearEndDepreciationDetail : assetYearEndDepreciationDetails) {
            this.getAssetService().setAssetSummaryFields(assetYearEndDepreciationDetail.getAsset());
        }
    }

    public void addMultipleValueLookupResults(MaintenanceDocument document, String collectionName, Collection<PersistableBusinessObject> rawValues, boolean needsBlank, PersistableBusinessObject bo) {
        Collection maintCollection = (Collection)ObjectUtils.getPropertyValue((Object)bo, (String)collectionName);
        String docTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List duplicateIdentifierFieldsFromDataDictionary = this.getDuplicateIdentifierFieldsFromDataDictionary(docTypeName, collectionName);
        List existingIdentifierList = this.getMultiValueIdentifierList(maintCollection, duplicateIdentifierFieldsFromDataDictionary);
        Class collectionClass = this.getMaintenanceDocumentDictionaryService().getCollectionBusinessObjectClass(docTypeName, collectionName);
        List sections = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(docTypeName);
        Map template = MaintenanceUtils.generateMultipleValueLookupBOTemplate((List)sections, (String)collectionName);
        try {
            GlobalVariables.getMessageMap().addToErrorPath(DETAIL_ERROR_PATH);
            for (PersistableBusinessObject nextBo : rawValues) {
                AssetYearEndDepreciationDetail templatedBo = (AssetYearEndDepreciationDetail)ObjectUtils.createHybridBusinessObject((Class)collectionClass, (BusinessObject)nextBo, (Map)template);
                templatedBo.setNewCollectionRecord(true);
                templatedBo.setActive(true);
                this.prepareBusinessObjectForAdditionFromMultipleValueLookup(collectionName, (BusinessObject)templatedBo);
                if (this.hasBusinessObjectExisted((BusinessObject)templatedBo, existingIdentifierList, duplicateIdentifierFieldsFromDataDictionary)) continue;
                maintCollection.add(templatedBo);
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(DETAIL_ERROR_PATH);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to add multiple value lookup results for assetYearEndDepreciation " + e.getMessage()));
            throw new RuntimeException("Unable to add multiple value lookup results for assetYearEndDepreciation " + e.getMessage());
        }
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        block3: {
            block2: {
                super.refresh(refreshCaller, fieldValues, document);
                AssetYearEndDepreciationDetail newDetail = (AssetYearEndDepreciationDetail)document.getNewMaintainableObject().getNewCollectionLine("assetYearEndDepreciationDetails");
                this.getAssetService().setAssetSummaryFields(newDetail.getAsset());
                AssetYearEndDepreciation assetYearEndDepreciation = (AssetYearEndDepreciation)document.getDocumentBusinessObject();
                List<AssetYearEndDepreciationDetail> assetYearEndDepreciationDetails = assetYearEndDepreciation.getAssetYearEndDepreciationDetails();
                if (!"multipleValues".equalsIgnoreCase(refreshCaller)) break block2;
                for (AssetYearEndDepreciationDetail assetYearEndDepreciationDetail : assetYearEndDepreciationDetails) {
                    this.getAssetService().setAssetSummaryFields(assetYearEndDepreciationDetail.getAsset());
                }
                break block3;
            }
            if (!"assetLookupable".equalsIgnoreCase(refreshCaller)) break block3;
            AssetYearEndDepreciation assetYearEndDepreciationOld = (AssetYearEndDepreciation)document.getOldMaintainableObject().getBusinessObject();
            List<AssetYearEndDepreciationDetail> assetYearEndDepreciationDetailsOld = assetYearEndDepreciationOld.getAssetYearEndDepreciationDetails();
            for (AssetYearEndDepreciationDetail assetYearEndDepreciationDetailOld : assetYearEndDepreciationDetailsOld) {
                this.getAssetService().setAssetSummaryFields(assetYearEndDepreciationDetailOld.getAsset());
            }
        }
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
        AssetYearEndDepreciation assetYearEndDepreciation = (AssetYearEndDepreciation)this.getBusinessObject();
        if (documentHeader.getWorkflowDocument().isEnroute()) {
            boolean allPaymentsFederalOwned = true;
            List<AssetYearEndDepreciationDetail> assetYearEndDepreciationDetails = assetYearEndDepreciation.getAssetYearEndDepreciationDetails();
            for (AssetYearEndDepreciationDetail assetYearEndDepreciationDetail : assetYearEndDepreciationDetails) {
                for (AssetPayment assetPayment : assetYearEndDepreciationDetail.getAsset().getAssetPayments()) {
                    if (this.getAssetPaymentService().isPaymentFederalOwned(assetPayment)) continue;
                    allPaymentsFederalOwned = false;
                }
            }
        }
        if (documentHeader.getWorkflowDocument().isProcessed()) {
            ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)assetYearEndDepreciation);
        }
        new AssetRetirementGeneralLedgerPendingEntrySource((FinancialSystemDocumentHeader)documentHeader).doRouteStatusChange(assetYearEndDepreciation.getGeneralLedgerPendingEntries());
        WorkflowDocument workflowDoc = documentHeader.getWorkflowDocument();
        if (workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isProcessed() || workflowDoc.isFinal()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(documentHeader.getDocumentNumber(), null);
        }
    }

    public void addNewLineToCollection(String collectionName) {
        AssetYearEndDepreciationDetail newDetail = (AssetYearEndDepreciationDetail)((Object)this.newCollectionLines.get("assetYearEndDepreciationDetails"));
        HashMap<String, Long> pKeys = new HashMap<String, Long>();
        Long assetNumber = newDetail.getCapitalAssetNumber();
        pKeys.put("capitalAssetNumber", assetNumber);
        Asset asset = (Asset)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Asset.class, pKeys);
        this.getAssetService().setAssetSummaryFields(asset);
        AssetYearEndDepreciation assetYearEndDepreciation = (AssetYearEndDepreciation)this.getBusinessObject();
        List<AssetYearEndDepreciationDetail> assetYearEndDepreciationDetails = assetYearEndDepreciation.getAssetYearEndDepreciationDetails();
        for (AssetYearEndDepreciationDetail assetYearEndDepreciationDetail : assetYearEndDepreciationDetails) {
            this.getAssetService().setAssetSummaryFields(assetYearEndDepreciationDetail.getAsset());
        }
        super.refreshReferences("add.assetYearEndDepreciationDetails.asset");
        super.addNewLineToCollection(collectionName);
    }

    public Map<String, String> populateNewCollectionLines(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        String capitalAssetNumber = fieldValues.get("assetRetirementGlobalDetails.capitalAssetNumber");
        if (StringUtils.isNotBlank((String)capitalAssetNumber)) {
            fieldValues.remove("assetRetirementGlobalDetails.capitalAssetNumber");
            fieldValues.put("assetRetirementGlobalDetails.capitalAssetNumber", capitalAssetNumber.trim());
        }
        return super.populateNewCollectionLines(fieldValues, maintenanceDocument, methodToCall);
    }

    private AssetRetirementService getAssetRetirementService() {
        return (AssetRetirementService)SpringContext.getBean(AssetRetirementService.class);
    }

    private AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    private AssetPaymentService getAssetPaymentService() {
        return (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }
}

