/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.kfs.krad.document.DocumentBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public class AssetLocationServiceImpl
implements AssetLocationService {
    private static Logger LOG = Logger.getLogger(AssetLocationService.class);
    private BusinessObjectService businessObjectService;
    private DataDictionaryService DataDictionaryService;

    @Override
    public void setOffCampusLocation(Asset asset) {
        List<AssetLocation> assetLocations = asset.getAssetLocations();
        AssetLocation offCampusLocation = null;
        for (AssetLocation location : assetLocations) {
            if (!"O".equalsIgnoreCase(location.getAssetLocationTypeCode())) continue;
            offCampusLocation = new AssetLocation(location);
            break;
        }
        if (ObjectUtils.isNull(offCampusLocation)) {
            offCampusLocation = new AssetLocation(asset.getCapitalAssetNumber());
            offCampusLocation.setAssetLocationTypeCode("O");
        }
        asset.setOffCampusLocation(offCampusLocation);
    }

    @Override
    public void updateOffCampusLocation(Asset asset) {
        AssetLocation offLocation = asset.getOffCampusLocation();
        boolean isOffCampusEmpty = this.isOffCampusLocationEmpty(offLocation);
        AssetLocation removableOffCampusLocation = null;
        for (AssetLocation location : asset.getAssetLocations()) {
            if (!"O".equalsIgnoreCase(location.getAssetLocationTypeCode())) continue;
            if (isOffCampusEmpty) {
                removableOffCampusLocation = location;
                continue;
            }
            location.setAssetLocationCityName(offLocation.getAssetLocationCityName());
            location.setAssetLocationContactIdentifier(offLocation.getAssetLocationContactIdentifier());
            location.setAssetLocationContactName(offLocation.getAssetLocationContactName());
            location.setAssetLocationCountryCode(offLocation.getAssetLocationCountryCode());
            location.setAssetLocationInstitutionName(offLocation.getAssetLocationInstitutionName());
            location.setAssetLocationPhoneNumber(offLocation.getAssetLocationPhoneNumber());
            location.setAssetLocationStateCode(offLocation.getAssetLocationStateCode());
            location.setAssetLocationStreetAddress(offLocation.getAssetLocationStreetAddress());
            location.setAssetLocationZipCode(offLocation.getAssetLocationZipCode());
            return;
        }
        if (removableOffCampusLocation != null) {
            asset.getAssetLocations().remove((Object)removableOffCampusLocation);
        } else if (!isOffCampusEmpty) {
            asset.getAssetLocations().add(offLocation);
        }
    }

    @Override
    public boolean isOffCampusLocationExists(AssetLocation offCampusLocation) {
        return ObjectUtils.isNotNull((Object)((Object)offCampusLocation)) && "O".equalsIgnoreCase(offCampusLocation.getAssetLocationTypeCode());
    }

    @Override
    public boolean isOffCampusLocationEmpty(AssetLocation offCampusLocation) {
        return !ObjectUtils.isNotNull((Object)((Object)offCampusLocation)) || !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationCityName()) && !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationContactIdentifier()) && !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationContactName()) && !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationCountryCode()) && !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationInstitutionName()) && !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationPhoneNumber()) && !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationStateCode()) && !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationStreetAddress()) && !StringUtils.isNotBlank((String)offCampusLocation.getAssetLocationZipCode());
    }

    @Override
    public boolean validateLocation(Map<AssetLocationService.LocationField, String> fieldMap, BusinessObject businessObject, boolean isCapital, AssetType assetType) {
        String campusCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.CAMPUS_CODE);
        String buildingCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.BUILDING_CODE);
        String roomNumber = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.ROOM_NUMBER);
        String subRoomNumber = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.SUB_ROOM_NUMBER);
        String contactName = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.CONTACT_NAME);
        String streetAddress = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.STREET_ADDRESS);
        String cityName = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.CITY_NAME);
        String stateCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.STATE_CODE);
        String zipCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.ZIP_CODE);
        String countryCode = this.readPropertyValue(businessObject, fieldMap, AssetLocationService.LocationField.COUNTRY_CODE);
        DataDictionaryService ddService = this.getDataDictionaryService();
        BusinessObjectEntry ddEntry = null;
        if (DocumentBase.class.isAssignableFrom(businessObject.getClass())) {
            String docTypeName = ddService.getDocumentTypeNameByClass(businessObject.getClass());
            ddEntry = ddService.getDataDictionary().getDocumentEntry(docTypeName);
        } else {
            ddEntry = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObject.getClass().getName());
        }
        boolean onCampus = StringUtils.isNotBlank((String)buildingCode) || StringUtils.isNotBlank((String)roomNumber) || StringUtils.isNotBlank((String)subRoomNumber);
        boolean offCampus = StringUtils.isNotBlank((String)contactName) || StringUtils.isNotBlank((String)streetAddress) || StringUtils.isNotBlank((String)cityName) || StringUtils.isNotBlank((String)stateCode) || StringUtils.isNotBlank((String)zipCode) || StringUtils.isNotBlank((String)countryCode);
        boolean valid = true;
        if (onCampus && offCampus) {
            this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.location.choose.right", new String[0]);
            valid &= false;
        } else {
            valid = isCapital ? (valid &= this.validateCapitalAssetLocation(assetType, fieldMap, campusCode, buildingCode, roomNumber, subRoomNumber, contactName, streetAddress, cityName, stateCode, zipCode, countryCode, onCampus, offCampus, (DataDictionaryEntryBase)ddEntry)) : (valid &= this.validateNonCapitalAssetLocation(fieldMap, contactName, streetAddress, cityName, stateCode, zipCode, countryCode, onCampus, offCampus));
        }
        return valid;
    }

    protected boolean validateCapitalAssetLocation(AssetType assetType, Map<AssetLocationService.LocationField, String> fieldMap, String campusCode, String buildingCode, String roomNumber, String subRoomNumber, String contactName, String streetAddress, String cityName, String stateCode, String zipCode, String countryCode, boolean onCampus, boolean offCampus, DataDictionaryEntryBase businessObjectEntry) {
        boolean valid = true;
        if (ObjectUtils.isNull((Object)((Object)assetType))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Location Information", "error.choose.asset.type.validate.location", new String[0]);
            valid &= false;
        } else if (assetType.isRequiredBuildingIndicator() && offCampus) {
            String label;
            if (StringUtils.isNotBlank((String)contactName)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.CONTACT_NAME)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.CONTACT_NAME, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)streetAddress)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.STREET_ADDRESS)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.STREET_ADDRESS, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)cityName)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.CITY_NAME)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.CITY_NAME, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)stateCode)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.STATE_CODE)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.STATE_CODE, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)zipCode)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.ZIP_CODE)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.ZIP_CODE, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)countryCode)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.COUNTRY_CODE)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.COUNTRY_CODE, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
        } else if (!assetType.isMovingIndicator() && !assetType.isRequiredBuildingIndicator() && onCampus) {
            String label;
            if (StringUtils.isNotBlank((String)buildingCode)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.BUILDING_CODE)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)roomNumber)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.ROOM_NUMBER)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.ROOM_NUMBER, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)subRoomNumber)) {
                label = businessObjectEntry.getAttributeDefinition(fieldMap.get((Object)AssetLocationService.LocationField.SUB_ROOM_NUMBER)).getLabel();
                this.putError(fieldMap, AssetLocationService.LocationField.SUB_ROOM_NUMBER, "error.location.not.permitted.asset.type", label, assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
        } else if (onCampus) {
            valid = this.validateOnCampusLocation(fieldMap, assetType, campusCode, buildingCode, roomNumber, subRoomNumber);
        } else if (offCampus) {
            valid = this.validateOffCampusLocation(fieldMap, contactName, streetAddress, cityName, stateCode, zipCode, countryCode);
        } else if (assetType.isMovingIndicator() || assetType.isRequiredBuildingIndicator()) {
            this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.location.info.required", new String[0]);
            valid &= false;
        }
        return valid;
    }

    protected boolean validateNonCapitalAssetLocation(Map<AssetLocationService.LocationField, String> fieldMap, String contactName, String streetAddress, String cityName, String stateCode, String zipCode, String countryCode, boolean onCampus, boolean offCampus) {
        boolean valid = true;
        if (offCampus) {
            valid = this.validateOffCampusLocation(fieldMap, contactName, streetAddress, cityName, stateCode, zipCode, countryCode);
        }
        return valid;
    }

    protected void putError(Map<AssetLocationService.LocationField, String> fieldMap, AssetLocationService.LocationField field, String errorKey, String ... errorParameters) {
        GlobalVariables.getMessageMap().putError(fieldMap.get((Object)field), errorKey, errorParameters);
    }

    protected boolean validateOnCampusLocation(Map<AssetLocationService.LocationField, String> fieldMap, AssetType assetType, String campusCode, String buildingCode, String buildingRoomNumber, String subRoomNumber) {
        boolean valid = true;
        if (assetType.isMovingIndicator()) {
            if (StringUtils.isBlank((String)buildingCode)) {
                this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.oncampus.building.value.required", assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isBlank((String)buildingRoomNumber)) {
                this.putError(fieldMap, AssetLocationService.LocationField.ROOM_NUMBER, "error.oncampus.room.number.required", assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
        }
        if (assetType.isRequiredBuildingIndicator()) {
            if (StringUtils.isBlank((String)buildingCode)) {
                this.putError(fieldMap, AssetLocationService.LocationField.BUILDING_CODE, "error.oncampus.building.value.required", assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)buildingRoomNumber)) {
                this.putError(fieldMap, AssetLocationService.LocationField.ROOM_NUMBER, "error.oncampus.room.number.not.permitted", assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
            if (StringUtils.isNotBlank((String)subRoomNumber)) {
                this.putError(fieldMap, AssetLocationService.LocationField.SUB_ROOM_NUMBER, "error.oncampus.sub.room.number.not.permitted", assetType.getCapitalAssetTypeDescription());
                valid &= false;
            }
        }
        return valid;
    }

    protected boolean validateOffCampusLocation(Map<AssetLocationService.LocationField, String> fieldMap, String contactName, String streetAddress, String cityName, String stateCode, String zipCode, String countryCode) {
        boolean valid = true;
        boolean isCountryUS = false;
        if (this.isBlank(fieldMap, AssetLocationService.LocationField.COUNTRY_CODE, countryCode)) {
            this.putError(fieldMap, AssetLocationService.LocationField.COUNTRY_CODE, "error.offcampus.country.required", new String[0]);
            valid &= false;
        } else {
            isCountryUS = countryCode.equals("US");
        }
        if (this.isBlank(fieldMap, AssetLocationService.LocationField.CONTACT_NAME, contactName)) {
            this.putError(fieldMap, AssetLocationService.LocationField.CONTACT_NAME, "error.offcampus.contactName.required", new String[0]);
            valid &= false;
        }
        if (this.isBlank(fieldMap, AssetLocationService.LocationField.STREET_ADDRESS, streetAddress)) {
            this.putError(fieldMap, AssetLocationService.LocationField.STREET_ADDRESS, "error.offcampus.address.required", new String[0]);
            valid &= false;
        }
        if (this.isBlank(fieldMap, AssetLocationService.LocationField.CITY_NAME, cityName)) {
            this.putError(fieldMap, AssetLocationService.LocationField.CITY_NAME, "error.offcampus.city.required", new String[0]);
            valid &= false;
        }
        if (isCountryUS) {
            if (this.isBlank(fieldMap, AssetLocationService.LocationField.STATE_CODE, stateCode)) {
                this.putError(fieldMap, AssetLocationService.LocationField.STATE_CODE, "error.offcampus.state.required", new String[0]);
                valid &= false;
            }
            if (this.isBlank(fieldMap, AssetLocationService.LocationField.ZIP_CODE, zipCode)) {
                this.putError(fieldMap, AssetLocationService.LocationField.ZIP_CODE, "error.offcampus.zip.required", new String[0]);
                valid &= false;
            }
            if (!this.isBlank(fieldMap, AssetLocationService.LocationField.STATE_CODE, stateCode)) {
                HashMap<String, String> assetLocationMap = new HashMap<String, String>();
                assetLocationMap.put("stateCode", stateCode);
                State locationState = ((StateService)SpringContext.getBean(StateService.class)).getState(countryCode, stateCode);
                if (ObjectUtils.isNull((Object)locationState)) {
                    this.putError(fieldMap, AssetLocationService.LocationField.STATE_CODE, "error.invalid.state.code", stateCode);
                    valid &= false;
                }
            }
        }
        return valid;
    }

    protected boolean isBlank(Map<AssetLocationService.LocationField, String> fieldMap, AssetLocationService.LocationField field, String countryCode) {
        return fieldMap.get((Object)field) != null && StringUtils.isBlank((String)countryCode);
    }

    protected String readPropertyValue(BusinessObject currObject, Map<AssetLocationService.LocationField, String> fieldMap, AssetLocationService.LocationField field) {
        String stringValue = null;
        try {
            String propertyName = fieldMap.get((Object)field);
            if (propertyName != null) {
                stringValue = (String)ObjectUtils.getNestedValue((Object)currObject, (String)propertyName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stringValue;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.DataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.DataDictionaryService = dataDictionaryService;
    }
}

