/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.fp.document.CapitalAssetEditable;
import org.kuali.kfs.fp.document.CapitalAssetInformationDocumentBase;
import org.kuali.kfs.integration.cab.CapitalAssetBuilderModuleService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.module.cam.businessobject.AssetLock;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.sys.businessobject.AccountingLineBase;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.TargetAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.kew.api.WorkflowDocument;

public class CapitalAssetManagementModuleServiceImpl
implements CapitalAssetManagementModuleService {
    protected static Logger LOG = Logger.getLogger(CapitalAssetManagementModuleServiceImpl.class);
    protected CapitalAssetBuilderModuleService capitalAssetBuilderModuleService;

    public boolean storeAssetLocks(List<Long> capitalAssetNumbers, String documentNumber, String documentType, String lockingInformation) {
        List<AssetLock> assetLocks = this.getAssetLockService().buildAssetLockHelper(capitalAssetNumbers, documentNumber, documentType, StringUtils.isBlank((String)lockingInformation) ? "-1" : lockingInformation);
        return this.getAssetLockService().checkAndSetAssetLocks(assetLocks, false);
    }

    public void deleteAssetLocks(String documentNumber, String lockingInformation) {
        this.getAssetLockService().deleteAssetLocks(documentNumber, lockingInformation);
    }

    protected AssetLockService getAssetLockService() {
        return (AssetLockService)SpringContext.getBean(AssetLockService.class);
    }

    public boolean isAssetLockedByCurrentDocument(String documentNumber, String lockingInformation) {
        return this.getAssetLockService().isAssetLockedByCurrentDocument(documentNumber, lockingInformation);
    }

    public boolean isAssetLocked(List<Long> assetNumbers, String documentTypeName, String excludingDocumentNumber) {
        return this.getAssetLockService().isAssetLocked(assetNumbers, documentTypeName, excludingDocumentNumber);
    }

    public void generateCapitalAssetLock(Document document, String documentTypeName) {
        ArrayList<AssetLock> assetLocks = new ArrayList<AssetLock>();
        StringBuilder capitalAssetToBeLocked = new StringBuilder();
        if (document instanceof CapitalAssetEditable) {
            List capitalAssets = ((CapitalAssetEditable)document).getCapitalAssetInformation();
            if (this.capitalAssetBuilderModuleService.isDocumentEligibleForCABBatch(documentTypeName)) {
                List includedObjectSubTypeCodes = this.capitalAssetBuilderModuleService.getBatchIncludedObjectSubTypes();
                List excludedChartCodes = this.capitalAssetBuilderModuleService.getBatchExcludedChartCodes();
                List excludedSubFundCodes = this.capitalAssetBuilderModuleService.getBatchExcludedSubFundCodes();
                for (CapitalAssetInformation assetLine : capitalAssets) {
                    Long capitalAssetNumber = assetLine.getCapitalAssetNumber();
                    if (capitalAssetNumber == null || !this.capitalAssetBuilderModuleService.isAssetLineEligibleForCABBatch(assetLine, ((CapitalAssetInformationDocumentBase)document).getPostingYear(), includedObjectSubTypeCodes, excludedChartCodes, excludedSubFundCodes)) continue;
                    AssetLock newLock = new AssetLock(document.getDocumentNumber(), capitalAssetNumber, assetLine.getCapitalAssetLineNumber() == null ? "-1" : assetLine.getCapitalAssetLineNumber().toString(), documentTypeName);
                    assetLocks.add(newLock);
                    if (!capitalAssetToBeLocked.toString().isEmpty()) {
                        capitalAssetToBeLocked.append(",");
                    }
                    capitalAssetToBeLocked.append(capitalAssetNumber.toString());
                }
                if (!this.getAssetLockService().checkAndSetAssetLocks(assetLocks, true)) {
                    throw new ValidationException("Asset " + capitalAssetToBeLocked.toString() + " is being locked by other documents.");
                }
            }
        }
    }

    public boolean isFpDocumentEligibleForAssetLock(AccountingDocument accountingDocument, String documentType) {
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        ArrayList excludedDocTypeCodes = new ArrayList(parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSET_BUILDER_BATCH.class, "DOCUMENT_TYPES"));
        if (!excludedDocTypeCodes.isEmpty() && excludedDocTypeCodes.contains(documentType)) {
            return false;
        }
        ArrayList<String> includedFinancialObjectSubTypeCodes = new ArrayList<String>(parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSET_BUILDER_BATCH.class, "OBJECT_SUB_TYPES"));
        ArrayList<String> excludedChartCodes = new ArrayList<String>(parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSET_BUILDER_BATCH.class, "CHARTS"));
        ArrayList<String> excludedSubFundCodes = new ArrayList<String>(parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSET_BUILDER_BATCH.class, "SUB_FUND_GROUPS"));
        List sAccountingLines = accountingDocument.getSourceAccountingLines();
        for (SourceAccountingLine sourceAccountingLine : sAccountingLines) {
            if (!this.isAccountLineEligibleForCABBatch(includedFinancialObjectSubTypeCodes, excludedChartCodes, excludedSubFundCodes, (AccountingLineBase)sourceAccountingLine)) continue;
            return true;
        }
        List tAccountingLines = accountingDocument.getTargetAccountingLines();
        for (TargetAccountingLine targetAccountingLine : tAccountingLines) {
            if (!this.isAccountLineEligibleForCABBatch(includedFinancialObjectSubTypeCodes, excludedChartCodes, excludedSubFundCodes, (AccountingLineBase)targetAccountingLine)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAccountLineEligibleForCABBatch(List<String> includedFinancialObjectSubTypeCodes, List<String> excludedChartCodes, List<String> excludedSubFundCodes, AccountingLineBase accountingLine) {
        if (!includedFinancialObjectSubTypeCodes.isEmpty() && !includedFinancialObjectSubTypeCodes.contains(accountingLine.getObjectCode().getFinancialObjectSubTypeCode())) {
            return false;
        }
        if (!excludedChartCodes.isEmpty() && excludedChartCodes.contains(accountingLine.getChartOfAccountsCode())) {
            return false;
        }
        return excludedSubFundCodes.isEmpty() || !excludedSubFundCodes.contains(accountingLine.getAccount().getSubFundGroupCode());
    }

    public void deleteDocumentAssetLocks(Document document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isRecalled() || workflowDocument.isException()) {
            this.deleteAssetLocks(document.getDocumentNumber(), null);
        }
    }

    public CapitalAssetBuilderModuleService getCapitalAssetBuilderModuleService() {
        return this.capitalAssetBuilderModuleService;
    }

    public void setCapitalAssetBuilderModuleService(CapitalAssetBuilderModuleService capitalAssetBuilderModuleService) {
        this.capitalAssetBuilderModuleService = capitalAssetBuilderModuleService;
    }
}

