/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.cam.document.EquipmentLoanOrReturnDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.role.RoleMembership;

public class AssetDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected DocumentService documentService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        EquipmentLoanOrReturnDocument document;
        String documentNumber;
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>(1);
        if (qualification != null && !qualification.isEmpty() && StringUtils.isNotBlank((String)(documentNumber = qualification.get("documentNumber"))) && (document = this.getEquipmentLoanOrReturnDocument(documentNumber)) != null) {
            RoleMembership.Builder builder = RoleMembership.Builder.create(null, null, (String)document.getBorrowerUniversalIdentifier(), (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, null);
            members.add(builder.build());
        }
        return members;
    }

    protected EquipmentLoanOrReturnDocument getEquipmentLoanOrReturnDocument(String documentNumber) {
        try {
            return (EquipmentLoanOrReturnDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Workflow problem while trying to get document using doc id '" + documentNumber + "'", e);
        }
    }

    protected DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return this.documentService;
    }
}

