/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cab.batch;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.cab.batch.ExtractProcessLog;
import org.kuali.kfs.module.cab.batch.service.BatchExtractReportService;
import org.kuali.kfs.module.cab.batch.service.BatchExtractService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class ExtractStep
extends AbstractStep {
    private static final Logger LOG = Logger.getLogger(ExtractStep.class);
    private BatchExtractService batchExtractService;
    private DateTimeService dateTimeService;
    private BatchExtractReportService batchExtractReportService;

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        ExtractProcessLog processLog = new ExtractProcessLog();
        try {
            Timestamp startTs = this.dateTimeService.getCurrentTimestamp();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("CAB extract started at " + startTs));
            }
            processLog.setStartTime(startTs);
            this.batchExtractService.performExtract(processLog);
            processLog.setFinishTime(this.dateTimeService.getCurrentTimestamp());
        }
        catch (Throwable e) {
            processLog.setSuccess(false);
            processLog.setErrorMessage("Unexpected error occured while performing CAB Extract. " + e.toString());
            LOG.error((Object)"Unexpected error occured while performing CAB Extract.", e);
            throw new RuntimeException(e);
        }
        finally {
            this.batchExtractReportService.generateStatusReportPDF(processLog);
            if (processLog.getMismatchedGLEntries() != null && !processLog.getMismatchedGLEntries().isEmpty()) {
                this.batchExtractReportService.generateMismatchReportPDF(processLog);
            }
            LOG.info((Object)"Batch status report is generated successfully.");
        }
        return true;
    }

    public BatchExtractService getBatchExtractService() {
        return this.batchExtractService;
    }

    public void setBatchExtractService(BatchExtractService batchExtractService) {
        this.batchExtractService = batchExtractService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BatchExtractReportService getBatchExtractReportService() {
        return this.batchExtractReportService;
    }

    public void setBatchExtractReportService(BatchExtractReportService batchExtractReportService) {
        this.batchExtractReportService = batchExtractReportService;
    }
}

