/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.GlobalBusinessObjectDetail;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class AssetLocationGlobal
extends PersistableBusinessObjectBase
implements GlobalBusinessObject {
    private String documentNumber;
    private DocumentHeader documentHeader;
    private List<AssetLocationGlobalDetail> assetLocationGlobalDetails = new ArrayList<AssetLocationGlobalDetail>();

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public DocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void setDocumentHeader(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public List<AssetLocationGlobalDetail> getAssetLocationGlobalDetails() {
        return this.assetLocationGlobalDetails;
    }

    public void setAssetLocationGlobalDetails(List<AssetLocationGlobalDetail> assetLocationGlobalDetails) {
        this.assetLocationGlobalDetails = assetLocationGlobalDetails;
    }

    public List<PersistableBusinessObject> generateDeactivationsToPersist() {
        return null;
    }

    public List<PersistableBusinessObject> generateGlobalChangesToPersist() {
        ArrayList<PersistableBusinessObject> persistables = new ArrayList<PersistableBusinessObject>();
        for (AssetLocationGlobalDetail detail : this.assetLocationGlobalDetails) {
            boolean isCampusCodeChanged = false;
            boolean isBuildingCodeChanged = false;
            boolean isBuildingRoomNumberChanged = false;
            boolean isBuildingSubRoomNumberChanged = false;
            boolean isCampusTagNumberChanged = false;
            Asset asset = (Asset)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Asset.class, detail.getPrimaryKeys());
            if (asset == null) continue;
            if (!StringUtils.equalsIgnoreCase((String)asset.getCampusCode(), (String)detail.getCampusCode())) {
                asset.setCampusCode(detail.getCampusCode());
                isCampusCodeChanged = true;
            }
            if (!StringUtils.equalsIgnoreCase((String)asset.getBuildingCode(), (String)detail.getBuildingCode())) {
                asset.setBuildingCode(detail.getBuildingCode());
                isBuildingCodeChanged = true;
            }
            if (!StringUtils.equalsIgnoreCase((String)asset.getBuildingRoomNumber(), (String)detail.getBuildingRoomNumber())) {
                asset.setBuildingRoomNumber(detail.getBuildingRoomNumber());
                isBuildingRoomNumberChanged = true;
            }
            if (!StringUtils.equalsIgnoreCase((String)asset.getBuildingSubRoomNumber(), (String)detail.getBuildingSubRoomNumber())) {
                asset.setBuildingSubRoomNumber(detail.getBuildingSubRoomNumber());
                isBuildingSubRoomNumberChanged = true;
            }
            if (!StringUtils.equalsIgnoreCase((String)detail.getCampusTagNumber(), (String)asset.getCampusTagNumber())) {
                asset.setOldTagNumber(asset.getCampusTagNumber());
                asset.setCampusTagNumber(detail.getCampusTagNumber());
                isCampusTagNumberChanged = true;
            }
            this.updateOffCampusWithOnCampusValues(asset);
            if (isCampusCodeChanged || isBuildingCodeChanged || isBuildingRoomNumberChanged || isBuildingSubRoomNumberChanged || isCampusTagNumberChanged) {
                asset.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
            }
            persistables.add((PersistableBusinessObject)asset);
        }
        return persistables;
    }

    private void updateOffCampusWithOnCampusValues(Asset asset) {
        ArrayList toDelete = new ArrayList();
        if (asset.getAssetLocations() != null) {
            for (AssetLocation location : asset.getAssetLocations()) {
                boolean buildingOrRoom;
                boolean offCampus = "O".equals(location.getAssetLocationTypeCode());
                boolean bl = buildingOrRoom = StringUtils.isNotBlank((String)asset.getBuildingCode()) || StringUtils.isNotBlank((String)asset.getBuildingRoomNumber());
                if (!offCampus || !buildingOrRoom) continue;
                location.setAssetLocationContactName(null);
                location.setAssetLocationStreetAddress(null);
                location.setAssetLocationCityName(null);
                location.setAssetLocationStateCode(null);
                location.setAssetLocationCountryCode(null);
                location.setAssetLocationZipCode(null);
            }
        }
    }

    public boolean isPersistable() {
        return true;
    }

    public List<? extends GlobalBusinessObjectDetail> getAllDetailObjects() {
        return this.getAssetLocationGlobalDetails();
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.documentNumber);
        return m;
    }
}

