/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.AccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PurApAccountLineGroup
extends AccountLineGroup {
    private Logger LOG = Logger.getLogger(PurApAccountLineGroup.class);
    private List<PurApAccountingLineBase> sourceEntries = new ArrayList<PurApAccountingLineBase>();

    protected PurApAccountLineGroup() {
    }

    public PurApAccountLineGroup(PurApAccountingLineBase entry) {
        entry.refreshReferenceObject("purapItem");
        AccountsPayableItem purapItem = (AccountsPayableItem)entry.getPurapItem();
        if (ObjectUtils.isNotNull((Object)purapItem)) {
            purapItem.refreshReferenceObject("purapDocument");
            AccountsPayableDocumentBase purapDocument = (AccountsPayableDocumentBase)((AccountsPayableItem)entry.getPurapItem()).getPurapDocument();
            if (ObjectUtils.isNotNull((Object)purapDocument)) {
                this.setReferenceFinancialDocumentNumber(purapDocument.getPurchaseOrderIdentifier() != null ? purapDocument.getPurchaseOrderIdentifier().toString() : "");
                this.setDocumentNumber(purapDocument.getDocumentNumber());
            }
        } else {
            this.LOG.error((Object)("Could not load PurAP document details for " + entry.toString()));
        }
        this.setUniversityFiscalYear(entry.getPostingYear());
        this.setUniversityFiscalPeriodCode(entry.getPostingPeriodCode());
        this.setChartOfAccountsCode(entry.getChartOfAccountsCode());
        this.setAccountNumber(entry.getAccountNumber());
        this.setSubAccountNumber(entry.getSubAccountNumber());
        this.setFinancialObjectCode(entry.getFinancialObjectCode());
        this.setFinancialSubObjectCode(entry.getFinancialSubObjectCode());
        this.setOrganizationReferenceId(entry.getOrganizationReferenceId());
        this.setProjectCode(entry.getProjectCode());
        this.sourceEntries.add(entry);
        if (CreditMemoAccountRevision.class.isAssignableFrom(entry.getClass())) {
            this.setAmount((KualiDecimal)entry.getAmount().negated());
        } else {
            this.setAmount(entry.getAmount());
        }
    }

    public boolean isAccounted(PurApAccountingLineBase entry) {
        PurApAccountLineGroup test = new PurApAccountLineGroup(entry);
        return this.equals(test);
    }

    public void combineEntry(PurApAccountingLineBase newEntry) {
        this.sourceEntries.add(newEntry);
        this.amount = CreditMemoAccountRevision.class.isAssignableFrom(newEntry.getClass()) ? (KualiDecimal)this.amount.add(newEntry.getAmount().negated()) : (KualiDecimal)this.amount.add((AbstractKualiDecimal)newEntry.getAmount());
    }

    public List<PurApAccountingLineBase> getSourceEntries() {
        return this.sourceEntries;
    }

    public void setSourceEntries(List<PurApAccountingLineBase> sourceGlEntries) {
        this.sourceEntries = sourceGlEntries;
    }
}

