/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.krad.document.Copyable;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAllocationType;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.validation.event.AssetPaymentManuallyAddAccountingLineEvent;
import org.kuali.kfs.module.cam.util.distribution.AssetDistribution;
import org.kuali.kfs.module.cam.util.distribution.AssetDistributionEvenly;
import org.kuali.kfs.module.cam.util.distribution.AssetDistributionManual;
import org.kuali.kfs.module.cam.util.distribution.AssetDistributionPercent;
import org.kuali.kfs.module.cam.util.distribution.AssetPaymentDistributionByTotalCost;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentBase;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class AssetPaymentDocument
extends AccountingDocumentBase
implements Copyable,
AmountTotaling {
    protected static Logger LOG = Logger.getLogger(AssetPaymentDocument.class);
    protected List<AssetPaymentAssetDetail> assetPaymentAssetDetail;
    protected Long capitalAssetNumber;
    protected boolean capitalAssetBuilderOriginIndicator;
    protected AssetPaymentAllocationType assetPaymentAllocationType;
    protected String assetPaymentAllocationTypeCode;
    protected boolean allocationFromFPDocuments;

    public AssetPaymentDocument() {
        this.setAllocationFromFPDocuments(false);
        this.assetPaymentAllocationTypeCode = "2";
        this.setAssetPaymentAssetDetail(new ArrayList<AssetPaymentAssetDetail>());
    }

    public List buildListOfDeletionAwareLists() {
        List deletionAwareList = super.buildListOfDeletionAwareLists();
        deletionAwareList.add(this.getAssetPaymentAssetDetail());
        return deletionAwareList;
    }

    public List generateSaveEvents() {
        ArrayList<AssetPaymentManuallyAddAccountingLineEvent> subEvents = new ArrayList<AssetPaymentManuallyAddAccountingLineEvent>();
        if (!this.isCapitalAssetBuilderOriginIndicator()) {
            String errorPathPrefix = "document.sourceAccountingLine";
            int index = 0;
            Iterator i = this.getSourceAccountingLines().iterator();
            while (i.hasNext()) {
                String indexedErrorPathPrefix = errorPathPrefix + "[" + index + "]";
                AccountingLine currentLine = (AccountingLine)i.next();
                AssetPaymentManuallyAddAccountingLineEvent newSubEvent = new AssetPaymentManuallyAddAccountingLineEvent(indexedErrorPathPrefix, (Document)this, currentLine);
                subEvents.add(newSubEvent);
                ++index;
            }
        }
        subEvents.addAll(super.generateSaveEvents());
        return subEvents;
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        String poDocId;
        ArrayList<String> documentIds = null;
        if (this.isCapitalAssetBuilderOriginIndicator() && StringUtils.isNotBlank((String)(poDocId = ((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).getCurrentPurchaseOrderDocumentNumber(this.getDocumentNumber())))) {
            documentIds = new ArrayList<String>();
            documentIds.add(poDocId);
        }
        return documentIds;
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return false;
    }

    public boolean isCapitalAssetBuilderOriginIndicator() {
        return this.capitalAssetBuilderOriginIndicator;
    }

    public void setCapitalAssetBuilderOriginIndicator(boolean capitalAssetBuilderOriginIndicator) {
        this.capitalAssetBuilderOriginIndicator = capitalAssetBuilderOriginIndicator;
    }

    public void addAssetPaymentAssetDetail(AssetPaymentAssetDetail assetPaymentAssetDetail) {
        this.getAssetPaymentAssetDetail().add(assetPaymentAssetDetail);
    }

    public void postProcessSave(KualiDocumentEvent event) {
        super.postProcessSave(event);
        if (!(event instanceof SaveDocumentEvent)) {
            ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
            for (AssetPaymentAssetDetail assetPaymentAssetDetail : this.getAssetPaymentAssetDetail()) {
                if (assetPaymentAssetDetail.getCapitalAssetNumber() == null) continue;
                capitalAssetNumbers.add(assetPaymentAssetDetail.getCapitalAssetNumber());
            }
            String documentTypeForLocking = "MPAY";
            if (this.isCapitalAssetBuilderOriginIndicator()) {
                documentTypeForLocking = "MPAYCAB";
            }
            if (!this.getCapitalAssetManagementModuleService().storeAssetLocks(capitalAssetNumbers, this.getDocumentNumber(), documentTypeForLocking, null)) {
                throw new ValidationException("Asset " + capitalAssetNumbers.toString() + " is being locked by other documents.");
            }
        }
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isProcessed()) {
            ((AssetPaymentService)SpringContext.getBean(AssetPaymentService.class)).processApprovedAssetPayment(this);
        }
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isProcessed()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
        if (this.isCapitalAssetBuilderOriginIndicator()) {
            ((CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class)).notifyRouteStatusChange(this.getDocumentHeader());
        }
    }

    public void prepareForSave(KualiDocumentEvent event) {
        for (AssetPaymentAssetDetail assetDetail : this.getAssetPaymentAssetDetail()) {
            assetDetail.refreshReferenceObject("asset");
            if (ObjectUtils.isNotNull((Object)((Object)assetDetail.getAsset())) && assetDetail.getAsset().getTotalCostAmount() != null) {
                assetDetail.setPreviousTotalCostAmount(assetDetail.getAsset().getTotalCostAmount());
            }
            List<AssetPaymentDetail> apdList = assetDetail.getAssetPaymentDetails();
            for (AssetPaymentDetail apd : apdList) {
                String accountingPeriodCompositeString = this.getAccountingPeriodCompositeString();
                apd.setPostingYear(new Integer(StringUtils.right((String)accountingPeriodCompositeString, (int)4)));
                apd.setPostingPeriodCode(StringUtils.left((String)accountingPeriodCompositeString, (int)2));
            }
        }
    }

    public List<AssetPaymentAssetDetail> getAssetPaymentAssetDetail() {
        return this.assetPaymentAssetDetail;
    }

    public void setAssetPaymentAssetDetail(List<AssetPaymentAssetDetail> assetPaymentAssetDetail) {
        this.assetPaymentAssetDetail = assetPaymentAssetDetail;
    }

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public KualiDecimal getAssetsTotalHistoricalCost() {
        KualiDecimal total = new KualiDecimal(0);
        if (this.getAssetPaymentAssetDetail().isEmpty()) {
            return new KualiDecimal(0);
        }
        for (AssetPaymentAssetDetail detail : this.getAssetPaymentAssetDetail()) {
            KualiDecimal amount = detail.getPreviousTotalCostAmount() == null ? new KualiDecimal(0) : detail.getPreviousTotalCostAmount();
            total = (KualiDecimal)total.add((AbstractKualiDecimal)amount);
        }
        return total;
    }

    public AssetDistribution getAssetPaymentDistributor() {
        if ("1".equals(this.getAssetPaymentAllocationTypeCode())) {
            return new AssetDistributionManual(this);
        }
        if ("4".equals(this.getAssetPaymentAllocationTypeCode())) {
            return new AssetDistributionPercent(this);
        }
        if ("3".equals(this.getAssetPaymentAllocationTypeCode())) {
            return new AssetPaymentDistributionByTotalCost(this);
        }
        return new AssetDistributionEvenly(this);
    }

    public String getAssetPaymentAllocationTypeCode() {
        return this.assetPaymentAllocationTypeCode;
    }

    public void setAssetPaymentAllocationTypeCode(String code) {
        this.assetPaymentAllocationTypeCode = code;
        this.refreshReferenceObject("assetPaymentAllocationType");
    }

    public void setAssetPaymentAllocationType(AssetPaymentAllocationType assetPaymentAllocationType) {
        this.assetPaymentAllocationType = assetPaymentAllocationType;
    }

    public AssetPaymentAllocationType getAssetPaymentAllocationType() {
        return this.assetPaymentAllocationType;
    }

    public boolean isAllocationFromFPDocuments() {
        return this.allocationFromFPDocuments;
    }

    public void setAllocationFromFPDocuments(boolean allocationFromFPDocuments) {
        this.allocationFromFPDocuments = allocationFromFPDocuments;
    }
}

