/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAllocationType;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.dataaccess.AssetPaymentDao;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.util.distribution.AssetDistribution;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AssetPaymentServiceImpl
implements AssetPaymentService {
    private static Logger LOG = Logger.getLogger(AssetPaymentServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private AssetPaymentDao assetPaymentDao;
    private ParameterService parameterService;
    private UniversityDateService universityDateService;
    private ObjectCodeService objectCodeService;
    private AssetRetirementService assetRetirementService;
    private AssetService assetService;
    private AssetGlobalService assetGlobalService;

    @Override
    public Integer getMaxSequenceNumber(Long capitalAssetNumber) {
        return this.getAssetPaymentDao().getMaxSquenceNumber(capitalAssetNumber);
    }

    @Override
    public boolean isPaymentFederalOwned(AssetPayment assetPayment) {
        assetPayment.refreshReferenceObject("objectCodeCurrent");
        if (ObjectUtils.isNotNull((Object)assetPayment.getObjectCodeCurrent())) {
            String subTypeCode = assetPayment.getObjectCodeCurrent().getFinancialObjectSubTypeCode();
            return this.getParameterService().getParameterValuesAsString(Asset.class, "FEDERAL_OWNED_OBJECT_SUB_TYPES").contains(subTypeCode);
        }
        return false;
    }

    @Override
    public boolean isPaymentEligibleForAccumDeprGLPosting(AssetPayment assetPayment) {
        KualiDecimal accumlatedDepreciationAmount = assetPayment.getAccumulatedPrimaryDepreciationAmount();
        return accumlatedDepreciationAmount == null ? false : !accumlatedDepreciationAmount.isZero();
    }

    @Override
    public boolean isPaymentEligibleForCapitalizationGLPosting(AssetPayment assetPayment) {
        KualiDecimal accountChargeAmount = assetPayment.getAccountChargeAmount();
        return accountChargeAmount == null ? false : !accountChargeAmount.isZero();
    }

    @Override
    public boolean isPaymentEligibleForOffsetGLPosting(AssetPayment assetPayment) {
        KualiDecimal accountChargeAmount = assetPayment.getAccountChargeAmount();
        if (assetPayment.getAccumulatedPrimaryDepreciationAmount() == null) {
            assetPayment.setAccumulatedPrimaryDepreciationAmount(KualiDecimal.ZERO);
        }
        KualiDecimal accumlatedDepreciationAmount = assetPayment.getAccumulatedPrimaryDepreciationAmount();
        return accountChargeAmount == null ? false : !((KualiDecimal)accountChargeAmount.subtract((AbstractKualiDecimal)accumlatedDepreciationAmount)).isZero();
    }

    @Override
    public boolean isPaymentFinancialObjectActive(AssetPayment assetPayment) {
        ObjectCode financialObjectCode = new ObjectCode();
        financialObjectCode.setUniversityFiscalYear(this.getUniversityDateService().getCurrentFiscalYear());
        financialObjectCode.setChartOfAccountsCode(assetPayment.getChartOfAccountsCode());
        financialObjectCode.setFinancialObjectCode(assetPayment.getFinancialObjectCode());
        financialObjectCode = (ObjectCode)this.getBusinessObjectService().retrieve((PersistableBusinessObject)financialObjectCode);
        if (ObjectUtils.isNotNull((Object)financialObjectCode)) {
            return financialObjectCode.isActive();
        }
        return false;
    }

    @Override
    public void processApprovedAssetPayment(AssetPaymentDocument document) {
        this.processPayments(document);
    }

    protected void processPayments(AssetPaymentDocument document) {
        List assetPaymentDetailLines = document.getSourceAccountingLines();
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = document.getAssetPaymentAssetDetail();
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        Integer maxSequenceNo = new Integer(0);
        AssetDistribution paymentDistributor = document.getAssetPaymentDistributor();
        Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> assetPaymentDistributionMap = paymentDistributor.getAssetPaymentDistributions();
        try {
            for (AssetPaymentAssetDetail assetPaymentAssetDetail : assetPaymentAssetDetails) {
                maxSequenceNo = this.getMaxSequenceNumber(assetPaymentAssetDetail.getCapitalAssetNumber());
                KualiDecimal totalAmount = KualiDecimal.ZERO;
                for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetailLines) {
                    KualiDecimal amount = assetPaymentDistributionMap.get(assetPaymentDetail.getAssetPaymentDetailKey()).get((Object)assetPaymentAssetDetail);
                    totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)amount);
                    AssetPayment assetPayment = new AssetPayment(assetPaymentDetail);
                    assetPayment.setCapitalAssetNumber(assetPaymentAssetDetail.getCapitalAssetNumber());
                    assetPayment.setTransferPaymentCode("N");
                    maxSequenceNo = maxSequenceNo + 1;
                    assetPayment.setPaymentSequenceNumber(maxSequenceNo);
                    if (StringUtils.isBlank((String)assetPayment.getDocumentNumber())) {
                        assetPayment.setDocumentNumber(document.getDocumentNumber());
                    }
                    assetPayment.setAccountChargeAmount(amount);
                    KualiDecimal baseAmount = KualiDecimal.ZERO;
                    ObjectCode objectCode = this.getObjectCodeService().getByPrimaryId(assetPaymentDetail.getPostingYear(), assetPaymentDetail.getChartOfAccountsCode(), assetPaymentDetail.getFinancialObjectCode());
                    if (!this.isNonDepreciableFederallyOwnedObjSubType(objectCode.getFinancialObjectSubTypeCode())) {
                        baseAmount = (KualiDecimal)baseAmount.add((AbstractKualiDecimal)amount);
                    }
                    assetPayment.setPrimaryDepreciationBaseAmount(baseAmount);
                    this.adjustPaymentAmounts(assetPayment, false, true);
                    assetPayments.add(assetPayment);
                }
                HashMap<String, Long> keys = new HashMap<String, Long>();
                keys.put("capitalAssetNumber", assetPaymentAssetDetail.getCapitalAssetNumber());
                Asset asset = (Asset)this.getBusinessObjectService().findByPrimaryKey(Asset.class, keys);
                if (assetPaymentAssetDetail.getPreviousTotalCostAmount() == null) {
                    assetPaymentAssetDetail.setPreviousTotalCostAmount(new KualiDecimal(0));
                }
                asset.setTotalCostAmount((KualiDecimal)assetPaymentAssetDetail.getPreviousTotalCostAmount().add((AbstractKualiDecimal)totalAmount));
                if (asset.getFinancialObjectSubTypeCode() == null || asset.getFinancialObjectSubTypeCode().trim().equals("")) {
                    asset.setFinancialObjectSubTypeCode(((AssetPaymentDetail)((Object)assetPaymentDetailLines.get(0))).getObjectCode().getFinancialObjectSubTypeCode());
                }
                this.getBusinessObjectService().save((PersistableBusinessObject)asset);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.getBusinessObjectService().save(assetPayments);
    }

    @Override
    public void adjustPaymentAmounts(AssetPayment assetPayment, boolean reverseAmount, boolean nullPeriodDepreciation) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor[] propertyDescriptors;
        LOG.debug((Object)"Starting - adjustAmounts() ");
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(AssetPayment.class)) {
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null || propertyDescriptor.getPropertyType() == null || !KualiDecimal.class.isAssignableFrom(propertyDescriptor.getPropertyType())) continue;
            KualiDecimal amount = (KualiDecimal)readMethod.invoke((Object)assetPayment, new Object[0]);
            Method writeMethod = propertyDescriptor.getWriteMethod();
            if (writeMethod == null || amount == null) continue;
            if (nullPeriodDepreciation && Pattern.matches("setperiod\\d.*depreciation\\damount", writeMethod.getName().toLowerCase())) {
                Object[] nullVal = new Object[]{null};
                writeMethod.invoke((Object)assetPayment, nullVal);
                continue;
            }
            if (!reverseAmount) continue;
            writeMethod.invoke((Object)assetPayment, amount.negated());
        }
        LOG.debug((Object)"Finished - adjustAmounts()");
    }

    @Override
    public boolean isPaymentEligibleForGLPosting(AssetPayment assetPayment) {
        boolean isEligible = !"Y".equals(assetPayment.getTransferPaymentCode());
        isEligible &= this.isPaymentFinancialObjectActive(assetPayment);
        return isEligible &= !this.isPaymentFederalOwned(assetPayment);
    }

    @Override
    public boolean isNonDepreciableFederallyOwnedObjSubType(String objectSubType) {
        ArrayList federallyOwnedObjectSubTypes = new ArrayList();
        if (this.getParameterService().parameterExists(AssetDepreciationStep.class, "NON_DEPRECIABLE_FEDERALLY_OWNED_OBJECT_SUB_TYPES").booleanValue()) {
            federallyOwnedObjectSubTypes = new ArrayList(this.getParameterService().getParameterValuesAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_FEDERALLY_OWNED_OBJECT_SUB_TYPES"));
        }
        return federallyOwnedObjectSubTypes.contains(objectSubType);
    }

    @Override
    public boolean extractPostedDatePeriod(AssetPaymentDetail assetPaymentDetail) {
        HashMap<String, Date> primaryKeys = new HashMap<String, Date>();
        primaryKeys.put("universityDate", assetPaymentDetail.getExpenditureFinancialDocumentPostedDate());
        UniversityDate universityDate = (UniversityDate)this.businessObjectService.findByPrimaryKey(UniversityDate.class, primaryKeys);
        if (universityDate != null) {
            assetPaymentDetail.setPostingYear(universityDate.getUniversityFiscalYear());
            assetPaymentDetail.setPostingPeriodCode(universityDate.getUniversityFiscalAccountingPeriod());
            return true;
        }
        return false;
    }

    @Override
    public Integer getAssetPaymentDetailQuantity(AssetGlobal assetGlobal) {
        Integer assetPaymentDetailQuantity = 0;
        for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
            Integer n = assetPaymentDetailQuantity;
            Integer n2 = assetPaymentDetailQuantity = Integer.valueOf(assetPaymentDetailQuantity + 1);
        }
        return assetPaymentDetailQuantity;
    }

    @Override
    public boolean validateAssets(String errorPath, Asset asset) {
        boolean valid = true;
        if (!this.getAssetService().isCapitalAsset(asset)) {
            GlobalVariables.getMessageMap().putError(errorPath, "error.non.capital.asset.payment", new String[]{asset.getCapitalAssetNumber().toString()});
            valid &= false;
        }
        if (this.getAssetService().isAssetRetired(asset)) {
            GlobalVariables.getMessageMap().putError(errorPath, "error.non.active.asset.retirment", new String[]{asset.getCapitalAssetNumber().toString()});
            valid &= false;
        }
        return valid;
    }

    @Override
    public boolean hasDifferentObjectSubTypes(AssetPaymentDocument document) {
        ArrayList subTypes = new ArrayList();
        subTypes = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(Asset.class, "OBJECT_SUB_TYPE_GROUPS"));
        List assetPaymentDetails = document.getSourceAccountingLines();
        List<Object> validObjectSubTypes = new ArrayList<String>();
        Object objectSubTypeCode = null;
        ArrayList<String> objectSubTypeList = new ArrayList<String>();
        for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
            assetPaymentDetail.refreshReferenceObject("objectCode");
            if (ObjectUtils.isNull((Object)assetPaymentDetail.getObjectCode())) {
                return false;
            }
            objectSubTypeList.add(assetPaymentDetail.getObjectCode().getFinancialObjectSubTypeCode());
        }
        if (!((AssetService)SpringContext.getBean(AssetService.class)).isObjectSubTypeCompatible(objectSubTypeList)) {
            return true;
        }
        List<AssetPaymentAssetDetail> assetPaymentAssetDetails = document.getAssetPaymentAssetDetail();
        for (AssetPaymentAssetDetail assetPaymentAssetDetail : assetPaymentAssetDetails) {
            assetPaymentAssetDetail.getAsset().refreshReferenceObject("assetPayments");
            List<AssetPayment> assetPayments = assetPaymentAssetDetail.getAsset().getAssetPayments();
            if (assetPayments.isEmpty()) continue;
            for (AssetPayment assetPayment : assetPayments) {
                String subType;
                String paymentSubObjectType = assetPayment.getFinancialObject().getFinancialObjectSubTypeCode();
                validObjectSubTypes = new ArrayList();
                Iterator iterator = subTypes.iterator();
                while (iterator.hasNext() && !(validObjectSubTypes = Arrays.asList(StringUtils.split((String)(subType = (String)iterator.next()), (String)","))).contains(paymentSubObjectType)) {
                    validObjectSubTypes = new ArrayList();
                }
                if (validObjectSubTypes.isEmpty()) {
                    validObjectSubTypes.add(paymentSubObjectType);
                }
                for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
                    if (validObjectSubTypes.contains(assetPaymentDetail.getObjectCode().getFinancialObjectSubTypeCode())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AssetPaymentDao getAssetPaymentDao() {
        return this.assetPaymentDao;
    }

    public void setAssetPaymentDao(AssetPaymentDao assetPaymentDao) {
        this.assetPaymentDao = assetPaymentDao;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public AssetRetirementService getAssetRetirementService() {
        return this.assetRetirementService;
    }

    public void setAssetRetirementService(AssetRetirementService assetRetirementService) {
        this.assetRetirementService = assetRetirementService;
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    @Override
    public AssetPaymentAllocationType getAssetDistributionType(String distributionCode) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("distributionCode", distributionCode);
        AssetPaymentAllocationType d = (AssetPaymentAllocationType)this.getBusinessObjectService().findByPrimaryKey(AssetPaymentAllocationType.class, keys);
        return d;
    }
}

