/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableProcessingReport;
import org.kuali.kfs.module.cam.service.PurchasingAccountsPayableReportService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.services.IdentityManagementService;
import org.kuali.rice.krad.bo.BusinessObject;

public class PurApReportLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static Logger LOG = Logger.getLogger(PurApReportLookupableHelperServiceImpl.class);
    private PurchasingAccountsPayableReportService purApReportService;

    public List<HtmlData> getCustomActionUrls(BusinessObject bo, List pkNames) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", "KFS-CAM");
        permissionDetails.put("actionClass", "org.kuali.kfs.module.cam.web.struts.PurApLineAction");
        if (!((IdentityManagementService)SpringContext.getBean(IdentityManagementService.class)).isAuthorizedByTemplateName(GlobalVariables.getUserSession().getPrincipalId(), "KR-NS", "Use Screen", permissionDetails, null)) {
            return super.getEmptyActionUrls();
        }
        GeneralLedgerEntry glEntry = (GeneralLedgerEntry)bo;
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        if (glEntry.getReferenceFinancialDocumentNumber() != null) {
            parameters.put("purchaseOrderIdentifier", glEntry.getReferenceFinancialDocumentNumber());
        }
        String href = UrlFactory.parameterizeUrl((String)"../camsPurApLine.do", (Properties)parameters);
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "start", "P".equalsIgnoreCase(glEntry.getActivityStatusCode()) ? "view" : "process");
        anchorHtmlData.setTarget("_blank");
        anchorHtmlDataList.add((HtmlData)anchorHtmlData);
        return anchorHtmlDataList;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String purapDocumentIdentifier = this.getSelectedField(fieldValues, "purapDocumentIdentifier");
        String active = this.getSelectedField(fieldValues, "activityStatusCode");
        if ("Y".equalsIgnoreCase(active)) {
            fieldValues.remove("activityStatusCode");
        }
        Iterator searchResultIterator = this.purApReportService.findGeneralLedgers(fieldValues);
        List<PurchasingAccountsPayableProcessingReport> purApReportList = this.buildGlEntrySearchResultCollection(searchResultIterator, active);
        if (StringUtils.isNotBlank((String)purapDocumentIdentifier)) {
            Map<String, String> purapDocumentLookupFields = this.getPurApDocumentLookupFields(fieldValues, purapDocumentIdentifier);
            Collection purApDocs = this.purApReportService.findPurchasingAccountsPayableDocuments(purapDocumentLookupFields);
            Map<String, Integer> purApDocNumberMap = this.buildDocumentNumberMap(purApDocs);
            purApReportList = this.updatePurApReportListByPurApDocs(purApReportList, purApDocNumberMap);
        } else {
            purApReportList = this.updateResultList(purApReportList);
        }
        return this.buildSearchResultList(purApReportList);
    }

    private List<PurchasingAccountsPayableProcessingReport> updateResultList(List<PurchasingAccountsPayableProcessingReport> purApReportList) {
        ArrayList<PurchasingAccountsPayableProcessingReport> newResultList = new ArrayList<PurchasingAccountsPayableProcessingReport>();
        BusinessObjectService boService = this.getBusinessObjectService();
        HashMap<String, String> pKeys = new HashMap<String, String>();
        for (PurchasingAccountsPayableProcessingReport report : purApReportList) {
            pKeys.put("documentNumber", report.getDocumentNumber());
            PurchasingAccountsPayableDocument purApDocument = (PurchasingAccountsPayableDocument)boService.findByPrimaryKey(PurchasingAccountsPayableDocument.class, pKeys);
            if (ObjectUtils.isNotNull((Object)((Object)purApDocument))) {
                report.setPurapDocumentIdentifier(purApDocument.getPurapDocumentIdentifier());
                newResultList.add(report);
            }
            pKeys.clear();
        }
        return newResultList;
    }

    private List<? extends BusinessObject> buildSearchResultList(List purApReportList) {
        CollectionIncomplete searchResults = null;
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(PurchasingAccountsPayableProcessingReport.class);
        Long matchingResultsCount = purApReportList.size();
        searchResults = searchResultsLimit > 0 && matchingResultsCount.intValue() > searchResultsLimit ? new CollectionIncomplete(purApReportList.subList(0, searchResultsLimit), matchingResultsCount) : new CollectionIncomplete((Collection)purApReportList, Long.valueOf(0L));
        return searchResults;
    }

    private Map<String, Integer> buildDocumentNumberMap(Collection purApDocs) {
        HashMap<String, Integer> purApDocNumbers = new HashMap<String, Integer>();
        for (PurchasingAccountsPayableDocument purApdoc : purApDocs) {
            purApDocNumbers.put(purApdoc.getDocumentNumber(), purApdoc.getPurapDocumentIdentifier());
        }
        return purApDocNumbers;
    }

    private Map<String, String> getPurApDocumentLookupFields(Map<String, String> fieldValues, String purapDocumentIdentifier) {
        HashMap<String, String> purapDocumentLookupFields = new HashMap<String, String>();
        purapDocumentLookupFields.put("purapDocumentIdentifier", purapDocumentIdentifier);
        purapDocumentLookupFields.put("documentNumber", fieldValues.get("documentNumber"));
        purapDocumentLookupFields.put("purchaseOrderIdentifier", fieldValues.get("referenceFinancialDocumentNumber"));
        return purapDocumentLookupFields;
    }

    private List<PurchasingAccountsPayableProcessingReport> updatePurApReportListByPurApDocs(List<PurchasingAccountsPayableProcessingReport> purApReportList, Map<String, Integer> purApDocNumberMap) {
        ArrayList<PurchasingAccountsPayableProcessingReport> newReportsList = new ArrayList<PurchasingAccountsPayableProcessingReport>();
        for (PurchasingAccountsPayableProcessingReport report : purApReportList) {
            if (!purApDocNumberMap.containsKey(report.getDocumentNumber())) continue;
            report.setPurapDocumentIdentifier(purApDocNumberMap.get(report.getDocumentNumber()));
            newReportsList.add(report);
        }
        return newReportsList;
    }

    private List<PurchasingAccountsPayableProcessingReport> buildGlEntrySearchResultCollection(Iterator searchResultIterator, String activeSelection) {
        ArrayList<PurchasingAccountsPayableProcessingReport> purApReportList = new ArrayList<PurchasingAccountsPayableProcessingReport>();
        while (searchResultIterator.hasNext()) {
            Object glEntry = searchResultIterator.next();
            if (!glEntry.getClass().isArray()) continue;
            int i = 0;
            Object[] columnValues = (Object[])glEntry;
            PurchasingAccountsPayableProcessingReport newReport = new PurchasingAccountsPayableProcessingReport();
            newReport.setUniversityFiscalYear(new Integer(columnValues[i++].toString()));
            newReport.setUniversityFiscalPeriodCode(columnValues[i++].toString());
            newReport.setChartOfAccountsCode(columnValues[i++].toString());
            newReport.setAccountNumber(columnValues[i++].toString());
            newReport.setFinancialObjectCode(columnValues[i++].toString());
            newReport.setFinancialDocumentTypeCode(columnValues[i++].toString());
            newReport.setDocumentNumber(columnValues[i++].toString());
            newReport.setTransactionDebitCreditCode(columnValues[i] == null ? null : columnValues[i].toString());
            newReport.setTransactionLedgerEntryAmount(columnValues[++i] == null ? null : new KualiDecimal(columnValues[i].toString()));
            newReport.setReferenceFinancialDocumentNumber(columnValues[++i] == null ? null : columnValues[i].toString());
            newReport.setTransactionDate(columnValues[++i] == null ? null : this.getDate(columnValues[i]));
            newReport.setTransactionLedgerSubmitAmount(columnValues[++i] == null ? null : new KualiDecimal(columnValues[i].toString()));
            newReport.setActivityStatusCode(columnValues[++i] == null ? null : columnValues[i].toString());
            if (this.excludeFromSearchResults(newReport, activeSelection)) continue;
            if (newReport.getActivityStatusCode() != null && newReport.isActive()) {
                if (newReport.getTransactionLedgerEntryAmount() != null) {
                    this.setReportAmount(activeSelection, newReport);
                }
            } else {
                newReport.setReportAmount(newReport.getAmount());
            }
            purApReportList.add(newReport);
        }
        return purApReportList;
    }

    private Date getDate(Object obj) {
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Timestamp) {
            Timestamp tsp = (Timestamp)obj;
            return new Date(tsp.getTime());
        }
        return null;
    }

    private boolean excludeFromSearchResults(PurchasingAccountsPayableProcessingReport newReport, String activeSelection) {
        return "Y".equalsIgnoreCase(activeSelection) && (newReport.getTransactionLedgerSubmitAmount() == null || newReport.getTransactionLedgerSubmitAmount().isZero());
    }

    private void setReportAmount(String active, PurchasingAccountsPayableProcessingReport newReport) {
        if ("Y".equalsIgnoreCase(active)) {
            newReport.setReportAmount(newReport.getTransactionLedgerSubmitAmount());
        } else if ("N".equalsIgnoreCase(active)) {
            KualiDecimal reportAmount = newReport.getAmount();
            if (reportAmount != null && newReport.getTransactionLedgerSubmitAmount() != null) {
                newReport.setReportAmount((KualiDecimal)reportAmount.subtract((AbstractKualiDecimal)newReport.getTransactionLedgerSubmitAmount()));
            } else {
                newReport.setReportAmount(reportAmount);
            }
        } else {
            newReport.setReportAmount(newReport.getAmount());
        }
    }

    private String getSelectedField(Map fieldValues, String fieldName) {
        String fieldValue = null;
        if (fieldValues.containsKey(fieldName)) {
            fieldValue = (String)fieldValues.get(fieldName);
        }
        return fieldValue == null ? "" : fieldValue;
    }

    public PurchasingAccountsPayableReportService getPurApReportService() {
        return this.purApReportService;
    }

    public void setPurApReportService(PurchasingAccountsPayableReportService purApReportService) {
        this.purApReportService = purApReportService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }
}

