/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetFabrication;
import org.kuali.kfs.module.cam.businessobject.defaultvalue.NextAssetNumberFinder;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.module.cam.document.service.RetirementInfoService;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.module.cam.util.MaintainableWorkflowUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;

public class AssetMaintainableImpl
extends FinancialSystemMaintainable {
    private Asset asset;
    private Asset copyAsset;
    private boolean fabricationOn;
    protected static volatile IdentityService identityService;
    protected static volatile DocumentService documentService;
    private static final Map<String, String> FINANCIAL_DOC_NAME_MAP;

    public List<MaintenanceLock> generateMaintenanceLocks() {
        return new ArrayList<MaintenanceLock>();
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
        WorkflowDocument workflowDoc = documentHeader.getWorkflowDocument();
        if (this.getBusinessObject() instanceof Asset && !(this.getBusinessObject() instanceof AssetFabrication) && (workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isProcessed() || workflowDoc.isFinal())) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void processAfterEdit(MaintenanceDocument document, Map parameters) {
        this.initializeAttributes(document);
        this.getAssetLocationService().setOffCampusLocation(this.copyAsset);
        this.getAssetLocationService().setOffCampusLocation(this.asset);
        PaymentSummaryService paymentSummaryService = (PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class);
        paymentSummaryService.calculateAndSetPaymentSummary(this.copyAsset);
        paymentSummaryService.calculateAndSetPaymentSummary(this.asset);
        this.getAssetService().setSeparateHistory(this.copyAsset);
        this.getAssetService().setSeparateHistory(this.asset);
        RetirementInfoService retirementInfoService = (RetirementInfoService)SpringContext.getBean(RetirementInfoService.class);
        retirementInfoService.setRetirementInfo(this.copyAsset);
        retirementInfoService.setRetirementInfo(this.asset);
        retirementInfoService.setMergeHistory(this.copyAsset);
        retirementInfoService.setMergeHistory(this.asset);
        EquipmentLoanOrReturnService equipmentLoanOrReturnService = (EquipmentLoanOrReturnService)SpringContext.getBean(EquipmentLoanOrReturnService.class);
        equipmentLoanOrReturnService.setEquipmentLoanInfo(this.copyAsset);
        equipmentLoanOrReturnService.setEquipmentLoanInfo(this.asset);
        super.processAfterEdit(document, parameters);
    }

    public List<Section> getCoreSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getCoreSections(document, oldMaintainable);
        Asset asset = (Asset)this.getBusinessObject();
        if (asset.getAssetPayments().size() == 0) {
            for (Section section : sections) {
                if (!"paymentInformation".equals(section.getSectionId())) continue;
                section.setSectionTitle(section.getSectionTitle() + "- No payment exists for Capital Asset: " + asset.getCapitalAssetNumber());
            }
        }
        return sections;
    }

    private void initializeAttributes(MaintenanceDocument document) {
        if (this.asset == null) {
            this.asset = (Asset)document.getNewMaintainableObject().getBusinessObject();
            this.asset.setTagged();
        }
        if (this.copyAsset == null) {
            this.copyAsset = (Asset)document.getOldMaintainableObject().getBusinessObject();
        }
        this.setFabricationOn(document.getNewMaintainableObject().getBusinessObject() instanceof AssetFabrication);
    }

    public void processAfterRetrieve() {
        if (this.getBusinessObject() instanceof Asset && MaintainableWorkflowUtils.isDocumentSavedOrEnroute(this.getDocumentNumber())) {
            Asset asset = (Asset)this.getBusinessObject();
            asset.refreshReferenceObject("assetPayments");
            PaymentSummaryService paymentSummaryService = (PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class);
            paymentSummaryService.calculateAndSetPaymentSummary(asset);
        }
    }

    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> parameters) {
        WorkflowDocument workflowDoc;
        String[] customAction = parameters.get("customAction");
        if (customAction != null && customAction.length > 0 && StringUtils.equals((String)"lastInventoryDateUpdateButton", (String)customAction[0]) && (workflowDoc = document.getDocumentHeader().getWorkflowDocument()) != null && workflowDoc.isInitiated()) {
            this.asset.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
            String userPrincipalName = GlobalVariables.getUserSession().getPrincipalName();
            String noteTextPattern = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("note.last.inventory.date.updated");
            Object[] arguments = new Object[]{userPrincipalName, this.asset.getCapitalAssetNumber().toString()};
            String noteText = MessageFormat.format(noteTextPattern, arguments);
            Note lastInventoryDateUpdatedNote = AssetMaintainableImpl.getDocumentService().createNoteFromDocument((Document)document, noteText);
            lastInventoryDateUpdatedNote.setAuthorUniversalIdentifier(this.getIdentityService().getPrincipalByPrincipalName("kfs").getPrincipalId());
            document.addNote(lastInventoryDateUpdatedNote);
            AssetMaintainableImpl.getDocumentService().saveDocumentNotes((Document)document);
        }
        super.processAfterPost(document, parameters);
    }

    public void saveBusinessObject() {
        Asset asset = (Asset)this.businessObject;
        if (asset.getCapitalAssetNumber() == null) {
            asset.setCapitalAssetNumber(NextAssetNumberFinder.getLongValue());
        }
        asset.refreshReferenceObject("assetLocations");
        if (this.getAssetLocationService().isOffCampusLocationExists(asset.getOffCampusLocation())) {
            this.getAssetLocationService().updateOffCampusLocation(asset);
        }
        super.saveBusinessObject();
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterNew(document, parameters);
        this.initializeAttributes(document);
        if (this.asset.getCreateDate() == null) {
            this.asset.setCreateDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate());
            this.asset.setAcquisitionTypeCode("C");
            this.asset.setVendorName("CONSTRUCTED");
            this.asset.setInventoryStatusCode("U");
            this.asset.setPrimaryDepreciationMethodCode("SL");
            this.asset.setCapitalAssetTypeCode(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(Asset.class, "DEFAULT_FABRICATION_ASSET_TYPE"));
            this.asset.setManufacturerName(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(Asset.class, "DEFAULT_FABRICATION_ASSET_MANUFACTURER"));
            this.getAssetService().setFiscalPeriod(this.asset);
        }
        this.getAssetLocationService().setOffCampusLocation(this.asset);
    }

    public void setGenerateDefaultValues(String docTypeName) {
    }

    public List<String> getFpLinks() {
        Asset asset = (Asset)this.getBusinessObject();
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        assetNumbers.add(asset.getCapitalAssetNumber());
        return ((AssetLockService)SpringContext.getBean(AssetLockService.class)).getAssetLockingDocuments(assetNumbers, "AFPINQ", "");
    }

    public List<String> getPreqLinks() {
        Asset asset = (Asset)this.getBusinessObject();
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        assetNumbers.add(asset.getCapitalAssetNumber());
        return ((AssetLockService)SpringContext.getBean(AssetLockService.class)).getAssetLockingDocuments(assetNumbers, "APREQINQ", "");
    }

    public List<String> getFpLinkedDocumentInfo() {
        ArrayList<String> documentInfo = new ArrayList<String>();
        for (String aDocumentNumber : this.getFpLinks()) {
            try {
                String docTypeName = AssetMaintainableImpl.getDocumentService().getByDocumentHeaderId(aDocumentNumber).getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
                documentInfo.add(FINANCIAL_DOC_NAME_MAP.get(docTypeName) + "-" + aDocumentNumber);
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Caught WorkflowException trying to get document type name", e);
            }
        }
        return documentInfo;
    }

    public boolean isFabricationOn() {
        return this.fabricationOn;
    }

    public void setFabricationOn(boolean fabricationOn) {
        this.fabricationOn = fabricationOn;
    }

    private AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    private AssetLocationService getAssetLocationService() {
        return (AssetLocationService)SpringContext.getBean(AssetLocationService.class);
    }

    protected static DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return documentService;
    }

    public IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = (IdentityService)SpringContext.getBean(IdentityService.class);
        }
        return identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        AssetMaintainableImpl.identityService = identityService;
    }

    static {
        FINANCIAL_DOC_NAME_MAP = new HashMap<String, String>();
        FINANCIAL_DOC_NAME_MAP.put("CR", "Cash Receipt");
        FINANCIAL_DOC_NAME_MAP.put("DI", "Distribution of Income and Expense");
        FINANCIAL_DOC_NAME_MAP.put("GEC", "General Error Correction");
        FINANCIAL_DOC_NAME_MAP.put("IB", "Internal Billing");
        FINANCIAL_DOC_NAME_MAP.put("SB", "Service Billing");
        FINANCIAL_DOC_NAME_MAP.put("YEDI", "Year End Distribution of Income and Expense");
        FINANCIAL_DOC_NAME_MAP.put("YEGE", "Year End General Error Correction");
        FINANCIAL_DOC_NAME_MAP.put("PCDO", "Procurement Card");
    }
}

