/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.integration.purap.ItemCapitalAsset;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.Pretag;
import org.kuali.kfs.module.cam.businessobject.PretagDetail;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.businessobject.defaultvalue.NextAssetNumberFinder;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.PurApInfoService;
import org.kuali.kfs.module.cam.document.service.PurApLineDocumentService;
import org.kuali.kfs.module.cam.document.service.PurApLineService;
import org.kuali.kfs.module.cam.document.web.PurApLineSession;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderCapitalAssetSystem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.DocumentSystemSaveEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.location.api.campus.Campus;
import org.kuali.rice.location.api.campus.CampusService;

public class PurApLineDocumentServiceImpl
implements PurApLineDocumentService {
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private PurApLineService purApLineService;
    private PurApInfoService purApInfoService;
    private AssetGlobalService assetGlobalService;
    public static final String DOCUMENT_DESC_PREFIX = "CAB created for ";

    @Override
    public String processApplyPayment(PurchasingAccountsPayableItemAsset selectedItem, List<PurchasingAccountsPayableDocument> purApDocs, PurApLineSession purApLineSession, Integer requisitionIdentifer) throws WorkflowException {
        AssetPaymentDocument newDocument = (AssetPaymentDocument)this.documentService.getNewDocument(AssetPaymentDocument.class);
        if (ObjectUtils.isNotNull((Object)selectedItem) && ObjectUtils.isNotNull((Object)((Object)selectedItem.getPurchasingAccountsPayableDocument()))) {
            newDocument.getDocumentHeader().setDocumentDescription(DOCUMENT_DESC_PREFIX + selectedItem.getPurchasingAccountsPayableDocument().getDocumentTypeCode() + " " + selectedItem.getDocumentNumber());
        }
        this.createAssetPaymentDetails(newDocument.getSourceAccountingLines(), selectedItem, newDocument.getDocumentNumber(), requisitionIdentifer);
        if (selectedItem.getPurApItemAssets() != null && !selectedItem.getPurApItemAssets().isEmpty()) {
            this.createAssetPaymentAssetDetails(newDocument.getAssetPaymentAssetDetail(), selectedItem, newDocument.getDocumentNumber());
        }
        newDocument.setCapitalAssetBuilderOriginIndicator(true);
        this.documentService.saveDocument((Document)newDocument);
        this.postProcessCreatingDocument(selectedItem, purApDocs, purApLineSession, newDocument.getDocumentNumber());
        return newDocument.getDocumentNumber();
    }

    protected void createAssetPaymentAssetDetails(List assetPaymentAssetDetails, PurchasingAccountsPayableItemAsset selectedItem, String documentNumber) {
        for (ItemCapitalAsset capitalAssetNumber : selectedItem.getPurApItemAssets()) {
            if (!this.isAssetNumberValid(capitalAssetNumber.getCapitalAssetNumber())) continue;
            AssetPaymentAssetDetail assetDetail = new AssetPaymentAssetDetail();
            assetDetail.setDocumentNumber(documentNumber);
            assetDetail.setCapitalAssetNumber(capitalAssetNumber.getCapitalAssetNumber());
            assetDetail.refreshReferenceObject("asset");
            AssetService assetService = (AssetService)SpringContext.getBean(AssetService.class);
            Asset candidateAsset = assetDetail.getAsset();
            if (!ObjectUtils.isNotNull((Object)((Object)candidateAsset)) || !assetService.isCapitalAsset(candidateAsset) || assetService.isAssetRetired(candidateAsset)) continue;
            assetDetail.setPreviousTotalCostAmount(assetDetail.getAsset().getTotalCostAmount());
            assetPaymentAssetDetails.add(assetDetail);
        }
    }

    protected boolean isAssetNumberValid(Long capitalAssetNumber) {
        HashMap<String, Long> pKeys = new HashMap<String, Long>();
        pKeys.put("capitalAssetNumber", capitalAssetNumber);
        Asset asset = (Asset)this.businessObjectService.findByPrimaryKey(Asset.class, pKeys);
        return ObjectUtils.isNotNull((Object)((Object)asset));
    }

    @Override
    public String processCreateAsset(PurchasingAccountsPayableItemAsset selectedItem, List<PurchasingAccountsPayableDocument> purApDocs, PurApLineSession purApLineSession, Integer requisitionIdentifier) throws WorkflowException {
        MaintenanceDocument newDocument = (MaintenanceDocument)this.documentService.getNewDocument("AA");
        newDocument.getNewMaintainableObject().setMaintenanceAction("New");
        if (ObjectUtils.isNotNull((Object)selectedItem) && ObjectUtils.isNotNull((Object)((Object)selectedItem.getPurchasingAccountsPayableDocument()))) {
            newDocument.getDocumentHeader().setDocumentDescription(DOCUMENT_DESC_PREFIX + selectedItem.getPurchasingAccountsPayableDocument().getDocumentTypeCode() + " " + selectedItem.getDocumentNumber());
        }
        Integer poId = selectedItem.getPurchasingAccountsPayableDocument().getPurchaseOrderIdentifier();
        Pretag preTag = this.purApLineService.getPreTagLineItem(poId, selectedItem.getItemLineNumber());
        AssetGlobal assetGlobal = this.createAssetGlobal(selectedItem, newDocument.getDocumentNumber(), preTag, requisitionIdentifier);
        newDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)assetGlobal);
        this.documentService.saveDocument((Document)newDocument, DocumentSystemSaveEvent.class);
        this.postProcessCreatingDocument(selectedItem, purApDocs, purApLineSession, newDocument.getDocumentNumber());
        if (this.isItemPretagged(preTag)) {
            this.businessObjectService.save((PersistableBusinessObject)preTag);
        }
        return newDocument.getDocumentNumber();
    }

    protected void postProcessCreatingDocument(PurchasingAccountsPayableItemAsset selectedItem, List<PurchasingAccountsPayableDocument> purApDocs, PurApLineSession purApLineSession, String documentNumber) {
        selectedItem.setCapitalAssetManagementDocumentNumber(documentNumber);
        this.inActivateItem(selectedItem);
        this.updateGlEntrySubmitAmount(selectedItem, purApLineSession.getGlEntryUpdateList());
        if (ObjectUtils.isNotNull((Object)((Object)selectedItem.getPurchasingAccountsPayableDocument()))) {
            this.conditionalyUpdateDocumentStatusAsEnroute(selectedItem.getPurchasingAccountsPayableDocument());
        }
        this.purApLineService.processSaveBusinessObjects(purApDocs, purApLineSession);
        List<GeneralLedgerEntry> glEntryUpdatesList = this.getGlEntryInActivedList(selectedItem);
        if (glEntryUpdatesList != null && !glEntryUpdatesList.isEmpty()) {
            this.businessObjectService.save(glEntryUpdatesList);
        }
    }

    protected void conditionalyUpdateDocumentStatusAsEnroute(PurchasingAccountsPayableDocument selectedDoc) {
        for (PurchasingAccountsPayableItemAsset item : selectedDoc.getPurchasingAccountsPayableItemAssets()) {
            if (!item.isActive()) continue;
            return;
        }
        selectedDoc.setActivityStatusCode("E");
    }

    protected void updateGlEntrySubmitAmount(PurchasingAccountsPayableItemAsset selectedItem, List glEntryList) {
        GeneralLedgerEntry glEntry = null;
        for (PurchasingAccountsPayableLineAssetAccount account : selectedItem.getPurchasingAccountsPayableLineAssetAccounts()) {
            glEntry = account.getGeneralLedgerEntry();
            if (ObjectUtils.isNotNull((Object)((Object)glEntry))) {
                if (glEntry.getTransactionLedgerSubmitAmount() != null) {
                    glEntry.setTransactionLedgerSubmitAmount((KualiDecimal)glEntry.getTransactionLedgerSubmitAmount().add((AbstractKualiDecimal)account.getItemAccountTotalAmount()));
                } else {
                    glEntry.setTransactionLedgerSubmitAmount(new KualiDecimal(account.getItemAccountTotalAmount().toString()));
                }
            }
            glEntryList.add(glEntry);
        }
    }

    protected void setAssetGlobalDetails(PurchasingAccountsPayableItemAsset selectedItem, AssetGlobal assetGlobal, Pretag preTag, PurchaseOrderCapitalAssetSystem capitalAssetSystem) {
        List<AssetGlobalDetail> assetDetailsList = assetGlobal.getAssetGlobalDetails();
        List<AssetGlobalDetail> sharedDetails = assetGlobal.getAssetSharedDetails();
        for (int i = 0; i < selectedItem.getAccountsPayableItemQuantity().intValue(); ++i) {
            AssetGlobalDetail assetGlobalDetail = new AssetGlobalDetail();
            assetGlobalDetail.setDocumentNumber(assetGlobal.getDocumentNumber());
            assetGlobalDetail.setCapitalAssetNumber(NextAssetNumberFinder.getLongValue());
            assetDetailsList.add(assetGlobalDetail);
            AssetGlobalDetail sharedDetail = new AssetGlobalDetail();
            sharedDetail.getAssetGlobalUniqueDetails().add(assetGlobalDetail);
            sharedDetails.add(sharedDetail);
        }
        if (this.isItemPretagged(preTag)) {
            this.setAssetDetailFromPreTag(preTag, sharedDetails, assetDetailsList);
        }
        if (!this.isItemFullyPretagged(preTag, assetGlobal) && ObjectUtils.isNotNull((Object)capitalAssetSystem)) {
            this.setAssetGlobalDetailFromPurAp(capitalAssetSystem, sharedDetails);
        }
    }

    protected boolean isItemFullyPretagged(Pretag preTag, AssetGlobal assetGlobal) {
        if (this.isItemPretagged(preTag)) {
            List<PretagDetail> pretagDetails = preTag.getPretagDetails();
            int pretagSize = 0;
            for (PretagDetail pretagDetail : pretagDetails) {
                if (!pretagDetail.isActive()) continue;
                ++pretagSize;
            }
            return pretagSize >= assetGlobal.getAssetSharedDetails().size();
        }
        return false;
    }

    protected void setAssetGlobalDetailFromPurAp(PurchaseOrderCapitalAssetSystem capitalAssetSystem, List<AssetGlobalDetail> assetSharedDetail) {
        List capitalAssetLocations = capitalAssetSystem.getCapitalAssetLocations();
        if (ObjectUtils.isNotNull((Object)capitalAssetLocations) && !capitalAssetLocations.isEmpty()) {
            Iterator locationIterator = capitalAssetLocations.iterator();
            int locationQuantity = 0;
            CapitalAssetLocation assetLocation = null;
            for (AssetGlobalDetail assetDetail : assetSharedDetail) {
                if (StringUtils.isNotEmpty((String)assetDetail.getCampusCode())) continue;
                if (locationQuantity <= 0 && locationIterator.hasNext()) {
                    assetLocation = (CapitalAssetLocation)locationIterator.next();
                    locationQuantity = assetLocation.getItemQuantity() != null ? assetLocation.getItemQuantity().intValue() : 1;
                } else if (locationQuantity <= 0 && !locationIterator.hasNext()) break;
                this.setNewAssetByPurApLocation(assetLocation, assetDetail);
                --locationQuantity;
            }
        }
    }

    protected void setNewAssetByPurApLocation(CapitalAssetLocation assetLocation, AssetGlobalDetail assetDetail) {
        String campusCode = assetLocation.getCampusCode();
        if (!StringUtils.isBlank((String)campusCode) && this.checkCampusCodeValid(campusCode)) {
            assetDetail.setCampusCode(campusCode);
            if (!assetLocation.isOffCampusIndicator()) {
                String buildingCode = assetLocation.getBuildingCode();
                if (!StringUtils.isBlank((String)buildingCode) && this.checkBuildingCodeValid(campusCode, buildingCode)) {
                    assetDetail.setBuildingCode(buildingCode);
                    String buildingRoomNumber = assetLocation.getBuildingRoomNumber();
                    if (!StringUtils.isBlank((String)buildingRoomNumber) && this.checkBuildingRoomNumberValid(campusCode, buildingCode, buildingRoomNumber)) {
                        assetDetail.setBuildingRoomNumber(buildingRoomNumber);
                    }
                }
            } else {
                assetDetail.setOffCampusCityName(assetLocation.getCapitalAssetCityName());
                assetDetail.setOffCampusAddress(assetLocation.getCapitalAssetLine1Address());
                assetDetail.setOffCampusCountryCode(assetLocation.getCapitalAssetCountryCode());
                assetDetail.setOffCampusStateCode(assetLocation.getCapitalAssetStateCode());
                assetDetail.setOffCampusZipCode(assetLocation.getCapitalAssetPostalCode());
            }
        }
    }

    protected boolean checkBuildingRoomNumberValid(String campusCode, String buildingCode, String buildingRoomNumber) {
        HashMap<String, String> pKeys = new HashMap<String, String>();
        pKeys.put("campusCode", campusCode);
        pKeys.put("buildingCode", buildingCode);
        pKeys.put("buildingRoomNumber", buildingRoomNumber);
        Room room = (Room)this.getBusinessObjectService().findByPrimaryKey(Room.class, pKeys);
        return ObjectUtils.isNotNull((Object)room) && room.isActive();
    }

    protected boolean checkBuildingCodeValid(String campusCode, String buildingCode) {
        HashMap<String, String> pKeys = new HashMap<String, String>();
        pKeys.put("campusCode", campusCode);
        pKeys.put("buildingCode", buildingCode);
        Building building = (Building)this.getBusinessObjectService().findByPrimaryKey(Building.class, pKeys);
        return ObjectUtils.isNotNull((Object)building) && building.isActive();
    }

    protected boolean checkCampusCodeValid(String campusCode) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("campusCode", campusCode);
        Campus campus = ((CampusService)SpringContext.getBean(CampusService.class)).getCampus(campusCode);
        return ObjectUtils.isNotNull((Object)campus) && campus.isActive();
    }

    protected void setAssetDetailFromPreTag(Pretag preTag, List<AssetGlobalDetail> assetSharedDetails, List<AssetGlobalDetail> assetUniqueDetails) {
        Iterator<AssetGlobalDetail> sharedDetailsIterator = assetSharedDetails.iterator();
        Iterator<AssetGlobalDetail> uniqueDetailsIterator = assetUniqueDetails.iterator();
        for (PretagDetail preTagDetail : preTag.getPretagDetails()) {
            if (!preTagDetail.isActive()) continue;
            if (sharedDetailsIterator.hasNext()) {
                AssetGlobalDetail sharedDetail = sharedDetailsIterator.next();
                sharedDetail.setBuildingCode(preTagDetail.getBuildingCode());
                sharedDetail.setBuildingRoomNumber(preTagDetail.getBuildingRoomNumber());
                sharedDetail.setBuildingSubRoomNumber(preTagDetail.getBuildingSubRoomNumber());
                sharedDetail.setCampusCode(preTagDetail.getCampusCode());
                preTagDetail.setActive(false);
            }
            if (!uniqueDetailsIterator.hasNext()) continue;
            AssetGlobalDetail uniqueDetail = uniqueDetailsIterator.next();
            uniqueDetail.setGovernmentTagNumber(preTagDetail.getGovernmentTagNumber());
            uniqueDetail.setNationalStockNumber(preTagDetail.getNationalStockNumber());
            uniqueDetail.setCampusTagNumber(preTagDetail.getCampusTagNumber());
            uniqueDetail.setOrganizationInventoryName(preTag.getOrganizationInventoryName());
            uniqueDetail.setSerialNumber(preTagDetail.getSerialNumber());
            uniqueDetail.setRepresentativeUniversalIdentifier(preTag.getRepresentativeUniversalIdentifier());
            preTagDetail.setActive(false);
        }
        this.inActivatePreTag(preTag);
    }

    protected void inActivatePreTag(Pretag preTag) {
        int inActiveCounter = 0;
        for (PretagDetail preTagDetail : preTag.getPretagDetails()) {
            if (preTagDetail.isActive()) continue;
            ++inActiveCounter;
        }
        if (preTag.getQuantityInvoiced().isLessEqual((AbstractKualiDecimal)new KualiDecimal(inActiveCounter))) {
            preTag.setActive(false);
        }
    }

    protected void createAssetPaymentDetails(List<AssetPaymentDetail> assetPaymentList, PurchasingAccountsPayableItemAsset selectedItem, String documentNumber, Integer requisitionIdentifier) {
        int seq = 1;
        for (PurchasingAccountsPayableLineAssetAccount account : selectedItem.getPurchasingAccountsPayableLineAssetAccounts()) {
            GeneralLedgerEntry glEntry = account.getGeneralLedgerEntry();
            if (!ObjectUtils.isNotNull((Object)((Object)glEntry))) continue;
            AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail();
            assetPaymentDetail.setDocumentNumber(documentNumber);
            assetPaymentDetail.setSequenceNumber(seq++);
            assetPaymentDetail.setChartOfAccountsCode(glEntry.getChartOfAccountsCode());
            assetPaymentDetail.setAccountNumber(this.replaceFiller(glEntry.getAccountNumber()));
            assetPaymentDetail.setSubAccountNumber(this.replaceFiller(glEntry.getSubAccountNumber()));
            assetPaymentDetail.setFinancialObjectCode(this.replaceFiller(glEntry.getFinancialObjectCode()));
            assetPaymentDetail.setFinancialSubObjectCode(this.replaceFiller(glEntry.getFinancialSubObjectCode()));
            assetPaymentDetail.setProjectCode(this.replaceFiller(glEntry.getProjectCode()));
            assetPaymentDetail.setOrganizationReferenceId(glEntry.getOrganizationReferenceId());
            assetPaymentDetail.setPostingYear(glEntry.getUniversityFiscalYear());
            assetPaymentDetail.setPostingPeriodCode(glEntry.getUniversityFiscalPeriodCode());
            assetPaymentDetail.setExpenditureFinancialSystemOriginationCode(this.replaceFiller(glEntry.getFinancialSystemOriginationCode()));
            assetPaymentDetail.setExpenditureFinancialDocumentNumber(glEntry.getDocumentNumber());
            assetPaymentDetail.setExpenditureFinancialDocumentTypeCode(this.replaceFiller(glEntry.getFinancialDocumentTypeCode()));
            assetPaymentDetail.setExpenditureFinancialDocumentPostedDate(glEntry.getTransactionDate());
            assetPaymentDetail.setAmount(account.getItemAccountTotalAmount());
            assetPaymentDetail.setPurchaseOrderNumber(this.replaceFiller(glEntry.getReferenceFinancialDocumentNumber()));
            assetPaymentDetail.setRequisitionNumber(requisitionIdentifier.toString());
            assetPaymentDetail.setTransferPaymentIndicator(false);
            assetPaymentList.add(assetPaymentDetail);
        }
    }

    protected void inActivateItem(PurchasingAccountsPayableItemAsset selectedItem) {
        for (PurchasingAccountsPayableLineAssetAccount selectedAccount : selectedItem.getPurchasingAccountsPayableLineAssetAccounts()) {
            selectedAccount.setActivityStatusCode("E");
        }
        selectedItem.setActivityStatusCode("E");
    }

    protected List<GeneralLedgerEntry> getGlEntryInActivedList(PurchasingAccountsPayableItemAsset selectedItem) {
        ArrayList<GeneralLedgerEntry> glEntryUpdateList = new ArrayList<GeneralLedgerEntry>();
        for (PurchasingAccountsPayableLineAssetAccount selectedAccount : selectedItem.getPurchasingAccountsPayableLineAssetAccounts()) {
            GeneralLedgerEntry glEntry = selectedAccount.getGeneralLedgerEntry();
            KualiDecimal relatedAccountAmount = KualiDecimal.ZERO;
            glEntry.refreshReferenceObject("purApLineAssetAccounts");
            for (PurchasingAccountsPayableLineAssetAccount account : glEntry.getPurApLineAssetAccounts()) {
                if (account.isActive()) continue;
                relatedAccountAmount = (KualiDecimal)relatedAccountAmount.add((AbstractKualiDecimal)account.getItemAccountTotalAmount());
            }
            if (relatedAccountAmount.compareTo((AbstractKualiDecimal)glEntry.getAmount()) != 0) continue;
            glEntry.setActivityStatusCode("E");
            glEntryUpdateList.add(glEntry);
        }
        return glEntryUpdateList;
    }

    protected String replaceFiller(String val) {
        return val == null ? "" : val.trim().replaceAll("-", "");
    }

    protected AssetGlobal createAssetGlobal(PurchasingAccountsPayableItemAsset selectedItem, String documentNumber, Pretag preTag, Integer requisitionIdentifier) {
        AssetGlobal assetGlobal = new AssetGlobal();
        assetGlobal.setDocumentNumber(documentNumber);
        assetGlobal.setCapitalAssetDescription(selectedItem.getAccountsPayableLineItemDescription());
        assetGlobal.setConditionCode("E");
        assetGlobal.setAcquisitionTypeCode(this.getAssetGlobalService().getNewAcquisitionTypeCode());
        assetGlobal.setInventoryStatusCode("A");
        PurchaseOrderDocument purApdocument = this.getPurApInfoService().getCurrentDocumentForPurchaseOrderIdentifier(selectedItem.getPurchasingAccountsPayableDocument().getPurchaseOrderIdentifier());
        if (purApdocument != null) {
            assetGlobal.setVendorName(purApdocument.getVendorName());
        }
        assetGlobal.setCapitalAssetBuilderOriginIndicator(true);
        PurchaseOrderCapitalAssetSystem capitalAssetSystem = null;
        if (selectedItem.getCapitalAssetSystemIdentifier() != null && ObjectUtils.isNotNull((Object)(capitalAssetSystem = this.findCapitalAssetSystem(selectedItem.getCapitalAssetSystemIdentifier())))) {
            this.setAssetGlobalFromPurAp(assetGlobal, capitalAssetSystem);
        }
        if (this.isItemPretagged(preTag)) {
            this.setAssetGlobalFromPreTag(preTag, assetGlobal);
        }
        this.setAssetGlobalDetails(selectedItem, assetGlobal, preTag, capitalAssetSystem);
        this.setOrgInventoryNameForAssetDetail(assetGlobal.getAssetGlobalDetails(), purApdocument);
        this.createAssetPaymentDetails(assetGlobal.getAssetPaymentDetails(), selectedItem, documentNumber, requisitionIdentifier);
        this.setAssetGlobalTotalCost(assetGlobal);
        this.setAssetGlobalOrgOwnerAccount(assetGlobal);
        return assetGlobal;
    }

    protected void setOrgInventoryNameForAssetDetail(List<AssetGlobalDetail> assetGlobalDetails, PurchaseOrderDocument purApdocument) {
        if (ObjectUtils.isNotNull((Object)purApdocument)) {
            String orgInventoryName = purApdocument.getInstitutionContactName();
            if (StringUtils.isBlank((String)orgInventoryName)) {
                orgInventoryName = purApdocument.getRequestorPersonName();
            }
            for (AssetGlobalDetail assetGlobalDetail : assetGlobalDetails) {
                assetGlobalDetail.setOrganizationInventoryName(orgInventoryName);
            }
        }
    }

    protected boolean isItemPretagged(Pretag preTag) {
        return ObjectUtils.isNotNull((Object)((Object)preTag)) && preTag.isActive() && ObjectUtils.isNotNull(preTag.getPretagDetails()) && !preTag.getPretagDetails().isEmpty();
    }

    protected void setAssetGlobalFromPurAp(AssetGlobal assetGlobal, PurchaseOrderCapitalAssetSystem capitalAssetSystem) {
        assetGlobal.setManufacturerName(capitalAssetSystem.getCapitalAssetManufacturerName());
        assetGlobal.setManufacturerModelNumber(capitalAssetSystem.getCapitalAssetModelDescription());
        String capitalAssetTypeCode = capitalAssetSystem.getCapitalAssetTypeCode();
        if (!StringUtils.isBlank((String)capitalAssetTypeCode) && this.checkCapitalAssetTypeCodeExist(capitalAssetTypeCode)) {
            assetGlobal.setCapitalAssetTypeCode(capitalAssetSystem.getCapitalAssetTypeCode());
        }
    }

    protected boolean checkCapitalAssetTypeCodeExist(String capitalAssetTypeCode) {
        HashMap<String, String> pKeys = new HashMap<String, String>();
        pKeys.put("capitalAssetTypeCode", capitalAssetTypeCode);
        AssetType assetType = (AssetType)this.getBusinessObjectService().findByPrimaryKey(AssetType.class, pKeys);
        return ObjectUtils.isNotNull((Object)((Object)assetType));
    }

    protected PurchaseOrderCapitalAssetSystem findCapitalAssetSystem(Integer capitalAssetSystemIdentifier) {
        HashMap<String, Integer> pKeys = new HashMap<String, Integer>();
        pKeys.put("capitalAssetSystemIdentifier", capitalAssetSystemIdentifier);
        return (PurchaseOrderCapitalAssetSystem)this.businessObjectService.findByPrimaryKey(PurchaseOrderCapitalAssetSystem.class, pKeys);
    }

    protected void setAssetGlobalOrgOwnerAccount(AssetGlobal assetGlobal) {
        AssetPaymentDetail maxCostPayment = null;
        for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
            if (maxCostPayment != null && !assetPaymentDetail.getAmount().isGreaterThan((AbstractKualiDecimal)maxCostPayment.getAmount())) continue;
            maxCostPayment = assetPaymentDetail;
        }
        if (maxCostPayment != null) {
            assetGlobal.setOrganizationOwnerAccountNumber(maxCostPayment.getAccountNumber());
            assetGlobal.setOrganizationOwnerChartOfAccountsCode(maxCostPayment.getChartOfAccountsCode());
        }
    }

    protected void setAssetGlobalTotalCost(AssetGlobal assetGlobal) {
        KualiDecimal totalCost = KualiDecimal.ZERO;
        for (AssetPaymentDetail assetPaymentDetail : assetGlobal.getAssetPaymentDetails()) {
            totalCost = (KualiDecimal)totalCost.add((AbstractKualiDecimal)assetPaymentDetail.getAmount());
        }
        assetGlobal.setTotalCostAmount(totalCost);
    }

    protected void setAssetGlobalFromPreTag(Pretag preTag, AssetGlobal assetGlobal) {
        if (StringUtils.isNotBlank((String)preTag.getManufacturerName())) {
            assetGlobal.setManufacturerName(preTag.getManufacturerName());
        }
        if (StringUtils.isNotBlank((String)preTag.getManufacturerModelNumber())) {
            assetGlobal.setManufacturerModelNumber(preTag.getManufacturerModelNumber());
        }
        if (StringUtils.isNotBlank((String)preTag.getCapitalAssetTypeCode())) {
            assetGlobal.setCapitalAssetTypeCode(preTag.getCapitalAssetTypeCode());
        }
        assetGlobal.setOrganizationText(preTag.getOrganizationText());
        assetGlobal.setRepresentativeUniversalIdentifier(preTag.getRepresentativeUniversalIdentifier());
        if (StringUtils.isNotBlank((String)preTag.getVendorName())) {
            assetGlobal.setVendorName(preTag.getVendorName());
        }
        assetGlobal.setAcquisitionTypeCode("P");
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public PurApLineService getPurApLineService() {
        return this.purApLineService;
    }

    public void setPurApLineService(PurApLineService purApLineService) {
        this.purApLineService = purApLineService;
    }

    public PurApInfoService getPurApInfoService() {
        return this.purApInfoService;
    }

    public void setPurApInfoService(PurApInfoService purApInfoService) {
        this.purApInfoService = purApInfoService;
    }

    private AssetGlobalService getAssetGlobalService() {
        return this.assetGlobalService;
    }

    public void setAssetGlobalService(AssetGlobalService assetGlobalService) {
        this.assetGlobalService = assetGlobalService;
    }
}

