/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.batch.service.AssetBarcodeInventoryLoadService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetCondition;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.BarcodeInventoryErrorDocument;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.location.api.campus.Campus;
import org.kuali.rice.location.api.campus.CampusService;

public class BarcodeInventoryErrorDocumentRule
extends TransactionalDocumentRuleBase {
    protected static Logger LOG = Logger.getLogger(BarcodeInventoryErrorDocumentRule.class);

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        return true;
    }

    public boolean validateBarcodeInventoryErrorDetail(BarcodeInventoryErrorDocument document, boolean updateStatus) {
        String errorPath = "";
        boolean valid = true;
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = document.getBarcodeInventoryErrorDetail();
        ArrayList inventory = new ArrayList();
        Long lineNumber = new Long(0L);
        for (BarcodeInventoryErrorDetail barcodeInventoryErrorDetail : barcodeInventoryErrorDetails) {
            barcodeInventoryErrorDetail.setErrorDescription("");
            if (barcodeInventoryErrorDetail.getErrorCorrectionStatusCode().equals("E")) {
                valid = true;
                errorPath = "document.barcodeInventoryErrorDetail[" + lineNumber.intValue() + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                Asset asset = this.validateTagNumberAndRetrieveActiveAsset(barcodeInventoryErrorDetail.getAssetTagNumber());
                valid &= ObjectUtils.isNotNull((Object)((Object)asset));
                valid &= this.validateCampusCode(barcodeInventoryErrorDetail.getCampusCode(), barcodeInventoryErrorDetail);
                if (ObjectUtils.isNotNull((Object)((Object)asset))) {
                    valid &= this.validateBuildingCodeAndRoomNumber(barcodeInventoryErrorDetail, asset);
                }
                valid &= this.validateConditionCode(barcodeInventoryErrorDetail.getAssetConditionCode(), barcodeInventoryErrorDetail);
                valid &= this.validateInventoryDate(barcodeInventoryErrorDetail.getUploadScanTimestamp());
                if (!(valid &= this.validateTaggingLock(barcodeInventoryErrorDetail.getAssetTagNumber(), document.getDocumentNumber()))) {
                    barcodeInventoryErrorDetail.setErrorCorrectionStatusCode("E");
                    barcodeInventoryErrorDetail.setErrorDescription(this.getErrorMessages(errorPath));
                } else {
                    if (updateStatus) {
                        barcodeInventoryErrorDetail.setErrorCorrectionStatusCode("C");
                    }
                    barcodeInventoryErrorDetail.setErrorDescription("NONE");
                }
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            }
            Long l = lineNumber;
            Long l2 = lineNumber = Long.valueOf(lineNumber + 1L);
        }
        this.deleteLockErrorMessages();
        return true;
    }

    @Deprecated
    protected boolean validateTagNumber(String tagNumber) {
        boolean result = true;
        Collection<Asset> assets = this.getAssetService().findAssetsMatchingTagNumber(tagNumber);
        if (ObjectUtils.isNull(assets) || assets.isEmpty()) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.capitalAsset.not.found", new String[0]);
            result = false;
        } else {
            int activeAssets = assets.size();
            for (Asset asset : assets) {
                if (!this.getAssetService().isAssetRetired(asset)) continue;
                --activeAssets;
            }
            if (activeAssets == 0) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.capitalAsset.retired", new String[0]);
                result = false;
            } else if (activeAssets > 1) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.duplicated.tagNumber", new String[0]);
                result = false;
            }
        }
        return result;
    }

    protected Asset validateTagNumberAndRetrieveActiveAsset(String tagNumber) {
        List<Asset> assets = this.getAssetService().findActiveAssetsMatchingTagNumber(tagNumber);
        if (ObjectUtils.isNull(assets) || assets.isEmpty()) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.capitalAsset.not.found", new String[0]);
            return null;
        }
        if (assets.size() > 1) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.duplicated.tagNumber", new String[0]);
            return null;
        }
        return assets.get(0);
    }

    protected boolean validateInventoryDate(Timestamp inventoryDate) {
        boolean result = true;
        String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.INVENTORY_DATE).getLabel();
        if (inventoryDate == null) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.INVENTORY_DATE, "error.document.invalid.field", new String[]{label});
            result = false;
        }
        return result;
    }

    protected boolean validateCampusCode(String campusCode, BarcodeInventoryErrorDetail detail) {
        boolean result = true;
        String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.CAMPUS_CODE).getLabel();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("campusCode", detail.getCampusCode());
        Campus campus = ((CampusService)SpringContext.getBean(CampusService.class)).getCampus(campusCode);
        if (ObjectUtils.isNull((Object)campus)) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.CAMPUS_CODE, "error.document.invalid.field", new String[]{label});
            result = false;
        } else if (!campus.isActive()) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.CAMPUS_CODE, "error.document.inactive.field", new String[]{label});
            result &= false;
        }
        return result;
    }

    @Deprecated
    protected boolean validateBuildingCode(String buildingCode, BarcodeInventoryErrorDetail detail, Asset asset) {
        boolean result = true;
        String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE).getLabel();
        String description = asset.getCapitalAssetTypeCode();
        if (StringUtils.isBlank((String)asset.getBuildingCode())) {
            if (StringUtils.isNotBlank((String)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.not.allowed.field", new String[]{label, description});
                result &= false;
            }
        } else {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("campusCode", detail.getCampusCode());
            fields.put("buildingCode", detail.getBuildingCode());
            Building building = (Building)this.getBusinessObjectService().findByPrimaryKey(Building.class, fields);
            if (StringUtils.isBlank((String)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.required.field", new String[]{label, description});
                result &= false;
            } else if (ObjectUtils.isNull((Object)building)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.invalid.field", new String[]{label});
                result &= false;
            } else if (!building.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.inactive.field", new String[]{label});
                result &= false;
            }
        }
        return result;
    }

    @Deprecated
    protected boolean validateBuildingRoomNumber(String roomNumber, BarcodeInventoryErrorDetail detail, Asset asset) {
        boolean result = true;
        String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER).getLabel();
        String description = asset.getCapitalAssetTypeCode();
        if (StringUtils.isBlank((String)asset.getBuildingRoomNumber())) {
            if (StringUtils.isNotBlank((String)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.not.allowed.field", new String[]{label, description});
                result &= false;
            }
        } else {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("campusCode", detail.getCampusCode());
            fields.put("buildingCode", detail.getBuildingCode());
            fields.put("buildingRoomNumber", detail.getBuildingRoomNumber());
            Room room = (Room)this.getBusinessObjectService().findByPrimaryKey(Room.class, fields);
            if (StringUtils.isBlank((String)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.required.field", new String[]{label, description});
                result &= false;
            } else if (ObjectUtils.isNull((Object)room)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.invalid.field", new String[]{label});
                result = false;
            } else if (!room.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.inactive.field", new String[]{label});
                result &= false;
            }
        }
        return result;
    }

    protected boolean validateBuildingCodeAndRoomNumber(BarcodeInventoryErrorDetail detail, Asset asset) {
        boolean result = true;
        String campusCode = detail.getCampusCode();
        String buildingCode = detail.getBuildingCode();
        String roomNumber = detail.getBuildingRoomNumber();
        String labelBuilding = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE).getLabel();
        String labelRoom = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER).getLabel();
        String assetTypeCode = asset.getCapitalAssetTypeCode();
        AssetType assetType = asset.getCapitalAssetType();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("campusCode", campusCode);
        fields.put("buildingCode", buildingCode);
        Building building = (Building)this.getBusinessObjectService().findByPrimaryKey(Building.class, fields);
        fields.put("buildingRoomNumber", roomNumber);
        Room room = (Room)this.getBusinessObjectService().findByPrimaryKey(Room.class, fields);
        if (assetType.isMovingIndicator() && !assetType.isRequiredBuildingIndicator()) {
            if (StringUtils.isBlank((String)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.required.field", new String[]{labelBuilding, assetTypeCode});
                result &= false;
            } else if (ObjectUtils.isNull((Object)building)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.invalid.field", new String[]{labelBuilding});
                result &= false;
            } else if (!building.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.inactive.field", new String[]{labelBuilding});
                result &= false;
            }
            if (StringUtils.isBlank((String)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.required.field", new String[]{labelRoom, assetTypeCode});
                result &= false;
            } else if (ObjectUtils.isNull((Object)room)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.invalid.field", new String[]{labelRoom});
                result = false;
            } else if (!room.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.inactive.field", new String[]{labelRoom});
                result &= false;
            }
        } else if (!assetType.isMovingIndicator() && assetType.isRequiredBuildingIndicator()) {
            if (StringUtils.isBlank((String)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.required.field", new String[]{labelBuilding, assetTypeCode});
                result &= false;
            } else if (ObjectUtils.isNull((Object)building)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.invalid.field", new String[]{labelBuilding});
                result &= false;
            } else if (!building.isActive()) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.inactive.field", new String[]{labelBuilding});
                result &= false;
            }
            if (StringUtils.isNotBlank((String)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.not.allowed.field", new String[]{labelRoom, assetTypeCode});
                result &= false;
            }
        } else if (!assetType.isMovingIndicator() && !assetType.isRequiredBuildingIndicator()) {
            if (StringUtils.isNotBlank((String)buildingCode)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, "error.document.not.allowed.field", new String[]{labelBuilding, assetTypeCode});
                result &= false;
            }
            if (StringUtils.isNotBlank((String)roomNumber)) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, "error.document.not.allowed.field", new String[]{labelRoom, assetTypeCode});
                result &= false;
            }
        }
        return result;
    }

    protected boolean validateConditionCode(String conditionCode, BarcodeInventoryErrorDetail detail) {
        boolean result = true;
        String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(BarcodeInventoryErrorDetail.class.getName()).getAttributeDefinition(CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE).getLabel();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE, detail.getAssetConditionCode());
        AssetCondition condition = (AssetCondition)this.getBusinessObjectService().findByPrimaryKey(AssetCondition.class, fields);
        if (ObjectUtils.isNull((Object)((Object)condition))) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE, "error.document.invalid.field", new String[]{label});
            result &= false;
        } else if (!condition.isActive()) {
            GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE, "error.document.inactive.field", new String[]{label});
            result &= false;
        }
        return result;
    }

    protected boolean validateTaggingLock(String tagNumber, String documentNumber) {
        String skipAssetLockValidation;
        boolean result = true;
        boolean isAssetLocked = false;
        if (this.getParameterService().parameterExists(BarcodeInventoryErrorDocument.class, "IGNORES_LOCKS_IND").booleanValue()) {
            skipAssetLockValidation = this.getParameterService().getParameterValueAsString(BarcodeInventoryErrorDocument.class, "IGNORES_LOCKS_IND");
        } else {
            LOG.warn((Object)"CAMS Parameter 'IGNORES_LOCKS_IND' not found! - Setting default value to 'N' ");
            skipAssetLockValidation = "N";
        }
        if (skipAssetLockValidation == null || StringUtils.isEmpty((String)skipAssetLockValidation) || StringUtils.equals((String)skipAssetLockValidation, (String)"N")) {
            List<Asset> assets = this.getAssetService().findActiveAssetsMatchingTagNumber(tagNumber);
            if (assets.size() > 1) {
                GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.duplicated.tagNumber", new String[0]);
                result = false;
            } else if (assets.size() > 0) {
                ArrayList<Long> assetNumbers = new ArrayList<Long>();
                assetNumbers.add(assets.get(0).getCapitalAssetNumber());
                List<String> lockingDocNumbers = ((AssetLockService)SpringContext.getBean(AssetLockService.class)).getAssetLockingDocuments(assetNumbers, "BCIE", documentNumber);
                if (lockingDocNumbers != null && !lockingDocNumbers.isEmpty()) {
                    for (String lockingDocNumber : lockingDocNumbers) {
                        GlobalVariables.getMessageMap().putError(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, "error.document.locked.asset", new String[]{lockingDocNumber});
                    }
                    result = false;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    protected String getErrorMessages(String errorPath) {
        String message = "";
        String[] fields = new String[]{CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER, CamsPropertyConstants.BarcodeInventory.INVENTORY_DATE, CamsPropertyConstants.BarcodeInventory.CAMPUS_CODE, CamsPropertyConstants.BarcodeInventory.BUILDING_CODE, CamsPropertyConstants.BarcodeInventory.BUILDING_ROOM_NUMBER, CamsPropertyConstants.BarcodeInventory.ASSET_CONDITION_CODE};
        for (int i = 0; i < fields.length; ++i) {
            String propertyName = errorPath + "." + fields[i];
            if (!GlobalVariables.getMessageMap().doesPropertyHaveError(propertyName)) continue;
            for (Object errorMessage : GlobalVariables.getMessageMap().getMessages(propertyName)) {
                String errorMsg = this.getKualiConfigurationService().getPropertyValueAsString(((ErrorMessage)errorMessage).getErrorKey());
                message = message + ", " + MessageFormat.format(errorMsg, ((ErrorMessage)errorMessage).getMessageParameters());
            }
        }
        return StringUtils.isEmpty((String)message) ? message : message.substring(2);
    }

    protected void deleteLockErrorMessages() {
        ArrayList<ErrorMessage> el = new ArrayList<ErrorMessage>();
        if (GlobalVariables.getMessageMap().getMessages("GLOBAL_ERRORS") == null) {
            return;
        }
        for (ErrorMessage errorMessage : GlobalVariables.getMessageMap().getMessages("GLOBAL_ERRORS")) {
            if (!errorMessage.getErrorKey().equals("error.maintenance.locked")) continue;
            el.add(errorMessage);
        }
        for (ErrorMessage em : el) {
            GlobalVariables.getMessageMap().getMessages("GLOBAL_ERRORS").remove((Object)em);
        }
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    protected DateTimeService getDateTimeService() {
        return (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    protected AssetBarcodeInventoryLoadService getAssetBarcodeInventoryLoadService() {
        return (AssetBarcodeInventoryLoadService)SpringContext.getBean(AssetBarcodeInventoryLoadService.class);
    }
}

