/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util;

import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.BarcodeInventoryErrorDocument;

public class BarcodeInventoryErrorDetailPredicate
implements Predicate,
Closure {
    private static final Logger LOG = Logger.getLogger(BarcodeInventoryErrorDetailPredicate.class);
    private BarcodeInventoryErrorDocument doc;

    public BarcodeInventoryErrorDetailPredicate(BarcodeInventoryErrorDocument doc) {
        this.doc = doc;
    }

    public boolean evaluate(Object object) {
        boolean satisfies = true;
        if (object instanceof BarcodeInventoryErrorDetail) {
            BarcodeInventoryErrorDetail detail = (BarcodeInventoryErrorDetail)((Object)object);
            if (detail.getErrorCorrectionStatusCode().equals("E")) {
                if (this.doc.getCurrentTagNumber() != null && !StringUtils.isBlank((String)this.doc.getCurrentTagNumber()) && !StringUtils.equals((String)this.doc.getCurrentTagNumber(), (String)detail.getAssetTagNumber())) {
                    satisfies = false;
                }
                if (this.doc.getCurrentScanCode() != null && !StringUtils.isBlank((String)this.doc.getCurrentScanCode())) {
                    boolean bl = satisfies = this.doc.getCurrentScanCode().equals("Y") && detail.isUploadScanIndicator();
                }
                if (this.doc.getCurrentCampusCode() != null && !StringUtils.isBlank((String)this.doc.getCurrentCampusCode()) && !StringUtils.equals((String)this.doc.getCurrentCampusCode(), (String)detail.getCampusCode())) {
                    satisfies = false;
                }
                if (this.doc.getCurrentBuildingNumber() != null && !StringUtils.isBlank((String)this.doc.getCurrentBuildingNumber()) && !StringUtils.equals((String)this.doc.getCurrentBuildingNumber(), (String)detail.getBuildingCode())) {
                    satisfies = false;
                }
                if (this.doc.getCurrentRoom() != null && !StringUtils.isBlank((String)this.doc.getCurrentRoom()) && !StringUtils.equals((String)this.doc.getCurrentRoom(), (String)detail.getBuildingRoomNumber())) {
                    satisfies = false;
                }
                if (this.doc.getCurrentSubroom() != null && !StringUtils.isBlank((String)this.doc.getCurrentSubroom()) && !StringUtils.equals((String)this.doc.getCurrentSubroom(), (String)detail.getBuildingSubRoomNumber())) {
                    satisfies = false;
                }
                if (this.doc.getCurrentConditionCode() != null && !StringUtils.isBlank((String)this.doc.getCurrentConditionCode()) && !StringUtils.equals((String)this.doc.getCurrentConditionCode(), (String)detail.getAssetConditionCode())) {
                    satisfies = false;
                }
            } else {
                satisfies = false;
            }
        }
        return satisfies;
    }

    public void execute(Object object) {
        if (this.evaluate(object)) {
            BarcodeInventoryErrorDetail detail = (BarcodeInventoryErrorDetail)((Object)object);
            if (this.doc.getNewCampusCode() != null && !StringUtils.isBlank((String)this.doc.getNewCampusCode())) {
                detail.setCampusCode(this.doc.getNewCampusCode());
            }
            if (this.doc.getNewBuildingNumber() != null && !StringUtils.isBlank((String)this.doc.getNewBuildingNumber())) {
                detail.setBuildingCode(this.doc.getNewBuildingNumber());
            }
            if (this.doc.getNewRoom() != null && !StringUtils.isBlank((String)this.doc.getNewRoom())) {
                detail.setBuildingRoomNumber(this.doc.getNewRoom());
            }
            if (this.doc.getNewSubroom() != null && !StringUtils.isBlank((String)this.doc.getNewSubroom())) {
                detail.setBuildingSubRoomNumber(this.doc.getNewSubroom());
            }
            if (this.doc.getNewConditionCode() != null && !StringUtils.isBlank((String)this.doc.getNewConditionCode())) {
                detail.setAssetConditionCode(this.doc.getNewConditionCode());
            }
        }
    }
}

