/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocationType;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.location.framework.country.CountryEbo;
import org.kuali.rice.location.framework.postalcode.PostalCodeEbo;
import org.kuali.rice.location.framework.state.StateEbo;

public class AssetLocation
extends PersistableBusinessObjectBase {
    protected Long capitalAssetNumber;
    protected String assetLocationTypeCode;
    protected String assetLocationContactName;
    protected String assetLocationContactIdentifier;
    protected String assetLocationInstitutionName;
    protected String assetLocationPhoneNumber;
    protected String assetLocationStreetAddress;
    protected String assetLocationCityName;
    protected String assetLocationStateCode;
    protected String assetLocationCountryCode;
    protected String assetLocationZipCode;
    protected Asset asset;
    protected AssetLocationType assetLocationType;
    protected StateEbo assetLocationState;
    protected CountryEbo assetLocationCountry;
    protected PostalCodeEbo postalZipCode;

    public AssetLocation() {
    }

    public AssetLocation(Long assetNumber) {
        this.capitalAssetNumber = assetNumber;
    }

    public AssetLocation(AssetLocation copiedLocation) {
        this.capitalAssetNumber = copiedLocation.getCapitalAssetNumber();
        this.assetLocationTypeCode = copiedLocation.getAssetLocationTypeCode();
        this.assetLocationContactName = copiedLocation.getAssetLocationContactName();
        this.assetLocationContactIdentifier = copiedLocation.getAssetLocationContactIdentifier();
        this.assetLocationInstitutionName = copiedLocation.getAssetLocationInstitutionName();
        this.assetLocationPhoneNumber = copiedLocation.getAssetLocationPhoneNumber();
        this.assetLocationStreetAddress = copiedLocation.getAssetLocationStreetAddress();
        this.assetLocationCityName = copiedLocation.getAssetLocationCityName();
        this.assetLocationStateCode = copiedLocation.getAssetLocationStateCode();
        this.assetLocationCountryCode = copiedLocation.getAssetLocationCountryCode();
        this.assetLocationZipCode = copiedLocation.getAssetLocationZipCode();
    }

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public String getAssetLocationTypeCode() {
        return this.assetLocationTypeCode;
    }

    public void setAssetLocationTypeCode(String assetLocationTypeCode) {
        this.assetLocationTypeCode = assetLocationTypeCode;
    }

    public String getAssetLocationContactName() {
        return this.assetLocationContactName;
    }

    public void setAssetLocationContactName(String assetLocationContactName) {
        this.assetLocationContactName = assetLocationContactName;
    }

    public String getAssetLocationContactIdentifier() {
        return this.assetLocationContactIdentifier;
    }

    public void setAssetLocationContactIdentifier(String assetLocationContactIdentifier) {
        this.assetLocationContactIdentifier = assetLocationContactIdentifier;
    }

    public String getAssetLocationInstitutionName() {
        return this.assetLocationInstitutionName;
    }

    public void setAssetLocationInstitutionName(String assetLocationInstitutionName) {
        this.assetLocationInstitutionName = assetLocationInstitutionName;
    }

    public String getAssetLocationPhoneNumber() {
        return this.assetLocationPhoneNumber;
    }

    public void setAssetLocationPhoneNumber(String assetLocationPhoneNumber) {
        this.assetLocationPhoneNumber = assetLocationPhoneNumber;
    }

    public String getAssetLocationStreetAddress() {
        return this.assetLocationStreetAddress;
    }

    public void setAssetLocationStreetAddress(String assetLocationStreetAddress) {
        this.assetLocationStreetAddress = assetLocationStreetAddress;
    }

    public String getAssetLocationCityName() {
        return this.assetLocationCityName;
    }

    public void setAssetLocationCityName(String assetLocationCityName) {
        this.assetLocationCityName = assetLocationCityName;
    }

    public String getAssetLocationStateCode() {
        return this.assetLocationStateCode;
    }

    public void setAssetLocationStateCode(String assetLocationStateCode) {
        this.assetLocationStateCode = assetLocationStateCode;
    }

    public String getAssetLocationCountryCode() {
        return this.assetLocationCountryCode;
    }

    public void setAssetLocationCountryCode(String assetLocationCountryCode) {
        this.assetLocationCountryCode = assetLocationCountryCode;
    }

    public String getAssetLocationZipCode() {
        return this.assetLocationZipCode;
    }

    public void setAssetLocationZipCode(String assetLocationZipCode) {
        this.assetLocationZipCode = assetLocationZipCode;
    }

    public PostalCodeEbo getPostalZipCode() {
        if (StringUtils.isBlank((CharSequence)this.assetLocationZipCode) || StringUtils.isBlank((CharSequence)"US")) {
            this.postalZipCode = null;
        } else if (this.postalZipCode == null || !StringUtils.equals((CharSequence)this.postalZipCode.getCode(), (CharSequence)this.assetLocationZipCode) || !StringUtils.equals((CharSequence)this.postalZipCode.getCountryCode(), (CharSequence)"US")) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(PostalCodeEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", "US");
                keys.put("code", this.assetLocationZipCode);
                this.postalZipCode = (PostalCodeEbo)moduleService.getExternalizableBusinessObject(PostalCodeEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.postalZipCode;
    }

    public void setPostalZipCode(PostalCodeEbo postalZipCode) {
        this.postalZipCode = postalZipCode;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public AssetLocationType getAssetLocationType() {
        return this.assetLocationType;
    }

    public void setAssetLocationType(AssetLocationType assetLocationType) {
        this.assetLocationType = assetLocationType;
    }

    public CountryEbo getAssetLocationCountry() {
        if (StringUtils.isBlank((CharSequence)this.assetLocationCountryCode)) {
            this.assetLocationCountry = null;
        } else if (this.assetLocationCountry == null || !StringUtils.equals((CharSequence)this.assetLocationCountry.getCode(), (CharSequence)this.assetLocationCountryCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(CountryEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(1);
                keys.put("code", this.assetLocationCountryCode);
                this.assetLocationCountry = (CountryEbo)moduleService.getExternalizableBusinessObject(CountryEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.assetLocationCountry;
    }

    public void setAssetLocationCountry(CountryEbo assetLocationCountry) {
        this.assetLocationCountry = assetLocationCountry;
    }

    public StateEbo getAssetLocationState() {
        if (StringUtils.isBlank((CharSequence)this.assetLocationStateCode) || StringUtils.isBlank((CharSequence)"US")) {
            this.assetLocationState = null;
        } else if (this.assetLocationState == null || !StringUtils.equals((CharSequence)this.assetLocationState.getCode(), (CharSequence)this.assetLocationStateCode) || !StringUtils.equals((CharSequence)this.assetLocationState.getCountryCode(), (CharSequence)"US")) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(StateEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", "US");
                keys.put("code", this.assetLocationStateCode);
                this.assetLocationState = (StateEbo)moduleService.getExternalizableBusinessObject(StateEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.assetLocationState;
    }

    public void setAssetLocationState(StateEbo assetLocationState) {
        this.assetLocationState = assetLocationState;
    }
}

