/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.sql.Date;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;

public class AssetPayment
extends PersistableBusinessObjectBase {
    private Long capitalAssetNumber;
    private Integer paymentSequenceNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String financialSystemOriginationCode;
    private String financialDocumentTypeCode;
    private String documentNumber;
    private Integer financialDocumentPostingYear;
    private String financialDocumentPostingPeriodCode;
    private Date financialDocumentPostingDate;
    private String projectCode;
    private String organizationReferenceId;
    private KualiDecimal accountChargeAmount;
    private String purchaseOrderNumber;
    private String requisitionNumber;
    private KualiDecimal primaryDepreciationBaseAmount;
    private KualiDecimal accumulatedPrimaryDepreciationAmount;
    private KualiDecimal previousYearPrimaryDepreciationAmount;
    private KualiDecimal period1Depreciation1Amount;
    private KualiDecimal period2Depreciation1Amount;
    private KualiDecimal period3Depreciation1Amount;
    private KualiDecimal period4Depreciation1Amount;
    private KualiDecimal period5Depreciation1Amount;
    private KualiDecimal period6Depreciation1Amount;
    private KualiDecimal period7Depreciation1Amount;
    private KualiDecimal period8Depreciation1Amount;
    private KualiDecimal period9Depreciation1Amount;
    private KualiDecimal period10Depreciation1Amount;
    private KualiDecimal period11Depreciation1Amount;
    private KualiDecimal period12Depreciation1Amount;
    private Integer accumulatedRoundingErrorInMillicents = 0;
    private String transferPaymentCode;
    private Asset asset;
    private Chart chartOfAccounts;
    private SubAccount subAccount;
    private ObjectCode financialObject;
    private ObjectCodeCurrent objectCodeCurrent;
    private Account account;
    private SubObjectCode financialSubObject;
    private ProjectCode project;
    private AccountingPeriod financialDocumentPostingPeriod;
    private DocumentTypeEBO financialSystemDocumentTypeCode;
    private DocumentHeader documentHeader;
    private OriginationCode financialSystemOrigination;
    private SystemOptions option;
    private KualiDecimal yearToDate;

    public AssetPayment() {
    }

    public AssetPayment(AssetPayment assetPayment, boolean withAmounts) {
        this.setCapitalAssetNumber(assetPayment.getCapitalAssetNumber());
        this.setPaymentSequenceNumber(assetPayment.getPaymentSequenceNumber());
        this.setChartOfAccountsCode(assetPayment.getChartOfAccountsCode());
        this.setAccountNumber(assetPayment.getAccountNumber());
        this.setSubAccountNumber(assetPayment.getSubAccountNumber());
        this.setFinancialObjectCode(assetPayment.getFinancialObjectCode());
        this.setFinancialSubObjectCode(assetPayment.getFinancialSubObjectCode());
        this.setFinancialSystemOriginationCode(assetPayment.getFinancialSystemOriginationCode());
        this.setFinancialDocumentTypeCode(assetPayment.getFinancialDocumentTypeCode());
        this.setDocumentNumber(assetPayment.getDocumentNumber());
        this.setFinancialDocumentPostingYear(assetPayment.getFinancialDocumentPostingYear());
        this.setFinancialDocumentPostingPeriodCode(assetPayment.getFinancialDocumentPostingPeriodCode());
        this.setFinancialDocumentPostingDate(assetPayment.getFinancialDocumentPostingDate());
        this.setProjectCode(assetPayment.getProjectCode());
        this.setOrganizationReferenceId(assetPayment.getOrganizationReferenceId());
        this.setPurchaseOrderNumber(assetPayment.getPurchaseOrderNumber());
        this.setRequisitionNumber(assetPayment.getRequisitionNumber());
        this.setTransferPaymentCode(assetPayment.getTransferPaymentCode());
        if (withAmounts) {
            this.setAccountChargeAmount(assetPayment.getAccountChargeAmount());
            this.setPrimaryDepreciationBaseAmount(assetPayment.getPrimaryDepreciationBaseAmount());
            this.setAccumulatedPrimaryDepreciationAmount(assetPayment.getAccumulatedPrimaryDepreciationAmount());
            this.setPreviousYearPrimaryDepreciationAmount(assetPayment.getPreviousYearPrimaryDepreciationAmount());
            this.setPeriod1Depreciation1Amount(assetPayment.getPeriod1Depreciation1Amount());
            this.setPeriod2Depreciation1Amount(assetPayment.getPeriod2Depreciation1Amount());
            this.setPeriod3Depreciation1Amount(assetPayment.getPeriod3Depreciation1Amount());
            this.setPeriod4Depreciation1Amount(assetPayment.getPeriod4Depreciation1Amount());
            this.setPeriod5Depreciation1Amount(assetPayment.getPeriod5Depreciation1Amount());
            this.setPeriod6Depreciation1Amount(assetPayment.getPeriod6Depreciation1Amount());
            this.setPeriod7Depreciation1Amount(assetPayment.getPeriod7Depreciation1Amount());
            this.setPeriod8Depreciation1Amount(assetPayment.getPeriod8Depreciation1Amount());
            this.setPeriod9Depreciation1Amount(assetPayment.getPeriod9Depreciation1Amount());
            this.setPeriod10Depreciation1Amount(assetPayment.getPeriod10Depreciation1Amount());
            this.setPeriod11Depreciation1Amount(assetPayment.getPeriod11Depreciation1Amount());
            this.setPeriod12Depreciation1Amount(assetPayment.getPeriod12Depreciation1Amount());
        }
    }

    public AssetPayment(AssetPaymentDetail assetPaymentDetail) {
        this.setChartOfAccountsCode(assetPaymentDetail.getChartOfAccountsCode());
        this.setAccountNumber(assetPaymentDetail.getAccountNumber());
        this.setSubAccountNumber(assetPaymentDetail.getSubAccountNumber());
        this.setFinancialObjectCode(assetPaymentDetail.getFinancialObjectCode());
        this.setFinancialSubObjectCode(assetPaymentDetail.getFinancialSubObjectCode());
        this.setFinancialSystemOriginationCode(assetPaymentDetail.getExpenditureFinancialSystemOriginationCode());
        this.setFinancialDocumentTypeCode(assetPaymentDetail.getExpenditureFinancialDocumentTypeCode());
        this.setDocumentNumber(assetPaymentDetail.getExpenditureFinancialDocumentNumber());
        this.setFinancialDocumentPostingYear(assetPaymentDetail.getPostingYear());
        this.setFinancialDocumentPostingPeriodCode(assetPaymentDetail.getPostingPeriodCode());
        this.setFinancialDocumentPostingDate(assetPaymentDetail.getExpenditureFinancialDocumentPostedDate());
        this.setProjectCode(assetPaymentDetail.getProjectCode());
        this.setOrganizationReferenceId(assetPaymentDetail.getOrganizationReferenceId());
        this.setPurchaseOrderNumber(assetPaymentDetail.getPurchaseOrderNumber());
        this.setRequisitionNumber(assetPaymentDetail.getRequisitionNumber());
    }

    public AssetPayment(AssetPaymentDetail assetPaymentDetail, String acquisitionTypeCode) {
        this(assetPaymentDetail);
        AssetGlobalService assetGlobalService = (AssetGlobalService)SpringContext.getBean(AssetGlobalService.class);
        if (assetGlobalService.getNewAcquisitionTypeCode().equals(acquisitionTypeCode)) {
            this.setFinancialDocumentPostingDate(assetPaymentDetail.getExpenditureFinancialDocumentPostedDate());
            this.setFinancialDocumentPostingYear(assetPaymentDetail.getPostingYear());
            this.setFinancialDocumentPostingPeriodCode(assetPaymentDetail.getPostingPeriodCode());
        } else {
            UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
            this.setFinancialDocumentPostingDate(universityDateService.getCurrentUniversityDate().getUniversityDate());
            this.setFinancialDocumentPostingYear(universityDateService.getCurrentUniversityDate().getUniversityFiscalYear());
            this.setFinancialDocumentPostingPeriodCode(universityDateService.getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
        }
    }

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public Integer getPaymentSequenceNumber() {
        return this.paymentSequenceNumber;
    }

    public void setPaymentSequenceNumber(Integer paymentSequenceNumber) {
        this.paymentSequenceNumber = paymentSequenceNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return this.financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getFinancialSystemOriginationCode() {
        return this.financialSystemOriginationCode;
    }

    public void setFinancialSystemOriginationCode(String financialSystemOriginationCode) {
        this.financialSystemOriginationCode = financialSystemOriginationCode;
    }

    public String getFinancialDocumentTypeCode() {
        return this.financialDocumentTypeCode;
    }

    public void setFinancialDocumentTypeCode(String financialDocumentTypeCode) {
        this.financialDocumentTypeCode = financialDocumentTypeCode;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getFinancialDocumentPostingYear() {
        return this.financialDocumentPostingYear;
    }

    public void setFinancialDocumentPostingYear(Integer financialDocumentPostingYear) {
        this.financialDocumentPostingYear = financialDocumentPostingYear;
    }

    public String getFinancialDocumentPostingPeriodCode() {
        return this.financialDocumentPostingPeriodCode;
    }

    public void setFinancialDocumentPostingPeriodCode(String financialDocumentPostingPeriodCode) {
        this.financialDocumentPostingPeriodCode = financialDocumentPostingPeriodCode;
    }

    public Date getFinancialDocumentPostingDate() {
        return this.financialDocumentPostingDate;
    }

    public void setFinancialDocumentPostingDate(Date financialDocumentPostingDate) {
        this.financialDocumentPostingDate = financialDocumentPostingDate;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrganizationReferenceId() {
        return this.organizationReferenceId;
    }

    public void setOrganizationReferenceId(String organizationReferenceId) {
        this.organizationReferenceId = organizationReferenceId;
    }

    public KualiDecimal getAccountChargeAmount() {
        return this.accountChargeAmount;
    }

    public void setAccountChargeAmount(KualiDecimal accountChargeAmount) {
        this.accountChargeAmount = accountChargeAmount;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public String getRequisitionNumber() {
        return this.requisitionNumber;
    }

    public void setRequisitionNumber(String requisitionNumber) {
        this.requisitionNumber = requisitionNumber;
    }

    public KualiDecimal getPrimaryDepreciationBaseAmount() {
        return this.primaryDepreciationBaseAmount;
    }

    public void setPrimaryDepreciationBaseAmount(KualiDecimal primaryDepreciationBaseAmount) {
        this.primaryDepreciationBaseAmount = primaryDepreciationBaseAmount;
    }

    public KualiDecimal getAccumulatedPrimaryDepreciationAmount() {
        return this.accumulatedPrimaryDepreciationAmount;
    }

    public void setAccumulatedPrimaryDepreciationAmount(KualiDecimal accumulatedPrimaryDepreciationAmount) {
        this.accumulatedPrimaryDepreciationAmount = accumulatedPrimaryDepreciationAmount;
    }

    public KualiDecimal getPreviousYearPrimaryDepreciationAmount() {
        return this.previousYearPrimaryDepreciationAmount;
    }

    public void setPreviousYearPrimaryDepreciationAmount(KualiDecimal previousYearPrimaryDepreciationAmount) {
        this.previousYearPrimaryDepreciationAmount = previousYearPrimaryDepreciationAmount;
    }

    public KualiDecimal getPeriod1Depreciation1Amount() {
        return this.period1Depreciation1Amount;
    }

    public void setPeriod1Depreciation1Amount(KualiDecimal period1Depreciation1Amount) {
        this.period1Depreciation1Amount = period1Depreciation1Amount;
    }

    public KualiDecimal getPeriod2Depreciation1Amount() {
        return this.period2Depreciation1Amount;
    }

    public void setPeriod2Depreciation1Amount(KualiDecimal period2Depreciation1Amount) {
        this.period2Depreciation1Amount = period2Depreciation1Amount;
    }

    public KualiDecimal getPeriod3Depreciation1Amount() {
        return this.period3Depreciation1Amount;
    }

    public void setPeriod3Depreciation1Amount(KualiDecimal period3Depreciation1Amount) {
        this.period3Depreciation1Amount = period3Depreciation1Amount;
    }

    public KualiDecimal getPeriod4Depreciation1Amount() {
        return this.period4Depreciation1Amount;
    }

    public void setPeriod4Depreciation1Amount(KualiDecimal period4Depreciation1Amount) {
        this.period4Depreciation1Amount = period4Depreciation1Amount;
    }

    public KualiDecimal getPeriod5Depreciation1Amount() {
        return this.period5Depreciation1Amount;
    }

    public void setPeriod5Depreciation1Amount(KualiDecimal period5Depreciation1Amount) {
        this.period5Depreciation1Amount = period5Depreciation1Amount;
    }

    public KualiDecimal getPeriod6Depreciation1Amount() {
        return this.period6Depreciation1Amount;
    }

    public void setPeriod6Depreciation1Amount(KualiDecimal period6Depreciation1Amount) {
        this.period6Depreciation1Amount = period6Depreciation1Amount;
    }

    public KualiDecimal getPeriod7Depreciation1Amount() {
        return this.period7Depreciation1Amount;
    }

    public void setPeriod7Depreciation1Amount(KualiDecimal period7Depreciation1Amount) {
        this.period7Depreciation1Amount = period7Depreciation1Amount;
    }

    public KualiDecimal getPeriod8Depreciation1Amount() {
        return this.period8Depreciation1Amount;
    }

    public void setPeriod8Depreciation1Amount(KualiDecimal period8Depreciation1Amount) {
        this.period8Depreciation1Amount = period8Depreciation1Amount;
    }

    public KualiDecimal getPeriod9Depreciation1Amount() {
        return this.period9Depreciation1Amount;
    }

    public void setPeriod9Depreciation1Amount(KualiDecimal period9Depreciation1Amount) {
        this.period9Depreciation1Amount = period9Depreciation1Amount;
    }

    public KualiDecimal getPeriod10Depreciation1Amount() {
        return this.period10Depreciation1Amount;
    }

    public void setPeriod10Depreciation1Amount(KualiDecimal period10Depreciation1Amount) {
        this.period10Depreciation1Amount = period10Depreciation1Amount;
    }

    public KualiDecimal getPeriod11Depreciation1Amount() {
        return this.period11Depreciation1Amount;
    }

    public void setPeriod11Depreciation1Amount(KualiDecimal period11Depreciation1Amount) {
        this.period11Depreciation1Amount = period11Depreciation1Amount;
    }

    public KualiDecimal getPeriod12Depreciation1Amount() {
        return this.period12Depreciation1Amount;
    }

    public void setPeriod12Depreciation1Amount(KualiDecimal period12Depreciation1Amount) {
        this.period12Depreciation1Amount = period12Depreciation1Amount;
    }

    public Integer getAccumulatedRoundingErrorInMillicents() {
        return this.accumulatedRoundingErrorInMillicents;
    }

    public void setAccumulatedRoundingErrorInMillicents(Integer accumulatedRoundingErrorInMillicents) {
        this.accumulatedRoundingErrorInMillicents = accumulatedRoundingErrorInMillicents;
    }

    public String getTransferPaymentCode() {
        return this.transferPaymentCode;
    }

    public void setTransferPaymentCode(String transferPaymentCode) {
        this.transferPaymentCode = transferPaymentCode;
    }

    public Asset getAsset() {
        return this.asset;
    }

    @Deprecated
    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    @Deprecated
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    @Deprecated
    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public ObjectCode getFinancialObject() {
        return this.financialObject;
    }

    @Deprecated
    public void setFinancialObject(ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public Account getAccount() {
        return this.account;
    }

    @Deprecated
    public void setAccount(Account account) {
        this.account = account;
    }

    public SubObjectCode getFinancialSubObject() {
        return this.financialSubObject;
    }

    @Deprecated
    public void setFinancialSubObject(SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    public ProjectCode getProject() {
        return this.project;
    }

    @Deprecated
    public void setProject(ProjectCode project) {
        this.project = project;
    }

    public DocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    @Deprecated
    public void setDocumentHeader(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    public DocumentTypeEBO getFinancialSystemDocumentTypeCode() {
        if (this.financialSystemDocumentTypeCode == null || !StringUtils.equals((CharSequence)this.financialSystemDocumentTypeCode.getName(), (CharSequence)this.financialDocumentTypeCode)) {
            DocumentType docType;
            this.financialSystemDocumentTypeCode = null;
            if (StringUtils.isNotBlank((CharSequence)this.financialDocumentTypeCode) && (docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this.financialDocumentTypeCode)) != null) {
                this.financialSystemDocumentTypeCode = org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)docType);
            }
        }
        return this.financialSystemDocumentTypeCode;
    }

    public AccountingPeriod getFinancialDocumentPostingPeriod() {
        return this.financialDocumentPostingPeriod;
    }

    @Deprecated
    public void setFinancialDocumentPostingPeriod(AccountingPeriod financialDocumentPostingPeriod) {
        this.financialDocumentPostingPeriod = financialDocumentPostingPeriod;
    }

    public OriginationCode getFinancialSystemOrigination() {
        return this.financialSystemOrigination;
    }

    @Deprecated
    public void setFinancialSystemOrigination(OriginationCode financialSystemOrigination) {
        this.financialSystemOrigination = financialSystemOrigination;
    }

    public SystemOptions getOption() {
        return this.option;
    }

    @Deprecated
    public void setOption(SystemOptions option) {
        this.option = option;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("capitalAssetNumber", this.capitalAssetNumber.toString());
        m.put("paymentSequenceNumber", this.paymentSequenceNumber.toString());
        m.put("objectId", this.getObjectId());
        m.put("versionNumber", this.getVersionNumber() == null ? "" : this.getVersionNumber().toString());
        m.put("chartOfAccountsCode", this.getChartOfAccountsCode());
        m.put("accountNumber", this.getAccountNumber());
        m.put("subAccountNumber", this.getSubAccountNumber());
        m.put("financialObjectCode", this.getFinancialObjectCode());
        m.put("financialSubObjectCode", this.getFinancialSubObjectCode());
        m.put("financialSystemOriginationCode", this.getFinancialSystemOriginationCode());
        m.put("financialDocumentTypeCode", this.getFinancialDocumentTypeCode());
        m.put("documentNumber", this.getDocumentNumber());
        m.put("FinancialDocumentPostingYear", this.getFinancialDocumentPostingYear().toString());
        m.put("FinancialDocumentPostingPeriodCode", this.getFinancialDocumentPostingPeriodCode());
        m.put("financialDocumentPostingDate", this.getFinancialDocumentPostingDate() != null ? this.getFinancialDocumentPostingDate().toString() : "");
        m.put("projectCode", this.getProjectCode());
        m.put("organizationReferenceId", this.getOrganizationReferenceId());
        m.put("accountChargeAmount", this.getAccountChargeAmount() == null ? "NULL" : this.getAccountChargeAmount().toString());
        m.put("purchaseOrderNumber", this.getPurchaseOrderNumber());
        m.put("requisitionNumber", this.getRequisitionNumber());
        m.put("primaryDepreciationBaseAmount", this.getPrimaryDepreciationBaseAmount() != null ? this.getPrimaryDepreciationBaseAmount().toString() : "0.00");
        m.put("accumulatedPrimaryDepreciationAmount", this.getAccumulatedPrimaryDepreciationAmount() != null ? this.getAccumulatedPrimaryDepreciationAmount().toString() : "0.00");
        m.put("previousYearPrimaryDepreciationAmount", this.getPreviousYearPrimaryDepreciationAmount() != null ? this.getPreviousYearPrimaryDepreciationAmount().toString() : "0.00");
        m.put("period1Depreciation1Amount", this.getPeriod1Depreciation1Amount() != null ? this.getPeriod1Depreciation1Amount().toString() : "NULL");
        m.put("period2Depreciation1Amount", this.getPeriod2Depreciation1Amount() != null ? this.getPeriod2Depreciation1Amount().toString() : "NULL");
        m.put("period3Depreciation1Amount", this.getPeriod3Depreciation1Amount() != null ? this.getPeriod3Depreciation1Amount().toString() : "NULL");
        m.put("period4Depreciation1Amount", this.getPeriod4Depreciation1Amount() != null ? this.getPeriod4Depreciation1Amount().toString() : "NULL");
        m.put("period5Depreciation1Amount", this.getPeriod5Depreciation1Amount() != null ? this.getPeriod5Depreciation1Amount().toString() : "NULL");
        m.put("period6Depreciation1Amount", this.getPeriod6Depreciation1Amount() != null ? this.getPeriod6Depreciation1Amount().toString() : "NULL");
        m.put("period7Depreciation1Amount", this.getPeriod7Depreciation1Amount() != null ? this.getPeriod7Depreciation1Amount().toString() : "NULL");
        m.put("period8Depreciation1Amount", this.getPeriod8Depreciation1Amount() != null ? this.getPeriod8Depreciation1Amount().toString() : "NULL");
        m.put("period9Depreciation1Amount", this.getPeriod9Depreciation1Amount() != null ? this.getPeriod9Depreciation1Amount().toString() : "NULL");
        m.put("period10Depreciation1Amount", this.getPeriod10Depreciation1Amount() != null ? this.getPeriod10Depreciation1Amount().toString() : "NULL");
        m.put("period11Depreciation1Amount", this.getPeriod11Depreciation1Amount() != null ? this.getPeriod11Depreciation1Amount().toString() : "NULL");
        m.put("period12Depreciation1Amount", this.getPeriod12Depreciation1Amount() != null ? this.getPeriod12Depreciation1Amount().toString() : "NULL");
        m.put("transferPaymentCode", this.getTransferPaymentCode());
        return m;
    }

    public KualiDecimal getYearToDate() {
        KualiDecimal yearToDate = KualiDecimal.ZERO;
        yearToDate = this.addAmount(yearToDate, this.getPeriod1Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod2Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod3Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod4Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod5Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod6Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod7Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod8Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod9Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod10Depreciation1Amount());
        yearToDate = this.addAmount(yearToDate, this.getPeriod11Depreciation1Amount());
        this.yearToDate = yearToDate = this.addAmount(yearToDate, this.getPeriod12Depreciation1Amount());
        return yearToDate;
    }

    protected KualiDecimal addAmount(KualiDecimal amount, KualiDecimal addend) {
        if (addend != null) {
            return (KualiDecimal)amount.add((AbstractKualiDecimal)addend);
        }
        return amount;
    }

    public void setYearToDate(KualiDecimal yearToDate) {
        this.yearToDate = yearToDate;
    }

    public int getLastDepreciationPeriod() {
        if (this.nonZero(this.getPeriod12Depreciation1Amount())) {
            return 12;
        }
        if (this.nonZero(this.getPeriod11Depreciation1Amount())) {
            return 11;
        }
        if (this.nonZero(this.getPeriod10Depreciation1Amount())) {
            return 10;
        }
        if (this.nonZero(this.getPeriod9Depreciation1Amount())) {
            return 9;
        }
        if (this.nonZero(this.getPeriod8Depreciation1Amount())) {
            return 8;
        }
        if (this.nonZero(this.getPeriod7Depreciation1Amount())) {
            return 7;
        }
        if (this.nonZero(this.getPeriod6Depreciation1Amount())) {
            return 6;
        }
        if (this.nonZero(this.getPeriod5Depreciation1Amount())) {
            return 5;
        }
        if (this.nonZero(this.getPeriod4Depreciation1Amount())) {
            return 4;
        }
        if (this.nonZero(this.getPeriod3Depreciation1Amount())) {
            return 3;
        }
        if (this.nonZero(this.getPeriod2Depreciation1Amount())) {
            return 2;
        }
        if (this.nonZero(this.getPeriod1Depreciation1Amount())) {
            return 1;
        }
        return 0;
    }

    private boolean nonZero(KualiDecimal testAmount) {
        return testAmount != null && !KualiDecimal.ZERO.equals((Object)testAmount);
    }

    public ObjectCodeCurrent getObjectCodeCurrent() {
        return this.objectCodeCurrent;
    }

    public void setObjectCodeCurrent(ObjectCodeCurrent objectCodeCurrent) {
        this.objectCodeCurrent = objectCodeCurrent;
    }
}

