/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntryAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;

public class GeneralLedgerEntry
extends PersistableBusinessObjectBase {
    private Long generalLedgerAccountIdentifier;
    private Integer universityFiscalYear;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String financialBalanceTypeCode;
    private String financialObjectTypeCode;
    private String universityFiscalPeriodCode;
    private String financialDocumentTypeCode;
    private String financialSystemOriginationCode;
    private String documentNumber;
    private Integer transactionLedgerEntrySequenceNumber;
    private String transactionLedgerEntryDescription;
    private KualiDecimal transactionLedgerEntryAmount;
    private KualiDecimal transactionLedgerSubmitAmount;
    private String organizationReferenceId;
    private String referenceFinancialSystemOriginationCode;
    private String referenceFinancialDocumentNumber;
    private String transactionDebitCreditCode;
    private String organizationDocumentNumber;
    private String projectCode;
    private Date transactionPostingDate;
    private Date transactionDate;
    private Timestamp transactionDateTimeStamp;
    private String activityStatusCode;
    private Account account;
    private Chart chart;
    private ObjectCode financialObject;
    private SubAccount subAccount;
    private SubObjectCode financialSubObject;
    private ObjectType objectType;
    private DocumentTypeEBO financialSystemDocumentTypeCode;
    private List<GeneralLedgerEntryAsset> generalLedgerEntryAssets = new ArrayList<GeneralLedgerEntryAsset>();
    private List<PurchasingAccountsPayableLineAssetAccount> purApLineAssetAccounts;
    private boolean selected;
    private KualiDecimal amount;
    private boolean active;

    public GeneralLedgerEntry() {
        this.purApLineAssetAccounts = new ArrayList<PurchasingAccountsPayableLineAssetAccount>();
    }

    public GeneralLedgerEntry(Entry entry) {
        this.setUniversityFiscalYear(entry.getUniversityFiscalYear());
        this.setChartOfAccountsCode(entry.getChartOfAccountsCode());
        this.setAccountNumber(entry.getAccountNumber());
        this.setSubAccountNumber(entry.getSubAccountNumber());
        this.setFinancialObjectCode(entry.getFinancialObjectCode());
        this.setFinancialSubObjectCode(entry.getFinancialSubObjectCode());
        this.setFinancialBalanceTypeCode(entry.getFinancialBalanceTypeCode());
        this.setFinancialObjectTypeCode(entry.getFinancialObjectTypeCode());
        this.setUniversityFiscalPeriodCode(entry.getUniversityFiscalPeriodCode());
        this.setFinancialDocumentTypeCode(entry.getFinancialDocumentTypeCode());
        this.setFinancialSystemOriginationCode(entry.getFinancialSystemOriginationCode());
        this.setDocumentNumber(entry.getDocumentNumber());
        this.setTransactionLedgerEntrySequenceNumber(entry.getTransactionLedgerEntrySequenceNumber());
        this.setTransactionLedgerEntryDescription(entry.getTransactionLedgerEntryDescription());
        this.setTransactionLedgerEntryAmount(entry.getTransactionLedgerEntryAmount());
        this.setOrganizationReferenceId(entry.getOrganizationReferenceId());
        this.setReferenceFinancialSystemOriginationCode(entry.getReferenceFinancialSystemOriginationCode());
        this.setReferenceFinancialDocumentNumber(entry.getReferenceFinancialDocumentNumber());
        this.setTransactionDebitCreditCode(entry.getTransactionDebitCreditCode());
        this.setOrganizationDocumentNumber(entry.getOrganizationDocumentNumber());
        this.setProjectCode(entry.getProjectCode());
        this.setTransactionDate(entry.getTransactionDate());
        this.setTransactionPostingDate(entry.getTransactionPostingDate());
        this.setTransactionDateTimeStamp(entry.getTransactionDateTimeStamp());
        this.setActivityStatusCode("N");
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (this.generalLedgerAccountIdentifier != null) {
            m.put("generalLedgerAccountIdentifier", this.generalLedgerAccountIdentifier.toString());
        }
        m.put("universityFiscalYear", this.universityFiscalYear.toString());
        m.put("chartOfAccountsCode", this.chartOfAccountsCode);
        m.put("accountNumber", this.accountNumber);
        m.put("subAccountNumber", this.subAccountNumber);
        m.put("financialObjectCode", this.financialObjectCode);
        m.put("financialSubObjectCode", this.financialSubObjectCode);
        m.put("financialBalanceTypeCode", this.financialBalanceTypeCode);
        m.put("financialObjectTypeCode", this.financialObjectTypeCode);
        m.put("universityFiscalPeriodCode", this.universityFiscalPeriodCode);
        m.put("financialDocumentTypeCode", this.financialDocumentTypeCode);
        m.put("financialSystemOriginationCode", this.financialSystemOriginationCode);
        m.put("documentNumber", this.documentNumber);
        m.put("transactionLedgerEntrySequenceNumber", this.transactionLedgerEntrySequenceNumber.toString());
        return m;
    }

    public Long getGeneralLedgerAccountIdentifier() {
        return this.generalLedgerAccountIdentifier;
    }

    public void setGeneralLedgerAccountIdentifier(Long glAccountId) {
        this.generalLedgerAccountIdentifier = glAccountId;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return this.financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getFinancialBalanceTypeCode() {
        return this.financialBalanceTypeCode;
    }

    public void setFinancialBalanceTypeCode(String financialBalanceTypeCode) {
        this.financialBalanceTypeCode = financialBalanceTypeCode;
    }

    public String getFinancialObjectTypeCode() {
        return this.financialObjectTypeCode;
    }

    public void setFinancialObjectTypeCode(String financialObjectTypeCode) {
        this.financialObjectTypeCode = financialObjectTypeCode;
    }

    public String getUniversityFiscalPeriodCode() {
        return this.universityFiscalPeriodCode;
    }

    public void setUniversityFiscalPeriodCode(String universityFiscalPeriodCode) {
        this.universityFiscalPeriodCode = universityFiscalPeriodCode;
    }

    public String getFinancialDocumentTypeCode() {
        return this.financialDocumentTypeCode;
    }

    public void setFinancialDocumentTypeCode(String financialDocumentTypeCode) {
        this.financialDocumentTypeCode = financialDocumentTypeCode;
    }

    public String getFinancialSystemOriginationCode() {
        return this.financialSystemOriginationCode;
    }

    public void setFinancialSystemOriginationCode(String financialSystemOriginationCode) {
        this.financialSystemOriginationCode = financialSystemOriginationCode;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getTransactionLedgerEntrySequenceNumber() {
        return this.transactionLedgerEntrySequenceNumber;
    }

    public void setTransactionLedgerEntrySequenceNumber(Integer transactionLedgerEntrySequenceNumber) {
        this.transactionLedgerEntrySequenceNumber = transactionLedgerEntrySequenceNumber;
    }

    public String getTransactionLedgerEntryDescription() {
        return this.transactionLedgerEntryDescription;
    }

    public void setTransactionLedgerEntryDescription(String transactionLedgerEntryDescription) {
        this.transactionLedgerEntryDescription = transactionLedgerEntryDescription;
    }

    public KualiDecimal getTransactionLedgerEntryAmount() {
        return this.transactionLedgerEntryAmount;
    }

    public void setTransactionLedgerEntryAmount(KualiDecimal transactionLedgerEntryAmount) {
        this.transactionLedgerEntryAmount = transactionLedgerEntryAmount;
    }

    public String getOrganizationReferenceId() {
        return this.organizationReferenceId;
    }

    public void setOrganizationReferenceId(String organizationReferenceId) {
        this.organizationReferenceId = organizationReferenceId;
    }

    public String getReferenceFinancialSystemOriginationCode() {
        return this.referenceFinancialSystemOriginationCode;
    }

    public void setReferenceFinancialSystemOriginationCode(String referenceFinancialSystemOriginationCode) {
        this.referenceFinancialSystemOriginationCode = referenceFinancialSystemOriginationCode;
    }

    public String getReferenceFinancialDocumentNumber() {
        return this.referenceFinancialDocumentNumber;
    }

    public void setReferenceFinancialDocumentNumber(String referenceFinancialDocumentNumber) {
        this.referenceFinancialDocumentNumber = referenceFinancialDocumentNumber;
    }

    public String getTransactionDebitCreditCode() {
        return this.transactionDebitCreditCode;
    }

    public void setTransactionDebitCreditCode(String transactionDebitCreditCode) {
        this.transactionDebitCreditCode = transactionDebitCreditCode;
    }

    public String getOrganizationDocumentNumber() {
        return this.organizationDocumentNumber;
    }

    public void setOrganizationDocumentNumber(String organizationDocumentNumber) {
        this.organizationDocumentNumber = organizationDocumentNumber;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Date getTransactionPostingDate() {
        return this.transactionPostingDate;
    }

    public void setTransactionPostingDate(Date transactionPostingDate) {
        this.transactionPostingDate = transactionPostingDate;
    }

    public Timestamp getTransactionDateTimeStamp() {
        return this.transactionDateTimeStamp;
    }

    public void setTransactionDateTimeStamp(Timestamp transactionDateTimeStamp) {
        this.transactionDateTimeStamp = transactionDateTimeStamp;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public ObjectCode getFinancialObject() {
        return this.financialObject;
    }

    public void setFinancialObject(ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public SubObjectCode getFinancialSubObject() {
        return this.financialSubObject;
    }

    public void setFinancialSubObject(SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public DocumentTypeEBO getFinancialSystemDocumentTypeCode() {
        if (this.financialSystemDocumentTypeCode == null || !StringUtils.equals((CharSequence)this.financialSystemDocumentTypeCode.getName(), (CharSequence)this.financialDocumentTypeCode)) {
            DocumentType docType;
            this.financialSystemDocumentTypeCode = null;
            if (StringUtils.isNotBlank((CharSequence)this.financialDocumentTypeCode) && (docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this.financialDocumentTypeCode)) != null) {
                this.financialSystemDocumentTypeCode = org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)docType);
            }
        }
        return this.financialSystemDocumentTypeCode;
    }

    public boolean isActive() {
        return "N".equalsIgnoreCase(this.getActivityStatusCode()) || "M".equalsIgnoreCase(this.getActivityStatusCode());
    }

    public String getActivityStatusCode() {
        return this.activityStatusCode;
    }

    public void setActivityStatusCode(String activityStatusCode) {
        this.activityStatusCode = activityStatusCode;
    }

    public List<GeneralLedgerEntryAsset> getGeneralLedgerEntryAssets() {
        return this.generalLedgerEntryAssets;
    }

    public void setGeneralLedgerEntryAssets(List<GeneralLedgerEntryAsset> generalLedgerEntryAssets) {
        this.generalLedgerEntryAssets = generalLedgerEntryAssets;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public List<PurchasingAccountsPayableLineAssetAccount> getPurApLineAssetAccounts() {
        return this.purApLineAssetAccounts;
    }

    public void setPurApLineAssetAccounts(List<PurchasingAccountsPayableLineAssetAccount> purApLineAssetAccounts) {
        this.purApLineAssetAccounts = purApLineAssetAccounts;
    }

    public KualiDecimal computePayment() {
        KualiDecimal absAmount = this.getTransactionLedgerEntryAmount();
        if (absAmount == null) {
            return null;
        }
        return "C".equals(this.getTransactionDebitCreditCode()) ? (KualiDecimal)absAmount.negated() : absAmount;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public KualiDecimal getAmount() {
        if (this.getTransactionLedgerEntryAmount() != null && "C".equals(this.getTransactionDebitCreditCode())) {
            this.setAmount((KualiDecimal)this.getTransactionLedgerEntryAmount().negated());
        } else {
            this.setAmount(this.getTransactionLedgerEntryAmount());
        }
        return this.amount;
    }

    public void setAmount(KualiDecimal absAmount) {
        this.amount = absAmount;
    }

    public KualiDecimal getTransactionLedgerSubmitAmount() {
        return this.transactionLedgerSubmitAmount;
    }

    public void setTransactionLedgerSubmitAmount(KualiDecimal transactionLedgerSubmitAmount) {
        this.transactionLedgerSubmitAmount = transactionLedgerSubmitAmount;
    }
}

