/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cam.CapitalAssetManagementAsset;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.document.authorization.FinancialSystemMaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentAuthorizerBase;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final Logger LOG = Logger.getLogger(AssetLookupableHelperServiceImpl.class);
    protected AssetService assetService;
    protected DocumentDictionaryService documentDictionaryService;

    public List<HtmlData> getCustomActionUrls(BusinessObject bo, List pkNames) {
        List anchorHtmlDataList = super.getCustomActionUrls(bo, pkNames);
        Asset asset = (Asset)bo;
        if (this.assetService.isAssetRetired(asset)) {
            anchorHtmlDataList.clear();
            anchorHtmlDataList.add(this.getViewAssetUrl(asset));
        } else {
            anchorHtmlDataList.add(this.getLoanUrl(asset));
            anchorHtmlDataList.add(this.getMergeUrl(asset));
            anchorHtmlDataList.add(this.getSeparateUrl(asset));
            anchorHtmlDataList.add(this.getTransferUrl(asset));
        }
        return anchorHtmlDataList;
    }

    protected HtmlData getViewAssetUrl(Asset asset) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("capitalAssetNumber", asset.getCapitalAssetNumber().toString());
        parameters.put("businessObjectClassName", CapitalAssetManagementAsset.class.getName());
        String href = UrlFactory.parameterizeUrl((String)"inquiry.do", (Properties)parameters);
        HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "start", "view");
        anchorHtmlData.setTarget("blank");
        return anchorHtmlData;
    }

    protected HtmlData getMergeUrl(Asset asset) {
        FinancialSystemMaintenanceDocumentAuthorizerBase documentAuthorizer = (FinancialSystemMaintenanceDocumentAuthorizerBase)this.getDocumentDictionaryService().getDocumentAuthorizer("ARG");
        boolean isAuthorized = documentAuthorizer.isAuthorized((BusinessObject)asset, "KFS-CAM", "Merge", this.determinePrincipalIdForCurrentUser());
        if (isAuthorized) {
            Properties parameters = new Properties();
            parameters.put("methodToCall", "newWithExisting");
            parameters.put("businessObjectClassName", AssetRetirementGlobal.class.getName());
            parameters.put("mergedTargetCapitalAssetNumber", asset.getCapitalAssetNumber().toString());
            parameters.put("overrideKeys", "retirementReasonCode,mergedTargetCapitalAssetNumber");
            parameters.put("retirementReasonCode", "M");
            parameters.put("refreshCaller", "retirementReasonCode::M");
            String href = UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)parameters);
            return new HtmlData.AnchorHtmlData(href, "merge", "merge");
        }
        return new HtmlData.AnchorHtmlData("", "", "");
    }

    protected String getReturnHref(Properties parameters, LookupForm lookupForm, List returnKeys) {
        String href = super.getReturnHref(parameters, lookupForm, returnKeys);
        href = href + "&referencesToRefresh=mergedTargetCapitalAsset";
        return href;
    }

    protected HtmlData getLoanUrl(Asset asset) {
        HtmlData.AnchorHtmlData anchorHtmlData = null;
        ArrayList<HtmlData.AnchorHtmlData> childURLDataList = new ArrayList<HtmlData.AnchorHtmlData>();
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("capitalAssetNumber", asset.getCapitalAssetNumber().toString());
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "ELR");
        if (this.getAssetService().isAssetLoaned(asset)) {
            anchorHtmlData = new HtmlData.AnchorHtmlData("", "", "");
            HtmlData.AnchorHtmlData childURLData = new HtmlData.AnchorHtmlData("", "", "loan");
            childURLDataList.add(childURLData);
            parameters.put("loanType", "renew");
            String childHref = UrlFactory.parameterizeUrl((String)"../camsEquipmentLoanOrReturn.do", (Properties)parameters);
            childURLData = new HtmlData.AnchorHtmlData(childHref, "docHandler", "renew");
            childURLDataList.add(childURLData);
            parameters.remove("loanType");
            parameters.put("loanType", "return");
            childHref = UrlFactory.parameterizeUrl((String)"../camsEquipmentLoanOrReturn.do", (Properties)parameters);
            childURLData = new HtmlData.AnchorHtmlData(childHref, "docHandler", "return");
            childURLDataList.add(childURLData);
            anchorHtmlData.setChildUrlDataList(childURLDataList);
        } else {
            anchorHtmlData = new HtmlData.AnchorHtmlData("", "", "");
            HtmlData.AnchorHtmlData childURLData = new HtmlData.AnchorHtmlData("", "", "");
            if (asset.getCampusTagNumber() == null) {
                childURLData = new HtmlData.AnchorHtmlData("", "", "loan");
                childURLDataList.add(childURLData);
            } else {
                parameters.put("loanType", "loan");
                String childHref = UrlFactory.parameterizeUrl((String)"../camsEquipmentLoanOrReturn.do", (Properties)parameters);
                childURLData = new HtmlData.AnchorHtmlData(childHref, "docHandler", "loan");
                childURLDataList.add(childURLData);
            }
            childURLData = new HtmlData.AnchorHtmlData("", "", "renew");
            childURLDataList.add(childURLData);
            childURLData = new HtmlData.AnchorHtmlData("", "", "return");
            childURLDataList.add(childURLData);
            anchorHtmlData.setChildUrlDataList(childURLDataList);
        }
        return anchorHtmlData;
    }

    protected HtmlData getSeparateUrl(Asset asset) {
        FinancialSystemMaintenanceDocumentAuthorizerBase documentAuthorizer = (FinancialSystemMaintenanceDocumentAuthorizerBase)this.getDocumentDictionaryService().getDocumentAuthorizer("AA");
        boolean isAuthorized = documentAuthorizer.isAuthorized((BusinessObject)asset, "KFS-CAM", "Separate", this.determinePrincipalIdForCurrentUser());
        if (isAuthorized) {
            String href = UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)this.getSeparateParameters(asset));
            return new HtmlData.AnchorHtmlData(href, "start", "separate");
        }
        return new HtmlData.AnchorHtmlData("", "", "");
    }

    protected Properties getSeparateParameters(Asset asset) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("businessObjectClassName", AssetGlobal.class.getName());
        parameters.put("separateSourceCapitalAssetNumber", asset.getCapitalAssetNumber().toString());
        parameters.put("financialDocumentTypeCode", "ASEP");
        return parameters;
    }

    protected HtmlData getTransferUrl(Asset asset) {
        if (this.isNonCapitalAsset(asset)) {
            return this.getTransferUrlForNonCapitalAsset(asset);
        }
        return this.getTransferUrlForCapitalAsset(asset);
    }

    private boolean isNonCapitalAsset(Asset asset) {
        Collection nonDepreciableNonCapitalAssetStatusCodes = this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES");
        return nonDepreciableNonCapitalAssetStatusCodes.contains(asset.getInventoryStatusCode());
    }

    private HtmlData getTransferUrlForNonCapitalAsset(Asset asset) {
        if (this.showTransferLinkForNonCapitalAsset(asset)) {
            return this.buildTransferUrl(asset);
        }
        return new HtmlData.AnchorHtmlData("", "", "");
    }

    private boolean showTransferLinkForNonCapitalAsset(Asset asset) {
        String financialObjectSubTypeCode = this.assetService.determineFinancialObjectSubTypeCode(asset);
        return this.showTransferLinkForNonCapitalAssetByPayment(financialObjectSubTypeCode);
    }

    private boolean showTransferLinkForNonCapitalAssetByPayment(String financialObjectSubTypeCode) {
        if (ObjectUtils.isNull((Object)financialObjectSubTypeCode)) {
            return true;
        }
        return this.parameterService.getParameterValuesAsString(Asset.class, "NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPES").contains(financialObjectSubTypeCode);
    }

    private HtmlData buildTransferUrl(Asset asset) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("capitalAssetNumber", asset.getCapitalAssetNumber().toString());
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "AT");
        String href = UrlFactory.parameterizeUrl((String)"../camsAssetTransfer.do", (Properties)parameters);
        return new HtmlData.AnchorHtmlData(href, "docHandler", "transfer");
    }

    private HtmlData getTransferUrlForCapitalAsset(Asset asset) {
        boolean isAuthorized = true;
        boolean assetMovable = false;
        try {
            assetMovable = this.getAssetService().isAssetMovableCheckByPayment(asset);
        }
        catch (ValidationException ve) {
            isAuthorized = false;
        }
        if (!assetMovable) {
            FinancialSystemTransactionalDocumentAuthorizerBase documentAuthorizer = (FinancialSystemTransactionalDocumentAuthorizerBase)this.getDocumentDictionaryService().getDocumentAuthorizer("AT");
            isAuthorized = documentAuthorizer.isAuthorized((BusinessObject)asset, "KFS-CAM", "Separate", this.determinePrincipalIdForCurrentUser());
        }
        if (isAuthorized) {
            return this.buildTransferUrl(asset);
        }
        return new HtmlData.AnchorHtmlData("", "", "");
    }

    protected String determinePrincipalIdForCurrentUser() {
        return GlobalVariables.getUserSession().getPerson().getPrincipalId();
    }

    public List<Row> getRows() {
        this.convertOrganizationOwnerAccountField();
        return super.getRows();
    }

    protected void setRows() {
        super.setRows();
        this.convertOrganizationOwnerAccountField();
    }

    protected void convertOrganizationOwnerAccountField() {
        boolean foundField = false;
        for (int i = 0; !foundField && i < super.getRows().size(); ++i) {
            Row r = (Row)super.getRows().get(i);
            for (int j = 0; !foundField && j < r.getFields().size(); ++j) {
                Field f = r.getField(j);
                if (!f.getPropertyName().equals("organizationOwnerAccount.organizationCode")) continue;
                f.setFieldConversions(this.fixProblematicField(f.getFieldConversions()));
                f.setLookupParameters(this.fixProblematicField(f.getLookupParameters()));
                foundField = true;
            }
        }
    }

    protected String fixProblematicField(String problemChildField) {
        if (StringUtils.isBlank((CharSequence)problemChildField)) {
            return problemChildField;
        }
        return problemChildField.replace("organizationOwnerAccount.chartOfAccountsCode", "organizationOwnerChartOfAccountsCode");
    }

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        String principalName = fieldValues.get("assetRepresentative.principalName");
        if (StringUtils.isNotBlank((CharSequence)principalName)) {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName);
            if (principal == null) {
                return Collections.EMPTY_LIST;
            }
            fieldValues.put("representativeUniversalIdentifier", principal.getPrincipalId());
            fieldValues.remove("assetRepresentative.principalName");
        }
        return super.getSearchResultsHelper(fieldValues, unbounded);
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}

