/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.fp.document.TransferOfFundsDocument;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.DocumentBase;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlpeSourceDetail;
import org.kuali.kfs.module.cam.document.service.AssetTransferService;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.GeneralLedgerPostingDocumentBase;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.location.framework.campus.CampusEbo;
import org.kuali.rice.location.framework.country.CountryEbo;
import org.kuali.rice.location.framework.postalcode.PostalCodeEbo;
import org.kuali.rice.location.framework.state.StateEbo;

public class AssetTransferDocument
extends GeneralLedgerPostingDocumentBase
implements GeneralLedgerPendingEntrySource {
    protected static Logger LOG = Logger.getLogger(AssetTransferDocument.class);
    protected String hiddenFieldForError;
    protected String representativeUniversalIdentifier;
    protected String campusCode;
    protected String buildingCode;
    protected String buildingRoomNumber;
    protected String buildingSubRoomNumber;
    protected String organizationTagNumber;
    protected String organizationOwnerChartOfAccountsCode;
    protected String organizationOwnerAccountNumber;
    protected String organizationText;
    protected String organizationInventoryName;
    protected String transferOfFundsFinancialDocumentNumber;
    protected String offCampusAddress;
    protected String offCampusCityName;
    protected String offCampusStateCode;
    protected String offCampusZipCode;
    protected String oldOrganizationOwnerChartOfAccountsCode;
    protected String oldOrganizationOwnerAccountNumber;
    protected String offCampusName;
    protected String offCampusCountryCode;
    protected boolean interdepartmentalSalesIndicator;
    protected Long capitalAssetNumber;
    protected Person assetRepresentative;
    protected CampusEbo campus;
    protected Account organizationOwnerAccount;
    protected Account oldOrganizationOwnerAccount;
    protected Chart organizationOwnerChartOfAccounts;
    protected StateEbo offCampusState;
    protected CountryEbo offCampusCountry;
    protected Building building;
    protected Room buildingRoom;
    protected transient List<AssetGlpeSourceDetail> sourceAssetGlpeSourceDetails = new ArrayList<AssetGlpeSourceDetail>();
    protected transient List<AssetGlpeSourceDetail> targetAssetGlpeSourceDetails = new ArrayList<AssetGlpeSourceDetail>();
    protected Asset asset;
    protected PostalCodeEbo postalZipCode;

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
    }

    public boolean customizeOffsetGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail accountingLine, GeneralLedgerPendingEntry explicitEntry, GeneralLedgerPendingEntry offsetEntry) {
        return false;
    }

    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public Person getAssetRepresentative() {
        this.assetRepresentative = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.representativeUniversalIdentifier, this.assetRepresentative);
        return this.assetRepresentative;
    }

    public void setAssetRepresentative(Person assetRepresentative) {
        this.assetRepresentative = assetRepresentative;
    }

    public Building getBuilding() {
        return this.building;
    }

    public String getBuildingCode() {
        return this.buildingCode;
    }

    public Room getBuildingRoom() {
        return this.buildingRoom;
    }

    public String getBuildingRoomNumber() {
        return this.buildingRoomNumber;
    }

    public String getBuildingSubRoomNumber() {
        return this.buildingSubRoomNumber;
    }

    public CampusEbo getCampus() {
        if (StringUtils.isBlank((CharSequence)this.campusCode)) {
            this.campus = null;
        } else if (this.campus == null || !StringUtils.equals((CharSequence)this.campus.getCode(), (CharSequence)this.campusCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(CampusEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(1);
                keys.put("code", this.campusCode);
                this.campus = (CampusEbo)moduleService.getExternalizableBusinessObject(CampusEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.campus;
    }

    public String getCampusCode() {
        return this.campusCode;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public KualiDecimal getGeneralLedgerPendingEntryAmountForDetail(GeneralLedgerPendingEntrySourceDetail postable) {
        return (KualiDecimal)postable.getAmount().abs();
    }

    public List<AssetGlpeSourceDetail> getSourceAssetGlpeSourceDetails() {
        if (this.sourceAssetGlpeSourceDetails == null) {
            this.sourceAssetGlpeSourceDetails = new ArrayList<AssetGlpeSourceDetail>();
        }
        return this.sourceAssetGlpeSourceDetails;
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        GeneralLedgerPendingEntry explicitEntry = new GeneralLedgerPendingEntry();
        ((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).populateExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySource)this, postable, sequenceHelper, explicitEntry);
        this.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        explicitEntry.refreshNonUpdateableReferences();
        this.addPendingEntry(explicitEntry);
        return true;
    }

    public String getOffCampusAddress() {
        return this.offCampusAddress;
    }

    public String getOffCampusCityName() {
        return this.offCampusCityName;
    }

    public StateEbo getOffCampusState() {
        if (StringUtils.isBlank((CharSequence)"US") || StringUtils.isBlank((CharSequence)this.offCampusStateCode)) {
            this.offCampusState = null;
        } else if (this.offCampusState == null || !StringUtils.equals((CharSequence)this.offCampusState.getCountryCode(), (CharSequence)"US") || !StringUtils.equals((CharSequence)this.offCampusState.getCode(), (CharSequence)this.offCampusStateCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(StateEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", this.offCampusCountryCode);
                keys.put("code", this.offCampusStateCode);
                this.offCampusState = (StateEbo)moduleService.getExternalizableBusinessObject(StateEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.offCampusState;
    }

    public String getOffCampusStateCode() {
        return this.offCampusStateCode;
    }

    public String getOffCampusZipCode() {
        return this.offCampusZipCode;
    }

    public PostalCodeEbo getPostalZipCode() {
        if (StringUtils.isBlank((CharSequence)this.offCampusCountryCode) || StringUtils.isBlank((CharSequence)this.offCampusZipCode)) {
            this.postalZipCode = null;
        } else if (this.postalZipCode == null || !StringUtils.equals((CharSequence)this.postalZipCode.getCountryCode(), (CharSequence)this.offCampusCountryCode) || !StringUtils.equals((CharSequence)this.postalZipCode.getCode(), (CharSequence)this.offCampusZipCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(PostalCodeEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(2);
                keys.put("countryCode", this.offCampusCountryCode);
                keys.put("code", this.offCampusZipCode);
                this.postalZipCode = (PostalCodeEbo)moduleService.getExternalizableBusinessObject(PostalCodeEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.postalZipCode;
    }

    public CountryEbo getOffCampusCountry() {
        if (StringUtils.isBlank((CharSequence)this.offCampusCountryCode)) {
            this.offCampusCountry = null;
        } else if (this.offCampusCountry == null || !StringUtils.equals((CharSequence)this.offCampusCountry.getCode(), (CharSequence)this.offCampusCountryCode)) {
            ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(CountryEbo.class);
            if (moduleService != null) {
                HashMap<String, String> keys = new HashMap<String, String>(1);
                keys.put("code", this.offCampusCountryCode);
                this.offCampusCountry = (CountryEbo)moduleService.getExternalizableBusinessObject(CountryEbo.class, keys);
            } else {
                throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
            }
        }
        return this.offCampusCountry;
    }

    public String getOrganizationInventoryName() {
        return this.organizationInventoryName;
    }

    public Account getOrganizationOwnerAccount() {
        return this.organizationOwnerAccount;
    }

    public Account getOldOrganizationOwnerAccount() {
        return this.oldOrganizationOwnerAccount;
    }

    public String getOrganizationOwnerAccountNumber() {
        return this.organizationOwnerAccountNumber;
    }

    public Chart getOrganizationOwnerChartOfAccounts() {
        return this.organizationOwnerChartOfAccounts;
    }

    public String getOrganizationOwnerChartOfAccountsCode() {
        return this.organizationOwnerChartOfAccountsCode;
    }

    public String getOrganizationTagNumber() {
        return this.organizationTagNumber;
    }

    public String getOrganizationText() {
        return this.organizationText;
    }

    public String getRepresentativeUniversalIdentifier() {
        return this.representativeUniversalIdentifier;
    }

    public TransferOfFundsDocument getTransferOfFundsFinancialDocument() {
        if (StringUtils.isNotBlank((CharSequence)this.getTransferOfFundsFinancialDocumentNumber())) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("documentNumber", this.getTransferOfFundsFinancialDocumentNumber());
            PersistableBusinessObject obj = (PersistableBusinessObject)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(TransferOfFundsDocument.class, primaryKeys);
            if (ObjectUtils.isNotNull((Object)obj)) {
                return (TransferOfFundsDocument)obj;
            }
        }
        return null;
    }

    public String getTransferOfFundsFinancialDocumentNumber() {
        return this.transferOfFundsFinancialDocumentNumber;
    }

    public Long getCapitalAssetNumber() {
        return this.capitalAssetNumber;
    }

    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    public void postProcessSave(KualiDocumentEvent event) {
        super.postProcessSave(event);
        if (!(event instanceof SaveDocumentEvent)) {
            ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
            if (this.getCapitalAssetNumber() != null) {
                capitalAssetNumbers.add(this.getCapitalAssetNumber());
            }
            if (!this.getCapitalAssetManagementModuleService().storeAssetLocks(capitalAssetNumbers, this.getDocumentNumber(), "AT", null)) {
                throw new ValidationException("Asset " + capitalAssetNumbers.toString() + " is being locked by other documents.");
            }
        }
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isProcessed()) {
            ((AssetTransferService)SpringContext.getBean(AssetTransferService.class)).saveApprovedChanges(this);
        }
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isProcessed()) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        AssetGlpeSourceDetail srcDetail = (AssetGlpeSourceDetail)postable;
        boolean isDebit = false;
        if (srcDetail.isSource() && (srcDetail.isCapitalization() && srcDetail.getAmount().isNegative() || srcDetail.isAccumulatedDepreciation() && srcDetail.getAmount().isPositive() || srcDetail.isCapitalizationOffset() && srcDetail.getAmount().isPositive())) {
            isDebit = true;
        }
        if (!srcDetail.isSource() && (srcDetail.isCapitalization() && srcDetail.getAmount().isPositive() || srcDetail.isAccumulatedDepreciation() && srcDetail.getAmount().isNegative() || srcDetail.isCapitalizationOffset() && srcDetail.getAmount().isNegative())) {
            isDebit = true;
        }
        return isDebit;
    }

    public boolean isInterdepartmentalSalesIndicator() {
        return this.interdepartmentalSalesIndicator;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public void setBuilding(Building building) {
        this.building = building;
    }

    public void setBuildingCode(String buildingCode) {
        this.buildingCode = buildingCode;
    }

    public void setBuildingRoom(Room buildingRoom) {
        this.buildingRoom = buildingRoom;
    }

    public void setBuildingRoomNumber(String buildingRoomNumber) {
        this.buildingRoomNumber = buildingRoomNumber;
    }

    public void setBuildingSubRoomNumber(String buildingSubRoomNumber) {
        this.buildingSubRoomNumber = buildingSubRoomNumber;
    }

    public void setCampus(CampusEbo campus) {
        this.campus = campus;
    }

    public void setCampusCode(String campusCode) {
        this.campusCode = campusCode;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public void setGeneralLedgerPostables(List<AssetGlpeSourceDetail> generalLedgerPostables) {
        this.sourceAssetGlpeSourceDetails = generalLedgerPostables;
    }

    public void setInterdepartmentalSalesIndicator(boolean interdepartmentalSalesIndicator) {
        this.interdepartmentalSalesIndicator = interdepartmentalSalesIndicator;
    }

    public void setOffCampusAddress(String offCampusAddress) {
        this.offCampusAddress = offCampusAddress;
    }

    public void setOffCampusCityName(String offCampusCityName) {
        this.offCampusCityName = offCampusCityName;
    }

    public void setOffCampusState(StateEbo offCampusState) {
        this.offCampusState = offCampusState;
    }

    public void setOffCampusStateCode(String offCampusStateCode) {
        this.offCampusStateCode = offCampusStateCode;
    }

    public void setOffCampusZipCode(String offCampusZipCode) {
        this.offCampusZipCode = offCampusZipCode;
    }

    public void setPostalZipCode(PostalCodeEbo postalZipCode) {
        this.postalZipCode = postalZipCode;
    }

    public void setOffCampusCountry(CountryEbo offCampusCountry) {
        this.offCampusCountry = offCampusCountry;
    }

    public void setOrganizationInventoryName(String organizationInventoryName) {
        this.organizationInventoryName = organizationInventoryName;
    }

    public void setOrganizationOwnerAccount(Account organizationOwnerAccount) {
        this.organizationOwnerAccount = organizationOwnerAccount;
    }

    public void setOldOrganizationOwnerAccount(Account oldOrganizationOwnerAccount) {
        this.oldOrganizationOwnerAccount = oldOrganizationOwnerAccount;
    }

    public void setOrganizationOwnerAccountNumber(String organizationOwnerAccountNumber) {
        Account account;
        this.organizationOwnerAccountNumber = organizationOwnerAccountNumber;
        AccountService accountService = (AccountService)SpringContext.getBean(AccountService.class);
        if (!accountService.accountsCanCrossCharts() && ObjectUtils.isNotNull((Object)(account = accountService.getUniqueAccountForAccountNumber(organizationOwnerAccountNumber)))) {
            this.setOrganizationOwnerChartOfAccountsCode(account.getChartOfAccountsCode());
        }
    }

    public void setOrganizationOwnerChartOfAccounts(Chart organizationOwnerChartOfAccounts) {
        this.organizationOwnerChartOfAccounts = organizationOwnerChartOfAccounts;
    }

    public void setOrganizationOwnerChartOfAccountsCode(String organizationOwnerChartOfAccountsCode) {
        this.organizationOwnerChartOfAccountsCode = organizationOwnerChartOfAccountsCode;
    }

    public void setOrganizationTagNumber(String organizationTagNumber) {
        this.organizationTagNumber = organizationTagNumber;
    }

    public void setOrganizationText(String organizationText) {
        this.organizationText = organizationText;
    }

    public void setRepresentativeUniversalIdentifier(String representativeUniversalIdentifier) {
        this.representativeUniversalIdentifier = representativeUniversalIdentifier;
    }

    public void setTransferOfFundsFinancialDocumentNumber(String transferOfFundsFinancialDocumentNumber) {
        this.transferOfFundsFinancialDocumentNumber = transferOfFundsFinancialDocumentNumber;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.documentNumber);
        return m;
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        ArrayList<GeneralLedgerPendingEntrySourceDetail> generalLedgerPostables = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        generalLedgerPostables.addAll(this.sourceAssetGlpeSourceDetails);
        generalLedgerPostables.addAll(this.targetAssetGlpeSourceDetails);
        return generalLedgerPostables;
    }

    public List<AssetGlpeSourceDetail> getTargetAssetGlpeSourceDetails() {
        if (this.targetAssetGlpeSourceDetails == null) {
            this.targetAssetGlpeSourceDetails = new ArrayList<AssetGlpeSourceDetail>();
        }
        return this.targetAssetGlpeSourceDetails;
    }

    public void setTargetAssetGlpeSourceDetails(List<AssetGlpeSourceDetail> targetAssetGlpeSourceDetails) {
        this.targetAssetGlpeSourceDetails = targetAssetGlpeSourceDetails;
    }

    public void setSourceAssetGlpeSourceDetails(List<AssetGlpeSourceDetail> sourceAssetGlpeSourceDetails) {
        this.sourceAssetGlpeSourceDetails = sourceAssetGlpeSourceDetails;
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPostables() {
        ArrayList<GeneralLedgerPendingEntrySourceDetail> generalLedgerPostables = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        generalLedgerPostables.addAll(this.sourceAssetGlpeSourceDetails);
        generalLedgerPostables.addAll(this.targetAssetGlpeSourceDetails);
        return generalLedgerPostables;
    }

    public String getOffCampusCountryCode() {
        return this.offCampusCountryCode;
    }

    public void setOffCampusCountryCode(String offCampusCountryCode) {
        this.offCampusCountryCode = offCampusCountryCode;
    }

    public String getOffCampusName() {
        return this.offCampusName;
    }

    public void setOffCampusName(String offCampusName) {
        this.offCampusName = offCampusName;
    }

    public String getOldOrganizationOwnerAccountNumber() {
        return this.oldOrganizationOwnerAccountNumber;
    }

    public void setOldOrganizationOwnerAccountNumber(String oldOrganizationOwnerAccountNumber) {
        this.oldOrganizationOwnerAccountNumber = oldOrganizationOwnerAccountNumber;
    }

    public String getOldOrganizationOwnerChartOfAccountsCode() {
        return this.oldOrganizationOwnerChartOfAccountsCode;
    }

    public void setOldOrganizationOwnerChartOfAccountsCode(String oldOrganizationOwnerChartOfAccountsCode) {
        this.oldOrganizationOwnerChartOfAccountsCode = oldOrganizationOwnerChartOfAccountsCode;
    }

    public void clearGlPostables() {
        this.getGeneralLedgerPendingEntries().clear();
        this.getSourceAssetGlpeSourceDetails().clear();
        this.getTargetAssetGlpeSourceDetails().clear();
    }

    public String getHiddenFieldForError() {
        return this.hiddenFieldForError;
    }

    public void setHiddenFieldForError(String hiddenFieldForError) {
        this.hiddenFieldForError = hiddenFieldForError;
    }

    public void prepareForSave(KualiDocumentEvent event) {
        super.prepareForSave(event);
        String accountingPeriodCompositeString = this.getAccountingPeriodCompositeString();
        this.setPostingYear(new Integer(StringUtils.right((String)accountingPeriodCompositeString, (int)4)));
        this.setPostingPeriodCode(StringUtils.left((String)accountingPeriodCompositeString, (int)2));
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if ("RequiresOrganizationInactiveReview".equals(nodeName)) {
            return AssetTransferDocument.isRequiresOrganizationInactiveRouteNode((DocumentBase)this, this.asset);
        }
        return super.answerSplitNodeQuestion(nodeName);
    }

    protected static boolean isRequiresOrganizationInactiveRouteNode(DocumentBase documentBase, Asset asset) {
        return !asset.getOrganizationOwnerAccount().getOrganization().isActive();
    }
}

