/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.service.ObjectTypeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.businessobject.CapitalAccountingLines;
import org.kuali.kfs.fp.businessobject.CapitalAssetAccountsGroupDetails;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformationDetail;
import org.kuali.kfs.fp.document.dataaccess.CapitalAssetInformationDao;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntryAsset;
import org.kuali.kfs.module.cam.businessobject.defaultvalue.NextAssetNumberFinder;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.service.GlLineService;
import org.kuali.kfs.module.cam.util.ObjectValueUtils;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

public class GlLineServiceImpl
implements GlLineService {
    private static final String CAB_DESC_PREFIX = "CAB created for FP ";
    protected BusinessObjectService businessObjectService;
    protected AssetGlobalService assetGlobalService;
    protected ObjectTypeService objectTypeService;
    protected DocumentService documentService;
    protected ParameterService parameterService;
    protected ParameterEvaluatorService parameterEvaluatorService;
    protected DocumentHeaderService documentHeaderService;
    protected CapitalAssetInformationDao capitalAssetInformationDao;

    @Override
    @NonTransactional
    public Document createAssetGlobalDocument(GeneralLedgerEntry primary, Integer capitalAssetLineNumber) throws WorkflowException {
        MaintenanceDocument document = (MaintenanceDocument)this.documentService.getNewDocument("AA");
        AssetGlobal assetGlobal = this.createAssetGlobal(primary, document);
        assetGlobal.setCapitalAssetBuilderOriginIndicator(true);
        assetGlobal.setAcquisitionTypeCode(this.assetGlobalService.getNewAcquisitionTypeCode());
        this.updatePreTagInformation(primary, document, assetGlobal, capitalAssetLineNumber);
        assetGlobal.getAssetPaymentDetails().addAll(this.createAssetPaymentDetails(primary, (Document)document, 0, capitalAssetLineNumber));
        document.getNewMaintainableObject().setMaintenanceAction("New");
        document.getDocumentHeader().setDocumentDescription(CAB_DESC_PREFIX + primary.getDocumentNumber());
        document.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)assetGlobal);
        document.getNewMaintainableObject().setBoClass(((Object)((Object)assetGlobal)).getClass());
        this.documentService.saveDocument((Document)document);
        this.markCapitalAssetProcessed(primary, capitalAssetLineNumber);
        this.deactivateGLEntries(primary, (Document)document, capitalAssetLineNumber);
        return document;
    }

    protected void markCapitalAssetProcessed(GeneralLedgerEntry primary, Integer capitalAssetLineNumber) {
        CapitalAssetInformation capitalAssetInformation = this.findCapitalAssetInformation(primary.getDocumentNumber(), capitalAssetLineNumber);
        if (ObjectUtils.isNotNull((Object)capitalAssetInformation)) {
            capitalAssetInformation.setCapitalAssetProcessedIndicator(true);
            this.businessObjectService.save((PersistableBusinessObject)capitalAssetInformation);
        }
    }

    protected void deactivateGLEntries(GeneralLedgerEntry entry, Document document, Integer capitalAssetLineNumber) {
        CapitalAssetInformation capitalAssetInformation = this.findCapitalAssetInformation(entry.getDocumentNumber(), capitalAssetLineNumber);
        if (ObjectUtils.isNotNull((Object)capitalAssetInformation)) {
            List groupAccountingLines = capitalAssetInformation.getCapitalAssetAccountsGroupDetails();
            Collection<GeneralLedgerEntry> documentGlEntries = this.findAllGeneralLedgerEntry(entry.getDocumentNumber());
            for (CapitalAssetAccountsGroupDetails accountingLine : groupAccountingLines) {
                Collection<GeneralLedgerEntry> glEntries = this.findMatchingGeneralLedgerEntries(documentGlEntries, accountingLine);
                for (GeneralLedgerEntry glEntry : glEntries) {
                    KualiDecimal lineAmount = accountingLine.getAmount();
                    this.createGeneralLedgerEntryAsset(glEntry, document, capitalAssetLineNumber);
                    this.updateTransactionSumbitGlEntryAmount(glEntry, lineAmount);
                }
            }
        }
    }

    protected void updatePreTagInformation(GeneralLedgerEntry entry, MaintenanceDocument document, AssetGlobal assetGlobal, Integer capitalAssetLineNumber) {
        CapitalAssetInformation capitalAssetInformation = this.findCapitalAssetInformation(entry.getDocumentNumber(), capitalAssetLineNumber);
        if (ObjectUtils.isNotNull((Object)capitalAssetInformation) && "C".equals(capitalAssetInformation.getCapitalAssetActionIndicator())) {
            List capitalAssetInformationDetails = capitalAssetInformation.getCapitalAssetInformationDetails();
            for (CapitalAssetInformationDetail capitalAssetInformationDetail : capitalAssetInformationDetails) {
                AssetGlobalDetail assetGlobalDetail = new AssetGlobalDetail();
                assetGlobalDetail.setDocumentNumber(document.getDocumentNumber());
                assetGlobalDetail.setCampusCode(capitalAssetInformationDetail.getCampusCode());
                assetGlobalDetail.setBuildingCode(capitalAssetInformationDetail.getBuildingCode());
                assetGlobalDetail.setBuildingRoomNumber(capitalAssetInformationDetail.getBuildingRoomNumber());
                assetGlobalDetail.setBuildingSubRoomNumber(capitalAssetInformationDetail.getBuildingSubRoomNumber());
                assetGlobalDetail.setSerialNumber(capitalAssetInformationDetail.getCapitalAssetSerialNumber());
                assetGlobalDetail.setCapitalAssetNumber(NextAssetNumberFinder.getLongValue());
                assetGlobalDetail.setCampusTagNumber(capitalAssetInformationDetail.getCapitalAssetTagNumber());
                AssetGlobalDetail uniqueAsset = new AssetGlobalDetail();
                ObjectValueUtils.copySimpleProperties((Object)assetGlobalDetail, (Object)uniqueAsset);
                assetGlobalDetail.getAssetGlobalUniqueDetails().add(uniqueAsset);
                assetGlobal.getAssetSharedDetails().add(assetGlobalDetail);
            }
            assetGlobal.setVendorName(capitalAssetInformation.getVendorName());
            assetGlobal.setInventoryStatusCode("A");
            assetGlobal.setCapitalAssetTypeCode(capitalAssetInformation.getCapitalAssetTypeCode());
            assetGlobal.setManufacturerName(capitalAssetInformation.getCapitalAssetManufacturerName());
            assetGlobal.setManufacturerModelNumber(capitalAssetInformation.getCapitalAssetManufacturerModelNumber());
            assetGlobal.setCapitalAssetDescription(capitalAssetInformation.getCapitalAssetDescription());
        }
    }

    @Override
    @NonTransactional
    public CapitalAssetInformation findCapitalAssetInformation(String documentNumber, Integer capitalAssetLineNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>(2);
        primaryKeys.put("documentNumber", documentNumber);
        primaryKeys.put("capitalAssetLineNumber", capitalAssetLineNumber.toString());
        CapitalAssetInformation assetInformation = (CapitalAssetInformation)this.businessObjectService.findByPrimaryKey(CapitalAssetInformation.class, primaryKeys);
        return assetInformation;
    }

    @Override
    @NonTransactional
    public List<CapitalAssetInformation> findAllCapitalAssetInformation(String documentNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>(1);
        primaryKeys.put("documentNumber", documentNumber);
        List assetInformation = (List)this.businessObjectService.findMatchingOrderBy(CapitalAssetInformation.class, primaryKeys, "capitalAssetActionIndicator", true);
        return assetInformation;
    }

    @Override
    @NonTransactional
    public List<CapitalAssetInformation> findCapitalAssetInformationForGLLine(GeneralLedgerEntry entry) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("documentNumber", entry.getDocumentNumber());
        fields.put("capitalAssetProcessedIndicator", "N");
        List assetInformation = (List)this.businessObjectService.findMatchingOrderBy(CapitalAssetInformation.class, fields, "capitalAssetActionIndicator", true);
        ArrayList<CapitalAssetInformation> matchingAssets = new ArrayList<CapitalAssetInformation>();
        for (CapitalAssetInformation capitalAsset : assetInformation) {
            this.addToCapitalAssets(matchingAssets, capitalAsset, entry);
        }
        return matchingAssets;
    }

    protected void addToCapitalAssets(List<CapitalAssetInformation> matchingAssets, CapitalAssetInformation capitalAsset, GeneralLedgerEntry entry) {
        List groupAccountLines = capitalAsset.getCapitalAssetAccountsGroupDetails();
        for (CapitalAssetAccountsGroupDetails groupAccountLine : groupAccountLines) {
            boolean isOrganizationReferenceIdEqual = StringUtils.equals((CharSequence)groupAccountLine.getOrganizationReferenceId(), (CharSequence)entry.getOrganizationReferenceId()) ? true : StringUtils.isBlank((CharSequence)groupAccountLine.getOrganizationReferenceId()) && StringUtils.isBlank((CharSequence)entry.getOrganizationReferenceId());
            if (!isOrganizationReferenceIdEqual || !StringUtils.equals((CharSequence)groupAccountLine.getDocumentNumber(), (CharSequence)entry.getDocumentNumber()) || !StringUtils.equals((CharSequence)groupAccountLine.getChartOfAccountsCode(), (CharSequence)entry.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)groupAccountLine.getAccountNumber(), (CharSequence)entry.getAccountNumber()) || !StringUtils.equals((CharSequence)groupAccountLine.getFinancialObjectCode(), (CharSequence)entry.getFinancialObjectCode())) continue;
            matchingAssets.add(capitalAsset);
            break;
        }
    }

    @Override
    @NonTransactional
    public long findUnprocessedCapitalAssetInformation(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>(2);
        fieldValues.put("documentNumber", documentNumber);
        fieldValues.put("capitalAssetProcessedIndicator", "N");
        return this.businessObjectService.countMatching(CapitalAssetInformation.class, fieldValues);
    }

    @Override
    @NonTransactional
    public Collection<GeneralLedgerEntry> findMatchingGeneralLedgerEntries(Collection<GeneralLedgerEntry> allGLEntries, CapitalAssetAccountsGroupDetails accountingDetails) {
        ArrayList<GeneralLedgerEntry> matchingGLEntries = new ArrayList<GeneralLedgerEntry>();
        for (GeneralLedgerEntry entry : allGLEntries) {
            if (!this.doesGeneralLedgerEntryMatchAssetAccountingDetails(entry, accountingDetails)) continue;
            matchingGLEntries.add(entry);
        }
        return matchingGLEntries;
    }

    protected boolean doesGeneralLedgerEntryMatchAssetAccountingDetails(GeneralLedgerEntry entry, CapitalAssetAccountsGroupDetails accountingDetails) {
        if (!StringUtils.equals((CharSequence)entry.getDocumentNumber(), (CharSequence)accountingDetails.getDocumentNumber())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)entry.getAccountNumber(), (CharSequence)accountingDetails.getAccountNumber())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)entry.getFinancialObjectCode(), (CharSequence)accountingDetails.getFinancialObjectCode())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)entry.getChartOfAccountsCode(), (CharSequence)accountingDetails.getChartOfAccountsCode())) {
            return false;
        }
        if (!(StringUtils.equals((CharSequence)entry.getOrganizationReferenceId(), (CharSequence)accountingDetails.getOrganizationReferenceId()) || StringUtils.isBlank((CharSequence)entry.getOrganizationReferenceId()) && StringUtils.isBlank((CharSequence)accountingDetails.getOrganizationReferenceId()))) {
            return false;
        }
        if (!(StringUtils.equals((CharSequence)entry.getSubAccountNumber(), (CharSequence)accountingDetails.getSubAccountNumber()) || StringUtils.equals((CharSequence)entry.getSubAccountNumber(), (CharSequence)KFSConstants.getDashSubAccountNumber()) && StringUtils.isBlank((CharSequence)accountingDetails.getSubAccountNumber()))) {
            return false;
        }
        if (!(StringUtils.equals((CharSequence)entry.getFinancialSubObjectCode(), (CharSequence)accountingDetails.getFinancialSubObjectCode()) || StringUtils.equals((CharSequence)entry.getFinancialSubObjectCode(), (CharSequence)KFSConstants.getDashFinancialSubObjectCode()) && StringUtils.isBlank((CharSequence)accountingDetails.getFinancialSubObjectCode()))) {
            return false;
        }
        return StringUtils.equals((CharSequence)entry.getProjectCode(), (CharSequence)accountingDetails.getProjectCode()) || StringUtils.equals((CharSequence)entry.getProjectCode(), (CharSequence)KFSConstants.getDashProjectCode()) && StringUtils.isBlank((CharSequence)accountingDetails.getProjectCode());
        {
        }
    }

    @Override
    @NonTransactional
    public Collection<GeneralLedgerEntry> findAllGeneralLedgerEntry(String documentNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>(1);
        fieldValues.put("documentNumber", documentNumber);
        return this.businessObjectService.findMatching(GeneralLedgerEntry.class, fieldValues);
    }

    protected void createGeneralLedgerEntryAsset(GeneralLedgerEntry entry, Document document, Integer capitalAssetLineNumber) {
        for (GeneralLedgerEntryAsset glEntryAsset : entry.getGeneralLedgerEntryAssets()) {
            if (!glEntryAsset.getCapitalAssetManagementDocumentNumber().equals(document.getDocumentNumber()) || !glEntryAsset.getCapitalAssetBuilderLineNumber().equals(capitalAssetLineNumber)) continue;
            return;
        }
        GeneralLedgerEntryAsset entryAsset = new GeneralLedgerEntryAsset();
        entryAsset.setGeneralLedgerAccountIdentifier(entry.getGeneralLedgerAccountIdentifier());
        entryAsset.setCapitalAssetBuilderLineNumber(capitalAssetLineNumber);
        entryAsset.setCapitalAssetManagementDocumentNumber(document.getDocumentNumber());
        entry.getGeneralLedgerEntryAssets().add(entryAsset);
    }

    protected AssetGlobal createAssetGlobal(GeneralLedgerEntry entry, MaintenanceDocument maintDoc) {
        AssetGlobal assetGlobal = new AssetGlobal();
        assetGlobal.setOrganizationOwnerChartOfAccountsCode(entry.getChartOfAccountsCode());
        assetGlobal.setOrganizationOwnerAccountNumber(entry.getAccountNumber());
        assetGlobal.setDocumentNumber(maintDoc.getDocumentNumber());
        assetGlobal.setConditionCode("E");
        String docType = "AA";
        ParameterEvaluator evaluator = this.parameterEvaluatorService.getParameterEvaluator("KFS-SYS", "Document", "FISCAL_PERIOD_SELECTION_DOCUMENT_TYPES", docType);
        if (evaluator.evaluationSucceeds()) {
            Integer closingYear = new Integer(this.parameterService.getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_FISCAL_YEAR"));
            if (entry.getUniversityFiscalYear().equals(closingYear + 1)) {
                assetGlobal.setUniversityFiscalPeriodName("");
            }
        }
        return assetGlobal;
    }

    @Override
    @NonTransactional
    public Document createAssetPaymentDocument(GeneralLedgerEntry primaryGlEntry, Integer capitalAssetLineNumber) throws WorkflowException {
        AssetPaymentDocument document = (AssetPaymentDocument)this.documentService.getNewDocument("MPAY");
        document.setCapitalAssetBuilderOriginIndicator(true);
        CapitalAssetInformation capitalAssetInformation = this.findCapitalAssetInformation(primaryGlEntry.getDocumentNumber(), capitalAssetLineNumber);
        if (ObjectUtils.isNotNull((Object)capitalAssetInformation)) {
            if (ObjectUtils.isNull((Object)capitalAssetInformation.getDistributionAmountCode())) {
                document.setAssetPaymentAllocationTypeCode("2");
                document.setAllocationFromFPDocuments(false);
            } else {
                document.setAssetPaymentAllocationTypeCode(capitalAssetInformation.getDistributionAmountCode());
                document.setAllocationFromFPDocuments(true);
            }
        }
        document.getDocumentHeader().setDocumentDescription(CAB_DESC_PREFIX + primaryGlEntry.getDocumentNumber());
        this.updatePreTagInformation(primaryGlEntry, document, capitalAssetLineNumber);
        document.getSourceAccountingLines().addAll(this.createAssetPaymentDetails(primaryGlEntry, (Document)document, 0, capitalAssetLineNumber));
        KualiDecimal assetAmount = KualiDecimal.ZERO;
        List sourceAccountingLines = document.getSourceAccountingLines();
        for (SourceAccountingLine sourceAccountingLine : sourceAccountingLines) {
            assetAmount = (KualiDecimal)assetAmount.add((AbstractKualiDecimal)sourceAccountingLine.getAmount());
        }
        List<AssetPaymentAssetDetail> assetPaymentDetails = document.getAssetPaymentAssetDetail();
        for (AssetPaymentAssetDetail assetPaymentDetail : assetPaymentDetails) {
            assetPaymentDetail.setAllocatedAmount(assetAmount);
        }
        this.documentService.saveDocument((Document)document);
        this.markCapitalAssetProcessed(primaryGlEntry, capitalAssetLineNumber);
        this.deactivateGLEntries(primaryGlEntry, (Document)document, capitalAssetLineNumber);
        return document;
    }

    protected void updatePreTagInformation(GeneralLedgerEntry entry, AssetPaymentDocument document, Integer capitalAssetLineNumber) {
        CapitalAssetInformation capitalAssetInformation = this.findCapitalAssetInformation(entry.getDocumentNumber(), capitalAssetLineNumber);
        if (ObjectUtils.isNotNull((Object)capitalAssetInformation) && "M".equals(capitalAssetInformation.getCapitalAssetActionIndicator())) {
            AssetPaymentAssetDetail assetPaymentAssetDetail = new AssetPaymentAssetDetail();
            assetPaymentAssetDetail.setDocumentNumber(document.getDocumentNumber());
            assetPaymentAssetDetail.setCapitalAssetNumber(capitalAssetInformation.getCapitalAssetNumber());
            assetPaymentAssetDetail.setAllocatedAmount(KualiDecimal.ZERO);
            assetPaymentAssetDetail.setAllocatedUserValue(assetPaymentAssetDetail.getAllocatedAmount());
            assetPaymentAssetDetail.refreshReferenceObject("asset");
            Asset asset = assetPaymentAssetDetail.getAsset();
            if (ObjectUtils.isNotNull((Object)((Object)asset))) {
                assetPaymentAssetDetail.setPreviousTotalCostAmount(asset.getTotalCostAmount() != null ? asset.getTotalCostAmount() : KualiDecimal.ZERO);
                document.getAssetPaymentAssetDetail().add(assetPaymentAssetDetail);
            }
        }
    }

    protected List<AssetPaymentDetail> createAssetPaymentDetails(GeneralLedgerEntry entry, Document document, int seqNo, Integer capitalAssetLineNumber) {
        ArrayList<AssetPaymentDetail> appliedPayments = new ArrayList<AssetPaymentDetail>();
        CapitalAssetInformation capitalAssetInformation = this.findCapitalAssetInformation(entry.getDocumentNumber(), capitalAssetLineNumber);
        Collection<GeneralLedgerEntry> documentGlEntries = this.findAllGeneralLedgerEntry(entry.getDocumentNumber());
        if (ObjectUtils.isNotNull((Object)capitalAssetInformation)) {
            List groupAccountingLines = capitalAssetInformation.getCapitalAssetAccountsGroupDetails();
            Integer paymentSequenceNumber = 1;
            for (CapitalAssetAccountsGroupDetails accountingLine : groupAccountingLines) {
                AssetPaymentDetail detail = new AssetPaymentDetail();
                for (GeneralLedgerEntry glEntry : documentGlEntries) {
                    if (!this.doesGeneralLedgerEntryMatchAssetAccountingDetails(glEntry, accountingLine)) continue;
                    entry = glEntry;
                }
                detail.setDocumentNumber(document.getDocumentNumber());
                Integer n = paymentSequenceNumber;
                Integer n2 = paymentSequenceNumber = Integer.valueOf(paymentSequenceNumber + 1);
                detail.setSequenceNumber(n);
                detail.setPostingYear(entry.getUniversityFiscalYear());
                detail.setPostingPeriodCode(entry.getUniversityFiscalPeriodCode());
                detail.setChartOfAccountsCode(accountingLine.getChartOfAccountsCode());
                detail.setAccountNumber(this.replaceFiller(accountingLine.getAccountNumber()));
                detail.setSubAccountNumber(this.replaceFiller(accountingLine.getSubAccountNumber()));
                detail.setFinancialObjectCode(this.replaceFiller(accountingLine.getFinancialObjectCode()));
                detail.setFinancialSubObjectCode(this.replaceFiller(accountingLine.getFinancialSubObjectCode()));
                detail.setProjectCode(this.replaceFiller(accountingLine.getProjectCode()));
                detail.setOrganizationReferenceId(this.replaceFiller(accountingLine.getOrganizationReferenceId()));
                detail.setAmount(this.getAccountingLineAmountForPaymentDetail(entry, accountingLine));
                detail.setExpenditureFinancialSystemOriginationCode(this.replaceFiller(entry.getFinancialSystemOriginationCode()));
                detail.setExpenditureFinancialDocumentNumber(entry.getDocumentNumber());
                detail.setExpenditureFinancialDocumentTypeCode(this.replaceFiller(entry.getFinancialDocumentTypeCode()));
                detail.setExpenditureFinancialDocumentPostedDate(entry.getTransactionDate());
                detail.setPurchaseOrderNumber(this.replaceFiller(entry.getReferenceFinancialDocumentNumber()));
                detail.setTransferPaymentIndicator(false);
                detail.refreshNonUpdateableReferences();
                appliedPayments.add(detail);
            }
        }
        return appliedPayments;
    }

    protected KualiDecimal getAccountingLineAmountForPaymentDetail(GeneralLedgerEntry entry, CapitalAssetAccountsGroupDetails accountingLine) {
        KualiDecimal accountLineAmount = accountingLine.getAmount();
        List expenseObjectTypes = this.objectTypeService.getExpenseAndTransferObjectTypesForPayments();
        List incomeObjectTypes = this.objectTypeService.getIncomeAndTransferObjectTypesForPayments();
        if (this.isDocumentAnErrorCorrection(entry)) {
            if ("F".equals(accountingLine.getFinancialDocumentLineTypeCode())) {
                return (KualiDecimal)accountLineAmount.negated();
            }
            return accountLineAmount;
        }
        if (expenseObjectTypes.contains(entry.getFinancialObjectTypeCode()) && "F".equals(accountingLine.getFinancialDocumentLineTypeCode()) && "C".equals(entry.getTransactionDebitCreditCode()) && accountLineAmount.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) > 0) {
            return (KualiDecimal)accountLineAmount.negated();
        }
        if (incomeObjectTypes.contains(entry.getFinancialObjectTypeCode()) && accountLineAmount.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) > 0) {
            return (KualiDecimal)accountLineAmount.negated();
        }
        return accountLineAmount;
    }

    protected boolean isDocumentAnErrorCorrection(GeneralLedgerEntry entry) {
        DocumentHeader docHeader = this.documentHeaderService.getDocumentHeaderById(entry.getDocumentNumber());
        FinancialSystemDocumentHeader fsDocumentHeader = (FinancialSystemDocumentHeader)docHeader;
        return fsDocumentHeader != null && StringUtils.isNotBlank((CharSequence)fsDocumentHeader.getFinancialDocumentInErrorNumber());
    }

    protected void updateTransactionSumbitGlEntryAmount(GeneralLedgerEntry matchingGLEntry, KualiDecimal accountLineAmount) {
        KualiDecimal submitTotalAmount = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull((Object)matchingGLEntry.getTransactionLedgerSubmitAmount())) {
            submitTotalAmount = matchingGLEntry.getTransactionLedgerSubmitAmount();
        }
        matchingGLEntry.setTransactionLedgerSubmitAmount((KualiDecimal)submitTotalAmount.add(accountLineAmount.abs()));
        if (matchingGLEntry.getTransactionLedgerSubmitAmount().equals((Object)matchingGLEntry.getTransactionLedgerEntryAmount())) {
            matchingGLEntry.setActivityStatusCode("E");
        }
        this.businessObjectService.save((PersistableBusinessObject)matchingGLEntry);
    }

    protected AssetPaymentDetail createAssetPaymentDetail(GeneralLedgerEntry entry, Document document, int seqNo, Integer capitalAssetLineNumber) {
        AssetPaymentDetail detail = new AssetPaymentDetail();
        detail.setDocumentNumber(document.getDocumentNumber());
        detail.setSequenceNumber(seqNo);
        detail.setPostingYear(entry.getUniversityFiscalYear());
        detail.setPostingPeriodCode(entry.getUniversityFiscalPeriodCode());
        detail.setChartOfAccountsCode(entry.getChartOfAccountsCode());
        detail.setAccountNumber(this.replaceFiller(entry.getAccountNumber()));
        detail.setSubAccountNumber(this.replaceFiller(entry.getSubAccountNumber()));
        detail.setFinancialObjectCode(this.replaceFiller(entry.getFinancialObjectCode()));
        detail.setFinancialSubObjectCode(this.replaceFiller(entry.getFinancialSubObjectCode()));
        detail.setProjectCode(this.replaceFiller(entry.getProjectCode()));
        detail.setOrganizationReferenceId(this.replaceFiller(entry.getOrganizationReferenceId()));
        KualiDecimal capitalAssetAmount = this.getCapitalAssetAmount(entry, capitalAssetLineNumber);
        detail.setAmount(capitalAssetAmount);
        detail.setExpenditureFinancialSystemOriginationCode(this.replaceFiller(entry.getFinancialSystemOriginationCode()));
        detail.setExpenditureFinancialDocumentNumber(entry.getDocumentNumber());
        detail.setExpenditureFinancialDocumentTypeCode(this.replaceFiller(entry.getFinancialDocumentTypeCode()));
        detail.setExpenditureFinancialDocumentPostedDate(entry.getTransactionDate());
        detail.setPurchaseOrderNumber(this.replaceFiller(entry.getReferenceFinancialDocumentNumber()));
        detail.setTransferPaymentIndicator(false);
        return detail;
    }

    protected KualiDecimal getCapitalAssetAmount(GeneralLedgerEntry entry, Integer capitalAssetLineNumber) {
        CapitalAssetInformation capitalAssetInformation = this.findCapitalAssetInformation(entry.getDocumentNumber(), capitalAssetLineNumber);
        if (ObjectUtils.isNotNull((Object)capitalAssetInformation)) {
            return capitalAssetInformation.getCapitalAssetLineAmount();
        }
        return KualiDecimal.ZERO;
    }

    protected String replaceFiller(String val) {
        char[] charArray;
        if (val == null) {
            return "";
        }
        for (char c : charArray = val.trim().toCharArray()) {
            if (c == '-') continue;
            return val;
        }
        return "";
    }

    @Override
    @Transactional
    public void setupCapitalAssetInformation(GeneralLedgerEntry entry) {
        int nextCapitalAssetLineNumber = this.capitalAssetInformationDao.getNextCapitalAssetLineNumber(entry.getDocumentNumber());
        ArrayList<CapitalAccountingLines> capitalAccountingLines = new ArrayList<CapitalAccountingLines>();
        this.createCapitalAccountingLine(capitalAccountingLines, entry, null);
        this.createNewCapitalAsset(capitalAccountingLines, entry.getDocumentNumber(), null, nextCapitalAssetLineNumber);
    }

    protected List<CapitalAccountingLines> createCapitalAccountingLine(List<CapitalAccountingLines> capitalAccountingLines, GeneralLedgerEntry entry, String distributionAmountCode) {
        Integer sequenceNumber = capitalAccountingLines.size() + 1;
        CapitalAccountingLines cal = this.addCapitalAccountingLine(capitalAccountingLines, entry);
        cal.setDistributionAmountCode(distributionAmountCode);
        capitalAccountingLines.add(cal);
        return capitalAccountingLines;
    }

    protected CapitalAccountingLines addCapitalAccountingLine(List<CapitalAccountingLines> capitalAccountingLines, GeneralLedgerEntry entry) {
        CapitalAccountingLines cal = new CapitalAccountingLines();
        String capitalAssetLineType = "C".equals(entry.getTransactionDebitCreditCode()) ? "Source" : "Target";
        cal.setLineType(capitalAssetLineType);
        cal.setSequenceNumber(entry.getTransactionLedgerEntrySequenceNumber());
        cal.setChartOfAccountsCode(entry.getChartOfAccountsCode());
        cal.setAccountNumber(entry.getAccountNumber());
        cal.setSubAccountNumber(entry.getSubAccountNumber());
        cal.setFinancialObjectCode(entry.getFinancialObjectCode());
        cal.setFinancialSubObjectCode(entry.getFinancialSubObjectCode());
        cal.setProjectCode(entry.getProjectCode());
        cal.setOrganizationReferenceId(entry.getOrganizationReferenceId());
        cal.setFinancialDocumentLineDescription(entry.getTransactionLedgerEntryDescription());
        cal.setAmount(entry.getAmount());
        cal.setAccountLinePercent(null);
        cal.setSelectLine(false);
        return cal;
    }

    protected void createNewCapitalAsset(List<CapitalAccountingLines> capitalAccountingLines, String documentNumber, String actionType, Integer nextCapitalAssetLineNumber) {
        CapitalAssetInformation capitalAsset = new CapitalAssetInformation();
        capitalAsset.setCapitalAssetLineAmount(KualiDecimal.ZERO);
        capitalAsset.setDocumentNumber(documentNumber);
        capitalAsset.setCapitalAssetLineNumber(nextCapitalAssetLineNumber);
        capitalAsset.setCapitalAssetActionIndicator(actionType);
        capitalAsset.setCapitalAssetProcessedIndicator(false);
        KualiDecimal capitalAssetLineAmount = KualiDecimal.ZERO;
        for (CapitalAccountingLines capitalAccountingLine : capitalAccountingLines) {
            capitalAsset.setDistributionAmountCode(capitalAccountingLine.getDistributionAmountCode());
            this.createCapitalAssetAccountingLinesDetails(capitalAccountingLine, capitalAsset);
            capitalAssetLineAmount = (KualiDecimal)capitalAssetLineAmount.add((AbstractKualiDecimal)capitalAccountingLine.getAmount());
        }
        capitalAsset.setCapitalAssetLineAmount(capitalAssetLineAmount);
        this.businessObjectService.save((PersistableBusinessObject)capitalAsset);
    }

    protected void createCapitalAssetAccountingLinesDetails(CapitalAccountingLines capitalAccountingLine, CapitalAssetInformation capitalAsset) {
        CapitalAssetAccountsGroupDetails capitalAssetAccountLine = new CapitalAssetAccountsGroupDetails();
        capitalAssetAccountLine.setDocumentNumber(capitalAsset.getDocumentNumber());
        capitalAssetAccountLine.setChartOfAccountsCode(capitalAccountingLine.getChartOfAccountsCode());
        capitalAssetAccountLine.setAccountNumber(capitalAccountingLine.getAccountNumber());
        capitalAssetAccountLine.setSubAccountNumber(capitalAccountingLine.getSubAccountNumber());
        capitalAssetAccountLine.setFinancialDocumentLineTypeCode("Source".equals(capitalAccountingLine.getLineType()) ? "F" : "T");
        capitalAssetAccountLine.setCapitalAssetAccountLineNumber(this.getNextAccountingLineNumber(capitalAccountingLine, capitalAsset));
        capitalAssetAccountLine.setCapitalAssetLineNumber(capitalAsset.getCapitalAssetLineNumber());
        capitalAssetAccountLine.setFinancialObjectCode(capitalAccountingLine.getFinancialObjectCode());
        capitalAssetAccountLine.setFinancialSubObjectCode(capitalAccountingLine.getFinancialSubObjectCode());
        capitalAssetAccountLine.setProjectCode(capitalAccountingLine.getProjectCode());
        capitalAssetAccountLine.setOrganizationReferenceId(capitalAccountingLine.getOrganizationReferenceId());
        capitalAssetAccountLine.setSequenceNumber(capitalAccountingLine.getSequenceNumber());
        capitalAssetAccountLine.setAmount(capitalAccountingLine.getAmount());
        capitalAsset.getCapitalAssetAccountsGroupDetails().add(capitalAssetAccountLine);
    }

    protected Integer getNextAccountingLineNumber(CapitalAccountingLines capitalAccountingLine, CapitalAssetInformation capitalAsset) {
        Integer nextAccountingLineNumber = 0;
        List capitalAssetAccountLines = capitalAsset.getCapitalAssetAccountsGroupDetails();
        for (CapitalAssetAccountsGroupDetails capitalAssetAccountLine : capitalAssetAccountLines) {
            nextAccountingLineNumber = capitalAssetAccountLine.getCapitalAssetAccountLineNumber();
        }
        nextAccountingLineNumber = nextAccountingLineNumber + 1;
        return nextAccountingLineNumber;
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public void setAssetGlobalService(AssetGlobalService assetGlobalService) {
        this.assetGlobalService = assetGlobalService;
    }

    @NonTransactional
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    @NonTransactional
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @NonTransactional
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @NonTransactional
    public void setParameterEvaluatorService(ParameterEvaluatorService parameterEvaluatorService) {
        this.parameterEvaluatorService = parameterEvaluatorService;
    }

    @NonTransactional
    public void setDocumentHeaderService(DocumentHeaderService documentHeaderService) {
        this.documentHeaderService = documentHeaderService;
    }

    @NonTransactional
    public void setCapitalAssetInformationDao(CapitalAssetInformationDao dao) {
        this.capitalAssetInformationDao = dao;
    }
}

