/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.document.gl.AssetRetirementGeneralLedgerPendingEntrySource;
import org.kuali.kfs.module.cam.document.service.AssetObjectCodeService;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.document.service.AssetRetirementService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.authorization.FinancialSystemMaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetRetirementGlobalRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = Logger.getLogger(AssetRetirementGlobalRule.class);
    protected PersistableBusinessObject bo;

    public void setupConvenienceObjects() {
        AssetRetirementGlobal newRetirementGlobal = (AssetRetirementGlobal)((Object)super.getNewBo());
        newRetirementGlobal.refreshNonUpdateableReferences();
        for (AssetRetirementGlobalDetail detail : newRetirementGlobal.getAssetRetirementGlobalDetails()) {
            detail.refreshNonUpdateableReferences();
        }
    }

    protected boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean valid = super.isDocumentValidForSave(document);
        if (valid) {
            AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getNewMaintainableObject().getBusinessObject();
            this.setupConvenienceObjects();
            valid &= this.assetRetirementValidation(assetRetirementGlobal, document);
        }
        return valid;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = true;
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getNewMaintainableObject().getBusinessObject();
        this.setupConvenienceObjects();
        if ((valid &= this.assetRetirementValidation(assetRetirementGlobal, document)) && super.processCustomSaveDocumentBusinessRules(document) && !this.getAssetRetirementService().isAssetRetiredByMerged(assetRetirementGlobal) && !this.allPaymentsFederalOwned(assetRetirementGlobal) && (valid &= this.validateObjectCodesForGLPosting(assetRetirementGlobal))) {
            AssetRetirementGeneralLedgerPendingEntrySource assetRetirementGlPoster = new AssetRetirementGeneralLedgerPendingEntrySource((FinancialSystemDocumentHeader)document.getDocumentHeader());
            this.getAssetRetirementService().createGLPostables(assetRetirementGlobal, assetRetirementGlPoster);
            if (((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)assetRetirementGlPoster)) {
                assetRetirementGlobal.setGeneralLedgerPendingEntries(assetRetirementGlPoster.getPendingEntries());
            } else {
                assetRetirementGlPoster.getPendingEntries().clear();
            }
        }
        if ("M".equals(assetRetirementGlobal.getRetirementReasonCode()) && !document.getDocumentHeader().getDocumentDescription().toLowerCase().contains("Merge an Asset".toLowerCase())) {
            Integer maxDocumentDescription = this.ddService.getAttributeMaxLength(DocumentHeader.class, "documentDescription");
            String documentDescription = "Merge an Asset " + document.getDocumentHeader().getDocumentDescription();
            documentDescription = StringUtils.left((String)documentDescription, (int)maxDocumentDescription);
            document.getDocumentHeader().setDocumentDescription(documentDescription);
        }
        List<Long> capitalAssetNumbers = this.retrieveAssetNumbersForLocking(assetRetirementGlobal);
        return valid &= !this.getCapitalAssetManagementModuleService().isAssetLocked(capitalAssetNumbers, "ARG", document.getDocumentNumber());
    }

    protected List<Long> retrieveAssetNumbersForLocking(AssetRetirementGlobal assetRetirementGlobal) {
        ArrayList<Long> capitalAssetNumbers = new ArrayList<Long>();
        if (this.getAssetRetirementService().isAssetRetiredByMerged(assetRetirementGlobal) && assetRetirementGlobal.getMergedTargetCapitalAssetNumber() != null) {
            capitalAssetNumbers.add(assetRetirementGlobal.getMergedTargetCapitalAssetNumber());
        }
        for (AssetRetirementGlobalDetail retirementDetail : assetRetirementGlobal.getAssetRetirementGlobalDetails()) {
            if (retirementDetail.getCapitalAssetNumber() == null) continue;
            capitalAssetNumbers.add(retirementDetail.getCapitalAssetNumber());
        }
        return capitalAssetNumbers;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = super.processCustomRouteDocumentBusinessRules(document);
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        if (!GlobalVariables.getMessageMap().hasErrors() && (workflowDoc.isInitiated() || workflowDoc.isSaved())) {
            valid &= this.setAssetLocks(document);
        }
        return valid;
    }

    protected boolean setAssetLocks(MaintenanceDocument document) {
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getNewMaintainableObject().getBusinessObject();
        return this.getCapitalAssetManagementModuleService().storeAssetLocks(this.retrieveAssetNumbersForLocking(assetRetirementGlobal), document.getDocumentNumber(), "ARG", null);
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    protected boolean allPaymentsFederalOwned(AssetRetirementGlobal assetRetirementGlobal) {
        List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = assetRetirementGlobal.getAssetRetirementGlobalDetails();
        for (AssetRetirementGlobalDetail assetRetirementGlobalDetail : assetRetirementGlobalDetails) {
            for (AssetPayment assetPayment : assetRetirementGlobalDetail.getAsset().getAssetPayments()) {
                if (this.getAssetPaymentService().isPaymentFederalOwned(assetPayment)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validateObjectCodesForGLPosting(AssetRetirementGlobal assetRetirementGlobal) {
        boolean valid = true;
        List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = assetRetirementGlobal.getAssetRetirementGlobalDetails();
        Asset asset = null;
        List<AssetPayment> assetPayments = null;
        for (AssetRetirementGlobalDetail assetRetirementGlobalDetail : assetRetirementGlobalDetails) {
            asset = assetRetirementGlobalDetail.getAsset();
            assetPayments = asset.getAssetPayments();
            for (AssetPayment assetPayment : assetPayments) {
                if (this.getAssetPaymentService().isPaymentFederalOwned(assetPayment) || !(valid &= this.validateAssetObjectCode(asset, assetPayment))) continue;
                valid &= this.validateFinancialObjectCodes(asset, assetPayment);
            }
        }
        return valid;
    }

    protected boolean validateFinancialObjectCodes(Asset asset, AssetPayment assetPayment) {
        AssetPaymentService assetPaymentService = this.getAssetPaymentService();
        boolean valid = true;
        ObjectCodeService objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
        ObjectCode objectCode = objectCodeService.getByPrimaryIdForCurrentYear(assetPayment.getChartOfAccountsCode(), assetPayment.getFinancialObjectCode());
        AssetObjectCode assetObjectCode = this.getAssetObjectCodeService().findAssetObjectCode(asset.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode());
        if (assetPaymentService.isPaymentEligibleForCapitalizationGLPosting(assetPayment)) {
            assetObjectCode.refreshReferenceObject("capitalizationFinancialObject");
            valid &= this.validateFinObjectCodeForGLPosting(asset.getOrganizationOwnerChartOfAccountsCode(), assetObjectCode.getCapitalizationFinancialObjectCode(), assetObjectCode.getCapitalizationFinancialObject(), "Capitalization");
        }
        if (assetPaymentService.isPaymentEligibleForAccumDeprGLPosting(assetPayment)) {
            assetObjectCode.refreshReferenceObject("accumulatedDepreciationFinancialObject");
            valid &= this.validateFinObjectCodeForGLPosting(asset.getOrganizationOwnerChartOfAccountsCode(), assetObjectCode.getAccumulatedDepreciationFinancialObjectCode(), assetObjectCode.getAccumulatedDepreciationFinancialObject(), "Accummulate Depreciation");
        }
        if (assetPaymentService.isPaymentEligibleForOffsetGLPosting(assetPayment)) {
            valid &= this.validateFinObjectCodeForGLPosting(asset.getOrganizationOwnerChartOfAccountsCode(), ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(AssetRetirementGlobal.class, "DEFAULT_GAIN_LOSS_DISPOSITION_OBJECT_CODE"), this.getAssetRetirementService().getOffsetFinancialObject(asset.getOrganizationOwnerChartOfAccountsCode()), "Offset Amount");
        }
        return valid;
    }

    protected boolean validateFinObjectCodeForGLPosting(String chartOfAccountsCode, String finObjectCode, ObjectCode finObject, String glPostingType) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)finObjectCode)) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.object.code.from.asset.object.code.not.found", new String[]{glPostingType, chartOfAccountsCode});
            valid = false;
        } else if (ObjectUtils.isNull((Object)finObject)) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.object.code.from.asset.object.code.invalid", new String[]{glPostingType, finObjectCode, chartOfAccountsCode});
            valid = false;
        } else if (!finObject.isActive()) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.object.code.from.asset.object.code.inactive", new String[]{glPostingType, finObjectCode, chartOfAccountsCode});
            valid = false;
        }
        return valid;
    }

    protected boolean validateAssetObjectCode(Asset asset, AssetPayment assetPayment) {
        boolean valid = true;
        ObjectCodeService objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
        ObjectCode objectCode = objectCodeService.getByPrimaryIdForCurrentYear(assetPayment.getChartOfAccountsCode(), assetPayment.getFinancialObjectCode());
        AssetObjectCode assetObjectCode = this.getAssetObjectCodeService().findAssetObjectCode(asset.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode());
        if (ObjectUtils.isNull((Object)((Object)assetObjectCode))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.asset.object.code.not.found", new String[]{asset.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode()});
            valid = false;
        } else if (!assetObjectCode.isActive()) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.asset.object.code.inactive", new String[]{asset.getOrganizationOwnerChartOfAccountsCode(), objectCode.getFinancialObjectSubTypeCode()});
            valid = false;
        }
        return valid;
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        boolean success = true;
        AssetRetirementGlobalDetail assetRetirementGlobalDetail = (AssetRetirementGlobalDetail)line;
        AssetRetirementGlobal assetRetirementGlobal = (AssetRetirementGlobal)document.getDocumentBusinessObject();
        if (!this.checkEmptyValue(assetRetirementGlobalDetail.getCapitalAssetNumber())) {
            GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.blank.capital.asset.number", new String[0]);
            return false;
        }
        assetRetirementGlobalDetail.refreshReferenceObject("asset");
        if (ObjectUtils.isNull((Object)((Object)assetRetirementGlobalDetail.getAsset()))) {
            GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.invalid.capital.asset.number", new String[]{assetRetirementGlobalDetail.getCapitalAssetNumber().toString()});
            return false;
        }
        if (this.getAssetService().isAssetLoaned(assetRetirementGlobalDetail.getAsset())) {
            GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.retirement.asset.loaned", new String[0]);
            success = false;
        } else if (!this.getAssetService().isDocumentEnrouting((Document)document)) {
            success &= this.checkRetirementDetailOneLine(assetRetirementGlobalDetail, assetRetirementGlobal, document);
            success &= this.checkRetireMultipleAssets(assetRetirementGlobal.getRetirementReasonCode(), assetRetirementGlobal.getAssetRetirementGlobalDetails(), new Integer(0), document);
        }
        for (AssetRetirementGlobalDetail detail : assetRetirementGlobal.getAssetRetirementGlobalDetails()) {
            this.getAssetService().setAssetSummaryFields(detail.getAsset());
        }
        return success & super.processCustomAddCollectionLineBusinessRules(document, collectionName, line);
    }

    protected boolean checkRetireMultipleAssets(String retirementReasonCode, List<AssetRetirementGlobalDetail> assetRetirementDetails, Integer maxNumber, MaintenanceDocument maintenanceDocument) {
        boolean success = true;
        if (assetRetirementDetails.size() > maxNumber && !this.getAssetRetirementService().isAllowedRetireMultipleAssets(maintenanceDocument)) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.multiple.asset.retired", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean validateRetirementDetails(AssetRetirementGlobal assetRetirementGlobal, MaintenanceDocument maintenanceDocument) {
        boolean success = true;
        List<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = assetRetirementGlobal.getAssetRetirementGlobalDetails();
        if (assetRetirementGlobalDetails.size() == 0) {
            success = false;
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.asset.retirement.global.no.asset", new String[0]);
        } else {
            int index = 0;
            for (AssetRetirementGlobalDetail detail : assetRetirementGlobalDetails) {
                String errorPath = "document.newMaintainableObject.assetRetirementGlobalDetails[" + index++ + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPath);
                success &= this.checkRetirementDetailOneLine(detail, assetRetirementGlobal, maintenanceDocument);
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            }
        }
        return success;
    }

    protected boolean checkRetirementDetailOneLine(AssetRetirementGlobalDetail assetRetirementGlobalDetail, AssetRetirementGlobal assetRetirementGlobal, MaintenanceDocument maintenanceDocument) {
        boolean success = true;
        assetRetirementGlobalDetail.refreshReferenceObject("asset");
        Asset asset = assetRetirementGlobalDetail.getAsset();
        if (ObjectUtils.isNull((Object)((Object)asset))) {
            success = false;
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.invalid.capital.asset.number", new String[]{assetRetirementGlobalDetail.getCapitalAssetNumber().toString()});
        } else {
            success &= this.validateActiveCapitalAsset(asset);
            success &= this.validateNonMoveableAsset(asset, maintenanceDocument);
            if (this.getAssetRetirementService().isAssetRetiredByMerged(assetRetirementGlobal)) {
                success &= this.validateDuplicateAssetNumber(assetRetirementGlobal.getMergedTargetCapitalAssetNumber(), assetRetirementGlobalDetail.getCapitalAssetNumber());
            }
            this.getAssetService().setAssetSummaryFields(asset);
        }
        return success;
    }

    protected boolean validateDuplicateAssetNumber(Long targetAssetNumber, Long sourceAssetNumber) {
        boolean success = true;
        if (this.getAssetService().isCapitalAssetNumberDuplicate(targetAssetNumber, sourceAssetNumber)) {
            GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.duplicate.capital.asset.number.with.target", new String[]{sourceAssetNumber.toString()});
            success = false;
        }
        return success;
    }

    protected boolean validateNonMoveableAsset(Asset asset, MaintenanceDocument maintenanceDocument) {
        boolean success = true;
        FinancialSystemMaintenanceDocumentAuthorizerBase documentAuthorizer = (FinancialSystemMaintenanceDocumentAuthorizerBase)((DocumentDictionaryService)SpringContext.getBean(DocumentDictionaryService.class)).getDocumentAuthorizer((Document)maintenanceDocument);
        boolean isAuthorized = documentAuthorizer.isAuthorized((BusinessObject)maintenanceDocument, "KFS-CAM", "Retire Non-Movable Assets", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (!this.getAssetService().isAssetMovableCheckByAsset(asset) && !isAuthorized) {
            GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.invalid.user.group.for.nonmoveable.asset", new String[]{asset.getCapitalAssetNumber().toString()});
            success = false;
        }
        return success;
    }

    protected boolean assetRetirementValidation(AssetRetirementGlobal assetRetirementGlobal, MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        valid &= this.validateRequiredGlobalFields(assetRetirementGlobal);
        if (this.getAssetRetirementService().isAssetRetiredByMerged(assetRetirementGlobal)) {
            valid &= this.validateMergeTargetAsset(assetRetirementGlobal);
        }
        if (!this.getAssetService().isDocumentEnrouting((Document)maintenanceDocument)) {
            valid &= this.validateRetirementDetails(assetRetirementGlobal, maintenanceDocument);
            valid &= this.checkRetireMultipleAssets(assetRetirementGlobal.getRetirementReasonCode(), assetRetirementGlobal.getAssetRetirementGlobalDetails(), new Integer(1), maintenanceDocument);
        }
        return valid;
    }

    protected boolean validateMergeTargetAsset(AssetRetirementGlobal assetRetirementGlobal) {
        boolean valid = true;
        Asset targetAsset = assetRetirementGlobal.getMergedTargetCapitalAsset();
        Long targetAssetNumber = assetRetirementGlobal.getMergedTargetCapitalAssetNumber();
        if (!this.checkEmptyValue(targetAssetNumber)) {
            this.putFieldError("mergedTargetCapitalAssetNumber", "error.blank.capital.asset.number");
            valid = false;
        } else if (ObjectUtils.isNull((Object)((Object)targetAsset))) {
            this.putFieldError("mergedTargetCapitalAssetNumber", "error.invalid.merged.target.asset.number", targetAssetNumber.toString());
            valid = false;
        } else {
            if (!this.getAssetService().isCapitalAsset(targetAsset)) {
                this.putFieldError("mergedTargetCapitalAssetNumber", "error.non.capital.asset.retirment", targetAssetNumber.toString());
                valid = false;
            }
            if (this.getAssetService().isAssetRetired(targetAsset)) {
                this.putFieldError("mergedTargetCapitalAssetNumber", "error.non.active.asset.retirment", targetAssetNumber.toString());
                valid = false;
            }
        }
        if (!this.checkEmptyValue(assetRetirementGlobal.getMergedTargetCapitalAssetDescription())) {
            String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDataDictionary().getBusinessObjectEntry(AssetRetirementGlobal.class.getName()).getAttributeDefinition("mergedTargetCapitalAssetDescription").getLabel();
            this.putFieldError("mergedTargetCapitalAssetDescription", "error.required", label);
            valid = false;
        }
        return valid;
    }

    protected boolean validateActiveCapitalAsset(Asset asset) {
        boolean valid = true;
        if (!this.getAssetService().isCapitalAsset(asset)) {
            GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.non.capital.asset.retirment", new String[]{asset.getCapitalAssetNumber().toString()});
            valid = false;
        } else if (this.getAssetService().isAssetRetired(asset)) {
            GlobalVariables.getMessageMap().putError("capitalAssetNumber", "error.non.active.asset.retirment", new String[]{asset.getCapitalAssetNumber().toString()});
            valid = false;
        } else if (!this.validateAssetOnLoan(asset)) {
            valid = false;
        }
        return valid;
    }

    protected boolean validateRequiredGlobalFields(AssetRetirementGlobal assetRetirementGlobal) {
        boolean valid = true;
        if (this.getAssetRetirementService().isAssetRetiredBySold(assetRetirementGlobal)) {
            if (StringUtils.isBlank((CharSequence)assetRetirementGlobal.getBuyerDescription())) {
                this.putFieldError("buyerDescription", "error.retirement.detail.info.null", new String[]{"Buyer Description", this.getAssetRetirementService().getAssetRetirementReasonName(assetRetirementGlobal)});
                valid = false;
            }
            if (assetRetirementGlobal.getSalePrice() == null) {
                this.putFieldError("salePrice", "error.retirement.detail.info.null", new String[]{"Sale Price", this.getAssetRetirementService().getAssetRetirementReasonName(assetRetirementGlobal)});
                valid = false;
            }
            valid &= this.validateCashReceiptFinancialDocumentNumber(assetRetirementGlobal.getCashReceiptFinancialDocumentNumber());
        } else if (this.getAssetRetirementService().isAssetRetiredByAuction(assetRetirementGlobal)) {
            valid = this.validateCashReceiptFinancialDocumentNumber(assetRetirementGlobal.getCashReceiptFinancialDocumentNumber());
        } else if (this.getAssetRetirementService().isAssetRetiredByExternalTransferOrGift(assetRetirementGlobal) && StringUtils.isBlank((CharSequence)assetRetirementGlobal.getRetirementInstitutionName())) {
            this.putFieldError("retirementInstitutionName", "error.retirement.detail.info.null", new String[]{"Retirement Institution Name", this.getAssetRetirementService().getAssetRetirementReasonName(assetRetirementGlobal)});
            valid = false;
        } else if (this.getAssetRetirementService().isAssetRetiredByTheft(assetRetirementGlobal) && StringUtils.isBlank((CharSequence)assetRetirementGlobal.getPaidCaseNumber())) {
            this.putFieldError("paidCaseNumber", "error.retirement.detail.info.null", new String[]{"Police Case Number", this.getAssetRetirementService().getAssetRetirementReasonName(assetRetirementGlobal)});
            valid = false;
        }
        return valid;
    }

    protected boolean validateCashReceiptFinancialDocumentNumber(String documentNumber) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
            HashMap<String, String> retirementInfoMap = new HashMap<String, String>();
            retirementInfoMap.put("documentNumber", documentNumber);
            this.bo = (FinancialSystemDocumentHeader)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(FinancialSystemDocumentHeader.class, retirementInfoMap);
            if (ObjectUtils.isNull((Object)this.bo)) {
                this.putFieldError("cashReceiptFinancialDocumentNumber", "error.invalid.retirement.detail.info", new String[]{"Cash Receipt Financial Document Number", documentNumber});
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateAssetOnLoan(Asset asset) {
        boolean success = true;
        if (this.getAssetService().isAssetLoaned(asset)) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Asset Detail Information", "error.retirement.asset.loaned", new String[0]);
            success = false;
        }
        return success;
    }

    protected AssetService getAssetService() {
        return (AssetService)SpringContext.getBean(AssetService.class);
    }

    protected AssetRetirementService getAssetRetirementService() {
        return (AssetRetirementService)SpringContext.getBean(AssetRetirementService.class);
    }

    protected AssetPaymentService getAssetPaymentService() {
        return (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
    }

    protected AssetObjectCodeService getAssetObjectCodeService() {
        return (AssetObjectCodeService)SpringContext.getBean(AssetObjectCodeService.class);
    }
}

