/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.document.EquipmentLoanOrReturnDocument;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.location.framework.state.StateEbo;

public class EquipmentLoanOrReturnDocumentRule
extends TransactionalDocumentRuleBase {
    private static Logger LOG = Logger.getLogger(EquipmentLoanOrReturnDocumentRule.class);
    private AssetLockService assetLockService;

    protected List<Long> retrieveAssetNumberForLocking(Document document) {
        EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument = (EquipmentLoanOrReturnDocument)document;
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        if (equipmentLoanOrReturnDocument.getCapitalAssetNumber() != null) {
            assetNumbers.add(equipmentLoanOrReturnDocument.getCapitalAssetNumber());
        }
        return assetNumbers;
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        if (!super.processCustomRouteDocumentBusinessRules(document)) {
            return false;
        }
        EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument = (EquipmentLoanOrReturnDocument)document;
        boolean valid = this.processValidation(equipmentLoanOrReturnDocument);
        return valid &= !this.getAssetLockService().isAssetLocked(this.retrieveAssetNumberForLocking(document), "ELR", document.getDocumentNumber());
    }

    protected boolean processValidation(EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument) {
        boolean valid = true;
        if (equipmentLoanOrReturnDocument.getBorrowerPerson() == null) {
            valid &= false;
            GlobalVariables.getMessageMap().putError("document.borrowerPerson.principalName", "error.invalid.borrower.id", new String[0]);
        }
        valid &= this.validateTagNumber(equipmentLoanOrReturnDocument);
        valid &= this.validateLoanDate(equipmentLoanOrReturnDocument);
        return valid &= this.validStateZipCode(equipmentLoanOrReturnDocument);
    }

    protected boolean validateTagNumber(EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument) {
        boolean valid = true;
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("capitalAssetNumber", equipmentLoanOrReturnDocument.getCapitalAssetNumber());
        Asset asset = (Asset)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Asset.class, map);
        if (asset.getCampusTagNumber() == null) {
            valid &= false;
            GlobalVariables.getMessageMap().putError("document.campusTagNumber", "error.campus.tag.number.required", new String[0]);
        }
        return valid;
    }

    protected boolean validateLoanDate(EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument) {
        Date expectReturnDate;
        boolean valid = true;
        Date loanDate = KfsDateUtils.clearTimeFields((Date)equipmentLoanOrReturnDocument.getLoanDate());
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(loanDate);
        cal.add(1, 2);
        Date maxDate = new Date(cal.getTime().getTime());
        Date loanReturnDate = equipmentLoanOrReturnDocument.getLoanReturnDate();
        if (equipmentLoanOrReturnDocument.isNewLoan() && loanDate.before(KfsDateUtils.clearTimeFields((java.util.Date)new java.util.Date()))) {
            GlobalVariables.getMessageMap().putError("document.loanDate", "error.invalid.loan.date", new String[0]);
        }
        if ((expectReturnDate = equipmentLoanOrReturnDocument.getExpectedReturnDate()) != null) {
            KfsDateUtils.clearTimeFields((Date)expectReturnDate);
            if (expectReturnDate.before(loanDate)) {
                valid &= false;
                GlobalVariables.getMessageMap().putError("document.expectedReturnDate", "error.invalid.expected.return.date", new String[0]);
            }
            if (maxDate.before(expectReturnDate)) {
                valid &= false;
                GlobalVariables.getMessageMap().putError("document.expectedReturnDate", "error.invalid.expected.max.date", new String[0]);
            }
        }
        if (loanReturnDate != null) {
            KfsDateUtils.clearTimeFields((Date)loanReturnDate);
            if (loanDate.after(loanReturnDate) || maxDate.before(loanReturnDate)) {
                valid &= false;
                GlobalVariables.getMessageMap().putError("document.loanReturnDate", "error.invalid.loan.return.date", new String[0]);
            }
        }
        return valid;
    }

    protected boolean validStateZipCode(EquipmentLoanOrReturnDocument equipmentLoanOrReturnDocument) {
        StateEbo borrowStateCode;
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerCountryCode())) {
            equipmentLoanOrReturnDocument.setBorrowerCountryCode("US");
        }
        if (equipmentLoanOrReturnDocument.getBorrowerCountryCode().equals("US") && ObjectUtils.isNull((Object)(borrowStateCode = equipmentLoanOrReturnDocument.getBorrowerState()))) {
            GlobalVariables.getMessageMap().putError("document.borrowerStateCode", "error.invalid.borrower.state.code", new String[]{equipmentLoanOrReturnDocument.getBorrowerStateCode()});
            valid &= false;
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerStorageStateCode()) && StringUtils.isBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerStorageCountryCode())) {
            equipmentLoanOrReturnDocument.setBorrowerStorageCountryCode("US");
        }
        String storageCountryCode = equipmentLoanOrReturnDocument.getBorrowerStorageCountryCode();
        String storageAddress = equipmentLoanOrReturnDocument.getBorrowerStorageAddress();
        if (StringUtils.isNotBlank((CharSequence)storageAddress) && StringUtils.isNotBlank((CharSequence)storageCountryCode) && storageCountryCode.equals("US")) {
            if (StringUtils.isBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerStorageStateCode())) {
                GlobalVariables.getMessageMap().putError("document.borrowerStorageStateCode", "error.borrower.storage.state.required", new String[]{equipmentLoanOrReturnDocument.getBorrowerCountryCode()});
                valid = false;
            } else {
                StateEbo borrowStorageStateCode = equipmentLoanOrReturnDocument.getBorrowerStorageState();
                if (ObjectUtils.isNull((Object)borrowStorageStateCode)) {
                    GlobalVariables.getMessageMap().putError("document.borrowerStorageStateCode", "error.invalid.borrower.storage.state.code", new String[]{equipmentLoanOrReturnDocument.getBorrowerStorageStateCode()});
                    valid = false;
                }
            }
            if (StringUtils.isBlank((CharSequence)equipmentLoanOrReturnDocument.getBorrowerStorageZipCode())) {
                GlobalVariables.getMessageMap().putError("document.borrowerStorageZipCode", "error.borrower.storage.zip.required", new String[]{equipmentLoanOrReturnDocument.getBorrowerCountryCode()});
                valid = false;
            }
        }
        return valid;
    }

    public AssetLockService getAssetLockService() {
        if (this.assetLockService == null) {
            this.assetLockService = (AssetLockService)SpringContext.getBean(AssetLockService.class);
        }
        return this.assetLockService;
    }
}

