/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.web.struts;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.batch.AssetBarcodeInventoryInputFileType;
import org.kuali.kfs.module.cam.batch.service.AssetBarcodeInventoryInputFileService;
import org.kuali.kfs.module.cam.document.web.struts.AssetBarCodeInventoryInputFileForm;
import org.kuali.kfs.sys.batch.BatchInputFileSetType;
import org.kuali.kfs.sys.batch.service.BatchInputFileSetService;
import org.kuali.kfs.sys.businessobject.BatchUpload;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.FileStorageException;
import org.kuali.kfs.sys.web.struts.KualiBatchInputFileSetAction;
import org.kuali.kfs.sys.web.struts.KualiBatchInputFileSetForm;
import org.kuali.rice.core.api.util.ConcreteKeyValue;

public class AssetBarCodeInventoryInputFileAction
extends KualiBatchInputFileSetAction {
    private static Logger LOG = Logger.getLogger(AssetBarCodeInventoryInputFileAction.class);

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssetBarcodeInventoryInputFileService batchInputFileSetService;
        String fileTypeExtension;
        BatchUpload batchUpload = ((AssetBarCodeInventoryInputFileForm)form).getBatchUpload();
        AssetBarcodeInventoryInputFileType batchType = (AssetBarcodeInventoryInputFileType)this.retrieveBatchInputFileSetTypeImpl(batchUpload.getBatchInputTypeName());
        Map uploadedFiles = ((KualiBatchInputFileSetForm)form).getUploadedFiles();
        String fileName = ((FormFile)uploadedFiles.get((fileTypeExtension = batchType.getFileExtension()).substring(1))).getFileName();
        if (!StringUtils.isBlank((CharSequence)fileName) && !fileName.endsWith(fileTypeExtension)) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.uploadFile.invalid.type", new String[0]);
            return mapping.findForward("basic");
        }
        String uploadDescription = ((AssetBarCodeInventoryInputFileForm)form).getUploadDescription();
        boolean requiredValuesForFilesMissing = false;
        if (StringUtils.isBlank((CharSequence)batchUpload.getFileUserIdentifer())) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.save.noFileSetIdentifier", new String[0]);
            requiredValuesForFilesMissing = true;
        }
        if (StringUtils.isBlank((CharSequence)uploadDescription)) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.document.noDescription", new String[0]);
            requiredValuesForFilesMissing = true;
        }
        if (!(batchInputFileSetService = (AssetBarcodeInventoryInputFileService)SpringContext.getBean(AssetBarcodeInventoryInputFileService.class)).isFileUserIdentifierProperlyFormatted(batchUpload.getFileUserIdentifer())) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.save.fileSetIdentifierBadFormat", new String[0]);
            requiredValuesForFilesMissing = true;
        }
        HashMap<String, InputStream> typeToStreamMap = new HashMap<String, InputStream>();
        for (String fileType : uploadedFiles.keySet()) {
            FormFile uploadedFile = (FormFile)uploadedFiles.get(fileType);
            if (uploadedFile == null || uploadedFile.getInputStream() == null || uploadedFile.getInputStream().available() == 0) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.save.noFileSelected.for.file.type", new String[]{batchType.getFileTypeDescription().get(fileType)});
                requiredValuesForFilesMissing = true;
                continue;
            }
            typeToStreamMap.put(fileType, uploadedFile.getInputStream());
        }
        if (requiredValuesForFilesMissing) {
            return mapping.findForward("basic");
        }
        try {
            Map<String, String> map = batchInputFileSetService.save(GlobalVariables.getUserSession().getPerson(), batchType, batchUpload.getFileUserIdentifer(), typeToStreamMap, (AssetBarCodeInventoryInputFileForm)form);
        }
        catch (FileStorageException e) {
            LOG.error((Object)"Error occured while trying to save file set (probably tried to save a file that already exists).", (Throwable)e);
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.save.fileSaveError", new String[]{e.getMessage()});
            return mapping.findForward("basic");
        }
        catch (ValidationException e) {
            LOG.error((Object)"Error occured while trying to validate file set.", (Throwable)e);
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.validation.fileSaveError", new String[0]);
            return mapping.findForward("basic");
        }
        KNSGlobalVariables.getMessageList().add("message.batchUpload.saveSuccessful", new String[0]);
        return mapping.findForward("basic");
    }

    public void setupForm(KualiBatchInputFileSetForm form) {
        BatchInputFileSetType batchInputFileSetType = this.retrieveBatchInputFileSetTypeImpl(form.getBatchUpload().getBatchInputTypeName());
        if (batchInputFileSetType == null) {
            LOG.error((Object)("Batch input type implementation not found for id " + form.getBatchUpload().getBatchInputTypeName()));
            throw new RuntimeException("Batch input type implementation not found for id " + form.getBatchUpload().getBatchInputTypeName());
        }
        if (!((BatchInputFileSetService)SpringContext.getBean(BatchInputFileSetService.class)).isBatchInputTypeActive(batchInputFileSetType)) {
            throw new RuntimeException("Batch input file set type is not active.");
        }
        form.setBatchInputFileSetType(batchInputFileSetType);
        BatchInputFileSetService batchInputFileSetService = (BatchInputFileSetService)SpringContext.getBean(BatchInputFileSetService.class);
        ArrayList<ConcreteKeyValue> fileTypes = new ArrayList<ConcreteKeyValue>();
        fileTypes.add(new ConcreteKeyValue("", "Select a file type to download"));
        for (String fileAlias : batchInputFileSetType.getFileTypes()) {
            fileTypes.add(new ConcreteKeyValue(fileAlias, (String)batchInputFileSetType.getFileTypeDescription().get(fileAlias)));
        }
        form.setFileTypes(fileTypes);
        form.setTitleKey(batchInputFileSetType.getTitleKey());
    }
}

