/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.web.struts;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.document.service.GlAndPurApHelperService;
import org.kuali.kfs.module.cam.document.service.GlLineService;
import org.kuali.kfs.module.cam.document.web.struts.CabActionBase;
import org.kuali.kfs.module.cam.web.struts.GlLineForm;
import org.kuali.kfs.sys.context.SpringContext;

public class GlLineAction
extends CabActionBase {
    public ActionForward process(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GlLineForm glLineForm = (GlLineForm)form;
        String glAcctId = request.getParameter("generalLedgerAccountIdentifier");
        Long cabGlEntryId = Long.valueOf(glAcctId);
        GeneralLedgerEntry entry = this.findGeneralLedgerEntry(request);
        String assetLineNumber = request.getParameter("capitalAssetLineNumber");
        Integer capitalAssetLineNumber = Integer.valueOf(assetLineNumber);
        glLineForm.setCapitalAssetLineNumber(capitalAssetLineNumber);
        if (ObjectUtils.isNotNull((Object)((Object)entry))) {
            this.prepareRecordsForDisplay(glLineForm, entry, capitalAssetLineNumber);
        }
        glLineForm.setGeneralLedgerEntry(entry);
        return mapping.findForward("basic");
    }

    private void prepareRecordsForDisplay(GlLineForm glLineForm, GeneralLedgerEntry entry, Integer capitalAssetLineNumber) {
        GlLineService glLineService = (GlLineService)SpringContext.getBean(GlLineService.class);
        entry.setSelected(true);
        glLineForm.setGeneralLedgerEntry(entry);
        glLineForm.setPrimaryGlAccountId(entry.getGeneralLedgerAccountIdentifier());
        CapitalAssetInformation capitalAssetInformation = glLineService.findCapitalAssetInformation(entry.getDocumentNumber(), capitalAssetLineNumber);
        glLineForm.setCapitalAssetInformation(capitalAssetInformation);
    }

    protected GeneralLedgerEntry findGeneralLedgerEntry(HttpServletRequest request) {
        String glAcctId = request.getParameter("generalLedgerAccountIdentifier");
        Long cabGlEntryId = Long.valueOf(glAcctId);
        return this.findGeneralLedgerEntry(cabGlEntryId, false);
    }

    public ActionForward submitAssetGlobal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GlLineForm glLineForm = (GlLineForm)form;
        GlLineService glLineService = (GlLineService)SpringContext.getBean(GlLineService.class);
        GeneralLedgerEntry defaultGeneralLedgerEntry = this.findGeneralLedgerEntry(glLineForm.getPrimaryGlAccountId(), true);
        defaultGeneralLedgerEntry.setSelected(true);
        Integer capitalAssetLineNumber = glLineForm.getCapitalAssetLineNumber();
        if (ObjectUtils.isNull((Object)((Object)defaultGeneralLedgerEntry))) {
            form.reset(mapping, request);
            return mapping.findForward("basic");
        }
        Document maintDoc = glLineService.createAssetGlobalDocument(defaultGeneralLedgerEntry, capitalAssetLineNumber);
        return new ActionForward(this.getGlAndPurApHelperService().getDocHandlerUrl(maintDoc.getDocumentNumber(), "AA"), true);
    }

    public ActionForward submitPaymentGlobal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GlLineService glLineService = (GlLineService)SpringContext.getBean(GlLineService.class);
        GlLineForm glLineForm = (GlLineForm)form;
        GeneralLedgerEntry defaultGeneralLedgerEntry = this.findGeneralLedgerEntry(glLineForm.getPrimaryGlAccountId(), true);
        if (ObjectUtils.isNull((Object)((Object)defaultGeneralLedgerEntry))) {
            form.reset(mapping, request);
            return mapping.findForward("basic");
        }
        Integer capitalAssetLineNumber = glLineForm.getCapitalAssetLineNumber();
        Document document = glLineService.createAssetPaymentDocument(defaultGeneralLedgerEntry, capitalAssetLineNumber);
        return new ActionForward(this.getGlAndPurApHelperService().getDocHandlerUrl(document.getDocumentNumber(), "MPAY"), true);
    }

    protected GeneralLedgerEntry findGeneralLedgerEntry(Long generalLedgerEntryId, boolean requireNew) {
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        HashMap<String, Object> pkeys = new HashMap<String, Object>();
        pkeys.put("generalLedgerAccountIdentifier", generalLedgerEntryId);
        if (requireNew) {
            pkeys.put("activityStatusCode", "N");
        }
        GeneralLedgerEntry entry = (GeneralLedgerEntry)boService.findByPrimaryKey(GeneralLedgerEntry.class, pkeys);
        return entry;
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }

    public ActionForward showAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GlLineForm glLineForm = (GlLineForm)form;
        GeneralLedgerEntry generalLedgerEntry = glLineForm.getGeneralLedgerEntry();
        generalLedgerEntry.setSelected(true);
        return super.showAllTabs(mapping, form, request, response);
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GlLineForm glLineForm = (GlLineForm)form;
        Integer capitalAssetLineNumber = glLineForm.getCapitalAssetLineNumber();
        GeneralLedgerEntry entry = glLineForm.getGeneralLedgerEntry();
        if (entry != null) {
            this.prepareRecordsForDisplay(glLineForm, entry, capitalAssetLineNumber);
        }
        return mapping.findForward("basic");
    }

    protected GlAndPurApHelperService getGlAndPurApHelperService() {
        return (GlAndPurApHelperService)SpringContext.getBean(GlAndPurApHelperService.class);
    }
}

