/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.config.property.ConfigurationService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CapitalAssetInvalidAPOTest
extends KualiTestBase {
    private RequisitionService reqService;
    private ConfigurationService kualiConfigurationService;

    protected void setUp() throws Exception {
        super.setUp();
        if (null == this.reqService) {
            this.reqService = (RequisitionService)SpringContext.getBean(RequisitionService.class);
        }
        if (null == this.kualiConfigurationService) {
            this.kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
    }

    public void testInvalidAPOCapitalAssetFailure() {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_INVALID_FAILS_CAPITAL_ASSET_RULE.createRequisitionDocument();
        CapitalAssetInvalidAPOTest.assertFalse((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
        if (requisitionDocument.getNotes() != null && requisitionDocument.getNotes().size() > 0) {
            String reason = this.kualiConfigurationService.getPropertyValueAsString("requisition.nonAPO.accounting.line.capital.object.level");
            CapitalAssetInvalidAPOTest.assertTrue((boolean)requisitionDocument.getNote(0).getNoteText().contains(reason));
        }
    }
}

